/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.hid4java.HidDevice;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class HidServicesListenerList {
    private final List<HidServicesListener> listeners = Collections.synchronizedList(new ArrayList());
    private final ExecutorService executorService = Executors.newFixedThreadPool(3, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName("hid4java event worker");
            thread.setDaemon(true);
            return thread;
        }
    });

    public final void add(HidServicesListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public final void remove(HidServicesListener listener) {
        this.listeners.remove(listener);
    }

    public final void clear() {
        this.listeners.clear();
    }

    protected final List<HidServicesListener> getListeners() {
        return this.listeners;
    }

    public HidServicesListener[] toArray() {
        return this.getListeners().toArray(new HidServicesListener[this.getListeners().size()]);
    }

    public void fireHidDeviceAttached(final HidDevice hidDevice) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                HidServicesEvent event = new HidServicesEvent(hidDevice);
                HidServicesListener[] hidServicesListenerArray = HidServicesListenerList.this.toArray();
                int n = hidServicesListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HidServicesListener listener = hidServicesListenerArray[n2];
                    listener.hidDeviceAttached(event);
                    ++n2;
                }
            }
        });
    }

    public void fireHidDeviceDetached(final HidDevice hidDevice) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                HidServicesEvent event = new HidServicesEvent(hidDevice);
                HidServicesListener[] hidServicesListenerArray = HidServicesListenerList.this.toArray();
                int n = hidServicesListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HidServicesListener listener = hidServicesListenerArray[n2];
                    listener.hidDeviceDetached(event);
                    ++n2;
                }
            }
        });
    }

    public void fireHidFailure(final HidDevice hidDevice) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                HidServicesEvent event = new HidServicesEvent(hidDevice);
                HidServicesListener[] hidServicesListenerArray = HidServicesListenerList.this.toArray();
                int n = hidServicesListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HidServicesListener listener = hidServicesListenerArray[n2];
                    listener.hidFailure(event);
                    ++n2;
                }
            }
        });
    }
}

