/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.text.NumberFormat;
import java.util.List;

public class VarValueVector
extends VarValue {
    private Vector vector;
    private static Functions functions = null;

    public VarValueVector() {
        this.vector = new Vector();
    }

    public VarValueVector(Vector vector) {
        this.vector = vector;
    }

    public VarValueVector(double[] value) {
        this.vector = new Vector(value);
    }

    public VarValueVector(boolean columnVector, double[] value) {
        this.vector = new Vector(columnVector, value);
    }

    public VarValueVector(Double[] value) {
        this.vector = new Vector(value);
    }

    public VarValueVector(List<Double> value) {
        this.vector = new Vector(value);
    }

    public VarValueVector(String value) {
        this.vector = new Vector(value);
    }

    @Override
    public VarValueVector clone() {
        return new VarValueVector(this.vector);
    }

    @Override
    public VarValue cloneSimple() {
        return this;
    }

    public int length() {
        return this.vector.length();
    }

    public double get(int i) {
        return this.vector.get(i);
    }

    public double[] getData() {
        return this.vector.getVec();
    }

    public boolean isNaN() {
        return this.vector.isNaN();
    }

    public boolean isInfinite() {
        return this.vector.isInfinite();
    }

    public boolean isColumnVector() {
        return this.vector.isColumnVector();
    }

    public double dot(Vector value) {
        return this.vector.dot(value);
    }

    public Vector cross(Vector value) {
        return this.vector.cross(value);
    }

    public Vector normalize() {
        return this.vector.normalize();
    }

    @Override
    public void setParams(String params) {
    }

    @Override
    public String getParams() {
        return "";
    }

    @Override
    public String typeName() {
        return "vector";
    }

    public double abs() {
        return this.vector.abs();
    }

    public boolean equal(Vector v) {
        return this.vector.equals(v);
    }

    @Override
    public boolean asBoolean() {
        throw new VarExceptions.RangeCheckException(this.vector + " is a vector");
    }

    @Override
    public char asChar() {
        throw new VarExceptions.RangeCheckException(this.vector + " is a vector");
    }

    @Override
    public float asFloat() {
        if (this.vector.length() != 1) {
            throw new VarExceptions.RangeCheckException(this.vector + " is a vector");
        }
        if (this.vector.get(0) < -3.4028234663852886E38 || this.vector.get(0) > 3.4028234663852886E38) {
            throw new VarExceptions.RangeCheckException(this.vector + " is outside int range");
        }
        return (int)this.vector.get(0);
    }

    @Override
    public double asDouble() {
        if (this.vector.length() != 1) {
            throw new VarExceptions.RangeCheckException(this.vector + " is a vector");
        }
        return this.vector.get(0);
    }

    @Override
    public Complex asComplex() {
        return new Complex(this.asDouble(), 0.0);
    }

    @Override
    public Vector asVector() {
        return this.vector;
    }

    @Override
    public Matrix asMatrix() {
        return new Matrix(this.vector);
    }

    @Override
    public byte[] asBytes() {
        throw new VarExceptions.RangeCheckException(this.vector + " is a vector");
    }

    @Override
    public int asInt() {
        if (this.vector.length() != 1) {
            throw new VarExceptions.RangeCheckException(this.vector + " is a vector");
        }
        if (this.vector.get(0) < -2.147483648E9 || this.vector.get(0) > 2.147483647E9) {
            throw new VarExceptions.RangeCheckException(this.vector + " is outside int range");
        }
        return (int)this.vector.get(0);
    }

    @Override
    public long asLong() {
        if (this.vector.length() != 1) {
            throw new VarExceptions.RangeCheckException(this.vector + " is a vector");
        }
        if (this.vector.get(0) < -9.223372036854776E18 || this.vector.get(0) > 9.223372036854776E18) {
            throw new VarExceptions.RangeCheckException(this.vector + " is outside longrange");
        }
        return (long)this.vector.get(0);
    }

    @Override
    public String asString() {
        return this.vector.toString();
    }

    @Override
    public boolean isVector() {
        return true;
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return this.vector.length() == 1 && this.vector.get(0) >= -3.4028234663852886E38 && this.vector.get(0) <= 3.4028234663852886E38;
    }

    @Override
    public boolean canDouble() {
        return this.vector.length() == 1;
    }

    @Override
    public boolean canComplex() {
        return this.vector.length() == 1;
    }

    @Override
    public boolean canInt() {
        return this.vector.length() == 1 && this.vector.get(0) >= -2.147483648E9 && this.vector.get(0) <= 2.147483647E9;
    }

    @Override
    public boolean canLong() {
        return this.vector.length() == 1 && this.vector.get(0) >= -9.223372036854776E18 && this.vector.get(0) <= 9.223372036854776E18;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    protected void set(long value) {
        this.vector = new Vector(value);
    }

    @Override
    protected void set(double value) {
        this.vector = new Vector(value);
    }

    @Override
    protected void set(Vector value) {
        this.vector = value;
    }

    @Override
    protected void set(String value) {
        this.vector = new Vector(value);
    }

    @Override
    protected void set(VarValue value) {
        this.vector = value.asVector();
    }

    @Override
    protected void clear() {
        this.vector = new Vector();
    }

    @Override
    protected long valueAdd(long value) {
        this.vector.add(value);
        return (long)this.vector.get(0);
    }

    @Override
    protected double valueAdd(double value) {
        this.vector.add(value);
        return this.vector.get(0);
    }

    @Override
    public String toString() {
        return this.asString();
    }

    @Override
    public int getSize() {
        return this.vector.length();
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("format"){
                private StringBuilder append;

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setGroupingUsed(false);
                    switch (params.size()) {
                        case 2: {
                            nf.setMinimumIntegerDigits(params.get(0).asInt());
                            nf.setMaximumIntegerDigits(params.get(1).asInt());
                            nf.setMinimumFractionDigits(params.get(0).asInt());
                            nf.setMaximumFractionDigits(params.get(0).asInt());
                            break;
                        }
                        case 4: {
                            nf.setMinimumIntegerDigits(params.get(0).asInt());
                            nf.setMaximumIntegerDigits(params.get(1).asInt());
                            nf.setMinimumFractionDigits(params.get(2).asInt());
                            nf.setMaximumFractionDigits(params.get(3).asInt());
                            break;
                        }
                        default: {
                            1.invalidNumberOfParams(script, "minIntDigits,maxIntDigits,minFracDigits,maxFracDigits");
                        }
                    }
                    StringBuilder sb = new StringBuilder();
                    VarValueVector vec = (VarValueVector)value;
                    int i = 0;
                    while (i < vec.length()) {
                        if (sb.length() > 0) {
                            sb.append(vec.isColumnVector() ? "; " : ", ");
                        }
                        sb.append(nf.format(vec.get(i)));
                        ++i;
                    }
                    return Var.createValue(sb.toString());
                }
            });
            functions.add(new Functions.FuncVarValue("v"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        2.invalidNumberOfParams(script, "index");
                    }
                    VarValueVector vec = (VarValueVector)value;
                    return Var.createValue(vec.get(params.get(0).asInt()));
                }
            });
            functions.add(new Functions.FuncVarValue("isColumn"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        3.invalidNumberOfParams(script, "");
                    }
                    VarValueVector vec = (VarValueVector)value;
                    return Var.createValue(vec.isColumnVector());
                }
            });
            functions.add(new Functions.FuncVarValue("isRow"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    VarValueVector vec;
                    if (params.size() != 0) {
                        4.invalidNumberOfParams(script, "");
                    }
                    return Var.createValue(!(vec = (VarValueVector)value).isColumnVector());
                }
            });
            functions.add(new Functions.FuncVarValue("asColumn"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    VarValueVector vec;
                    if (params.size() != 0) {
                        5.invalidNumberOfParams(script, "");
                    }
                    return (vec = (VarValueVector)value).isColumnVector() ? new Var(vec) : Var.createValue(new Vector(true, vec.getData()));
                }
            });
            functions.add(new Functions.FuncVarValue("asRow"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    VarValueVector vec;
                    if (params.size() != 0) {
                        6.invalidNumberOfParams(script, "");
                    }
                    return !(vec = (VarValueVector)value).isColumnVector() ? new Var(vec) : Var.createValue(new Vector(false, vec.getData()));
                }
            });
            functions.add(new Functions.FuncVarValue("abs"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        7.invalidNumberOfParams(script, "");
                    }
                    VarValueVector vec = (VarValueVector)value;
                    return Var.createValue(vec.abs());
                }
            });
            functions.add(new Functions.FuncVarValue("dot"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        8.invalidNumberOfParams(script, "vector");
                    }
                    VarValueVector vec = (VarValueVector)value;
                    return Var.createValue(vec.dot(params.get(0).asVector()));
                }
            });
            functions.add(new Functions.FuncVarValue("cross"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        9.invalidNumberOfParams(script, "vector");
                    }
                    VarValueVector vec = (VarValueVector)value;
                    return Var.createValue(vec.cross(params.get(0).asVector()));
                }
            });
            functions.add(new Functions.FuncVarValue("transpose"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    Vector vec;
                    if (params.size() != 0) {
                        10.invalidNumberOfParams(script, "");
                    }
                    return Var.createValue(new Vector(!(vec = value.asVector()).isColumnVector(), vec.getVec()));
                }
            });
            functions.add(new Functions.FuncVarValue("normalize"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        11.invalidNumberOfParams(script, "");
                    }
                    Vector vec = value.asVector();
                    return Var.createValue(vec.normalize());
                }
            });
            functions.add(new Functions.FuncVarValue("random"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    switch (params.size()) {
                        case 0: {
                            return Var.createValue(Vector.randomVector(3, 0L, 100L));
                        }
                        case 1: {
                            int d = params.get(0).asInt();
                            return Var.createValue(Vector.randomVector(d, 0L, 1000L));
                        }
                        case 3: {
                            int d = params.get(0).asInt();
                            if (params.get(1).isDouble() || params.get(2).isDouble()) {
                                return Var.createValue(Vector.randomVector(d, params.get(1).asDouble(), params.get(2).asDouble()));
                            }
                            return Var.createValue(Vector.randomVector(d, params.get(1).asLong(), params.get(2).asLong()));
                        }
                    }
                    12.invalidNumberOfParams(script, "length{,min,max}}");
                    return null;
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueVector.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }

    @Override
    public boolean canVector() {
        return true;
    }

    @Override
    public boolean canMatrix() {
        return true;
    }
}

