/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VarValueStruct
extends VarValue {
    private Map<String, Var> varList = null;
    private List<Var> indexList = null;
    private static Functions functions = null;

    public VarValueStruct() {
        this.varList = new HashMap<String, Var>(10);
    }

    public VarValueStruct(Map<String, Var> varList) {
        this.varList = varList;
    }

    @Override
    public VarValueStruct clone() {
        HashMap<String, Var> map = new HashMap<String, Var>(this.varList.size());
        for (String s : this.getNames()) {
            map.put(s, this.getVar(s).clone());
        }
        return new VarValueStruct(map);
    }

    @Override
    public VarValue cloneSimple() {
        return this;
    }

    @Override
    public String typeName() {
        return "struct";
    }

    @Override
    public boolean asBoolean() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public char asChar() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public float asFloat() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public double asDouble() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public int asInt() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public long asLong() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public String asString() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public Complex asComplex() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public Vector asVector() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public Matrix asMatrix() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public byte[] asBytes() {
        throw new VarExceptions.ValueException("A struct can not contain a value");
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    @Override
    public boolean canDouble() {
        return false;
    }

    @Override
    public boolean canComplex() {
        return false;
    }

    @Override
    public boolean canVector() {
        return false;
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canInt() {
        return false;
    }

    @Override
    public boolean canLong() {
        return false;
    }

    @Override
    public boolean canString() {
        return false;
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.varList.isEmpty();
    }

    @Override
    public void set(long value) {
        throw new VarExceptions.ValueException("A struct can not contain a value, try clearing the var first");
    }

    @Override
    public void set(double value) {
        throw new VarExceptions.ValueException("A struct can not contain a value, try clearing the var first");
    }

    @Override
    public void set(String value) {
        throw new VarExceptions.ValueException("A struct can not contain a value, try clearing the var first");
    }

    @Override
    public void set(VarValue value) {
        throw new VarExceptions.ValueException("A struct can not contain a value, try clearing the var first");
    }

    @Override
    protected synchronized void clear() {
        this.indexList = null;
        this.varList.clear();
    }

    @Override
    public synchronized List<String> getNames() {
        return new ArrayList<String>(this.varList.keySet());
    }

    @Override
    public synchronized Collection<Var> getVars() {
        return this.varList.values();
    }

    public synchronized void addVar(Var element) {
        if (element.getName() == null || element.getName().length() == 0) {
            new VarExceptions.IndexException("Elements in struct must be named");
        }
        this.indexList = null;
        this.varList.put(element.getName(), element);
    }

    public synchronized void addVar(String name, Var element) {
        if (name == null || name.length() == 0) {
            new VarExceptions.IndexException("Elements in struct must be named");
        }
        this.indexList = null;
        this.varList.put(name, element);
    }

    public synchronized Var getVar(String name) {
        return this.varList.get(name);
    }

    public synchronized Var getVar(int index) {
        if (this.indexList == null) {
            this.indexList = new ArrayList<Var>(this.getSize());
            for (Var v : this.getVars()) {
                this.indexList.add(v);
            }
        }
        return this.indexList.get(index);
    }

    @Override
    public int getSize() {
        return this.varList.size();
    }

    public synchronized void remove(String name) {
        Var var = this.varList.get(name);
        if (var == null) {
            return;
        }
        if (var.isReadOnly()) {
            throw new VarExceptions.ReadOnlyException("Can not remove read only value");
        }
        this.indexList = null;
        this.varList.remove(name);
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueStruct.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

