/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Support;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class VarValueString
extends VarValue {
    private String value;
    private static Functions functions = null;

    public VarValueString() {
        this.value = "";
    }

    public VarValueString(String value) {
        this.value = value;
    }

    @Override
    public String typeName() {
        return "string";
    }

    @Override
    public VarValueString clone() {
        return new VarValueString(this.value);
    }

    @Override
    public boolean asBoolean() {
        return Support.stringToBoolean(this.value);
    }

    @Override
    public char asChar() {
        if (this.value.length() > 0) {
            return this.value.charAt(0);
        }
        return '\u0000';
    }

    @Override
    public float asFloat() {
        double v = Support.stringToDouble(this.value);
        if (v < (double)1.4E-45f || v > 3.4028234663852886E38) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside int range");
        }
        return (float)v;
    }

    @Override
    public double asDouble() {
        double v = Support.stringToDouble(this.value);
        return v;
    }

    @Override
    public Complex asComplex() {
        return Support.stringToComplex(this.value);
    }

    @Override
    public Vector asVector() {
        return new Vector(this.value);
    }

    @Override
    public Matrix asMatrix() {
        return new Matrix(this.value);
    }

    @Override
    public int asInt() {
        long v = Support.stringToLong(this.value);
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside int range");
        }
        return (int)v;
    }

    @Override
    public long asLong() {
        long v = Support.stringToLong(this.value);
        return v;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public byte[] asBytes() {
        if (this.value.startsWith("$") && this.value.endsWith("$")) {
            ByteBuffer bb = new ByteBuffer();
            int i = 0;
            while (i < this.value.length() - 2) {
                String s = this.value.substring(i + 1, Math.min(i + 3, this.value.length() - 1));
                bb.append((byte)Integer.parseInt(s, 16));
                i += 2;
            }
            return bb.getAsArray();
        }
        try {
            return this.value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return this.value.getBytes();
        }
    }

    @Override
    public String toString() {
        return "\"" + this.value + "\"";
    }

    @Override
    public boolean canBoolean() {
        try {
            Support.stringToBoolean(this.value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canChar() {
        return this.value.length() > 0;
    }

    @Override
    public boolean canFloat() {
        return Support.isFloat(this.value);
    }

    @Override
    public boolean canDouble() {
        return Support.isDouble(this.value);
    }

    @Override
    public boolean canComplex() {
        return Support.isComplex(this.value);
    }

    @Override
    public boolean canVector() {
        return Vector.isVector(this.value);
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canInt() {
        try {
            long v = Support.stringToLong(this.value);
            return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean canLong() {
        return Support.isLong(this.value);
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isChar() {
        return this.value.length() > 0;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    protected void set(double value) {
        this.value = Double.toString(value);
    }

    @Override
    protected void set(long value) {
        this.value = Long.toString(value);
    }

    @Override
    protected void set(String value) {
        this.value = value;
    }

    @Override
    protected void set(VarValue value) {
        this.value = value.asString();
    }

    @Override
    protected void clear() {
        this.value = "";
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("length"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    VarValueString v = (VarValueString)value;
                    return Var.createValue(v.value.length());
                }
            });
            functions.add(new Functions.FuncVarValue("substring"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    VarValueString v = (VarValueString)value;
                    if (params.size() == 1) {
                        int i = params.get(0).asInt();
                        if (i < 0) {
                            i = 0;
                        }
                        if (i > v.value.length()) {
                            i = v.value.length();
                        }
                        return Var.createValue(v.value.substring(i));
                    }
                    if (params.size() == 2) {
                        int j;
                        int i = params.get(0).asInt();
                        if (i < 0) {
                            i = 0;
                        }
                        if (i > v.value.length()) {
                            i = v.value.length();
                        }
                        if ((j = params.get(1).asInt()) < i) {
                            j = i;
                        }
                        if (j > v.value.length()) {
                            j = v.value.length();
                        }
                        return Var.createValue(v.value.substring(i, j));
                    }
                    return null;
                }
            });
            functions.add(new Functions.FuncVarValue("trim"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        3.invalidNumberOfParams(script, "none");
                    }
                    VarValueString v = (VarValueString)value;
                    return Var.createValue(v.value.trim());
                }
            });
            functions.add(new Functions.FuncVarValue("replace"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 2) {
                        4.invalidNumberOfParams(script, "from,to");
                    }
                    VarValueString v = (VarValueString)value;
                    return Var.createValue(v.value.replace(params.get(0).asString(), params.get(1).asString()));
                }
            });
            functions.add(new Functions.FuncVarValue("toLowerCase"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        5.invalidNumberOfParams(script, "none");
                    }
                    VarValueString v = (VarValueString)value;
                    return Var.createValue(v.value.toLowerCase());
                }
            });
            functions.add(new Functions.FuncVarValue("toUpperCase"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        6.invalidNumberOfParams(script, "none");
                    }
                    VarValueString v = (VarValueString)value;
                    return Var.createValue(v.value.toUpperCase());
                }
            });
            functions.add(new Functions.FuncVarValue("charAt"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        7.invalidNumberOfParams(script, "1");
                    }
                    VarValueString v = (VarValueString)value;
                    int index = params.get(0).asInt();
                    if (index < 0 || index >= v.value.length()) {
                        return Var.createValue(' ');
                    }
                    return Var.createValue(Character.valueOf(v.value.charAt(index)).charValue());
                }
            });
            functions.add(new Functions.FuncVarValue("contains"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        8.invalidNumberOfParams(script, "1");
                    }
                    return Var.createValue(value.asString().contains(params.get(0).asString()));
                }
            });
            functions.add(new Functions.FuncVarValue("indexOf"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        9.invalidNumberOfParams(script, "1");
                    }
                    VarValueString v = (VarValueString)value;
                    String str = params.get(0).asString();
                    return Var.createValue(v.value.indexOf(str));
                }
            });
            functions.add(new Functions.FuncVarValue("split"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        10.invalidNumberOfParams(script, "1");
                    }
                    VarValueString v = (VarValueString)value;
                    String str = params.get(0).asString();
                    String[] a = v.value.split(str);
                    Var va = new Var();
                    va.defineArray();
                    String[] stringArray = a;
                    int n = a.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        va.addVar(Var.createValue(s));
                        ++n2;
                    }
                    return va;
                }
            });
            functions.add(new Functions.FuncVarValue("firstChars"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        11.invalidNumberOfParams(script, "1");
                    }
                    VarValueString v = (VarValueString)value;
                    int index = params.get(0).asInt();
                    if (index > v.value.length()) {
                        index = v.value.length();
                    }
                    return Var.createValue(v.value.substring(0, index));
                }
            });
            functions.add(new Functions.FuncVarValue("lastChars"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        12.invalidNumberOfParams(script, "1");
                    }
                    VarValueString v = (VarValueString)value;
                    int index = params.get(0).asInt();
                    if (index > v.value.length()) {
                        index = v.value.length();
                    }
                    return Var.createValue(v.value.substring(v.value.length() - index));
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public int getSize() {
        return this.value.length();
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueString.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

