/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.text.NumberFormat;
import java.util.List;

public class VarValueMatrix
extends VarValue {
    private Matrix mx;
    private static Functions functions = null;

    public VarValueMatrix() {
        this.mx = new Matrix();
    }

    public VarValueMatrix(Matrix matrix) {
        this.mx = matrix;
    }

    public VarValueMatrix(double[][] value) {
        this.mx = new Matrix(value);
    }

    public VarValueMatrix(Double[][] value) {
        this.mx = new Matrix(value);
    }

    public VarValueMatrix(String value) {
        this.mx = new Matrix(value);
    }

    @Override
    public VarValueMatrix clone() {
        return new VarValueMatrix(this.mx);
    }

    @Override
    public VarValue cloneSimple() {
        return this;
    }

    public int rows() {
        return this.mx.rows();
    }

    public int columns() {
        return this.mx.columns();
    }

    public boolean isNaN() {
        return this.mx.isNaN();
    }

    public boolean isInfinite() {
        return this.mx.isInfinite();
    }

    public double get(int row, int column) {
        return this.mx.get(row, column);
    }

    public double[] getRow(int row) {
        return this.mx.getRow(row);
    }

    public double[] getColumn(int column) {
        return this.mx.getColumn(column);
    }

    public double[][] getMatrix() {
        return this.mx.getMatrix();
    }

    @Override
    public void setParams(String params) {
    }

    @Override
    public String getParams() {
        return "";
    }

    @Override
    public String typeName() {
        return "matrix";
    }

    public Matrix abs() {
        return this.mx.abs();
    }

    public boolean equal(Vector v) {
        return this.mx.equals(v);
    }

    @Override
    public boolean asBoolean() {
        throw new VarExceptions.RangeCheckException(this.mx + " is a matrix");
    }

    @Override
    public char asChar() {
        throw new VarExceptions.RangeCheckException(this.mx + " is a matrix");
    }

    @Override
    public byte[] asBytes() {
        throw new VarExceptions.RangeCheckException(this.mx + " is a matrix");
    }

    @Override
    public float asFloat() {
        if (this.mx.rows() != 1 && this.mx.columns() != 1) {
            throw new VarExceptions.RangeCheckException(this.mx + " is a matrix");
        }
        if (this.mx.get(0, 0) < -3.4028234663852886E38 || this.mx.get(0, 0) > 3.4028234663852886E38) {
            throw new VarExceptions.RangeCheckException(this.mx + " is outside int range");
        }
        return (int)this.mx.get(0, 0);
    }

    @Override
    public double asDouble() {
        if (!this.mx.isSingle()) {
            throw new VarExceptions.RangeCheckException(this.mx + " is a matrix");
        }
        return this.mx.get(0, 0);
    }

    @Override
    public Complex asComplex() {
        return new Complex(this.asDouble(), 0.0);
    }

    @Override
    public Vector asVector() {
        if (this.mx.rows() == 1) {
            return new Vector(false, this.mx.getRow(0));
        }
        if (this.mx.columns() == 1) {
            return new Vector(true, this.mx.getColumn(0));
        }
        throw new VarExceptions.RangeCheckException(this.mx + " is a matrix");
    }

    @Override
    public Matrix asMatrix() {
        return this.mx;
    }

    @Override
    public int asInt() {
        if (!this.mx.isSingle()) {
            throw new VarExceptions.RangeCheckException(this.mx + " is a matrix");
        }
        if (this.mx.get(0, 0) < -2.147483648E9 || this.mx.get(0, 0) > 2.147483647E9) {
            throw new VarExceptions.RangeCheckException(this.mx + " is outside int range");
        }
        return (int)this.mx.get(0, 0);
    }

    @Override
    public long asLong() {
        if (!this.mx.isSingle()) {
            throw new VarExceptions.RangeCheckException(this.mx + " is a matrix");
        }
        if (this.mx.get(0, 0) < -9.223372036854776E18 || this.mx.get(0, 0) > 9.223372036854776E18) {
            throw new VarExceptions.RangeCheckException(this.mx + " is outside longrange");
        }
        return (long)this.mx.get(0, 0);
    }

    @Override
    public String asString() {
        return this.mx.toString();
    }

    @Override
    public boolean isMatrix() {
        return true;
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return this.mx.isSingle() && this.mx.get(0, 0) >= -3.4028234663852886E38 && this.mx.get(0, 0) <= 3.4028234663852886E38;
    }

    @Override
    public boolean canDouble() {
        return this.mx.isSingle();
    }

    @Override
    public boolean canComplex() {
        return this.mx.isSingle();
    }

    @Override
    public boolean canInt() {
        return this.mx.isSingle() && this.mx.get(0, 0) >= -2.147483648E9 && this.mx.get(0, 0) <= 2.147483647E9;
    }

    @Override
    public boolean canLong() {
        return this.mx.isSingle() && this.mx.get(0, 0) >= -9.223372036854776E18 && this.mx.get(0, 0) <= 9.223372036854776E18;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    protected void set(long value) {
        this.mx = new Matrix(value);
    }

    @Override
    protected void set(double value) {
        this.mx = new Matrix(value);
    }

    @Override
    protected void set(Vector value) {
        this.mx = new Matrix(value);
    }

    @Override
    protected void set(Matrix value) {
        this.mx = value;
    }

    @Override
    protected void set(String value) {
        this.mx = new Matrix(value);
    }

    @Override
    protected void set(VarValue value) {
        this.mx = value.asMatrix();
    }

    @Override
    protected void clear() {
        this.mx = new Matrix();
    }

    @Override
    protected long valueAdd(long value) {
        this.mx.add(value);
        return (long)this.mx.get(0, 0);
    }

    @Override
    protected double valueAdd(double value) {
        this.mx.add(value);
        return this.mx.get(0, 0);
    }

    @Override
    public String toString() {
        return this.asString();
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("format"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setGroupingUsed(false);
                    switch (params.size()) {
                        case 2: {
                            nf.setMinimumIntegerDigits(params.get(0).asInt());
                            nf.setMaximumIntegerDigits(params.get(1).asInt());
                            nf.setMinimumFractionDigits(params.get(0).asInt());
                            nf.setMaximumFractionDigits(params.get(0).asInt());
                            break;
                        }
                        case 4: {
                            nf.setMinimumIntegerDigits(params.get(0).asInt());
                            nf.setMaximumIntegerDigits(params.get(1).asInt());
                            nf.setMinimumFractionDigits(params.get(2).asInt());
                            nf.setMaximumFractionDigits(params.get(3).asInt());
                            break;
                        }
                        default: {
                            1.invalidNumberOfParams(script, "minIntDigits,maxIntDigits,minFracDigits,maxFracDigits");
                        }
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    StringBuilder sb = new StringBuilder();
                    boolean mark = false;
                    int i = 0;
                    while (i < mx.columns()) {
                        if (mark) {
                            sb.append("; ");
                            mark = false;
                        }
                        int j = 0;
                        while (j < mx.rows()) {
                            if (mark) {
                                sb.append(", ");
                            }
                            sb.append(nf.format(mx.get(i, j)));
                            mark = true;
                            ++j;
                        }
                        ++i;
                    }
                    return Var.createValue(sb.toString());
                }
            });
            functions.add(new Functions.FuncVarValue("v"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 2) {
                        2.invalidNumberOfParams(script, "row,column");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.get(params.get(0).asInt(), params.get(1).asInt()));
                }
            });
            functions.add(new Functions.FuncVarValue("row"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        3.invalidNumberOfParams(script, "row");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.getRow(params.get(0).asInt()));
                }
            });
            functions.add(new Functions.FuncVarValue("column"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        4.invalidNumberOfParams(script, "column");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(new Vector(true, mx.getColumn(params.get(0).asInt())));
                }
            });
            functions.add(new Functions.FuncVarValue("det"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        5.invalidNumberOfParams(script, "");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.determinant());
                }
            });
            functions.add(new Functions.FuncVarValue("adjoint"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        6.invalidNumberOfParams(script, "");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.adjoint());
                }
            });
            functions.add(new Functions.FuncVarValue("inverse"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        7.invalidNumberOfParams(script, "");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.inverse());
                }
            });
            functions.add(new Functions.FuncVarValue("transpose"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        8.invalidNumberOfParams(script, "");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.transpose());
                }
            });
            functions.add(new Functions.FuncVarValue("abs"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        9.invalidNumberOfParams(script, "");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.abs());
                }
            });
            functions.add(new Functions.FuncVarValue("rank"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        10.invalidNumberOfParams(script, "");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.rank());
                }
            });
            functions.add(new Functions.FuncVarValue("power"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        11.invalidNumberOfParams(script, "exponent");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.power(params.get(0).asInt()));
                }
            });
            functions.add(new Functions.FuncVarValue("minor"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 2) {
                        12.invalidNumberOfParams(script, "row,column");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.minor(params.get(0).asInt(), params.get(1).asInt()));
                }
            });
            functions.add(new Functions.FuncVarValue("cofactors"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        13.invalidNumberOfParams(script, "");
                    }
                    VarValueMatrix mx = (VarValueMatrix)value;
                    return Var.createValue(mx.mx.cofactors());
                }
            });
            functions.add(new Functions.FuncVarValue("idMatrix"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        14.invalidNumberOfParams(script, "size");
                    }
                    return Var.createValue(Matrix.idMatrix(params.get(0).asInt()));
                }
            });
            functions.add(new Functions.FuncVarValue("random"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    switch (params.size()) {
                        case 0: {
                            return Var.createValue(Matrix.randomMatrix(3, 3, 0L, 100L));
                        }
                        case 1: {
                            int d = params.get(0).asInt();
                            return Var.createValue(Matrix.randomMatrix(d, d, 0L, 1000L));
                        }
                        case 2: {
                            int r = params.get(0).asInt();
                            int c = params.get(1).asInt();
                            return Var.createValue(Matrix.randomMatrix(r, c, 0L, 1000L));
                        }
                        case 4: {
                            int r = params.get(0).asInt();
                            int c = params.get(1).asInt();
                            if (params.get(2).isDouble() || params.get(3).isDouble()) {
                                return Var.createValue(Matrix.randomMatrix(r, c, params.get(2).asDouble(), params.get(2).asDouble()));
                            }
                            return Var.createValue(Matrix.randomMatrix(r, c, params.get(2).asLong(), params.get(3).asLong()));
                        }
                    }
                    15.invalidNumberOfParams(script, "rows{,columns{,min,max}}");
                    return null;
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueMatrix.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }

    @Override
    public boolean canVector() {
        return this.rows() == 1 || this.columns() == 1;
    }

    @Override
    public boolean canMatrix() {
        return true;
    }
}

