/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Support;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.text.NumberFormat;
import java.util.List;

public class VarValueLong
extends VarValue {
    protected long value;
    protected long min;
    protected long max;
    private static Functions functions = null;

    public VarValueLong() {
        this.value = 0L;
        this.min = Long.MIN_VALUE;
        this.max = Long.MAX_VALUE;
    }

    public VarValueLong(long value) {
        this.value = value;
        this.min = Long.MIN_VALUE;
        this.max = Long.MAX_VALUE;
    }

    public VarValueLong(long value, long min, long max) {
        this.value = value;
        this.min = min;
        this.max = max;
    }

    @Override
    public VarValueLong clone() {
        return new VarValueLong(this.value, this.min, this.max);
    }

    @Override
    public String typeName() {
        if (this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
            return "int";
        }
        if (this.min == 0L && this.max == 1L) {
            return "boolean";
        }
        return "long";
    }

    @Override
    public void setParams(String params) {
        String[] val = params.split("[,]");
        this.min = Support.stringToLong(val[0]);
        this.max = Support.stringToLong(val[1]);
    }

    @Override
    public String getParams() {
        if (!(this.min == Long.MIN_VALUE && this.max == Long.MAX_VALUE || this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE || this.min == 0L && this.max == 0x10FFFFL || this.min == 0L && this.max == 1L)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.min);
            sb.append(',');
            sb.append(this.max);
            return sb.toString();
        }
        return "";
    }

    public void setParamsInt() {
        this.min = Integer.MIN_VALUE;
        this.max = Integer.MAX_VALUE;
    }

    public void setParamsBoolean() {
        this.min = 0L;
        this.max = 1L;
    }

    public void setParamsChar() {
        this.min = 0L;
        this.max = 0x10FFFFL;
    }

    @Override
    public boolean asBoolean() {
        return this.value != 0L;
    }

    @Override
    public char asChar() {
        if (this.value < 0L || this.value > 0x10FFFFL) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside char range");
        }
        return (char)this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public Complex asComplex() {
        return new Complex(this.value, 0.0);
    }

    @Override
    public Vector asVector() {
        return new Vector(this.value);
    }

    @Override
    public Matrix asMatrix() {
        return new Matrix(this.value);
    }

    @Override
    public byte[] asBytes() {
        byte[] b = new byte[8];
        long l = this.value;
        int i = 0;
        while (i < 8) {
            b[i] = (byte)l;
            l >>= 8;
            ++i;
        }
        return b;
    }

    @Override
    public int asInt() {
        if (this.value < Integer.MIN_VALUE || this.value > Integer.MAX_VALUE) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside int range");
        }
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public String asString() {
        return Long.toString(this.value);
    }

    @Override
    public boolean canBoolean() {
        return true;
    }

    @Override
    public boolean canChar() {
        return this.value >= 0L && this.value <= 0x10FFFFL;
    }

    @Override
    public boolean canFloat() {
        return true;
    }

    @Override
    public boolean canDouble() {
        return true;
    }

    @Override
    public boolean canComplex() {
        return true;
    }

    @Override
    public boolean canVector() {
        return true;
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canInt() {
        return this.value >= Integer.MIN_VALUE && this.value <= Integer.MAX_VALUE;
    }

    @Override
    public boolean canLong() {
        return true;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean isInt() {
        return this.value >= Integer.MIN_VALUE && this.value <= Integer.MAX_VALUE;
    }

    @Override
    public boolean isChar() {
        return this.value >= 0L && this.value <= 65535L;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public void set(double value) {
        if (value < (double)this.min || value > (double)this.max) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside range");
        }
        this.value = (long)value;
    }

    @Override
    public void set(long value) {
        if (value < this.min || value > this.max) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside range");
        }
        this.value = value;
    }

    @Override
    public void set(String value) {
        if (this.min == 0L && this.max == 1L) {
            this.set(Support.stringToBoolean(value) ? 1 : 0);
        } else {
            this.set(Support.stringToLong(value));
        }
    }

    @Override
    public void set(VarValue value) {
        this.set(value.asLong());
    }

    @Override
    protected void clear() {
        this.value = 0L;
    }

    @Override
    protected long valueAdd(long value) {
        this.value += value;
        return this.value;
    }

    @Override
    protected double valueAdd(double value) {
        this.value = (long)((double)this.value + value);
        return this.value;
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("format"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setGroupingUsed(false);
                    if (params.size() == 2) {
                        nf.setMinimumIntegerDigits(params.get(0).asInt());
                        nf.setMaximumIntegerDigits(params.get(1).asInt());
                    } else if (params.size() == 4) {
                        nf.setMinimumIntegerDigits(params.get(0).asInt());
                        nf.setMaximumIntegerDigits(params.get(1).asInt());
                    } else {
                        1.invalidNumberOfParams(script, "minIntDigits,maxIntDigits");
                    }
                    return Var.createValue(nf.format(value.asLong()));
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueLong.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

