/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.util.ArrayList;
import java.util.List;

public class VarValueEnum
extends VarValue {
    protected String value;
    protected List<EnumValue> enumValues;

    public VarValueEnum() {
        this.value = null;
        this.enumValues = new ArrayList<EnumValue>(20);
    }

    public VarValueEnum(String value, List<EnumValue> enumValues) {
        this.value = value;
        this.enumValues = enumValues;
    }

    @Override
    public VarValueEnum clone() {
        ArrayList<EnumValue> ev = new ArrayList<EnumValue>(this.enumValues.size());
        for (EnumValue v : this.enumValues) {
            ev.add(v.clone());
        }
        return new VarValueEnum(this.value, ev);
    }

    @Override
    public String typeName() {
        return "enum";
    }

    protected Long findLong(String name) {
        for (EnumValue v : this.enumValues) {
            if (!v.name.equalsIgnoreCase(name)) continue;
            return v.value;
        }
        return null;
    }

    protected String findString(Long value) {
        for (EnumValue v : this.enumValues) {
            if (v.value != value) continue;
            return v.name;
        }
        return null;
    }

    @Override
    public void setParams(String params) {
        String[] val = params.split("[,]");
        this.enumValues.clear();
        long index = Long.MIN_VALUE;
        String[] stringArray = val;
        int n = val.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int i = s.indexOf(61);
            if (i > 0) {
                index = new Long(Long.parseLong(s.substring(i + 1)));
                s = s.substring(0, i);
            } else if (index == Long.MIN_VALUE) {
                index = new Long(0L);
            }
            this.enumValues.add(new EnumValue(s, index++));
            ++n2;
        }
    }

    @Override
    public String getParams() {
        StringBuilder sb = new StringBuilder();
        long index = 0L;
        for (EnumValue v : this.enumValues) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(v.name);
            if (v.value != index) {
                sb.append('=');
                sb.append(v.value);
                index = v.value;
            }
            ++index;
        }
        return sb.toString();
    }

    @Override
    public boolean asBoolean() {
        return false;
    }

    @Override
    public char asChar() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not value");
        }
        if (v < 0L || v > 0x10FFFFL) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside char range");
        }
        return (char)v.longValue();
    }

    @Override
    public double asDouble() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return v.doubleValue();
    }

    @Override
    public Complex asComplex() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return new Complex(v.doubleValue(), 0.0);
    }

    @Override
    public Vector asVector() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return new Vector(v);
    }

    @Override
    public Matrix asMatrix() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return new Matrix(v);
    }

    @Override
    public float asFloat() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return v.floatValue();
    }

    @Override
    public int asInt() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return v.intValue();
    }

    @Override
    public long asLong() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return v;
    }

    @Override
    public byte[] asBytes() {
        byte[] b = new byte[8];
        long l = this.asLong();
        int i = 0;
        while (i < 8) {
            b[i] = (byte)l;
            l >>= 8;
            ++i;
        }
        return b;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canDouble() {
        return false;
    }

    @Override
    public boolean canComplex() {
        return false;
    }

    @Override
    public boolean canVector() {
        return false;
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    @Override
    public boolean canInt() {
        return true;
    }

    @Override
    public boolean canLong() {
        return true;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isInt() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE;
    }

    @Override
    public boolean isLong() {
        Long v = this.findLong(this.value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
        }
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    protected void clear() {
        this.value = null;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "empty";
        }
        return String.valueOf(this.value) + "(" + this.asLong() + ")";
    }

    @Override
    protected void set(long value) {
        String v = this.findString(value);
        if (v == null) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is not a valid value");
        }
        this.value = v;
    }

    @Override
    protected void set(double value) {
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside range");
        }
        this.set((long)value);
    }

    @Override
    protected void set(String value) {
        if (this.findLong(value) == null) {
            StringBuilder sb = new StringBuilder();
            for (EnumValue ev : this.enumValues) {
                if (ev.name.length() > 0) {
                    sb.append(", ");
                }
                sb.append(ev.name);
                sb.append("(");
                sb.append(ev.value);
                sb.append(")");
            }
            sb.insert(0, " is not in the valid values: ");
            sb.insert(0, value);
            throw new VarExceptions.RangeCheckException(sb.toString());
        }
        this.value = value;
    }

    @Override
    protected void set(VarValue value) {
        if (value.isString()) {
            this.set(value.asString());
        } else if (value.canLong()) {
            this.set(value.asLong());
        } else {
            this.set(value.asString());
        }
    }

    @Override
    protected long valueAdd(long value) {
        int index = 0;
        while (index < this.enumValues.size()) {
            if (this.value.equalsIgnoreCase(this.enumValues.get((int)index).name)) {
                if ((index = (int)((long)index + value)) < 0 || index >= this.enumValues.size()) {
                    throw new VarExceptions.RangeCheckException("Increment outside valid range");
                }
                this.value = this.enumValues.get((int)index).name;
                return this.enumValues.get((int)index).value;
            }
            ++index;
        }
        throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is not a valid value");
    }

    protected class EnumValue {
        final String name;
        final long value;

        public EnumValue(String name, long value) {
            this.name = name;
            this.value = value;
        }

        public EnumValue clone() {
            return this;
        }
    }
}

