/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Support;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.text.NumberFormat;
import java.util.List;

public class VarValueDouble
extends VarValue {
    private double value;
    private double min;
    private double max;
    private static Functions functions = null;

    public VarValueDouble() {
        this.value = 0.0;
        this.min = -1.7976931348623157E308;
        this.max = Double.MAX_VALUE;
    }

    public VarValueDouble(double value) {
        this.value = value;
        this.min = -1.7976931348623157E308;
        this.max = Double.MAX_VALUE;
    }

    public VarValueDouble(double value, double min, double max) {
        this.value = value;
        this.min = min;
        this.max = max;
    }

    @Override
    public VarValueDouble clone() {
        return new VarValueDouble(this.value, this.min, this.max);
    }

    @Override
    public void setParams(String params) {
        String[] val = params.split("[,]");
        this.min = Support.stringToDouble(val[0]);
        this.max = Support.stringToDouble(val[1]);
    }

    @Override
    public String getParams() {
        if (this.min == -3.4028234663852886E38 && this.max == 3.4028234663852886E38) {
            return "";
        }
        if (this.min == -1.7976931348623157E308 && this.max == Double.MAX_VALUE) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.min);
        sb.append(',');
        sb.append(this.max);
        return sb.toString();
    }

    public void setParamsFloat() {
        this.min = -3.4028234663852886E38;
        this.max = 3.4028234663852886E38;
    }

    @Override
    public String typeName() {
        if (this.min == -3.4028234663852886E38 && this.max == 3.4028234663852886E38) {
            return "float";
        }
        return "double";
    }

    @Override
    public boolean asBoolean() {
        return this.value != 0.0;
    }

    @Override
    public char asChar() {
        if (this.value < 0.0 || this.value > 1114111.0) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside char range");
        }
        return (char)this.value;
    }

    @Override
    public float asFloat() {
        if (this.value < -3.4028234663852886E38 || this.value > 3.4028234663852886E38) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside float range");
        }
        return (float)this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public byte[] asBytes() {
        if (this.min == -3.4028234663852886E38 && this.max == 3.4028234663852886E38) {
            byte[] b = new byte[4];
            long l = Float.floatToIntBits((float)this.value);
            int i = 0;
            while (i < 4) {
                b[i] = (byte)l;
                l >>= 8;
                ++i;
            }
            return b;
        }
        byte[] b = new byte[8];
        long l = Double.doubleToLongBits(this.value);
        int i = 0;
        while (i < 8) {
            b[i] = (byte)l;
            l >>= 8;
            ++i;
        }
        return b;
    }

    @Override
    public Complex asComplex() {
        return new Complex(this.value, 0.0);
    }

    @Override
    public Vector asVector() {
        return new Vector(this.value);
    }

    @Override
    public Matrix asMatrix() {
        return new Matrix(this.value);
    }

    @Override
    public int asInt() {
        if (this.value < -2.147483648E9 || this.value > 2.147483647E9) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside int range");
        }
        return (int)this.value;
    }

    @Override
    public long asLong() {
        if (this.value < -9.223372036854776E18 || this.value > 9.223372036854776E18) {
            throw new VarExceptions.RangeCheckException(String.valueOf(this.value) + " is outside long range");
        }
        return (long)this.value;
    }

    @Override
    public String asString() {
        return Double.toString(this.value);
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return this.value >= -3.4028234663852886E38 && this.value <= 3.4028234663852886E38;
    }

    @Override
    public boolean canDouble() {
        return true;
    }

    @Override
    public boolean canComplex() {
        return true;
    }

    @Override
    public boolean canVector() {
        return true;
    }

    @Override
    public boolean canMatrix() {
        return true;
    }

    @Override
    public boolean canInt() {
        return this.value >= -2.147483648E9 && this.value <= 2.147483647E9;
    }

    @Override
    public boolean canLong() {
        return this.value >= -9.223372036854776E18 && this.value <= 9.223372036854776E18;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return this.value >= -3.4028234663852886E38 && this.value <= 3.4028234663852886E38;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    protected void set(long value) {
        if ((double)value < this.min || (double)value > this.max) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside range");
        }
        this.value = value;
    }

    @Override
    protected void set(double value) {
        if ((value < this.min || value > this.max) && value != Double.POSITIVE_INFINITY && value != Double.NEGATIVE_INFINITY) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside range");
        }
        this.value = value;
    }

    @Override
    protected void set(String value) {
        this.set(Support.stringToDouble(value));
    }

    @Override
    protected void set(VarValue value) {
        this.set(value.asDouble());
    }

    @Override
    protected void clear() {
        this.value = 0.0;
    }

    @Override
    protected long valueAdd(long value) {
        this.value += (double)value;
        return (long)this.value;
    }

    @Override
    protected double valueAdd(double value) {
        this.value += value;
        return this.value;
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("format"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    NumberFormat nf = NumberFormat.getInstance();
                    switch (params.size()) {
                        case 2: {
                            nf.setMinimumIntegerDigits(params.get(0).asInt());
                            nf.setMaximumIntegerDigits(params.get(1).asInt());
                            nf.setMinimumFractionDigits(params.get(0).asInt());
                            nf.setMaximumFractionDigits(params.get(0).asInt());
                            break;
                        }
                        case 4: {
                            nf.setMinimumIntegerDigits(params.get(0).asInt());
                            nf.setMaximumIntegerDigits(params.get(1).asInt());
                            nf.setMinimumFractionDigits(params.get(2).asInt());
                            nf.setMaximumFractionDigits(params.get(3).asInt());
                            break;
                        }
                        default: {
                            1.invalidNumberOfParams(script, "minIntDigits,maxIntDigits,minFracDigits,maxFracDigits");
                        }
                    }
                    return Var.createValue(nf.format(value.asDouble()));
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueDouble.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

