/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Support;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class VarValueDateTime
extends VarValue {
    private Date value;
    private SimpleDateFormat sdf;
    private final double DAY_LENGTH = 8.64E7;
    private final String defaultFormat = "yyyyMMddHHmmss";
    private String currentFormat = "";
    private static Functions functions = null;

    public VarValueDateTime() {
        this.value = null;
        this.sdf = null;
    }

    public VarValueDateTime(Date value) {
        this.value = value;
        this.sdf = null;
    }

    public VarValueDateTime(Date value, String format) {
        this.value = value;
        this.currentFormat = format;
        this.sdf = null;
    }

    @Override
    public String typeName() {
        return "dateTime";
    }

    @Override
    public VarValueDateTime clone() {
        return new VarValueDateTime(this.value, this.currentFormat);
    }

    @Override
    public void setParams(String params) {
        this.currentFormat = params;
        this.sdf = new SimpleDateFormat(Support.reformatDateTimeFormat(params));
    }

    @Override
    public String getParams() {
        if (this.currentFormat != null && this.currentFormat.length() > 0) {
            return this.currentFormat;
        }
        return "";
    }

    @Override
    public boolean asBoolean() {
        return false;
    }

    @Override
    public char asChar() {
        return '\u0000';
    }

    @Override
    public double asDouble() {
        return this.value == null ? 0.0 : (double)this.value.getTime() / 8.64E7;
    }

    @Override
    public Complex asComplex() {
        return new Complex(this.asDouble(), 0.0);
    }

    @Override
    public Vector asVector() {
        return new Vector(this.asDouble());
    }

    @Override
    public Matrix asMatrix() {
        return new Matrix(this.asDouble());
    }

    @Override
    public byte[] asBytes() {
        byte[] b = new byte[8];
        long l = this.asLong();
        int i = 0;
        while (i < 8) {
            b[i] = (byte)l;
            l >>= 8;
            ++i;
        }
        return b;
    }

    @Override
    public float asFloat() {
        return this.value == null ? 0.0f : (float)((double)this.value.getTime() / 8.64E7);
    }

    @Override
    public int asInt() {
        return 0;
    }

    @Override
    public Date asDateTime() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value == null ? 0L : this.value.getTime();
    }

    @Override
    public String asString() {
        if (this.sdf == null) {
            this.sdf = new SimpleDateFormat(this.currentFormat == null || this.currentFormat.length() == 0 ? "yyyyMMddHHmmss" : this.currentFormat);
        }
        return this.value == null ? "" : this.sdf.format(this.value);
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canDouble() {
        return this.value != null;
    }

    @Override
    public boolean canComplex() {
        return this.value != null;
    }

    @Override
    public boolean canVector() {
        return false;
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    @Override
    public boolean canInt() {
        return false;
    }

    @Override
    public boolean canLong() {
        return this.value != null;
    }

    @Override
    public boolean canString() {
        return this.value != null;
    }

    @Override
    public boolean canDateTime() {
        return this.value != null;
    }

    @Override
    public boolean isDateTime() {
        return this.value != null;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    protected void clear() {
        this.value = null;
        this.sdf = null;
    }

    @Override
    protected void set(long value) {
        this.value = new Date(value);
    }

    @Override
    protected void set(double value) {
        this.value = new Date((long)(value * 8.64E7));
    }

    @Override
    protected void set(String value) {
        if (this.sdf == null) {
            this.currentFormat = (value = value.trim()).length() == 5 && value.charAt(2) == ':' ? "HH:mm" : (value.length() == 8 && value.charAt(2) == ':' && value.charAt(5) == ':' ? "HH:mm:ss" : (value.length() == 8 && value.charAt(2) == '/' && value.charAt(5) == '-' ? "dd/MM-yy" : (value.length() == 10 && value.charAt(2) == '/' && value.charAt(5) == '-' ? "dd/MM-yyyy" : (value.length() == 6 ? "yyMMdd" : (value.length() == 8 ? "yyyyMMdd" : (value.length() == 12 ? "yyyyMMddHHmm" : (value.length() == 14 ? "yyyyMMddHHmmss" : "yyyyMMddHHmmss")))))));
            this.sdf = new SimpleDateFormat(this.currentFormat);
        }
        try {
            this.value = this.sdf.parse(value);
        }
        catch (Exception e) {
            VarExceptions.ValueException ee = new VarExceptions.ValueException();
            ee.initCause(e);
            throw ee;
        }
    }

    @Override
    protected void set(Date value) {
        this.value = value;
    }

    @Override
    protected void set(VarValue value) {
        if (value.isDateTime()) {
            this.set(value.asDateTime());
        } else if (value.isDouble()) {
            this.set(value.asDouble());
        } else {
            this.set(value.asLong());
        }
    }

    @Override
    protected long valueAdd(long value) {
        this.value = new Date(this.value.getTime() + value);
        return this.asLong();
    }

    @Override
    protected double valueAdd(double value) {
        this.value = new Date(this.value.getTime() + (long)(value * 8.64E7));
        return this.asDouble();
    }

    @Override
    public String toString() {
        return this.asString();
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("setFormat"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        1.invalidNumberOfParams(script, "1");
                    }
                    VarValueDateTime v = (VarValueDateTime)value;
                    v.setParams(params.get(0).asString());
                    return null;
                }
            });
            functions.add(new Functions.FuncVarValue("format"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        2.invalidNumberOfParams(script, "1");
                    }
                    VarValueDateTime v = (VarValueDateTime)value;
                    SimpleDateFormat sdf = new SimpleDateFormat(params.get(0).asString());
                    return Var.createValue(sdf.format(v.value));
                }
            });
            functions.add(new Functions.FuncVarValue("asSeconds"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        3.invalidNumberOfParams(script, "0");
                    }
                    VarValueDateTime v = (VarValueDateTime)value;
                    return Var.createValue(TimeUnit.MILLISECONDS.toSeconds(v.value.getTime()));
                }
            });
            functions.add(new Functions.FuncVarValue("asMinutes"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        4.invalidNumberOfParams(script, "0");
                    }
                    VarValueDateTime v = (VarValueDateTime)value;
                    return Var.createValue(TimeUnit.MILLISECONDS.toMinutes(v.value.getTime()));
                }
            });
            functions.add(new Functions.FuncVarValue("asHours"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        5.invalidNumberOfParams(script, "0");
                    }
                    VarValueDateTime v = (VarValueDateTime)value;
                    return Var.createValue(TimeUnit.MILLISECONDS.toHours(v.value.getTime()));
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueDateTime.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

