/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Support;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.text.NumberFormat;
import java.util.List;

public class VarValueComplex
extends VarValue {
    private Complex value;
    private static Functions functions = null;

    public VarValueComplex() {
        this.value = new Complex();
    }

    public VarValueComplex(double value) {
        this.value = new Complex(value, 0.0);
    }

    public VarValueComplex(double real, double imag) {
        this.value = new Complex(real, imag);
    }

    public VarValueComplex(Complex value) {
        this.value = value;
    }

    @Override
    public VarValueComplex clone() {
        return new VarValueComplex(this.value);
    }

    public Var real() {
        return Var.createValue(this.value.real());
    }

    public Var imag() {
        return Var.createValue(this.value.imag());
    }

    public Var absImag() {
        return Var.createValue(Math.abs(this.value.imag()));
    }

    @Override
    public void setParams(String params) {
    }

    @Override
    public String getParams() {
        return "";
    }

    @Override
    public String typeName() {
        return "complex";
    }

    public boolean isNaN() {
        return this.value.isNaN();
    }

    public boolean isInfinite() {
        return this.value.isInfinite();
    }

    public double abs() {
        return this.value.abs();
    }

    public boolean equal(Complex v) {
        return this.value.real() == v.real() && this.value.imag() == v.imag();
    }

    @Override
    public boolean asBoolean() {
        return this.value.real() != 0.0 || this.value.imag() != 0.0;
    }

    @Override
    public char asChar() {
        if (!this.value.isReal()) {
            throw new VarExceptions.RangeCheckException(this.value + " is a complex number");
        }
        return (char)this.value.real();
    }

    @Override
    public float asFloat() {
        if (!this.value.isReal()) {
            throw new VarExceptions.RangeCheckException(this.value + " is a complex number");
        }
        double value = this.value.real();
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside float range");
        }
        return (float)value;
    }

    @Override
    public double asDouble() {
        if (!this.value.isReal()) {
            throw new VarExceptions.RangeCheckException(this.value + " is a complex number");
        }
        return this.value.real();
    }

    @Override
    public Complex asComplex() {
        return this.value;
    }

    @Override
    public Vector asVector() {
        return new Vector(this.value.abs());
    }

    @Override
    public Matrix asMatrix() {
        return new Matrix(this.value.abs());
    }

    @Override
    public int asInt() {
        if (!this.value.isReal()) {
            throw new VarExceptions.RangeCheckException(this.value + " is a complex number");
        }
        double value = this.value.real();
        if (value < -2.147483648E9 || value > 2.147483647E9) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside int range");
        }
        return (int)value;
    }

    @Override
    public long asLong() {
        if (!this.value.isReal()) {
            throw new VarExceptions.RangeCheckException(this.value + " is a complex number");
        }
        double value = this.value.real();
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18) {
            throw new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside long range");
        }
        return (long)value;
    }

    @Override
    public String asString() {
        return this.value.toString();
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return this.value.isReal() && this.value.real() >= -3.4028234663852886E38 && this.value.real() <= 3.4028234663852886E38;
    }

    @Override
    public boolean canDouble() {
        return this.value.isReal();
    }

    @Override
    public boolean canComplex() {
        return true;
    }

    @Override
    public boolean canVector() {
        return this.value.isReal();
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canInt() {
        return this.value.isReal() && this.value.real() >= -2.147483648E9 && this.value.real() <= 2.147483647E9;
    }

    @Override
    public boolean canLong() {
        return this.value.isReal() && this.value.real() >= -9.223372036854776E18 && this.value.real() <= 9.223372036854776E18;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public byte[] asBytes() {
        byte[] b = new byte[16];
        long l = Double.doubleToLongBits(this.value.real());
        int i = 0;
        while (i < 8) {
            b[i] = (byte)l;
            l >>= 8;
            ++i;
        }
        l = Double.doubleToLongBits(this.value.imag());
        i = 0;
        while (i < 8) {
            b[i + 8] = (byte)l;
            l >>= 8;
            ++i;
        }
        return b;
    }

    @Override
    protected void set(long value) {
        this.value = new Complex(value, 0.0);
    }

    @Override
    protected void set(double value) {
        this.value = new Complex(value, 0.0);
    }

    @Override
    protected void set(Complex value) {
        this.value = value;
    }

    @Override
    protected void set(String value) {
        this.set(Support.stringToDouble(value));
    }

    @Override
    protected void set(VarValue value) {
        this.set(value.asComplex());
    }

    @Override
    protected void clear() {
        this.value = new Complex();
    }

    @Override
    protected long valueAdd(long value) {
        this.value = this.value.add(value);
        return (long)this.value.real();
    }

    @Override
    protected double valueAdd(double value) {
        this.value = this.value.add(value);
        return (long)this.value.real();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("format"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setGroupingUsed(false);
                    switch (params.size()) {
                        case 2: {
                            nf.setMinimumIntegerDigits(params.get(0).asInt());
                            nf.setMaximumIntegerDigits(params.get(1).asInt());
                            nf.setMinimumFractionDigits(params.get(0).asInt());
                            nf.setMaximumFractionDigits(params.get(0).asInt());
                            break;
                        }
                        case 4: {
                            nf.setMinimumIntegerDigits(params.get(0).asInt());
                            nf.setMaximumIntegerDigits(params.get(1).asInt());
                            nf.setMinimumFractionDigits(params.get(2).asInt());
                            nf.setMaximumFractionDigits(params.get(3).asInt());
                            break;
                        }
                        default: {
                            1.invalidNumberOfParams(script, "minIntDigits,maxIntDigits,minFracDigits,maxFracDigits");
                        }
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(nf.format(value.asComplex().real()));
                    sb.append(value.asComplex().imag() < 0.0 ? (char)'-' : '+');
                    sb.append(String.valueOf(nf.format(Math.abs(value.asComplex().imag()))) + Complex.complexChar);
                    return Var.createValue(sb.toString());
                }
            });
            functions.add(new Functions.FuncVarValue("r"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        2.invalidNumberOfParams(script, "no parameters");
                    }
                    return Var.createValue(value.asComplex().real());
                }
            });
            functions.add(new Functions.FuncVarValue("i"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        3.invalidNumberOfParams(script, "no parameters");
                    }
                    return Var.createValue(value.asComplex().imag());
                }
            });
            functions.add(new Functions.FuncVarValue("v"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        4.invalidNumberOfParams(script, "no parameters");
                    }
                    return Var.createValue(value.asComplex().abs());
                }
            });
            functions.add(new Functions.FuncVarValue("a"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        5.invalidNumberOfParams(script, "no parameters");
                    }
                    return Var.createValue(value.asComplex().phase());
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueComplex.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

