/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.color.ColorUtil;
import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.awt.Color;
import java.util.List;

public class VarValueColor
extends VarValue {
    private Color value;
    private static Functions functions = null;

    public VarValueColor() {
        this.value = Color.BLACK;
    }

    public VarValueColor(Color value) {
        this.value = value;
    }

    @Override
    public String typeName() {
        return "color";
    }

    @Override
    public VarValueColor clone() {
        return new VarValueColor(this.value);
    }

    @Override
    public void setParams(String params) {
    }

    @Override
    public boolean asBoolean() {
        return false;
    }

    @Override
    public char asChar() {
        return '\u0000';
    }

    @Override
    public double asDouble() {
        return 0.0;
    }

    @Override
    public Complex asComplex() {
        return new Complex();
    }

    @Override
    public Vector asVector() {
        return new Vector();
    }

    @Override
    public Matrix asMatrix() {
        return new Matrix();
    }

    @Override
    public float asFloat() {
        return 0.0f;
    }

    @Override
    public int asInt() {
        return this.value.getRGB();
    }

    @Override
    public long asLong() {
        return this.asInt();
    }

    @Override
    public String asString() {
        return ColorUtil.colorToName(this.value);
    }

    @Override
    public Color asColor() {
        return this.value;
    }

    @Override
    public byte[] asBytes() {
        byte[] b = new byte[4];
        int i = this.asInt();
        b[0] = (byte)i;
        b[1] = (byte)(i >> 8);
        b[2] = (byte)(i >> 16);
        b[3] = (byte)(i >> 24);
        return b;
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canDouble() {
        return false;
    }

    @Override
    public boolean canComplex() {
        return false;
    }

    @Override
    public boolean canVector() {
        return false;
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    @Override
    public boolean canInt() {
        return true;
    }

    @Override
    public boolean canLong() {
        return true;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isColor() {
        return true;
    }

    @Override
    protected void clear() {
        this.value = Color.BLACK;
    }

    @Override
    public String toString() {
        return ColorUtil.colorToName(this.value);
    }

    @Override
    protected void set(long value) {
        this.value = new Color((int)value);
    }

    @Override
    protected void set(Color value) {
        this.value = value;
    }

    @Override
    protected void set(double value) {
        throw new VarExceptions.ValueException("Not supported by type");
    }

    @Override
    protected void set(String value) {
        this.value = ColorUtil.nameToColor(value);
    }

    @Override
    protected void set(VarValue value) {
        if (value.isColor()) {
            this.value = ((VarValueColor)value).value;
        } else if (value.isString()) {
            this.set(value.asString());
        } else if (value.isInt()) {
            this.set(value.asInt());
        } else {
            this.set(value.asString());
        }
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("name"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        1.invalidNumberOfParams(script, "");
                    }
                    return Var.createValue(ColorUtil.colorToName(value.asColor()));
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueColor.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

