/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.util.List;

public class VarValueChar
extends VarValue {
    protected char value;
    private static Functions functions = null;

    public VarValueChar() {
        this.value = '\u0000';
    }

    public VarValueChar(char value) {
        this.value = value;
    }

    @Override
    public VarValue clone() {
        return new VarValueChar(this.value);
    }

    @Override
    public String typeName() {
        return "char";
    }

    @Override
    public boolean asBoolean() {
        return this.value != '\u0000';
    }

    @Override
    public char asChar() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public Complex asComplex() {
        return new Complex(this.value, 0.0);
    }

    @Override
    public Vector asVector() {
        return new Vector(this.value);
    }

    @Override
    public Matrix asMatrix() {
        return new Matrix(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public byte[] asBytes() {
        byte[] b = new byte[]{(byte)this.value};
        return b;
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean canBoolean() {
        return true;
    }

    @Override
    public boolean canChar() {
        return true;
    }

    @Override
    public boolean canDouble() {
        return false;
    }

    @Override
    public boolean canComplex() {
        return false;
    }

    @Override
    public boolean canVector() {
        return false;
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    @Override
    public boolean canInt() {
        return true;
    }

    @Override
    public boolean canLong() {
        return true;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isChar() {
        return true;
    }

    @Override
    protected void clear() {
        this.value = '\u0000';
    }

    @Override
    protected void set(long value) {
        if (value < 0L || value > 65535L) {
            new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside range");
        }
        this.value = (char)value;
    }

    @Override
    protected void set(double value) {
        if (value < 0.0 || value > 65535.0) {
            new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside range");
        }
        this.value = (char)value;
    }

    @Override
    protected void set(String value) {
        if (value.length() != 1) {
            new VarExceptions.RangeCheckException(String.valueOf(value) + " is outside range");
        }
        this.value = value.charAt(0);
    }

    @Override
    protected void set(VarValue value) {
        this.set(value.asChar());
    }

    @Override
    protected long valueAdd(long value) {
        this.value = (char)(this.value + (char)value);
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("toLowerCase"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    VarValueChar v = (VarValueChar)value;
                    return Var.createValue(Character.toLowerCase(v.value));
                }
            });
            functions.add(new Functions.FuncVarValue("toUpperCase"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    VarValueChar v = (VarValueChar)value;
                    return Var.createValue(Character.toUpperCase(v.value));
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueChar.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

