/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.StringUtil;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class VarValueBytes
extends VarValue {
    private byte[] value;
    private static Functions functions = null;

    public VarValueBytes() {
        this.value = new byte[0];
    }

    public VarValueBytes(String value) {
        try {
            this.value = value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            this.value = value.getBytes();
        }
    }

    public VarValueBytes(byte[] value) {
        this.value = value;
    }

    @Override
    public String typeName() {
        return "bytes";
    }

    @Override
    public VarValueBytes clone() {
        return new VarValueBytes(this.value);
    }

    @Override
    public boolean asBoolean() {
        return this.value.length > 0 && this.asLong() != 0L;
    }

    @Override
    public char asChar() {
        if (this.value.length == 1) {
            return (char)(this.value[0] & 0xFF);
        }
        return '\u0000';
    }

    @Override
    public float asFloat() {
        if (this.value.length == 4) {
            return Float.intBitsToFloat((int)this.asLong());
        }
        return (float)Double.longBitsToDouble(this.asLong());
    }

    @Override
    public double asDouble() {
        if (this.value.length == 4) {
            return Float.intBitsToFloat((int)this.asLong());
        }
        return Double.longBitsToDouble(this.asLong());
    }

    @Override
    public Complex asComplex() {
        throw new VarExceptions.ConversionException("bytes cannot be converted");
    }

    @Override
    public Vector asVector() {
        throw new VarExceptions.ConversionException("bytes cannot be converted");
    }

    @Override
    public Matrix asMatrix() {
        throw new VarExceptions.ConversionException("bytes cannot be converted");
    }

    @Override
    public int asInt() {
        return (int)this.asLong();
    }

    @Override
    public long asLong() {
        if (this.value.length > 8) {
            throw new VarExceptions.ConversionException("bytes cannot be converted");
        }
        long l = 0L;
        int i = 0;
        while (i < this.value.length) {
            l |= ((long)this.value[i] & 0xFFL) << i * 8;
            ++i;
        }
        return l;
    }

    @Override
    public byte[] asBytes() {
        return this.value;
    }

    @Override
    public String asString() {
        return "$" + StringUtil.hexNN(this.value) + "$";
    }

    @Override
    public String toString() {
        boolean txt = true;
        int i = 0;
        while (i < this.value.length) {
            if (this.value[i] != 13 && this.value[i] != 10 && this.value[i] < 32 || this.value[i] >= 127) {
                txt = false;
                break;
            }
            ++i;
        }
        if (txt) {
            return "\"" + new String(this.value) + "\"";
        }
        return "$" + StringUtil.hexNN(this.value) + "$";
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return this.value.length == 1;
    }

    @Override
    public boolean canFloat() {
        return this.value.length == 4;
    }

    @Override
    public boolean canDouble() {
        return this.value.length == 4 || this.value.length == 8;
    }

    @Override
    public boolean canComplex() {
        return false;
    }

    @Override
    public boolean canVector() {
        return false;
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canInt() {
        return this.value.length == 4;
    }

    @Override
    public boolean canLong() {
        return this.value.length == 8;
    }

    @Override
    public boolean canString() {
        return true;
    }

    @Override
    public boolean isChar() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBytes() {
        return true;
    }

    @Override
    protected void set(double value) {
        this.set(Double.doubleToLongBits(value));
    }

    @Override
    protected void set(long value) {
        byte[] b = new byte[8];
        int i = 0;
        while (i < 8) {
            b[i] = (byte)value;
            value >>= 8;
            ++i;
        }
        this.value = b;
    }

    @Override
    protected void set(String value) {
        byte[] b = new byte[value.length()];
        int i = 0;
        while (i < value.length()) {
            b[i] = (byte)value.charAt(i);
            ++i;
        }
        this.value = b;
    }

    @Override
    protected void set(byte[] value) {
        this.value = value;
    }

    @Override
    protected void set(VarValue value) {
        this.set(value.asBytes());
    }

    @Override
    protected void clear() {
        this.value = new byte[0];
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("length"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    VarValueBytes v = (VarValueBytes)value;
                    return Var.createValue(v.value.length);
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public int getSize() {
        return this.value.length;
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueBytes.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }
}

