/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class VarValueArray
extends VarValue {
    private List<Var> array;
    private static Functions functions = null;

    public VarValueArray() {
        this.array = new ArrayList<Var>(10);
    }

    public VarValueArray(List<Var> array) {
        this.array = array;
    }

    public void sort(String fieldNames) {
        Collections.sort(this.array, new CompareValue(fieldNames));
    }

    public int findValue(Var value, String fieldName) {
        CompareValue cv = new CompareValue(fieldName);
        int i = 0;
        while (i < this.array.size()) {
            if (cv.compare(value, this.array.get(i)) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Var partOf(int firstIndex, int size) {
        Var v = Var.createArray();
        int i = 0;
        while (i < size) {
            if (i + firstIndex < this.array.size()) {
                v.addVar(this.array.get(i + firstIndex));
            }
            ++i;
        }
        return v;
    }

    public Var copyOf(int firstIndex, int size) {
        Var v = Var.createArray();
        int i = 0;
        while (i < size) {
            if (i + firstIndex < this.array.size()) {
                v.addVar(this.array.get(i + firstIndex).clone());
            }
            ++i;
        }
        return v;
    }

    @Override
    public VarValueArray clone() {
        ArrayList<Var> list = new ArrayList<Var>(this.array.size());
        for (Var v : list) {
            list.add(v.clone());
        }
        return new VarValueArray(list);
    }

    @Override
    public VarValue cloneSimple() {
        return this;
    }

    @Override
    public String typeName() {
        return "array";
    }

    @Override
    public boolean asBoolean() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public char asChar() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public float asFloat() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public double asDouble() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public Complex asComplex() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public Vector asVector() {
        ArrayList<Double> list = new ArrayList<Double>();
        int i = 0;
        while (i < this.array.size()) {
            list.add(this.array.get(i).asDouble());
            ++i;
        }
        return new Vector(list);
    }

    @Override
    public Matrix asMatrix() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public int asInt() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public long asLong() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public String asString() {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    public byte[] asBytes() {
        ByteBuffer bb = new ByteBuffer();
        for (Var v : this.array) {
            bb.append(v.asBytes());
        }
        return bb.getAsArray();
    }

    @Override
    public boolean canBoolean() {
        return false;
    }

    @Override
    public boolean canChar() {
        return false;
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    @Override
    public boolean canDouble() {
        return false;
    }

    @Override
    public boolean canComplex() {
        return false;
    }

    @Override
    public boolean canVector() {
        int i = 0;
        while (i < this.array.size()) {
            if (!this.array.get(i).canDouble()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean canMatrix() {
        return false;
    }

    @Override
    public boolean canInt() {
        return false;
    }

    @Override
    public boolean canLong() {
        return false;
    }

    @Override
    public boolean canString() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.array.size() == 0;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    protected void set(long value) {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    protected void set(double value) {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    protected void set(String value) {
        throw new VarExceptions.ValueException("A array can not contain a value");
    }

    @Override
    protected void set(VarValue value) {
        if (!value.isArray()) {
            throw new VarExceptions.ValueException("A array can not contain a value");
        }
        this.array.clear();
        this.array.addAll(((VarValueArray)value).array);
    }

    @Override
    protected synchronized void clear() {
        this.array.clear();
    }

    public synchronized void addVar(Var element) {
        this.array.add(element);
    }

    public synchronized void addVar(int index, Var element) {
        while (this.array.size() < index) {
            this.array.add(new Var("[" + this.array.size() + "]"));
        }
        if (this.array.size() > index) {
            this.array.set(index, element);
        } else {
            this.array.add(index, element);
        }
    }

    public synchronized Var getVar(int index) {
        if (index >= this.array.size()) {
            return null;
        }
        return this.array.get(index);
    }

    public synchronized Var getVar(Integer index) {
        if (index >= this.array.size()) {
            return null;
        }
        return this.array.get(index);
    }

    @Override
    public synchronized Collection<Var> getVars() {
        return this.array;
    }

    @Override
    public synchronized int getSize() {
        return this.array.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ARRAY[");
        sb.append(this.array.size());
        sb.append("]=");
        for (Var v : this.getVars()) {
            sb.append(v.toString());
        }
        sb.append("  ");
        return sb.toString();
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("size"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 0) {
                        1.invalidNumberOfParams(script, "");
                    }
                    return Var.createValue(value.getSize());
                }
            });
            functions.add(new Functions.FuncVarValue("sort"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 1) {
                        2.invalidNumberOfParams(script, "fieldList");
                    }
                    ((VarValueArray)value).sort(params.get(0).asString());
                    return Var.createValue(value.getSize());
                }
            });
            functions.add(new Functions.FuncVarValue("find"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    int n;
                    if (params.size() != 2) {
                        3.invalidNumberOfParams(script, "value,fieldName");
                    }
                    return (n = ((VarValueArray)value).findValue(params.get(0), params.get(1).asString())) < 0 ? null : ((VarValueArray)value).getVar(n);
                }
            });
            functions.add(new Functions.FuncVarValue("findIndex"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 2) {
                        4.invalidNumberOfParams(script, "value,fieldName");
                    }
                    return Var.createValue(((VarValueArray)value).findValue(params.get(0), params.get(1).asString()));
                }
            });
            functions.add(new Functions.FuncVarValue("partOf"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 2) {
                        5.invalidNumberOfParams(script, "firstIndex,size");
                    }
                    return ((VarValueArray)value).partOf(params.get(0).asInt(), params.get(1).asInt());
                }
            });
            functions.add(new Functions.FuncVarValue("copyOf"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() != 2) {
                        6.invalidNumberOfParams(script, "firstIndex,size");
                    }
                    return ((VarValueArray)value).copyOf(params.get(0).asInt(), params.get(1).asInt());
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    @Override
    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = super.findFunc(name);
        if (func == null) {
            func = VarValueArray.findFuncStatic(name);
        }
        if (func != null) {
            func.setValue(this);
        }
        return func;
    }

    static class CompareValue
    implements Comparator<Object> {
        String[] fieldNames;

        CompareValue(String fieldNames) {
            this.fieldNames = fieldNames == null || fieldNames.trim().length() == 0 ? null : fieldNames.split("[;, ]");
        }

        @Override
        public int compare(Var o1, Var o2) {
            if (this.fieldNames == null) {
                return o1.compareTo(o2);
            }
            int n = 0;
            while (n < this.fieldNames.length) {
                Var f1 = o1.isStruct() ? o1.find(this.fieldNames[n]) : o1;
                Var f2 = o2.find(this.fieldNames[n]);
                int cmp = 0;
                cmp = f1 != null && f2 != null ? f1.compareTo(f2) : (f1 == null && f2 == null ? 0 : (f1 == null ? 1 : -1));
                if (cmp != 0) {
                    return cmp;
                }
                ++n;
            }
            return 0;
        }

        @Override
        public int compare(Object o1, Object o2) {
            return this.compare((Var)o1, (Var)o2);
        }
    }
}

