/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.StringUtil;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarValueArray;
import dk.hkj.vars.VarValueColor;
import dk.hkj.vars.VarValueComplex;
import dk.hkj.vars.VarValueDateTime;
import dk.hkj.vars.VarValueDouble;
import dk.hkj.vars.VarValueEnum;
import dk.hkj.vars.VarValueLong;
import dk.hkj.vars.VarValueString;
import dk.hkj.vars.VarValueStruct;
import java.awt.Color;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class VarValue {
    private static Map<String, String> userTypes = null;
    private static Functions functions = null;

    public int compareTo(VarValue v) {
        if (this.isDouble() || v.isDouble()) {
            double v2;
            double v1 = this.asDouble();
            if (v1 > (v2 = v.asDouble())) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }
        if (this.canLong() && v.canLong()) {
            long v2;
            long v1 = this.asLong();
            if (v1 > (v2 = v.asLong())) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }
        if (this.isComplex() || v.isComplex()) {
            double v2;
            double v1 = this.asComplex().abs();
            if (v1 > (v2 = v.asComplex().abs())) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }
        String v1 = this.asString();
        String v2 = v.asString();
        return v1.compareTo(v2);
    }

    static void addUserType(String userType, String systemType, String params) {
        if (userTypes == null) {
            userTypes = new HashMap<String, String>();
        }
        userTypes.put(userType, String.valueOf(systemType) + "|" + params);
    }

    static VarValue getType(String typeName) {
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        if (typeName.equalsIgnoreCase("long")) {
            return new VarValueLong();
        }
        if (typeName.equalsIgnoreCase("int")) {
            VarValueLong v = new VarValueLong();
            v.setParamsInt();
            return v;
        }
        if (typeName.equalsIgnoreCase("boolean")) {
            VarValueLong v = new VarValueLong();
            v.setParamsBoolean();
            return v;
        }
        if (typeName.equalsIgnoreCase("char")) {
            VarValueLong v = new VarValueLong();
            v.setParamsChar();
            return v;
        }
        if (typeName.equalsIgnoreCase("string")) {
            return new VarValueString();
        }
        if (typeName.equalsIgnoreCase("double")) {
            return new VarValueDouble();
        }
        if (typeName.equalsIgnoreCase("float")) {
            VarValueDouble v = new VarValueDouble();
            v.setParamsFloat();
            return v;
        }
        if (typeName.equalsIgnoreCase("struct")) {
            return new VarValueStruct();
        }
        if (typeName.equalsIgnoreCase("array")) {
            return new VarValueArray();
        }
        if (typeName.equalsIgnoreCase("enum")) {
            return new VarValueEnum();
        }
        if (typeName.equalsIgnoreCase("dateTime")) {
            return new VarValueDateTime();
        }
        if (typeName.equalsIgnoreCase("color")) {
            return new VarValueColor();
        }
        if (typeName.equalsIgnoreCase("complex")) {
            return new VarValueComplex();
        }
        String type = userTypes.get(typeName);
        if (type != null) {
            String[] s = type.split("[|]");
            VarValue v = VarValue.getType(s[0]);
            v.setParams(s[1]);
            return v;
        }
        throw new VarExceptions.SyntaxException("Unknown type requested " + typeName);
    }

    public void setParams(String params) {
        if (params != null && params.trim().length() > 0) {
            throw new VarExceptions.SyntaxException("Params not valid for type");
        }
    }

    public String getParams() {
        return "";
    }

    public abstract VarValue clone();

    public VarValue cloneSimple() {
        return this.clone();
    }

    public abstract String typeName();

    public abstract boolean asBoolean();

    public abstract char asChar();

    public abstract int asInt();

    public abstract long asLong();

    public abstract float asFloat();

    public abstract double asDouble();

    public abstract Complex asComplex();

    public abstract Vector asVector();

    public abstract Matrix asMatrix();

    public abstract String asString();

    public abstract byte[] asBytes();

    public Date asDateTime() {
        return null;
    }

    public Color asColor() {
        return null;
    }

    public abstract boolean canBoolean();

    public abstract boolean canChar();

    public abstract boolean canInt();

    public abstract boolean canLong();

    public abstract boolean canFloat();

    public abstract boolean canDouble();

    public abstract boolean canComplex();

    public abstract boolean canVector();

    public abstract boolean canMatrix();

    public abstract boolean canString();

    public boolean canDateTime() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isColor() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isStruct() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isBytes() {
        return false;
    }

    public boolean isComplex() {
        return false;
    }

    public boolean isVector() {
        return false;
    }

    public boolean isMatrix() {
        return false;
    }

    private static Functions.FuncVarValue findFuncStatic(String name) {
        if (functions == null) {
            functions = new Functions();
            functions.add(new Functions.FuncVarValue("asString"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        1.invalidNumberOfParams(script, "none");
                    }
                    return Var.createValue(value.asString());
                }
            });
            functions.add(new Functions.FuncVarValue("asInt"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        2.invalidNumberOfParams(script, "none");
                    }
                    return Var.createValue(value.asInt());
                }
            });
            functions.add(new Functions.FuncVarValue("asLong"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        3.invalidNumberOfParams(script, "none");
                    }
                    return Var.createValue(value.asLong());
                }
            });
            functions.add(new Functions.FuncVarValue("asFloat"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        4.invalidNumberOfParams(script, "none");
                    }
                    return Var.createValue(value.asFloat());
                }
            });
            functions.add(new Functions.FuncVarValue("asBoolean"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        5.invalidNumberOfParams(script, "none");
                    }
                    return Var.createValue(value.asBoolean());
                }
            });
            functions.add(new Functions.FuncVarValue("formatLeft"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() < 1 || params.size() > 2) {
                        6.invalidNumberOfParams(script, "1 or 2");
                    }
                    String str = value.asString();
                    int len = params.get(0).asInt();
                    char filler = params.size() >= 2 ? (char)params.get(1).asChar() : (char)' ';
                    return Var.createValue(StringUtil.formatLeft(str, len, filler));
                }
            });
            functions.add(new Functions.FuncVarValue("formatRight"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() < 1 || params.size() > 2) {
                        7.invalidNumberOfParams(script, "1 or 2");
                    }
                    String str = value.asString();
                    int len = params.get(0).asInt();
                    char filler = params.size() >= 2 ? (char)params.get(1).asChar() : (char)' ';
                    return Var.createValue(StringUtil.formatRight(str, len, filler));
                }
            });
            functions.add(new Functions.FuncVarValue("formatCenter"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() < 1 || params.size() > 2) {
                        8.invalidNumberOfParams(script, "1 or 2");
                    }
                    String str = value.asString();
                    int len = params.get(0).asInt();
                    char filler = params.size() >= 2 ? (char)params.get(1).asChar() : (char)' ';
                    return Var.createValue(StringUtil.formatCenter(str, len, filler));
                }
            });
            functions.add(new Functions.FuncVarValue("toString"){

                @Override
                public Var execute(VarValue value, Script script, List<Var> params) {
                    if (params.size() > 0) {
                        9.invalidNumberOfParams(script, "none");
                    }
                    return Var.createValue(value.toString());
                }
            });
        }
        return (Functions.FuncVarValue)functions.find(name);
    }

    public Functions.FuncVarValue findFunc(String name) {
        Functions.FuncVarValue func = VarValue.findFuncStatic(name);
        if (func != null) {
            func.setValue(this);
            return func;
        }
        return null;
    }

    protected abstract void set(long var1);

    protected abstract void set(double var1);

    protected abstract void set(String var1);

    protected abstract void set(VarValue var1);

    protected void set(Complex value) {
        throw new VarExceptions.SyntaxException("Not valid for type");
    }

    protected void set(byte[] value) {
        throw new VarExceptions.SyntaxException("Not valid for type");
    }

    protected void set(Vector value) {
        throw new VarExceptions.SyntaxException("Not valid for type");
    }

    protected void set(Matrix value) {
        throw new VarExceptions.SyntaxException("Not valid for type");
    }

    protected void set(Date value) {
        throw new VarExceptions.SyntaxException("Not valid for type");
    }

    protected void set(Color value) {
        throw new VarExceptions.SyntaxException("Not valid for type");
    }

    protected abstract void clear();

    protected long valueAdd(long value) {
        throw new VarExceptions.SyntaxException("Not valid for type");
    }

    protected double valueAdd(double value) {
        throw new VarExceptions.SyntaxException("Not valid for type");
    }

    public String toString() {
        return "--Not implementet--";
    }

    public List<String> getNames() {
        throw new VarExceptions.IndexException("Only valid for arrays/structs");
    }

    public Collection<Var> getVars() {
        throw new VarExceptions.IndexException("Only valid for arrays/structs");
    }

    public int getSize() {
        return 1;
    }
}

