/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.script.Functions;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Support;
import dk.hkj.vars.VarExceptions;
import dk.hkj.vars.VarPredefined;
import dk.hkj.vars.VarValue;
import dk.hkj.vars.VarValueArray;
import dk.hkj.vars.VarValueBytes;
import dk.hkj.vars.VarValueChar;
import dk.hkj.vars.VarValueColor;
import dk.hkj.vars.VarValueComplex;
import dk.hkj.vars.VarValueDateTime;
import dk.hkj.vars.VarValueDouble;
import dk.hkj.vars.VarValueLong;
import dk.hkj.vars.VarValueMatrix;
import dk.hkj.vars.VarValueString;
import dk.hkj.vars.VarValueStruct;
import dk.hkj.vars.VarValueVector;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Var
implements Comparable<Var> {
    private static final VarPredefined predefined = new VarPredefined();
    private VarValue value = null;
    private Functions funcList = null;
    private String name = "";
    private String predef = null;
    private boolean typeLock = false;
    private boolean readOnly = false;
    private Functions functions = null;
    public static Var gl = new Var("globalList");

    public Var() {
    }

    public Var(String name) {
        this();
        this.name = name;
    }

    public Var(VarValue value) {
        this();
        this.name = "";
        this.value = value;
    }

    public Var(String name, VarValue value) {
        this();
        this.name = name;
        this.value = value;
    }

    public Var clone() {
        Var v = new Var();
        v.value = this.value.clone();
        v.name = this.name;
        v.predef = this.predef;
        v.funcList = this.funcList;
        v.typeLock = this.typeLock;
        v.readOnly = this.readOnly;
        return v;
    }

    public Var cloneSimple() {
        Var v = new Var();
        v.value = this.value.cloneSimple();
        v.name = this.name;
        v.predef = this.predef;
        v.funcList = this.funcList;
        v.typeLock = this.typeLock;
        v.readOnly = this.readOnly;
        return v;
    }

    public String getName() {
        return this.name;
    }

    public synchronized boolean asBoolean() {
        if (this.value == null) {
            return false;
        }
        return this.value.asBoolean();
    }

    public synchronized char asChar() {
        if (this.value == null) {
            return '\u0000';
        }
        return this.value.asChar();
    }

    public synchronized int asInt() {
        if (this.value == null) {
            return 0;
        }
        return this.value.asInt();
    }

    public synchronized long asLong() {
        if (this.value == null) {
            return 0L;
        }
        return this.value.asLong();
    }

    public synchronized Complex asComplex() {
        if (this.value == null) {
            return new Complex();
        }
        return this.value.asComplex();
    }

    public synchronized Vector asVector() {
        if (this.value == null) {
            return new Vector();
        }
        return this.value.asVector();
    }

    public synchronized Matrix asMatrix() {
        if (this.value == null) {
            return new Matrix();
        }
        return this.value.asMatrix();
    }

    public synchronized double asDouble() {
        if (this.value == null) {
            return 0.0;
        }
        return this.value.asDouble();
    }

    public synchronized float asFloat() {
        if (this.value == null) {
            return 0.0f;
        }
        return this.value.asFloat();
    }

    public synchronized String asString() {
        if (this.value == null) {
            return "";
        }
        return this.value.asString();
    }

    public synchronized Date asDateTime() {
        if (this.value == null) {
            return null;
        }
        return this.value.asDateTime();
    }

    public synchronized Color asColor() {
        if (this.value == null) {
            return null;
        }
        return this.value.asColor();
    }

    public byte[] asBytes() {
        if (this.value == null) {
            return null;
        }
        return this.value.asBytes();
    }

    public synchronized boolean canBoolean() {
        if (this.value == null) {
            return false;
        }
        return this.value.canBoolean();
    }

    public synchronized boolean canChar() {
        if (this.value == null) {
            return false;
        }
        return this.value.canChar();
    }

    public synchronized boolean canInt() {
        if (this.value == null) {
            return false;
        }
        return this.value.canInt();
    }

    public synchronized boolean canLong() {
        if (this.value == null) {
            return false;
        }
        return this.value.canLong();
    }

    public synchronized boolean canDouble() {
        if (this.value == null) {
            return false;
        }
        return this.value.canDouble();
    }

    public synchronized boolean canComplex() {
        if (this.value == null) {
            return false;
        }
        return this.value.canComplex();
    }

    public synchronized boolean canVector() {
        if (this.value == null) {
            return false;
        }
        return this.value.canVector();
    }

    public synchronized boolean canMatrix() {
        if (this.value == null) {
            return false;
        }
        return this.value.canMatrix();
    }

    public synchronized boolean canFloat() {
        if (this.value == null) {
            return false;
        }
        return this.value.canFloat();
    }

    public synchronized boolean canString() {
        if (this.value == null) {
            return false;
        }
        return this.value.canString();
    }

    public synchronized boolean canDateTime() {
        if (this.value == null) {
            return false;
        }
        return this.value.canDateTime();
    }

    public synchronized boolean isBoolean() {
        if (this.value == null) {
            return false;
        }
        return this.value.isBoolean();
    }

    public synchronized boolean isChar() {
        if (this.value == null) {
            return false;
        }
        return this.value.isChar();
    }

    public synchronized boolean isInt() {
        if (this.value == null) {
            return false;
        }
        return this.value.isInt();
    }

    public synchronized boolean isLong() {
        if (this.value == null) {
            return false;
        }
        return this.value.isLong();
    }

    public synchronized boolean isDouble() {
        if (this.value == null) {
            return false;
        }
        return this.value.isDouble();
    }

    public synchronized boolean isComplex() {
        if (this.value == null) {
            return false;
        }
        return this.value.isComplex();
    }

    public synchronized boolean isBytes() {
        if (this.value == null) {
            return false;
        }
        return this.value.isBytes();
    }

    public synchronized boolean isVector() {
        if (this.value == null) {
            return false;
        }
        return this.value.isVector();
    }

    public synchronized boolean isMatrix() {
        if (this.value == null) {
            return false;
        }
        return this.value.isMatrix();
    }

    public synchronized boolean isFloat() {
        if (this.value == null) {
            return false;
        }
        return this.value.isFloat();
    }

    public synchronized boolean isString() {
        if (this.value == null) {
            return false;
        }
        return this.value.isString();
    }

    public synchronized boolean isDateTime() {
        if (this.value == null) {
            return false;
        }
        return this.value.isDateTime();
    }

    public synchronized boolean isColor() {
        if (this.value == null) {
            return false;
        }
        return this.value.isColor();
    }

    public synchronized boolean isStruct() {
        if (this.value == null) {
            return false;
        }
        return this.value.isStruct();
    }

    public synchronized boolean isArray() {
        if (this.value == null) {
            return false;
        }
        return this.value.isArray();
    }

    public boolean isEmpty() {
        return this.value == null ? true : this.value.isEmpty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isTypeLock() {
        return this.typeLock;
    }

    @Override
    public int compareTo(Var v) {
        if (this.value == null || v.value == null) {
            if (v != null) {
                return 1;
            }
            if (this.value != null) {
                return -1;
            }
            return 0;
        }
        return this.value.compareTo(v.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Var)) {
            return false;
        }
        Var v = (Var)obj;
        if (this.value == null || v.value == null) {
            return this.value == null && v == null;
        }
        if (this.value.canLong() && v.canLong()) {
            return this.value.asLong() == v.asLong();
        }
        if (this.value.canDouble() && v.canDouble()) {
            return this.value.asDouble() == v.asDouble();
        }
        if (this.value.canComplex() && v.canComplex()) {
            return this.value.asComplex().equals(v.asComplex());
        }
        if (this.value.canVector() && v.canVector()) {
            return this.value.asVector().equals(v.asVector());
        }
        if (this.value.canMatrix() && v.canMatrix()) {
            return this.value.asMatrix().equals(v.asMatrix());
        }
        return this.value.asString().equals(v.asString());
    }

    public void set(boolean value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueLong) {
            this.value.set(value ? 1 : 0);
        } else {
            this.value = new VarValueLong(value ? 1 : 0);
        }
    }

    public void set(char value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueChar) {
            this.value.set(value);
        } else {
            this.value = new VarValueChar(value);
        }
    }

    public void set(int value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueLong) {
            this.value.set(value);
        } else {
            this.value = new VarValueLong(value);
        }
    }

    public synchronized void set(long value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueLong) {
            this.value.set(value);
        } else {
            this.value = new VarValueLong(value);
        }
    }

    public synchronized void set(float value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value instanceof VarValueDouble) {
            this.value.set(value);
        } else {
            this.value = new VarValueDouble(value);
        }
    }

    public synchronized void set(double value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueDouble) {
            this.value.set(value);
        } else {
            this.value = new VarValueDouble(value);
        }
    }

    public synchronized void set(Complex value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueComplex) {
            this.value.set(value);
        } else {
            this.value = new VarValueComplex(value);
        }
    }

    public synchronized void set(Vector value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueVector) {
            this.value.set(value);
        } else {
            this.value = new VarValueVector(value);
        }
    }

    public synchronized void set(double[] value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueVector) {
            this.value.set(new Vector(value));
        } else {
            this.value = new VarValueVector(value);
        }
    }

    public synchronized void set(Double[] value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueVector) {
            this.value.set(new Vector(value));
        } else {
            this.value = new VarValueVector(value);
        }
    }

    public synchronized void set(Matrix value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueVector) {
            this.value.set(value);
        } else {
            this.value = new VarValueMatrix(value);
        }
    }

    public synchronized void set(double[][] value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueVector) {
            this.value.set(new Matrix(value));
        } else {
            this.value = new VarValueMatrix(value);
        }
    }

    public synchronized void set(Double[][] value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueVector) {
            this.value.set(new Matrix(value));
        } else {
            this.value = new VarValueMatrix(value);
        }
    }

    public synchronized void set(String value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueString) {
            this.value.set(value);
        } else {
            this.value = new VarValueString(value);
        }
    }

    public synchronized void set(Date value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueDateTime) {
            this.value.set(value);
        } else {
            this.value = new VarValueDateTime(value);
        }
    }

    public synchronized void set(Color value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueColor) {
            this.value.set(value);
        } else {
            this.value = new VarValueColor(value);
        }
    }

    public synchronized void set(byte[] value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value instanceof VarValueBytes) {
            this.value.set(value);
        } else {
            this.value = new VarValueBytes(value);
        }
    }

    public synchronized void set(Object value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (value instanceof Double) {
            this.set((Double)value);
        } else if (value instanceof Float) {
            this.set(((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.set((Long)value);
        } else if (value instanceof Integer) {
            this.set((Integer)value);
        } else if (value instanceof Boolean) {
            this.set((Boolean)value);
        } else if (value instanceof String) {
            this.set((String)value);
        } else if (value instanceof Color) {
            this.set((Color)value);
        } else if (value instanceof Date) {
            this.set((Date)value);
        } else if (value instanceof Character) {
            this.set((Character)value);
        } else if (value instanceof Complex) {
            this.set((Complex)value);
        } else if (value instanceof Vector) {
            this.set((Vector)value);
        } else if (value instanceof double[]) {
            this.set((double[])value);
        } else if (value instanceof Double[]) {
            this.set((Double[])value);
        } else if (value instanceof Matrix) {
            this.set((Matrix)value);
        } else if (value instanceof byte[]) {
            this.set((byte[])value);
        } else if (value instanceof double[][]) {
            this.set((double[][])value);
        } else if (value instanceof Double[][]) {
            this.set((Double[][])value);
        } else {
            throw new VarExceptions.ConversionException("Type " + value.getClass().getName() + " is not directly supported for " + this.name);
        }
    }

    public synchronized void set(VarValue value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null) {
            if (this.value instanceof VarValueStruct && value instanceof VarValueStruct) {
                this.value.clear();
                for (Var vv : value.getVars()) {
                    ((VarValueStruct)this.value).addVar(vv);
                }
                return;
            }
            if (this.value.getClass() == value.getClass()) {
                this.value.set(value);
                return;
            }
        }
        this.value = value;
    }

    public synchronized void setRef(VarValue value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock && this.value.getClass() != value.getClass()) {
            throw new VarExceptions.ConversionException(String.valueOf(this.name) + " is type locked");
        }
        this.value = value;
    }

    public synchronized void setRef(Var v) {
        this.setRef(v.value);
    }

    public synchronized void set(Var v) {
        this.set(v.value);
    }

    public synchronized void setCopy(VarValue value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock || this.value != null && this.value.getClass() == value.getClass()) {
            this.value.set(value);
        }
        this.value = value.isArray() || value.isStruct() ? value : value.clone();
    }

    public synchronized void setCopy(Var v) {
        this.setCopy(v.value);
    }

    public synchronized void clear() {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.typeLock) {
            this.value.clear();
        } else {
            this.value = null;
        }
    }

    public static Var createValueAuto(String value) {
        Var v = new Var();
        v.setAuto(value);
        return v;
    }

    public static Var createValueAuto(String name, String value) {
        Var v = new Var(name);
        v.setAuto(value);
        return v;
    }

    public static Var createValueAuto(String name, String type, String value) {
        Var v = new Var(name);
        VarValue vv = VarValue.getType(type);
        vv.set(value);
        v.set(vv);
        return v;
    }

    public static Var createValue(String name, boolean value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, char value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, int value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, long value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, float value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, double value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, Complex value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, Vector value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, double[] value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, Double[] value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, Matrix value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, double[][] value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, Double[][] value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, String value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, Date value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(String name, Color value) {
        Var v = new Var(name);
        v.set(value);
        return v;
    }

    public static Var createValue(boolean value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(byte[] value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(char value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(int value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(long value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(float value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(double value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(Complex value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(Vector value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(double[] value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(Double[] value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(Matrix value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(double[][] value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(Double[][] value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(String value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(Date value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public static Var createValue(Color value) {
        Var v = new Var();
        v.set(value);
        return v;
    }

    public String getParams() {
        String params;
        if (this.value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(this.value.typeName());
        if (this.readOnly) {
            sb.append(",RO");
        }
        if ((params = this.value.getParams()) != null && params.length() > 0) {
            sb.append('|');
            sb.append(params);
        }
        sb.append('}');
        return sb.toString();
    }

    public synchronized void setAuto(String value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (value == null || value.length() == 0) {
            this.value.clear();
            return;
        }
        if (value.charAt(0) == '{') {
            int i = value.indexOf(125);
            if (i < 0) {
                throw new VarExceptions.SyntaxException("Missing } in " + value);
            }
            if (this.typeLock) {
                throw new VarExceptions.SyntaxException(String.valueOf(this.name) + " is type locked");
            }
            String[] params = value.substring(1, i).split("[|]");
            String[] settings = params[0].split("[,]");
            int j = 0;
            while (j < params.length) {
                params[j] = params[j].trim();
                ++j;
            }
            value = value.substring(i + 1).trim();
            if (settings[0].length() > 0 && settings[0].charAt(0) == '!') {
                this.predef = settings[0].substring(1);
                if (params.length > 1) {
                    throw new VarExceptions.SyntaxException("No type specifications allowed in predef " + params[1]);
                }
                List<String> list = predefined.get(this.predef);
                if (list == null) {
                    throw new VarExceptions.SyntaxException("Undefined predef " + this.predef);
                }
                for (String s : list) {
                    this.addValue(s);
                }
            } else {
                this.value = VarValue.getType(settings[0]);
                if (params.length > 1) {
                    this.value.setParams(params[1]);
                }
                this.typeLock = true;
            }
            if (settings.length > 1 && settings[1].equalsIgnoreCase("ro")) {
                this.readOnly = true;
            }
            if (value.length() > 0) {
                this.value.set(Support.parseEscape(value));
            }
        } else if (value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            this.set(Support.parseEscape(value.substring(1, value.length() - 1)));
        } else if (Support.isLong(value)) {
            this.set(Support.stringToLong(value));
        } else if (Support.isDouble(value)) {
            this.set(Support.stringToDouble(value));
        } else if (Support.isComplex(value)) {
            this.set(Support.stringToComplex(value));
        } else {
            this.set(Support.parseEscape(value));
        }
    }

    public int valueAdd(int value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.value == null) {
            throw new VarExceptions.ValueException("no value defined");
        }
        return (int)this.value.valueAdd(value);
    }

    public long valueAdd(long value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.value == null) {
            throw new VarExceptions.ValueException("no value defined");
        }
        return this.value.valueAdd(value);
    }

    public double valueAdd(double value) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.value == null) {
            throw new VarExceptions.ValueException("no value defined");
        }
        return this.value.valueAdd(value);
    }

    public synchronized List<String> getNames() {
        if (this.value == null) {
            throw new VarExceptions.IndexException("Only valid for structs");
        }
        return this.value.getNames();
    }

    public synchronized Collection<Var> getVars() {
        if (this.value == null) {
            throw new VarExceptions.IndexException("Only valid for arrays/structs");
        }
        return this.value.getVars();
    }

    public synchronized List<Var> getVarsSorted() {
        ArrayList<Var> list = new ArrayList<Var>();
        list.addAll(this.value.getVars());
        list.sort(new Comparator<Var>(){

            @Override
            public int compare(Var v1, Var v2) {
                return v1.name.toLowerCase().compareTo(v2.name.toLowerCase());
            }
        });
        return list;
    }

    public synchronized int getSize() {
        if (this.value == null) {
            return 0;
        }
        return this.value.getSize();
    }

    public static String indexListToString(List<Object> indexList, int index) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indexList.size()) {
            Object obj = indexList.get(i);
            if (obj instanceof String) {
                if (sb.length() != 0) {
                    sb.append('.');
                }
                if (i == index) {
                    sb.append("-->");
                }
                sb.append(obj.toString());
                if (i == index) {
                    sb.append("<--");
                }
            } else {
                if (i == index) {
                    sb.append("-->");
                }
                sb.append('[');
                sb.append(obj.toString());
                sb.append(']');
                if (i == index) {
                    sb.append("<--");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    protected synchronized Var getVarCreate(List<Object> indexList, int index) {
        if (index >= indexList.size()) {
            return this;
        }
        Object obj = indexList.get(index);
        if (obj instanceof String) {
            if (this.value == null) {
                this.value = new VarValueStruct();
            }
            if (!this.isStruct()) {
                throw new VarExceptions.IndexException(String.valueOf(Var.indexListToString(indexList, index)) + " not possible");
            }
            String name = obj.toString();
            Var v = ((VarValueStruct)this.value).getVar(name);
            if (v == null) {
                if (this.readOnly) {
                    throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
                }
                v = new Var(name);
                ((VarValueStruct)this.value).addVar(v);
            }
            return v.getVarCreate(indexList, index + 1);
        }
        if (this.value == null) {
            this.value = new VarValueArray();
        }
        if (!this.isArray()) {
            throw new VarExceptions.IndexException(String.valueOf(Var.indexListToString(indexList, index)) + " not possible");
        }
        int i = (Integer)obj;
        Var v = ((VarValueArray)this.value).getVar(i);
        if (v == null) {
            if (this.readOnly) {
                throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
            }
            v = new Var("[" + Integer.toString(i) + "]");
            ((VarValueArray)this.value).addVar(i, v);
        }
        return v.getVarCreate(indexList, index + 1);
    }

    protected synchronized Var findVar(List<Object> indexList, int index) {
        if (index >= indexList.size()) {
            return this;
        }
        Object obj = indexList.get(index);
        if (obj instanceof String) {
            if (!this.isStruct()) {
                return null;
            }
            String name = obj.toString();
            Var v = ((VarValueStruct)this.value).getVar(name);
            if (v == null) {
                return null;
            }
            return v.getVarCreate(indexList, index + 1);
        }
        if (!this.isArray()) {
            return null;
        }
        int i = (Integer)obj;
        Var v = ((VarValueArray)this.value).getVar(i);
        if (v == null) {
            return null;
        }
        return v.getVarCreate(indexList, index + 1);
    }

    protected synchronized void remove(List<Object> indexList) {
        if (indexList.size() == 0) {
            return;
        }
        Object last = indexList.get(indexList.size() - 1);
        indexList.remove(indexList.size() - 1);
        Var var = this.findVar(indexList, 0);
        if (!var.isStruct()) {
            throw new VarExceptions.IndexException("Can only remove from struct");
        }
        if (var.readOnly) {
            throw new VarExceptions.ReadOnlyException("Can not remove from read only struct");
        }
        ((VarValueStruct)var.value).remove(last.toString());
    }

    protected synchronized void map(List<Object> sourceList, List<Object> targetList) {
        Var tv;
        Var sv = this.getVarCreate(sourceList, 0);
        Object last = targetList.get(targetList.size() - 1);
        if (targetList.size() == 1) {
            tv = this;
        } else {
            targetList.remove(targetList.size() - 1);
            tv = this.getVarCreate(targetList, 0);
        }
        if (!tv.isStruct()) {
            throw new VarExceptions.IndexException("Can only map to struct");
        }
        if (tv.readOnly) {
            throw new VarExceptions.ReadOnlyException("Can not map to read only struct");
        }
        tv.addVar(last.toString(), sv);
    }

    public static List<Object> makeIndexList(String namePath) {
        ArrayList<Object> indexList = new ArrayList<Object>();
        if ((namePath = namePath.trim()).length() == 0) {
            return indexList;
        }
        int start = 0;
        do {
            if (namePath.charAt(start) == '[') {
                do {
                    int i = 0;
                    ++start;
                    while (Character.isDigit(namePath.charAt(start))) {
                        i = i * 10 + Character.getNumericValue(namePath.charAt(start));
                        ++start;
                    }
                    indexList.add(new Integer(i));
                } while (namePath.charAt(start) == ',');
                if (namePath.charAt(start) == ']') {
                    ++start;
                }
                if (start >= namePath.length() || namePath.charAt(start) != '.') continue;
                ++start;
                continue;
            }
            if (namePath.charAt(start) == '.') {
                throw new VarExceptions.NameException("A name can not start with . <" + namePath + ">");
            }
            int pos = start;
            while (pos < namePath.length() && namePath.charAt(pos) != '.' && namePath.charAt(pos) != '[') {
                ++pos;
            }
            if (start == pos) {
                throw new VarExceptions.NameException(String.valueOf(namePath) + " Empty name found");
            }
            indexList.add(namePath.substring(start, pos));
            if (pos >= namePath.length() || namePath.charAt(pos) == '.') {
                // empty if block
            }
            start = ++pos;
        } while (start < namePath.length());
        return indexList;
    }

    public synchronized void addVar(Var var) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.value == null) {
            this.value = new VarValueStruct();
        }
        if (this.isStruct()) {
            ((VarValueStruct)this.value).addVar(var);
        } else if (this.isArray()) {
            ((VarValueArray)this.value).addVar(var);
        } else {
            throw new VarExceptions.ValueException(String.valueOf(this.name) + " is not an array/struct");
        }
    }

    public synchronized void addVar(String name, Var var) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.value == null) {
            this.value = new VarValueStruct();
        }
        if (!this.isStruct()) {
            throw new VarExceptions.ValueException(String.valueOf(name) + " is not an struct");
        }
        ((VarValueStruct)this.value).addVar(name, var);
    }

    private synchronized Functions.Func findFunc(List<Object> indexList, int index) {
        Object obj = indexList.get(index);
        if (index >= indexList.size() - 1) {
            if (!(obj instanceof String)) {
                return null;
            }
            return this.findFunc(obj.toString());
        }
        if (obj instanceof String) {
            if (!this.isStruct()) {
                return null;
            }
            String name = obj.toString();
            Var v = ((VarValueStruct)this.value).getVar(name);
            if (v == null) {
                return null;
            }
            return v.findFunc(indexList, index + 1);
        }
        if (!this.isArray()) {
            return null;
        }
        int i = (Integer)obj;
        Var v = ((VarValueArray)this.value).getVar(i);
        if (v == null) {
            throw new VarExceptions.NameException(String.valueOf(Var.indexListToString(indexList, 0)) + " not found");
        }
        return v.findFunc(indexList, index + 1);
    }

    public Functions.Func findFunc(List<Object> indexList) {
        return this.findFunc(indexList, 0);
    }

    public Functions.Func findFunc(String name) {
        Functions.Func f;
        if (this.funcList != null && (f = this.funcList.find(name)) != null) {
            return f;
        }
        if (this.value != null) {
            return this.value.findFunc(name);
        }
        return null;
    }

    public void addFunc(Functions.Func f) {
        if (this.funcList == null) {
            this.funcList = new Functions();
        }
        this.funcList.add(f);
    }

    public Functions getFuncList() {
        if (this.funcList == null) {
            this.funcList = new Functions();
        }
        return this.funcList;
    }

    public synchronized void addVar(int index, Var var) {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.value == null) {
            this.value = new VarValueArray();
        }
        if (this.isArray()) {
            if (index < 0) {
                ((VarValueArray)this.value).addVar(var);
            } else {
                ((VarValueArray)this.value).addVar(index, var);
            }
        } else {
            throw new VarExceptions.ValueException(String.valueOf(this.name) + " is not an array");
        }
    }

    public synchronized Var addValue(String prefix, String namePathAndValue) {
        String name;
        int i = namePathAndValue.indexOf(61);
        String value = "";
        if (i < 0) {
            name = namePathAndValue.trim();
        } else {
            name = namePathAndValue.substring(0, i).trim();
            value = namePathAndValue.substring(i + 1).trim();
        }
        if (name.length() == 0 && value.length() == 0 || name.length() > 0 && name.charAt(0) == ';') {
            return null;
        }
        if (prefix.length() > 0) {
            name = String.valueOf(prefix) + "." + name;
        }
        Var v = this.getCreate(name);
        if (value.length() > 0) {
            v.setAuto(value);
        }
        return v;
    }

    public Var addValue(String namePathAndValue) {
        return this.addValue("", namePathAndValue);
    }

    public void addValues(String prefix, List<String> namePathAndValues) {
        for (String s : namePathAndValues) {
            this.addValue(prefix, s);
        }
    }

    public void addValuesIni(String prefix, List<String> namePathAndValues) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix.trim());
        if (sb.length() > 0) {
            sb.append('.');
        }
        int n = sb.length();
        for (String s : namePathAndValues) {
            if ((s = s.trim()).length() <= 0 || s.charAt(0) == ';') continue;
            if (s.charAt(0) == '[') {
                int i = s.indexOf(93);
                if (i < 0) {
                    throw new VarExceptions.SyntaxException("Missing ] in " + s);
                }
                sb.setLength(n);
                sb.append(s.substring(1, i).trim());
                continue;
            }
            if (Character.isJavaIdentifierStart(s.charAt(0))) {
                this.addValue(sb.toString(), s);
                continue;
            }
            throw new VarExceptions.SyntaxException("Invalid character in " + s);
        }
    }

    public void addValuesIni(List<String> namePathAndValues) {
        this.addValuesIni("", namePathAndValues);
    }

    public synchronized void defineArray() {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.value != null) {
            throw new VarExceptions.SyntaxException(String.valueOf(this.name) + " already has a type");
        }
        this.value = new VarValueArray();
    }

    public synchronized void defineStruct() {
        if (this.readOnly) {
            throw new VarExceptions.ReadOnlyException(String.valueOf(this.name) + " is read only");
        }
        if (this.value != null) {
            throw new VarExceptions.SyntaxException(String.valueOf(this.name) + " already has a type");
        }
        this.value = new VarValueStruct();
    }

    public void addValuesXml(File xmlFile, String id) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XmlHandler xmlHandler = new XmlHandler(this);
            sp.parse(xmlFile, (DefaultHandler)xmlHandler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized Var get(String namePath) {
        Var v = this.findVar(Var.makeIndexList(namePath), 0);
        if (v == null) {
            throw new VarExceptions.NameException(String.valueOf(namePath) + " not found");
        }
        return v;
    }

    public synchronized VarValue getValue(String namePath) {
        return this.get((String)namePath).value;
    }

    public synchronized VarValue getValue() {
        return this.value;
    }

    public synchronized Var get(int arrayIndex) {
        if (this.isArray()) {
            return ((VarValueArray)this.value).getVar(arrayIndex);
        }
        if (this.isStruct()) {
            return ((VarValueStruct)this.value).getVar(arrayIndex);
        }
        throw new VarExceptions.ValueException(String.valueOf(this.name) + " is not an array or struct");
    }

    public synchronized VarValue getValue(int arrayIndex) {
        return this.get((int)arrayIndex).value;
    }

    public Var getCreate(List<Object> indexList) {
        return this.getVarCreate(indexList, 0);
    }

    public Var getCreate(String namePath) {
        return this.getVarCreate(Var.makeIndexList(namePath), 0);
    }

    public Var find(List<Object> indexList) {
        return this.findVar(indexList, 0);
    }

    public Var find(String namePath) {
        return this.findVar(Var.makeIndexList(namePath), 0);
    }

    public void remove(String namePath) {
        this.remove(Var.makeIndexList(namePath));
    }

    public void map(String sourcePath, String targetPath) {
        this.map(Var.makeIndexList(sourcePath), Var.makeIndexList(targetPath));
    }

    public boolean getAsBoolean(String namePath, boolean defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asBoolean();
    }

    public char getAsChar(String namePath, char defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asChar();
    }

    public int getAsInt(String namePath, int defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asInt();
    }

    public long getAsLong(String namePath, long defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asLong();
    }

    public float getAsFloat(String namePath, float defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asFloat();
    }

    public double getAsDouble(String namePath, double defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asDouble();
    }

    public Complex getAsComplex(String namePath, Complex defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asComplex();
    }

    public Vector getAsVector(String namePath, Vector defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asVector();
    }

    public Matrix getAsMatrix(String namePath, Matrix defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asMatrix();
    }

    public String getAsString(String namePath, String defaultValue) {
        Var v = this.find(namePath);
        return v == null ? defaultValue : v.asString();
    }

    public Color getAsColor(String namePath, Color defaultValue) {
        Var v = this.find(namePath);
        return v == null || v.isEmpty() ? defaultValue : v.asColor();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.value == null) {
            sb.append("(Empty value)");
        } else if (this.isStruct() || this.isArray()) {
            sb.append("{");
            for (Var v : this.getVars()) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(v.getName());
                sb.append(v.toString());
            }
            sb.append("}");
        } else {
            sb.append('=');
            sb.append(this.value.toString());
        }
        return sb.toString();
    }

    public Class<?> commonType(Var v) {
        if (this.isLong() && v.isLong()) {
            return Long.class;
        }
        if ((this.isComplex() || v.isComplex()) && this.canComplex() && v.canComplex()) {
            return Complex.class;
        }
        if (this.isVector() && v.canVector() || this.canVector() && v.isVector()) {
            return Vector.class;
        }
        if (this.isMatrix() && v.canMatrix() || this.canMatrix() && v.isMatrix()) {
            return Matrix.class;
        }
        if (this.canDouble() && v.canDouble()) {
            return Double.class;
        }
        if (this.canLong() && v.canLong()) {
            return Long.class;
        }
        if (this.canComplex() && v.canComplex()) {
            return Complex.class;
        }
        if (this.isVector() && v.canDouble()) {
            return Vector.class;
        }
        if (this.isBytes() || v.isBytes()) {
            return VarValueBytes.class;
        }
        return String.class;
    }

    static synchronized void addUserType(String userType, String systemType, String params) {
        VarValue.addUserType(userType, systemType, params);
    }

    private String spaces(int n) {
        String spc = "                                                                 ";
        if (n < "                                                                 ".length()) {
            return "                                                                 ".substring(0, n);
        }
        StringBuilder sb = new StringBuilder(n + 100);
        while (sb.length() < n) {
            sb.append("                                                                 ");
        }
        return sb.toString().substring(0, n);
    }

    protected synchronized void listXmlFormat(List<String> list, int level, String name, boolean includeDataType) {
        StringBuilder sb = new StringBuilder();
        if (this.isStruct()) {
            Object[] names = this.value.getNames().toArray(new String[0]);
            Arrays.sort(names);
            sb.append(this.spaces(level * 2 + 2));
            sb.append("<");
            sb.append(name);
            sb.append(" class=\"struct\"");
            if (!includeDataType && this.predef != null) {
                sb.append(" type=\"{!");
                sb.append(this.predef);
                sb.append("}\"");
            }
            sb.append(">");
            list.add(sb.toString());
            Object[] objectArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                Object n3 = objectArray[n2];
                this.get((String)n3).listXmlFormat(list, level + 1, (String)n3, includeDataType);
                ++n2;
            }
            sb.setLength(0);
            sb.append(this.spaces(level * 2 + 2));
            sb.append("</");
            sb.append(name);
            sb.append(">");
            list.add(sb.toString());
        } else if (this.isArray()) {
            sb.append(this.spaces(level * 2 + 2));
            sb.append("<");
            sb.append(name);
            sb.append(" class=\"array\"");
            if (!includeDataType && this.predef != null) {
                sb.append(" type=\"{!");
                sb.append(this.predef);
                sb.append("}\"");
            }
            sb.append(">");
            list.add(sb.toString());
            int index = 0;
            while (index < this.getSize()) {
                this.get(index).listXmlFormat(list, level + 1, "A" + Integer.toString(index), includeDataType);
                ++index;
            }
            sb.setLength(0);
            sb.append(this.spaces(level * 2 + 2));
            sb.append("</");
            sb.append(name);
            sb.append(">");
            list.add(sb.toString());
        } else {
            sb.append(this.spaces(level * 2 + 2));
            sb.append("<");
            sb.append(name);
            if (includeDataType) {
                sb.append(" type=\"");
                sb.append(this.getParams());
                sb.append("\"");
            } else if (this.predef != null) {
                sb.append(" type=\"{!");
                sb.append(this.predef);
                sb.append("}\"");
            }
            if (this.value instanceof VarValueString) {
                sb.append(" string=\"");
                sb.append(Support.addEscape(this.asString()));
                sb.append("\"");
            } else if (this.value != null) {
                sb.append(" data=\"");
                sb.append(this.asString());
                sb.append("\"");
            }
            sb.append(" />");
            list.add(sb.toString());
        }
    }

    protected synchronized void listIniFormat(List<String> list, String prefix, boolean includeDataType) {
        StringBuilder sb = new StringBuilder();
        if (this.isStruct()) {
            Var v;
            Object name;
            Object[] names = this.value.getNames().toArray(new String[0]);
            Arrays.sort(names);
            boolean first = true;
            Object[] objectArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                name = objectArray[n2];
                v = this.get((String)name);
                if (!v.isStruct()) {
                    if (first) {
                        list.add("");
                        list.add("[" + prefix + "]");
                        first = false;
                    }
                    v.listFormat(list, (String)name, includeDataType);
                } else if (!includeDataType && v.predef != null) {
                    if (first) {
                        list.add("");
                        list.add("[" + prefix + "]");
                        first = false;
                    }
                    list.add(String.valueOf(name) + "={!" + v.predef + "}");
                }
                ++n2;
            }
            if (prefix.length() > 0) {
                sb.append(prefix);
                sb.append('.');
            }
            int n3 = sb.length();
            objectArray = names;
            n = names.length;
            n2 = 0;
            while (n2 < n) {
                name = objectArray[n2];
                v = this.get((String)name);
                if (v.isStruct()) {
                    sb.setLength(n3);
                    sb.append((String)name);
                    v.listIniFormat(list, sb.toString(), includeDataType);
                }
                ++n2;
            }
        } else {
            this.listFormat(list, prefix, includeDataType);
        }
    }

    protected synchronized void listFormat(List<String> list, String prefix, boolean includeDataType) {
        StringBuilder sb = new StringBuilder();
        if (this.isStruct()) {
            Object[] names = this.value.getNames().toArray(new String[0]);
            Arrays.sort(names);
            if (!includeDataType && this.predef != null) {
                list.add(String.valueOf(prefix) + "={!" + this.predef + "}");
            }
            if (prefix.length() > 0) {
                sb.append(prefix);
                sb.append('.');
            }
            int n = sb.length();
            Object[] objectArray = names;
            int n2 = names.length;
            int n3 = 0;
            while (n3 < n2) {
                Object name = objectArray[n3];
                sb.setLength(n);
                sb.append((String)name);
                this.get((String)name).listFormat(list, sb.toString(), includeDataType);
                ++n3;
            }
        } else if (this.isArray()) {
            if (prefix.length() > 0) {
                sb.append(prefix);
            }
            sb.append('[');
            int n = sb.length();
            int i = 0;
            while (i < this.getSize()) {
                sb.setLength(n);
                sb.append(i);
                sb.append(']');
                this.get(i).listFormat(list, sb.toString(), includeDataType);
                ++i;
            }
        } else if (this.value == null) {
            if (prefix.length() == 0) {
                sb.append(this.name);
            } else {
                sb.append(prefix);
            }
            sb.append("{Empty value}");
            list.add(sb.toString());
        } else {
            if (prefix.length() == 0) {
                sb.append(this.name);
            } else {
                sb.append(prefix);
            }
            sb.append('=');
            if (includeDataType) {
                sb.append(this.getParams());
            } else if (this.predef != null) {
                sb.append("{!");
                sb.append(this.predef);
                sb.append("}");
            }
            if (this.value instanceof VarValueString) {
                if (!includeDataType) {
                    sb.append('\"');
                }
                sb.append(Support.addEscape(this.asString()));
                if (!includeDataType) {
                    sb.append('\"');
                }
            } else {
                sb.append(this.asString());
            }
            list.add(sb.toString());
        }
    }

    public List<String> listIniFormat(String prefix, boolean includeDataType) {
        ArrayList<String> list = new ArrayList<String>(100);
        this.listIniFormat(list, prefix, includeDataType);
        return list;
    }

    public List<String> listIniFormat(boolean includeDataType) {
        ArrayList<String> list = new ArrayList<String>(100);
        this.listIniFormat(list, "", includeDataType);
        return list;
    }

    public List<String> listXmlFormat(boolean includeDataType, String id, String charset) {
        if (charset == null || charset.length() == 0) {
            charset = "ISO8859-1";
        }
        ArrayList<String> list = new ArrayList<String>(100);
        list.add("<?xml version=\"1.0\" encoding=\"" + charset + "\" standalone=\"yes\" ?>");
        list.add("<var id=\"" + id + "\">");
        this.listXmlFormat(list, 0, "root", includeDataType);
        list.add("</var>");
        return list;
    }

    public List<String> listFormat(String prefix, boolean includeDataType) {
        ArrayList<String> list = new ArrayList<String>(100);
        this.listFormat(list, prefix, includeDataType);
        return list;
    }

    public List<String> listFormat(boolean includeDataType) {
        ArrayList<String> list = new ArrayList<String>(100);
        this.listFormat(list, "", includeDataType);
        return list;
    }

    public static void addPredefined(String name, List<String> predef) {
        predefined.add(name, predef);
    }

    public static void addPredefined(String name, String predef) {
        predefined.add(name, predef);
    }

    public static Var createArray(Vector v) {
        Var var = new Var();
        var.set(new VarValueArray());
        double[] dArray = v.getVec();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            var.addVar(Var.createValue(d));
            ++n2;
        }
        return var;
    }

    public static Var createArray() {
        Var var = new Var();
        var.set(new VarValueArray());
        return var;
    }

    public static Var createArray(String name) {
        Var var = new Var(name);
        var.set(new VarValueArray());
        return var;
    }

    public static Var createStruct() {
        Var var = new Var();
        var.set(new VarValueStruct());
        return var;
    }

    public static void main2(String[] args) {
        Var v = new Var("root");
        Var.addPredefined("person", "navn={string}\ralder={int|0,150}\rk\ufffdn={enum|ukendt,kvinde,mand}ukendt");
        Var.addPredefined("kort", "={enum|hjerter=3,kl\ufffdr=17,spar=-9,ruder=999}");
        try {
            v.addValuesXml(new File("e:/test.xml"), "test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String str : v.listXmlFormat(false, "test", null)) {
            System.out.print(str);
            System.out.print('\n');
        }
    }

    public static void main1(String[] args) {
        Var.addPredefined("person", "navn={string}\ralder={int|0,150}\rk\ufffdn={enum|ukendt,kvinde,mand}ukendt");
        Var.addPredefined("kort", "={enum|hjerter=3,kl\ufffdr=17,spar=-9,ruder=999}");
        Var v = new Var("root");
        v.getCreate("kurt").setAuto("{!person}");
        v.getCreate("j\ufffdrgen").setAuto("{!person}");
        v.getCreate("olsen.test[0]").setAuto("{!person}");
        v.getCreate("olsen.test[4].dk");
        v.getCreate("olsen.test[0].uk");
        v.getCreate("olsen.test[3].se");
        v.getCreate("olsen.navn");
        v.getCreate("knudsen.navn");
        v.getCreate("knudsen.kort").setAuto("{!kort}spar");
        v.getCreate("knudsen").setAuto("{!person}");
        v.getCreate("olsen").setAuto("{!person}");
        v.getCreate("susanne").setAuto("{!person}");
        v.getCreate("susanne.navn");
        v.getCreate("susanne.male").setAuto("{boolean}false");
        v.getCreate("susanne.alder").setAuto("34");
        v.getCreate("olsen.penge").setAuto("{double}17");
        v.getCreate("olsen.adresse").setAuto("Rosenvej 17\r\nH\ufffdje T\ufffdrnb\ufffdk");
        v.map("susanne", "olsen.kone");
        v.get("olsen.kone.navn").set("Susanne");
        v.getCreate("born").setAuto("{dateTime}21/11-1959");
        v.getCreate("farve").setAuto("{color}blue");
        for (String str : v.listXmlFormat(false, "test", null)) {
            System.out.print(str);
            System.out.print('\n');
        }
        System.out.print("Program terminated normally");
    }

    private class XmlHandler
    extends DefaultHandler {
        private Stack<Var> stack = new Stack();
        private Var base;

        public XmlHandler(Var base) {
            this.base = base;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.stack.size() > 0) {
                this.stack.pop();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            Var var;
            if (this.stack.size() == 0) {
                if (name.equalsIgnoreCase("var")) {
                    return;
                }
                if (!name.equalsIgnoreCase("root")) throw new VarExceptions.SyntaxException("XML must start with a root element");
                var = this.base;
            } else {
                Var parentVar = this.stack.peek();
                var = new Var(name);
                parentVar.addVar(var);
            }
            String cl = attributes.getValue("class");
            String type = attributes.getValue("type");
            String data = attributes.getValue("data");
            if (cl != null && cl.length() != 0) {
                if (cl.equalsIgnoreCase("array")) {
                    var.defineArray();
                } else {
                    if (!cl.equalsIgnoreCase("struct")) throw new VarExceptions.SyntaxException(String.valueOf(cl) + " unknown class specified for " + name);
                    var.defineStruct();
                }
            }
            if (data != null && data.length() > 0 && type != null && type.length() > 0) {
                var.setAuto(String.valueOf(type) + data);
            } else if (data != null && data.length() > 0) {
                var.setAuto(data);
            } else if (type != null && type.length() > 0) {
                var.setAuto(type);
            }
            this.stack.push(var);
        }
    }
}

