/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.util.Complex;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.VarExceptions;

public class Support {
    public static float stringToFloat(String value) {
        float v = 0.0f;
        try {
            v = Float.parseFloat(value);
        }
        catch (Exception e) {
            throw new VarExceptions.ConversionException(String.valueOf(value) + " could not be converted to double");
        }
        return v;
    }

    public static double stringToDouble(String value) {
        double v = 0.0;
        try {
            v = Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new VarExceptions.ConversionException(String.valueOf(value) + " could not be converted to double");
        }
        return v;
    }

    public static Complex stringToComplex(String value) {
        int i = value.indexOf(105);
        if (i < 0) {
            i = value.indexOf(106);
        }
        if (i < 0) {
            return new Complex(Support.stringToDouble(value), 0.0);
        }
        int j = Math.max(value.lastIndexOf(43), value.lastIndexOf(45));
        if (j < 0) {
            return new Complex(0.0, Support.stringToDouble(value.substring(0, i)));
        }
        double real = Support.stringToDouble(value.substring(0, j));
        double imag = Support.stringToDouble(value.substring(j, i));
        return new Complex(real, imag);
    }

    public static int stringToInt(String value) {
        long v = Support.stringToLong(value);
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new VarExceptions.ConversionException(String.valueOf(value) + " could not be converted to int");
        }
        return (int)v;
    }

    /*
     * Unable to fully structure code
     */
    public static long stringToLong(String value) {
        v = 0L;
        sign = false;
        i = 0;
        length = (value = value.trim()).length();
        if (length == 0) {
            throw new VarExceptions.ConversionException("No digits in number <" + value + ">");
        }
        base = 10;
        firstChar = value.charAt(0);
        lastChar = value.charAt(length - 1);
        if (firstChar == '-') {
            sign = true;
            ++i;
        } else if (firstChar == '+') {
            sign = false;
            ++i;
        } else if (firstChar == '$') {
            base = 16;
            ++i;
        } else if (length > 2 && firstChar == '0' && (value.charAt(1) == 'x' || value.charAt(1) == 'X')) {
            i += 2;
            base = 16;
        } else if (lastChar == 'h' || lastChar == 'H') {
            --length;
            base = 16;
        } else if (lastChar == 'o' || lastChar == 'O') {
            --length;
            base = 8;
        } else if (lastChar == 'b' || lastChar == 'B') {
            --length;
            base = 2;
        }
        if (i < length) ** GOTO lbl45
        throw new VarExceptions.ConversionException("No digits in number <" + value + ">");
lbl-1000:
        // 1 sources

        {
            c = value.charAt(i);
            j = Character.digit(c, base);
            if (j < 0) {
                throw new VarExceptions.ConversionException("Invalid digit in <" + value + ">");
            }
            v = v * (long)base + (long)j;
            ++i;
lbl45:
            // 2 sources

            ** while (i < length)
        }
lbl46:
        // 1 sources

        if (sign) {
            v = -v;
        }
        return v;
    }

    public static boolean stringToBoolean(String value) {
        block5: {
            block4: {
                try {
                    if (!value.equalsIgnoreCase("yes") && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("y") && !value.equalsIgnoreCase("t")) break block4;
                    return true;
                }
                catch (Exception e) {
                    throw new VarExceptions.ConversionException(String.valueOf(value) + " could not be converted to boolean");
                }
            }
            if (!value.equalsIgnoreCase("no") && !value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("n") && !value.equalsIgnoreCase("f")) break block5;
            return false;
        }
        long v = Support.stringToLong(value);
        return v != 0L;
    }

    public static boolean isInt(String value) {
        block3: {
            try {
                if (value.indexOf(32) < 0) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        Support.stringToInt(value);
        return true;
    }

    public static boolean isLong(String value) {
        block3: {
            try {
                if (value.indexOf(32) < 0) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        Support.stringToLong(value);
        return true;
    }

    public static boolean isFloat(String value) {
        block3: {
            try {
                if (value.indexOf(32) < 0) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        Support.stringToFloat(value);
        return true;
    }

    public static boolean isDouble(String value) {
        block3: {
            try {
                if (value.indexOf(32) < 0) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        Support.stringToDouble(value);
        return true;
    }

    public static boolean isComplex(String value) {
        int i = value.indexOf(105);
        if (i < 0) {
            i = value.indexOf(106);
        }
        if (i < 0) {
            return Support.isDouble(value);
        }
        int j = Math.max(value.lastIndexOf(43), value.lastIndexOf(45));
        if (j < 0) {
            return Support.isDouble(value.substring(0, i));
        }
        return Support.isDouble(value.substring(0, j)) && Support.isDouble(value.substring(j, i));
    }

    public static boolean isBoolean(String value) {
        try {
            Support.stringToBoolean(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String parseEscape(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        int i = 0;
        while (i < value.length()) {
            int c;
            if ((c = value.charAt(i++)) == 92) {
                c = value.charAt(i++);
                switch (c) {
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 120: {
                        c = (char)Integer.parseInt(value.substring(i, i + 2), 16);
                        i += 2;
                        break;
                    }
                    case 117: {
                        c = (char)Integer.parseInt(value.substring(i, i + 4), 16);
                        i += 4;
                    }
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String addEscape(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(value.length() * 3);
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\"': {
                    sb.append("\\x");
                    sb.append(StringUtil.hex2(34));
                    break;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\x");
                        sb.append(StringUtil.hex2(c));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String reformatDateTimeFormat(String format) {
        StringBuilder sb = new StringBuilder();
        if (format.charAt(0) == '!') {
            return format.substring(1);
        }
        int i = 0;
        while (i < format.length()) {
            char c = format.charAt(i);
            switch (c) {
                case 'Y': 
                case 'y': {
                    sb.append('y');
                    break;
                }
                case 'M': 
                case 'm': {
                    sb.append('M');
                    break;
                }
                case 'D': 
                case 'd': {
                    sb.append('d');
                    break;
                }
                case 'H': 
                case 'h': {
                    sb.append('H');
                    break;
                }
                case 'N': 
                case 'n': {
                    sb.append('m');
                    break;
                }
                case 'S': 
                case 's': {
                    sb.append('s');
                    break;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') break;
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("Test");
        System.out.println("Test");
        System.out.println("Test");
        System.out.println("Test");
        System.out.println("Test");
        System.exit(5);
    }
}

