/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.vars;

import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.StringUtil;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarValueComplex;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class FormatVar {
    private static FormatVar defaultFormatVar = null;
    private DisplayFormat displayFormat = DisplayFormat.DSI;
    private int decimals = 3;
    private DecimalFormat dfE;
    private DecimalFormat dfF;
    private DecimalFormat dfD;
    private boolean spaceBeforeUnit = false;

    public FormatVar() {
        this.setDecimals(3);
    }

    public FormatVar(String format) {
        this.setFormat(format);
    }

    public void setSpaceBeforeUnit(boolean spaceBeforeUnit) {
        this.spaceBeforeUnit = spaceBeforeUnit;
    }

    public synchronized void setFormat(String format) {
        String f = "";
        int n = -1;
        while (format.length() > 0 && Character.isAlphabetic(format.charAt(0))) {
            f = String.valueOf(f) + format.substring(0, 1);
            format = format.substring(1);
        }
        if (format.length() > 0) {
            n = Integer.parseInt(format);
        }
        if ((f = f.toLowerCase()).equals("si")) {
            this.setFormat(DisplayFormat.DSI);
        } else if (f.equals("e")) {
            this.setFormat(DisplayFormat.DE);
        } else if (f.equals("x")) {
            this.setFormat(DisplayFormat.DX);
        } else if (f.equals("d")) {
            this.setFormat(DisplayFormat.DD);
        } else if (f.equals("hex")) {
            this.setFormat(DisplayFormat.DHex);
        } else if (f.equals("int")) {
            this.setFormat(DisplayFormat.DInt);
        } else if (f.equals("string") || f.equals("str")) {
            this.setFormat(DisplayFormat.DStr);
        } else if (f.equals("bin")) {
            this.setFormat(DisplayFormat.DBin);
        }
        this.setDecimals(n);
    }

    public String getFormat() {
        switch (this.displayFormat) {
            case DBin: {
                return "BIN";
            }
            case DD: {
                return "D" + this.decimals;
            }
            case DE: {
                return "E" + this.decimals;
            }
            case DHex: {
                return "Hex";
            }
            case DInt: {
                return "Int";
            }
            case DSI: {
                return "SI" + this.decimals;
            }
            case DStr: {
                return "Str";
            }
            case DX: {
                return "X" + this.decimals;
            }
        }
        return "";
    }

    public FormatVar clone() {
        FormatVar fm = new FormatVar();
        fm.setFormat(this.displayFormat);
        fm.setDecimals(this.decimals);
        return fm;
    }

    public synchronized void setDecimals(int n) {
        this.decimals = n;
        String deciInt = "##############0";
        if (n == 0) {
            this.dfE = new DecimalFormat("0E0;-0E0");
            this.dfF = new DecimalFormat(String.valueOf(deciInt) + ";-" + deciInt);
            this.dfD = new DecimalFormat(String.valueOf(deciInt) + ";-" + deciInt);
        } else {
            String deciFrac = "";
            String deciDFrac = "";
            while (n > 1) {
                deciFrac = String.valueOf(deciFrac) + "#";
                deciDFrac = String.valueOf(deciDFrac) + "0";
                --n;
            }
            this.dfE = new DecimalFormat("0.0" + deciFrac + "E0;-0.0" + deciFrac + "E0");
            this.dfF = new DecimalFormat(String.valueOf(deciInt) + ".0" + deciFrac + ";-" + deciInt + ".0" + deciFrac);
            this.dfD = new DecimalFormat(String.valueOf(deciInt) + ".0" + deciDFrac + ";-" + deciInt + ".0" + deciDFrac);
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.dfE.setDecimalFormatSymbols(dfs);
        this.dfF.setDecimalFormatSymbols(dfs);
        this.dfD.setDecimalFormatSymbols(dfs);
    }

    public synchronized void setFormat(DisplayFormat df) {
        this.displayFormat = df;
    }

    /*
     * Unable to fully structure code
     */
    public String formatHex(long vv) {
        block2: {
            block1: {
                s = StringUtil.hex16(vv);
                if (!s.startsWith("FFFFFFFFFFFFF")) break block1;
                s = s.substring(12);
                break block2;
            }
            if (!s.startsWith("FFFFFFFFF")) ** GOTO lbl10
            s = s.substring(8);
            break block2;
lbl-1000:
            // 1 sources

            {
                s = s.substring(4);
lbl10:
                // 2 sources

                ** while (s.length() > 4 && s.startsWith((String)"0000"))
            }
        }
        return "0x" + s;
    }

    /*
     * Unable to fully structure code
     */
    public String formatBin(long vv) {
        block6: {
            sb = new StringBuilder();
            i = 63;
            while (i >= 0) {
                if ((vv & 1L << i) != 0L) {
                    sb.append((char)(i % 8 + 48));
                } else {
                    sb.append('.');
                }
                if (i != 0 && i % 8 == 0) {
                    sb.append("  ");
                }
                --i;
            }
            if (!sb.toString().startsWith("76543210 ")) ** GOTO lbl23
            while (sb.length() > 8 && sb.toString().startsWith("76543210  7")) {
                sb.replace(0, 10, "");
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                sb.replace(0, 10, "");
lbl23:
                // 2 sources

                ** while (sb.length() > 8 && sb.toString().startsWith((String)"........  "))
            }
        }
        return sb.toString();
    }

    public synchronized String formatNumber(double vv) {
        if (Double.isNaN(vv)) {
            return "?";
        }
        if (Double.isInfinite(vv)) {
            return vv < 0.0 ? "-\u221e" : "\u221e";
        }
        switch (this.displayFormat) {
            case DSI: {
                return StringUtil.formatDoubleEE(vv, this.spaceBeforeUnit, this.decimals);
            }
            case DE: {
                if (Math.abs(vv) < 100000.0 && Math.abs(vv) > 0.001) {
                    return String.valueOf(this.dfF.format(vv)) + (this.spaceBeforeUnit ? " " : "");
                }
                return String.valueOf(this.dfE.format(vv)) + (this.spaceBeforeUnit ? " " : "");
            }
            case DX: {
                if (Math.abs(vv) < 1.0E12) {
                    return String.valueOf(this.dfF.format(vv)) + (this.spaceBeforeUnit ? " " : "");
                }
                return String.valueOf(this.dfE.format(vv)) + (this.spaceBeforeUnit ? " " : "");
            }
            case DD: {
                if (Math.abs(vv) < 1.0E12) {
                    return String.valueOf(this.dfD.format(vv)) + (this.spaceBeforeUnit ? " " : "");
                }
                return String.valueOf(this.dfE.format(vv)) + (this.spaceBeforeUnit ? " " : "");
            }
            case DInt: {
                return String.valueOf(Long.toString((long)(vv + 0.5))) + (this.spaceBeforeUnit ? " " : "");
            }
            case DStr: {
                return Double.toString(vv);
            }
            case DHex: {
                return String.valueOf(this.formatHex((long)(vv + 0.5))) + (this.spaceBeforeUnit ? " " : "");
            }
            case DBin: {
                return String.valueOf(this.formatBin((long)(vv + 0.5))) + (this.spaceBeforeUnit ? " " : "");
            }
        }
        return null;
    }

    public String formatInt(long vv) {
        return Long.toString(vv);
    }

    public synchronized String formatVar(Var v) {
        if (v == null) {
            return "--";
        }
        if (v.isVector()) {
            StringBuilder sb = new StringBuilder();
            Vector vv = v.asVector();
            double[] dArray = vv.getVec();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                if (sb.length() > 0) {
                    sb.append(vv.isColumnVector() ? "; " : ", ");
                }
                sb.append(this.formatNumber(d));
                ++n2;
            }
            return sb.toString();
        }
        if (v.isMatrix()) {
            StringBuilder sb = new StringBuilder();
            Matrix mx = v.asMatrix();
            boolean mark = false;
            double[][] dArray = mx.getMatrix();
            int n = dArray.length;
            int n3 = 0;
            while (n3 < n) {
                double[] dd = dArray[n3];
                if (mark) {
                    sb.append("; ");
                    mark = false;
                }
                double[] dArray2 = dd;
                int n4 = dd.length;
                int n5 = 0;
                while (n5 < n4) {
                    double d = dArray2[n5];
                    if (mark) {
                        sb.append(", ");
                    }
                    sb.append(this.formatNumber(d));
                    mark = true;
                    ++n5;
                }
                ++n3;
            }
            return sb.toString();
        }
        if (v.isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Var vv : v.getVars()) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(vv.isEmpty() ? " " : this.formatVar(vv));
            }
            sb.append("}");
            return sb.toString();
        }
        if (v.isStruct()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Var vv : v.getVarsSorted()) {
                String s;
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if ((s = vv.getName()).length() > 0) {
                    sb.append(vv.getName());
                    sb.append("=");
                }
                sb.append(this.formatVar(vv));
            }
            sb.append("}");
            return sb.toString();
        }
        if (v.isComplex()) {
            StringBuilder sb = new StringBuilder();
            VarValueComplex vv = (VarValueComplex)v.getValue();
            if (vv.asComplex().isReal()) {
                return this.formatVar(vv.real());
            }
            if (vv.asComplex().real() != 0.0) {
                sb.append(this.formatVar(vv.real()));
            }
            sb.append(vv.asComplex().imag() < 0.0 ? " -" : " +");
            sb.append(this.formatVar(vv.absImag()));
            sb.append(Complex.complexChar);
            return sb.toString();
        }
        if (v.isBytes()) {
            if (this.displayFormat == DisplayFormat.DStr) {
                return new String(v.asBytes());
            }
            if (this.displayFormat == DisplayFormat.DHex) {
                return StringUtil.hexN(v.asBytes());
            }
            return v.getValue().toString();
        }
        switch (this.displayFormat) {
            case DSI: 
            case DE: 
            case DX: 
            case DD: {
                if (!v.canDouble()) break;
                return this.formatNumber(v.asDouble());
            }
            case DStr: {
                return v.asString();
            }
            case DInt: {
                if (v.canLong()) {
                    return this.formatInt(v.asLong());
                }
                if (!v.canDouble()) break;
                return this.formatNumber(v.asDouble());
            }
            case DHex: {
                if (v.isString()) {
                    return StringUtil.hexString(v.asString());
                }
                if (!v.canLong()) break;
                return this.formatHex(v.asLong());
            }
            case DBin: {
                return this.formatBin(v.asLong());
            }
        }
        return v.asString();
    }

    public synchronized List<Object> formatVarAsList(Var v) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (v == null) {
            list.add("--");
            return list;
        }
        if (v.isVector()) {
            Vector vv = v.asVector();
            if (vv.isColumnVector()) {
                double[] dArray = vv.getVec();
                int n = dArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double d = dArray[n2];
                    list.add(this.formatNumber(d));
                    ++n2;
                }
            } else {
                ArrayList<String> l = new ArrayList<String>();
                double[] dArray = vv.getVec();
                int n = dArray.length;
                int n3 = 0;
                while (n3 < n) {
                    double d = dArray[n3];
                    l.add(this.formatNumber(d));
                    ++n3;
                }
                list.add(l);
            }
            return list;
        }
        if (v.isMatrix()) {
            Matrix mx = v.asMatrix();
            double[][] dArray = mx.getMatrix();
            int n = dArray.length;
            int d = 0;
            while (d < n) {
                double[] dd = dArray[d];
                ArrayList<String> l = new ArrayList<String>();
                double[] dArray2 = dd;
                int n4 = dd.length;
                int n5 = 0;
                while (n5 < n4) {
                    double d2 = dArray2[n5];
                    l.add(this.formatNumber(d2));
                    ++n5;
                }
                list.add(l);
                ++d;
            }
            return list;
        }
        if (v.isArray()) {
            for (Var vv : v.getVars()) {
                list.add(vv.isEmpty() ? " " : this.formatVar(vv));
            }
            return list;
        }
        if (v.isStruct()) {
            for (Var vv : v.getVarsSorted()) {
                ArrayList<String> l = new ArrayList<String>();
                l.add(String.valueOf(vv.getName()) + ":");
                l.add(this.formatVar(vv));
                list.add(l);
            }
            return list;
        }
        if (v.isComplex()) {
            StringBuilder sb = new StringBuilder();
            VarValueComplex vv = (VarValueComplex)v.getValue();
            if (vv.asComplex().isReal()) {
                list.add(this.formatVar(vv.real()));
                return list;
            }
            if (vv.asComplex().real() != 0.0) {
                sb.append(this.formatVar(vv.real()));
            }
            sb.append(vv.asComplex().imag() < 0.0 ? " -" : " +");
            sb.append(this.formatVar(vv.absImag()));
            sb.append(Complex.complexChar);
            list.add(sb.toString());
            return list;
        }
        if (v.isBytes()) {
            if (this.displayFormat == DisplayFormat.DStr) {
                list.add(new String(v.asBytes()));
            } else if (this.displayFormat == DisplayFormat.DHex) {
                list.add(StringUtil.hexN(v.asBytes()));
            } else {
                list.add(v.getValue().toString());
            }
            return list;
        }
        switch (this.displayFormat) {
            case DSI: 
            case DE: 
            case DX: 
            case DD: {
                if (!v.canDouble()) break;
                list.add(this.formatNumber(v.asDouble()));
                break;
            }
            case DStr: {
                list.add(v.asString());
                break;
            }
            case DInt: {
                if (v.canLong()) {
                    list.add(this.formatInt(v.asLong()));
                    break;
                }
                if (!v.canDouble()) break;
                list.add(this.formatNumber(v.asDouble()));
                break;
            }
            case DHex: {
                if (v.isString()) {
                    list.add(StringUtil.hexString(v.asString()));
                    break;
                }
                if (!v.canLong()) break;
                list.add(this.formatHex(v.asLong()));
                break;
            }
            case DBin: {
                list.add(this.formatBin(v.asLong()));
            }
        }
        if (list.size() == 0) {
            list.add(v.asString());
        }
        return list;
    }

    public static synchronized FormatVar getDefault() {
        if (defaultFormatVar == null) {
            defaultFormatVar = new FormatVar();
        }
        return defaultFormatVar;
    }

    public static enum DisplayFormat {
        DSI,
        DE,
        DX,
        DD,
        DInt,
        DStr,
        DHex,
        DBin;

    }
}

