/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import dk.hkj.util.Matrix;
import dk.hkj.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class Vector {
    final boolean columnVector;
    private final double[] vec;
    private final boolean isNaN;
    private final boolean isInfinite;

    public Vector() {
        this.columnVector = false;
        this.vec = new double[0];
        this.isNaN = false;
        this.isInfinite = false;
    }

    public Vector(long vector) {
        this.columnVector = false;
        this.vec = new double[]{vector};
        this.isNaN = false;
        this.isInfinite = false;
    }

    public Vector(double vector) {
        this.columnVector = false;
        this.vec = new double[]{vector};
        this.isNaN = Double.isNaN(this.vec[0]);
        this.isInfinite = Double.isInfinite(this.vec[0]);
    }

    public Vector(double[] vector) {
        this.columnVector = false;
        this.vec = vector;
        boolean lisNaN = false;
        boolean lisInfinite = false;
        int i = 0;
        while (i < this.vec.length) {
            if (Double.isNaN(this.vec[i])) {
                lisNaN = true;
            }
            if (Double.isInfinite(this.vec[i])) {
                lisInfinite = true;
            }
            ++i;
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public Vector(boolean columnVector, double[] vector) {
        this.columnVector = columnVector;
        this.vec = vector;
        boolean lisNaN = false;
        boolean lisInfinite = false;
        int i = 0;
        while (i < this.vec.length) {
            if (Double.isNaN(this.vec[i])) {
                lisNaN = true;
            }
            if (Double.isInfinite(this.vec[i])) {
                lisInfinite = true;
            }
            ++i;
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public Vector(Double[] vector) {
        this.columnVector = false;
        boolean lisNaN = false;
        boolean lisInfinite = false;
        this.vec = new double[vector.length];
        int i = 0;
        while (i < this.vec.length) {
            this.vec[i] = vector[i];
            if (Double.isNaN(this.vec[i])) {
                lisNaN = true;
            }
            if (Double.isInfinite(this.vec[i])) {
                lisInfinite = true;
            }
            ++i;
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public Vector(List<Double> vector) {
        this.columnVector = false;
        boolean lisNaN = false;
        boolean lisInfinite = false;
        this.vec = new double[vector.size()];
        int i = 0;
        while (i < this.vec.length) {
            this.vec[i] = vector.get(i);
            if (Double.isNaN(this.vec[i])) {
                lisNaN = true;
            }
            if (Double.isInfinite(this.vec[i])) {
                lisInfinite = true;
            }
            ++i;
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isVector(String value) {
        boolean col = value.indexOf(59) >= 0;
        String[] vv = value.split(col ? "[; ]+" : "[, ]+");
        if (vv.length == 0) {
            return false;
        }
        try {
            String[] stringArray = vv;
            int n = vv.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String s = stringArray[n2];
                double a = StringUtil.parseDoubleEE(s);
                if (Double.isNaN(a)) return false;
                if (Double.isInfinite(a)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public Vector(String value) {
        this.columnVector = value.indexOf(59) >= 0;
        String[] vv = value.split(this.columnVector ? "[; ]+" : "[, ]+");
        ArrayList<Double> list = new ArrayList<Double>();
        String[] stringArray = vv;
        int n = vv.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).length() > 0) {
                list.add(StringUtil.parseDoubleEE(s));
            }
            ++n2;
        }
        boolean lisNaN = false;
        boolean lisInfinite = false;
        this.vec = new double[list.size()];
        int i = 0;
        while (i < this.vec.length) {
            this.vec[i] = (Double)list.get(i);
            if (Double.isNaN(this.vec[i])) {
                lisNaN = true;
            }
            if (Double.isInfinite(this.vec[i])) {
                lisInfinite = true;
            }
            ++i;
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public double get(int index) {
        if (index < 0 || index >= this.vec.length) {
            return 0.0;
        }
        return this.vec[index];
    }

    public boolean isZero() {
        double[] dArray = this.vec;
        int n = this.vec.length;
        int n2 = 0;
        while (n2 < n) {
            double a = dArray[n2];
            if (a != 0.0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isNaN() {
        return this.isNaN;
    }

    public double[] getVec() {
        return this.vec;
    }

    public boolean isColumnVector() {
        return this.columnVector;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    public static double[] randomVector(int size, double min, double max) {
        double[] vec = new double[size];
        int i = 0;
        while (i < size) {
            vec[i] = Math.random() * (max - min) + min;
            ++i;
        }
        return vec;
    }

    public static double[] randomVector(int size, long min, long max) {
        double[] vec = new double[size];
        int i = 0;
        while (i < size) {
            vec[i] = Math.rint(Math.random() * (double)(max - min) + (double)min);
            ++i;
        }
        return vec;
    }

    public boolean equals(Vector v) {
        if (v.vec.length != this.vec.length) {
            return false;
        }
        int i = 0;
        while (i < this.vec.length) {
            if (v.vec[i] != this.vec[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object v) {
        if (this == v) {
            return true;
        }
        if (v instanceof Vector) {
            return this.equals((Vector)v);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        double[] dArray = this.vec;
        int n = this.vec.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (sb.length() > 0) {
                sb.append(this.columnVector ? ";" : ", ");
            }
            sb.append(v);
            ++n2;
        }
        return sb.toString();
    }

    public int length() {
        return this.vec.length;
    }

    public Vector neg() {
        double[] v = new double[this.vec.length];
        int i = 0;
        while (i < this.vec.length) {
            v[i] = -this.vec[i];
            ++i;
        }
        return new Vector(v);
    }

    public double abs() {
        double sum = 0.0;
        double[] dArray = this.vec;
        int n = this.vec.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            sum += v * v;
            ++n2;
        }
        return Math.sqrt(sum);
    }

    public Vector add(Vector value) {
        if (this.columnVector != value.columnVector) {
            throw new OrientationException("addition");
        }
        int n = Math.max(value.length(), this.vec.length);
        double[] v = new double[n];
        int i = 0;
        while (i < n) {
            v[i] = this.get(i) + value.get(i);
            ++i;
        }
        return new Vector(this.columnVector, v);
    }

    public Vector add(double value) {
        double[] v = new double[this.vec.length];
        int i = 0;
        while (i < this.vec.length) {
            v[i] = this.vec[i] + value;
            ++i;
        }
        return new Vector(this.columnVector, v);
    }

    public Vector sub(Vector value) {
        if (this.columnVector != value.columnVector) {
            throw new OrientationException("subtraction");
        }
        int n = Math.max(value.length(), this.vec.length);
        double[] v = new double[n];
        int i = 0;
        while (i < n) {
            v[i] = this.get(i) - value.get(i);
            ++i;
        }
        return new Vector(this.columnVector, v);
    }

    public Vector sub(double v) {
        return this.add(-v);
    }

    public double dot(Vector value) {
        if (this.columnVector != value.columnVector) {
            throw new OrientationException("dot");
        }
        int n = Math.min(value.length(), this.vec.length);
        double v = 0.0;
        int i = 0;
        while (i < n) {
            v += this.get(i) * value.get(i);
            ++i;
        }
        return v;
    }

    public Vector normalize() {
        double f = this.abs();
        double[] v = new double[this.length()];
        int i = 0;
        while (i < this.length()) {
            v[i] = this.get(i) / f;
            ++i;
        }
        return new Vector(this.columnVector, v);
    }

    public Vector cross(Vector value) {
        if (this.columnVector != value.columnVector) {
            throw new OrientationException("cross");
        }
        if (this.vec.length != 3 || value.length() != 3) {
            throw new SizeException("Cross", this.vec.length, value.length());
        }
        double[] vv = new double[]{this.get(1) * value.get(2) - this.get(2) * value.get(1), this.get(2) * value.get(0) - this.get(0) * value.get(2), this.get(0) * value.get(1) - this.get(1) * value.get(0)};
        return new Vector(this.columnVector, vv);
    }

    public Vector mult(Matrix value) {
        if (this.columnVector) {
            throw new MatrixException();
        }
        double[] vv = new double[value.columns()];
        int k = 0;
        while (k < value.columns()) {
            vv[k] = 0.0;
            int j = 0;
            while (j < value.rows()) {
                int n = k;
                vv[n] = vv[n] + this.get(j) * value.get(j, k);
                ++j;
            }
            ++k;
        }
        return new Vector(this.columnVector, vv);
    }

    public Vector mult(double value) {
        double[] v = new double[this.vec.length];
        int i = 0;
        while (i < this.vec.length) {
            v[i] = this.vec[i] * value;
            ++i;
        }
        return new Vector(this.columnVector, v);
    }

    public Vector div(double v) {
        return this.mult(1.0 / v);
    }

    public static class MatrixException
    extends RuntimeException {
        MatrixException() {
            super("Column vector cannot be multiplied by matrix");
        }
    }

    public static class OrientationException
    extends RuntimeException {
        OrientationException(String msg) {
            super("Mixing row and column vectors in " + msg);
        }
    }

    public static class SizeException
    extends RuntimeException {
        SizeException(String msg, int n) {
            super(String.valueOf(msg) + " in not valid for size " + n + " vector");
        }

        SizeException(String msg, int n, int m) {
            super(String.valueOf(msg) + " in not valid for size " + n + " and " + m + " vector");
        }
    }
}

