/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ThreadGate<EStart, EResult> {
    private LinkedBlockingQueue<EStart> startQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<EResult> resultQueue = new LinkedBlockingQueue();
    private boolean busy = false;

    public void request(EStart msg) {
        try {
            this.startQueue.put(msg);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public EStart waitRequest() {
        try {
            EStart d = this.startQueue.take();
            this.busy = true;
            return d;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void postResult(EResult msg) {
        try {
            this.busy = false;
            this.resultQueue.put(msg);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public EResult waitResult() {
        try {
            return this.resultQueue.take();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public EResult waitResult(int timeout) {
        try {
            return this.resultQueue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public boolean isResult() {
        return !this.resultQueue.isEmpty();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void clear() {
        this.startQueue.clear();
        this.resultQueue.clear();
    }
}

