/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

public class Thermocouples {
    static Table tableJ1 = new Table('J', -210.0, 760.0, new double[]{0.0, 0.050381187815, 3.047583693E-5, -8.568106572E-8, 1.3228195295E-10, -1.7052958337E-13, 2.0948090697E-16, -1.2538395336E-19, 1.5631725697E-23});
    static Table tableJ2 = new Table('J', 760.0, 1200.0, new double[]{296.45625681, -1.4976127786, 0.0031787103924, -3.1847686701E-6, 1.5720819004E-9, -3.0691369056E-13});
    static Table tableE1 = new Table('E', -270.0, 0.0, new double[]{0.0, 0.058665508708, 4.5410977124E-5, -7.7998048686E-7, -2.5800160843E-8, -5.9452583057E-10, -9.3214058667E-12, -1.0287605534E-13, -8.0370123621E-16, -4.3979497391E-18, -1.6414776355E-20, -3.9673619516E-23, -5.5827328721E-26, -3.4657842013E-29});
    static Table tableE2 = new Table('E', 0.0, 1000.0, new double[]{0.0, 0.05866550871, 4.5032275582E-5, 2.8908407212E-8, -3.3056896652E-10, 6.502440327E-13, -1.9197495504E-16, -1.2536600497E-18, 2.1489217569E-21, -1.4388041782E-24, 3.5960899481E-28});
    static Table tableB1 = new Table('B', 0.0, 630.615, new double[]{0.0, -2.4650818346E-4, 5.9040421171E-6, -1.3257931636E-9, 1.5668291901E-12, -1.694452924E-15, 6.2990347094E-19});
    static Table tableB2 = new Table('B', 630.615, 1820.0, new double[]{-3.8938168621, 0.02857174747, -8.4885104785E-5, 1.5785280164E-7, -1.6835344864E-10, 1.1109794013E-13, -4.4515431033E-17, 9.8975640821E-21, -9.3791330289E-25});
    static Table tableN1 = new Table('N', -270.0, 0.0, new double[]{0.0, 0.026159105962, 1.0957484228E-5, -9.3841111554E-8, -4.6412039759E-11, -2.6303357716E-12, -2.2653438003E-14, -7.6089300791E-17, -9.3419667835E-20});
    static Table tableN2 = new Table('N', 0.0, 1300.0, new double[]{0.0, 0.025929394601, 1.571014188E-5, 4.3825627237E-8, -2.5261169794E-10, 6.4311819339E-13, -1.0063471519E-15, 9.9745338992E-19, -6.0863245607E-22, 2.0849229339E-25, -3.0682196151E-29});
    static Table tableR1 = new Table('R', -50.0, 1064.18, new double[]{0.0, 0.00528961729765, 1.39166589782E-5, -2.38855693017E-8, 3.56916001063E-11, -4.62347666298E-14, 5.00777441034E-17, -3.73105886191E-20, 1.57716482367E-23, -2.81038625251E-27});
    static Table tableR2 = new Table('R', 1064.18, 1664.5, new double[]{2.95157925316, -0.00252061251332, 1.59564501865E-5, -7.64085947576E-9, 2.05305291024E-12, -2.93359668173E-16});
    static Table tableR3 = new Table('R', 1664.5, 1768.1, new double[]{152.232118209, -0.268819888545, 1.71280280471E-4, -3.45895706453E-8, -9.34633971046E-15});
    static Table tableS1 = new Table('S', -50.0, 1064.18, new double[]{0.0, 0.00540313308631, 1.2593428974E-5, -2.32477968689E-8, 3.22028823036E-11, -3.31465196389E-14, 2.55744251786E-17, -1.25068871393E-20, 2.71443176145E-24});
    static Table tableS2 = new Table('S', 1064.18, 1664.5, new double[]{1.32900444085, 0.00334509311344, 6.54805192818E-6, -1.64856259209E-9, 1.29989605174E-14});
    static Table tableS3 = new Table('S', 1664.5, 1768.1, new double[]{146.628232636, -0.258430516752, 1.63693574641E-4, -3.30439046987E-8, -9.43223690612E-15});
    static Table tableT1 = new Table('T', -270.0, 0.0, new double[]{0.0, 0.038748106364, 4.4194434347E-5, 1.1844323105E-7, 2.0032973554E-8, 9.0138019559E-10, 2.2651156593E-11, 3.6071154205E-13, 3.8493939883E-15, 2.8213521925E-17, 1.4251594779E-19, 4.8768662286E-22, 1.079553927E-24, 1.3945027062E-27, 7.9795153927E-31});
    static Table tableT2 = new Table('T', 0.0, 400.0, new double[]{0.0, 0.038748106364, 3.329222788E-5, 2.0618243404E-7, -2.1882256846E-9, 1.0996880928E-11, -3.0815758772E-14, 4.547913529E-17, -2.7512901673E-20});
    static Table tableK1 = new Table('K', -270.0, 0.0, new double[]{0.0, 0.039450128025, 2.3622373598E-5, -3.2858906784E-7, -4.9904828777E-9, -6.7509059173E-11, -5.7410327428E-13, -3.1088872894E-15, -1.0451609365E-17, -1.9889266878E-20, -1.6322697486E-23});
    static Table tableK2 = new TableK('K', 0.0, 1372.0, new double[]{-0.017600413686, 0.038921204975, 1.8558770032E-5, -9.9457592874E-8, 3.1840945719E-10, -5.6072844889E-13, 5.6075059059E-16, -3.2020720003E-19, 9.7151147152E-23, -1.2104721275E-26});
    static Table tableRJ1 = new Table('J', -8.095, 0.0, new double[]{0.0, 19.528268, -1.2286185, -1.0752178, -0.59086933, -0.17256713, -0.028131513, -0.002396337, -8.3823321E-5});
    static Table tableRJ2 = new Table('J', 0.0, 42.919, new double[]{0.0, 19.78425, -0.2001204, 0.01036969, -2.549687E-4, 3.585153E-6, -5.344285E-8, 5.09989E-10});
    static Table tableRJ3a = new Table('J', 42.919, 69.553, new double[]{-3113.58187, 300.543684, -9.9477323, 0.17027663, -0.00143033468, 4.73886084E-6});
    static Table tableRJ3 = new Table('J', 42.919, 69.553, new double[]{-3113.58187, 300.543684, -9.9477323, 0.17027663, -0.00143033468, 4.73886084E-6});
    static Table tableRB1 = new Table('B', 0.291, 2.431, new double[]{98.423321, 699.715, -847.65304, 1005.2644, -833.45952, 455.08542, -155.23037, 29.88675, -2.474286});
    static Table tableRB2 = new Table('B', 2.431, 13.82, new double[]{213.15071, 285.10504, -52.742887, 9.9160804, -1.2965303, 0.1119587, -0.0060625199, 1.8661696E-4, -2.4878585E-6});
    static Table tableRE1 = new Table('E', -8.825, 0.0, new double[]{0.0, 16.977288, -0.4351497, -0.15859697, -0.092502871, -0.026084314, -0.0041360199, -3.403403E-4, -1.156489E-5, 0.0});
    static Table tableRE2 = new Table('E', 0.0, 76.373, new double[]{0.0, 17.057035, -0.23301759, 0.0065435585, -7.3562749E-5, -1.7896001E-6, 8.4036165E-8, -1.3735879E-9, 1.0629823E-11, -3.2447087E-14});
    static Table tableRN1 = new Table('N', -3.99, 0.0, new double[]{0.0, 38.436847, 1.1010485, 5.2229312, 7.2060525, 5.8488586, 2.7754916, 0.77075166, 0.11582665, 0.0073138868});
    static Table tableRN2 = new Table('N', 0.0, 20.613, new double[]{0.0, 38.6896, -1.08267, 0.0470205, -2.12169E-6, -1.17272E-4, 5.3928E-6, -7.98156E-8});
    static Table tableRN3 = new Table('N', 20.613, 47.513, new double[]{19.72485, 33.00943, -0.3915159, 0.009855391, -1.274371E-4, 7.767022E-7});
    static Table tableRR1 = new Table('R', -0.226, 1.923, new double[]{0.0, 188.9138, -93.83529, 130.68619, -227.0358, 351.45659, -389.539, 282.39471, -126.07281, 31.353611, -3.3187769});
    static Table tableRR2 = new Table('R', 1.923, 13.228, new double[]{13.34584505, 147.2644573, -18.44024844, 4.031129726, -0.624942836, 0.06468412046, -0.004458750426, 1.994710149E-4, -5.31340179E-6, 6.481976217E-8});
    static Table tableRR3 = new Table('R', 11.361, 19.739, new double[]{-81.99599416, 155.3962042, -8.342197663, 0.4279433549, -0.0119157791, 1.492290091E-4});
    static Table tableRR4 = new Table('R', 19.739, 21.103, new double[]{34061.77836, -7023.729171, 558.2903813, -19.52394635, 0.2560740231});
    static Table tableRS1 = new Table('R', -0.235, 1.874, new double[]{0.0, 184.94946, -80.0504062, 102.23743, -152.248592, 188.821343, -159.085941, 82.302788, -23.4181944, 2.7978626});
    static Table tableRS2 = new Table('R', 1.874, 11.95, new double[]{12.91507177, 146.6298863, -15.34713402, 3.145945973, -0.4163257839, 0.03187963771, -0.0012916375, 2.183475087E-5, -1.447379511E-7, 8.211272125E-9});
    static Table tableRS3 = new Table('R', 10.332, 17.536, new double[]{-80.87801117, 162.1573104, -8.536869453, 0.4719686976, -0.01441693666, 2.08161889E-4});
    static Table tableRS4 = new Table('R', 17.536, 18.693, new double[]{53338.75126, -12358.92298, 1092.657613, -42.65693686, 0.624720542});
    static Table tableRT1 = new Table('T', -5.603, 0.0, new double[]{0.0, 25.949192, -0.21316967, 0.79018692, 0.42527777, 0.13304473, 0.020241446, 0.0012668171});
    static Table tableRT2 = new Table('T', 0.0, 20.872, new double[]{0.0, 25.928, -0.7602961, 0.04637791, -0.002165394, 6.048144E-5, -7.293422E-7});
    static Table tableRK1 = new Table('K', -5.891, 0.0, new double[]{0.0, 25.173462, -1.1662878, -1.0833638, -0.8977354, -0.37342377, -0.086632643, -0.010450598, -5.1920577E-4});
    static Table tableRK2 = new Table('K', 0.0, 20.644, new double[]{0.0, 25.08355, 0.07860106, -0.2503131, 0.0831527, -0.01228034, 9.804036E-4, -4.41303E-5, 1.057734E-6, -1.052755E-8});
    static Table tableRK3 = new Table('K', 20.644, 54.886, new double[]{-131.8058, 48.30222, -1.646031, 0.05464731, -9.650715E-4, 8.802193E-6, -3.11081E-8});

    public static double thermocoupleT(String type, double temperature) {
        if (type.trim().length() == 0) {
            type = "J";
        }
        return Thermocouples.thermocouple(type.charAt(0), temperature);
    }

    public static double thermocoupleT(char type, double temperature) {
        switch (Character.toUpperCase(type)) {
            case 'J': {
                if (temperature < Thermocouples.tableJ1.min) {
                    return 0.0;
                }
                if (temperature <= Thermocouples.tableJ1.max) {
                    return tableJ1.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableJ2.max) {
                    return tableJ2.calc(temperature) / 1000.0;
                }
                return 0.0;
            }
            case 'E': {
                if (temperature < Thermocouples.tableE1.min) {
                    return 0.0;
                }
                if (temperature <= Thermocouples.tableE1.max) {
                    return tableE1.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableE2.max) {
                    return tableE2.calc(temperature) / 1000.0;
                }
                return 0.0;
            }
            case 'B': {
                if (temperature < Thermocouples.tableB1.min) {
                    return 0.0;
                }
                if (temperature <= Thermocouples.tableB1.max) {
                    return tableB1.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableB2.max) {
                    return tableB2.calc(temperature) / 1000.0;
                }
                return 0.0;
            }
            case 'N': {
                if (temperature < Thermocouples.tableN1.min) {
                    return 0.0;
                }
                if (temperature <= Thermocouples.tableN1.max) {
                    return tableN1.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableN2.max) {
                    return tableN2.calc(temperature) / 1000.0;
                }
                return 0.0;
            }
            case 'R': {
                if (temperature < Thermocouples.tableR1.min) {
                    return 0.0;
                }
                if (temperature <= Thermocouples.tableR1.max) {
                    return tableR1.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableR2.max) {
                    return tableR2.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableR3.max) {
                    return tableR3.calc(temperature) / 1000.0;
                }
                return 0.0;
            }
            case 'S': {
                if (temperature < Thermocouples.tableS1.min) {
                    return 0.0;
                }
                if (temperature <= Thermocouples.tableS1.max) {
                    return tableS1.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableS2.max) {
                    return tableS2.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableS3.max) {
                    return tableS3.calc(temperature) / 1000.0;
                }
                return 0.0;
            }
            case 'T': {
                if (temperature < Thermocouples.tableT1.min) {
                    return 0.0;
                }
                if (temperature <= Thermocouples.tableT1.max) {
                    return tableT1.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableT2.max) {
                    return tableT2.calc(temperature) / 1000.0;
                }
                return 0.0;
            }
            case 'K': {
                if (temperature < Thermocouples.tableK1.min) {
                    return 0.0;
                }
                if (temperature <= Thermocouples.tableK1.max) {
                    return tableK1.calc(temperature) / 1000.0;
                }
                if (temperature <= Thermocouples.tableK2.max) {
                    return tableK2.calc(temperature) / 1000.0;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    public static double thermocoupleMaxT(char type) {
        switch (Character.toUpperCase(type)) {
            case 'J': {
                return Thermocouples.tableJ2.max;
            }
            case 'E': {
                return Thermocouples.tableE2.max;
            }
            case 'B': {
                return Thermocouples.tableB2.max;
            }
            case 'N': {
                return Thermocouples.tableN2.max;
            }
            case 'R': {
                return Thermocouples.tableR3.max;
            }
            case 'S': {
                return Thermocouples.tableS3.max;
            }
            case 'T': {
                return Thermocouples.tableT2.max;
            }
            case 'K': {
                return Thermocouples.tableK2.max;
            }
        }
        return 0.0;
    }

    public static double thermocoupleMinT(char type) {
        switch (Character.toUpperCase(type)) {
            case 'J': {
                return Thermocouples.tableJ1.min;
            }
            case 'E': {
                return Thermocouples.tableE1.min;
            }
            case 'B': {
                return Thermocouples.tableB1.min;
            }
            case 'N': {
                return Thermocouples.tableN1.min;
            }
            case 'R': {
                return Thermocouples.tableR1.min;
            }
            case 'S': {
                return Thermocouples.tableS1.min;
            }
            case 'T': {
                return Thermocouples.tableT1.min;
            }
            case 'K': {
                return Thermocouples.tableK1.min;
            }
        }
        return 0.0;
    }

    public static double thermocouple(String type, double volt) {
        if (type.trim().length() == 0) {
            type = "J";
        }
        return Thermocouples.thermocouple(type.charAt(0), volt);
    }

    public static double thermocouple(char type, double volt) {
        volt *= 1000.0;
        switch (Character.toUpperCase(type)) {
            case 'J': {
                if (volt < Thermocouples.tableRJ1.min) {
                    return 0.0;
                }
                if (volt <= Thermocouples.tableRJ1.max) {
                    return tableRJ1.calc(volt);
                }
                if (volt <= Thermocouples.tableRJ2.max) {
                    return tableRJ2.calc(volt);
                }
                if (volt <= Thermocouples.tableRJ3.max) {
                    return tableRJ3.calc(volt);
                }
                return 0.0;
            }
            case 'B': {
                if (volt < Thermocouples.tableRB1.min) {
                    return 0.0;
                }
                if (volt <= Thermocouples.tableRB1.max) {
                    return tableRB1.calc(volt);
                }
                if (volt <= Thermocouples.tableRB2.max) {
                    return tableRB2.calc(volt);
                }
                return 0.0;
            }
            case 'E': {
                if (volt < Thermocouples.tableRE1.min) {
                    return 0.0;
                }
                if (volt <= Thermocouples.tableRE1.max) {
                    return tableRE1.calc(volt);
                }
                if (volt <= Thermocouples.tableRE2.max) {
                    return tableRE2.calc(volt);
                }
                return 0.0;
            }
            case 'N': {
                if (volt < Thermocouples.tableRN1.min) {
                    return 0.0;
                }
                if (volt <= Thermocouples.tableRN1.max) {
                    return tableRN1.calc(volt);
                }
                if (volt <= Thermocouples.tableRN2.max) {
                    return tableRN2.calc(volt);
                }
                if (volt <= Thermocouples.tableRN3.max) {
                    return tableRN3.calc(volt);
                }
                return 0.0;
            }
            case 'R': {
                if (volt < Thermocouples.tableRR1.min) {
                    return 0.0;
                }
                if (volt <= Thermocouples.tableRR1.max) {
                    return tableRR1.calc(volt);
                }
                if (volt <= Thermocouples.tableRR2.max) {
                    return tableRR2.calc(volt);
                }
                if (volt <= Thermocouples.tableRR3.max) {
                    return tableRR3.calc(volt);
                }
                if (volt <= Thermocouples.tableRR4.max) {
                    return tableRR4.calc(volt);
                }
                return 0.0;
            }
            case 'S': {
                if (volt < Thermocouples.tableRS1.min) {
                    return 0.0;
                }
                if (volt <= Thermocouples.tableRS1.max) {
                    return tableRS1.calc(volt);
                }
                if (volt <= Thermocouples.tableRS2.max) {
                    return tableRS2.calc(volt);
                }
                if (volt <= Thermocouples.tableRS3.max) {
                    return tableRS3.calc(volt);
                }
                if (volt <= Thermocouples.tableRS4.max) {
                    return tableRS4.calc(volt);
                }
                return 0.0;
            }
            case 'T': {
                if (volt < Thermocouples.tableRT1.min) {
                    return 0.0;
                }
                if (volt <= Thermocouples.tableRT1.max) {
                    return tableRT1.calc(volt);
                }
                if (volt <= Thermocouples.tableRT2.max) {
                    return tableRT2.calc(volt);
                }
                return 0.0;
            }
            case 'K': {
                if (volt < Thermocouples.tableRK1.min) {
                    return 0.0;
                }
                if (volt <= Thermocouples.tableRK1.max) {
                    return tableRK1.calc(volt);
                }
                if (volt <= Thermocouples.tableRK2.max) {
                    return tableRK2.calc(volt);
                }
                if (volt <= Thermocouples.tableRK3.max) {
                    return tableRK3.calc(volt);
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    public static double thermocoupleMaxV(char type) {
        switch (Character.toUpperCase(type)) {
            case 'J': {
                return Thermocouples.tableRJ3.max / 1000.0;
            }
            case 'B': {
                return Thermocouples.tableRB2.max / 1000.0;
            }
            case 'E': {
                return Thermocouples.tableRE2.max / 1000.0;
            }
            case 'N': {
                return Thermocouples.tableRN3.max / 1000.0;
            }
            case 'R': {
                return Thermocouples.tableRR4.max / 1000.0;
            }
            case 'S': {
                return Thermocouples.tableRS4.max / 1000.0;
            }
            case 'T': {
                return Thermocouples.tableRT2.max / 1000.0;
            }
            case 'K': {
                return Thermocouples.tableRK3.max / 1000.0;
            }
        }
        return 0.0;
    }

    public static double thermocoupleMinV(char type) {
        switch (Character.toUpperCase(type)) {
            case 'J': {
                return Thermocouples.tableRJ1.min / 1000.0;
            }
            case 'B': {
                return Thermocouples.tableRB1.min / 1000.0;
            }
            case 'E': {
                return Thermocouples.tableRE1.min / 1000.0;
            }
            case 'N': {
                return Thermocouples.tableRN1.min / 1000.0;
            }
            case 'R': {
                return Thermocouples.tableRR1.min / 1000.0;
            }
            case 'S': {
                return Thermocouples.tableRS1.min / 1000.0;
            }
            case 'T': {
                return Thermocouples.tableRT1.min / 1000.0;
            }
            case 'K': {
                return Thermocouples.tableRK1.min / 1000.0;
            }
        }
        return 0.0;
    }

    public static void test(char type) {
        System.out.println("Thermocoupler type " + type + " test");
        System.out.println("       Voltage range: " + Thermocouples.thermocoupleMinV(type) + "   " + Thermocouples.thermocoupleMaxV(type));
        System.out.println("       Temperature range: " + Thermocouples.thermocoupleMinT(type) + "   " + Thermocouples.thermocoupleMaxT(type));
        double t = Thermocouples.thermocoupleMinT(type);
        double dt = 0.0;
        while (t <= Thermocouples.thermocoupleMaxT(type)) {
            double tt;
            double v = Thermocouples.thermocoupleT(type, t);
            if (v >= Thermocouples.thermocoupleMinV(type) && v <= Thermocouples.thermocoupleMaxV(type) && Math.abs((tt = Thermocouples.thermocouple(type, v)) - t) > dt) {
                if (Math.abs(tt - t) > 0.5) {
                    System.out.println("Bad: " + t + "      " + tt);
                }
                dt = Math.abs(tt - t);
            }
            t += 0.01;
        }
        System.out.println("       Max error in conversion: " + dt + " degree ");
    }

    public static void test() {
        Thermocouples.test('J');
        Thermocouples.test('B');
        Thermocouples.test('E');
        Thermocouples.test('N');
        Thermocouples.test('R');
        Thermocouples.test('S');
        Thermocouples.test('T');
        Thermocouples.test('K');
    }

    private static class Table {
        char type;
        double min;
        double max;
        double[] table;

        public Table(char type, double min, double max, double[] table) {
            this.type = type;
            this.min = min;
            this.max = max;
            this.table = table;
        }

        public double calc(double value) {
            double sum = 0.0;
            int i = 0;
            while (i < this.table.length) {
                sum += this.table[i] * Math.pow(value, i);
                ++i;
            }
            return sum;
        }
    }

    private static class TableK
    extends Table {
        private double a0 = 0.1185976;
        private double a1 = -1.183432E-4;
        private double a2 = 126.9686;

        public TableK(char type, double min, double max, double[] table) {
            super(type, min, max, table);
        }

        @Override
        public double calc(double value) {
            double sum = super.calc(value);
            if (value > 0.0) {
                sum += this.a0 * Math.exp(this.a1 * (value - this.a2) * (value - this.a2));
            }
            return sum;
        }
    }
}

