/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String formatCenter(String str, int len, char filler) {
        StringBuilder sb = new StringBuilder(len);
        int n = (len - str.length()) / 2;
        int i = 0;
        while (i < n) {
            sb.append(filler);
            ++i;
        }
        i = 0;
        while (sb.length() < len && i < str.length()) {
            sb.append(str.charAt(i));
            ++i;
        }
        while (sb.length() < len) {
            sb.append(filler);
        }
        return sb.toString();
    }

    public static String formatLeft(String str, int len, char filler) {
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (sb.length() < len && i < str.length()) {
            sb.append(str.charAt(i));
            ++i;
        }
        while (sb.length() < len) {
            sb.append(filler);
        }
        return sb.toString();
    }

    public static String formatRight(String str, int len, char filler) {
        StringBuilder sb = new StringBuilder(len);
        int n = len - str.length();
        int i = 0;
        while (i < n) {
            sb.append(filler);
            ++i;
        }
        i = 0;
        while (sb.length() < len && i < str.length()) {
            sb.append(str.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static String addEscape(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    if (c < ' ' || c == '\u007f') {
                        sb.append("0x" + StringUtil.hex2(c));
                        break;
                    }
                    if (c > '\u007f') {
                        sb.append("0u" + StringUtil.hex4(c));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String decodeEscape(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\') {
                int c1 = ++i >= str.length() ? 32 : (int)str.charAt(i);
                switch (c1) {
                    case 98: {
                        sb.append('\b');
                        break;
                    }
                    case 116: {
                        sb.append('\t');
                        break;
                    }
                    case 110: {
                        sb.append('\n');
                        break;
                    }
                    case 114: {
                        sb.append('\r');
                        break;
                    }
                    case 95: {
                        break;
                    }
                    case 92: {
                        sb.append('\\');
                        break;
                    }
                    case 32: {
                        sb.append(' ');
                        break;
                    }
                    case 34: {
                        sb.append('\"');
                        break;
                    }
                    case 39: {
                        sb.append('\'');
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 117: {
                        sb.append((char)Integer.parseInt("" + str.charAt(++i) + str.charAt(++i) + str.charAt(++i) + str.charAt(++i), 16));
                        break;
                    }
                    case 120: {
                        sb.append((char)Integer.parseInt("" + str.charAt(++i) + str.charAt(++i), 16));
                    }
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String dec1(int value) {
        char[] c = new char[]{(char)(value % 10 + 48)};
        return new String(c);
    }

    public static String dec2(int value) {
        char[] c = new char[2];
        c[1] = (char)(value % 10 + 48);
        c[0] = (char)(value / 10 % 10 + 48);
        return new String(c);
    }

    public static String dec3(int value) {
        char[] c = new char[3];
        c[2] = (char)(value % 10 + 48);
        c[1] = (char)(value / 10 % 10 + 48);
        c[0] = (char)(value / 100 % 10 + 48);
        return new String(c);
    }

    public static String bin(byte b) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 8) {
            sb.append((b & 1 << 7 - i) != 0 ? "1" : "0");
            ++i;
        }
        return sb.toString();
    }

    public static String hex2(int value) {
        return StringUtil.hex2((byte)value);
    }

    public static String hex2(byte b) {
        char[] a = new char[]{HEX_DIGIT[b >> 4 & 0xF], HEX_DIGIT[b & 0xF]};
        return String.valueOf(a);
    }

    public static String hex(int bytes, long value) {
        StringBuilder sb = new StringBuilder();
        if (bytes >= 8) {
            sb.append(StringUtil.hex2((byte)(value >> 56 & 0xFFL)));
        }
        if (bytes >= 7) {
            sb.append(StringUtil.hex2((byte)(value >> 48 & 0xFFL)));
        }
        if (bytes >= 6) {
            sb.append(StringUtil.hex2((byte)(value >> 40 & 0xFFL)));
        }
        if (bytes >= 5) {
            sb.append(StringUtil.hex2((byte)(value >> 32 & 0xFFL)));
        }
        if (bytes >= 4) {
            sb.append(StringUtil.hex2((byte)(value >> 24 & 0xFFL)));
        }
        if (bytes >= 3) {
            sb.append(StringUtil.hex2((byte)(value >> 16 & 0xFFL)));
        }
        if (bytes >= 2) {
            sb.append(StringUtil.hex2((byte)(value >> 8 & 0xFFL)));
        }
        sb.append(StringUtil.hex2((byte)(value & 0xFFL)));
        return sb.toString();
    }

    public static String hex4(int value) {
        byte[] a = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return StringUtil.hexNN(a);
    }

    public static String hex8(int value) {
        byte[] a = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return StringUtil.hexNN(a);
    }

    public static String hex16(long value) {
        byte[] a = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return StringUtil.hexNN(a);
    }

    public static String hexN(byte[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(a.length * 3);
        byte[] byArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(HEX_DIGIT[b >> 4 & 0xF]);
            sb.append(HEX_DIGIT[b & 0xF]);
            sb.append(' ');
            ++n2;
        }
        sb.setLength(a.length * 3 - 1);
        return sb.toString();
    }

    public static String hexN(Byte[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(a.length * 3);
        Byte[] byteArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byteArray[n2];
            sb.append(HEX_DIGIT[b >> 4 & 0xF]);
            sb.append(HEX_DIGIT[b & 0xF]);
            sb.append(' ');
            ++n2;
        }
        sb.setLength(a.length * 3 - 1);
        return sb.toString();
    }

    public static String hexNN(byte[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(a.length * 2);
        byte[] byArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(HEX_DIGIT[b >> 4 & 0xF]);
            sb.append(HEX_DIGIT[b & 0xF]);
            ++n2;
        }
        return sb.toString();
    }

    public static String hexString(String str) {
        if (str == null) {
            return "";
        }
        try {
            return StringUtil.hexN(str.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            return StringUtil.hexN(str.getBytes());
        }
    }

    public static String printableString(String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            int c = str.charAt(i);
            if (c < 32) {
                c = 46;
            }
            sb.append((char)c);
            ++i;
        }
        return sb.toString();
    }

    public static double parseDoubleEE(String value) {
        block28: {
            block27: {
                block26: {
                    block25: {
                        try {
                            if (value != null) break block25;
                            return Double.NaN;
                        }
                        catch (Exception e) {
                            return Double.NaN;
                        }
                    }
                    value = value.trim().replace(',', '.');
                    if (value.length() != 0 && !value.equals("NaN") && !value.equals("?") && !value.equals("\ufffd")) break block26;
                    return Double.NaN;
                }
                if (!value.equals("\u221e")) break block27;
                return Double.POSITIVE_INFINITY;
            }
            if (!value.equals("-\u221e")) break block28;
            return Double.NEGATIVE_INFINITY;
        }
        double f = 1.0;
        switch (value.charAt(value.length() - 1)) {
            case 'Y': {
                f = 1.0E24;
                break;
            }
            case 'Z': {
                f = 1.0E21;
                break;
            }
            case 'E': {
                f = 1.0E18;
                break;
            }
            case 'P': {
                f = 1.0E15;
                break;
            }
            case 'T': {
                f = 1.0E12;
                break;
            }
            case 'G': {
                f = 1.0E9;
                break;
            }
            case 'M': {
                f = 1000000.0;
                break;
            }
            case 'k': {
                f = 1000.0;
                break;
            }
            case 'm': {
                f = 0.001;
                break;
            }
            case 'u': 
            case '\ufffd': {
                f = 1.0E-6;
                break;
            }
            case 'n': {
                f = 1.0E-9;
                break;
            }
            case 'p': {
                f = 1.0E-12;
                break;
            }
            case 'f': {
                f = 1.0E-15;
                break;
            }
            case 'a': {
                f = 1.0E-18;
                break;
            }
            case 'z': {
                f = 1.0E-21;
                break;
            }
            case 'y': {
                f = 1.0E-24;
            }
        }
        if (f != 1.0) {
            value = value.substring(0, value.length() - 1).trim();
        }
        return Double.parseDouble(value) * f;
    }

    public static String formatDoubleEE(double value) {
        return StringUtil.formatDoubleEE(value, true);
    }

    public static String formatDoubleEE(double value, boolean spaceBeforeUnit) {
        return StringUtil.formatDoubleEE(value, spaceBeforeUnit, -1, '.');
    }

    public static String formatDoubleEE(double value, boolean spaceBeforeUnit, int digits) {
        return StringUtil.formatDoubleEE(value, spaceBeforeUnit, digits, '.');
    }

    public static String formatDoubleEE(double value, boolean spaceBeforeUnit, int digits, char lowerLimit) {
        int limit = "_munpfazy".indexOf(lowerLimit);
        if (limit < 0) {
            limit = lowerLimit == ' ' ? 0 : 9;
        }
        if (Double.isInfinite(value)) {
            return value > 0.0 ? "\u221e" : "-\u221e";
        }
        if (Double.isNaN(value)) {
            return "\ufffd";
        }
        String prefix = "";
        double v = Math.abs(value);
        if (v > 1.0E27) {
            String f = "0.";
            if (digits > 2) {
                int i = 1;
                while (i < digits) {
                    f = String.valueOf(f) + "#";
                    ++i;
                }
            } else {
                f = "0.0######";
            }
            f = String.valueOf(f) + "E0;-" + f + "E0";
            DecimalFormat df = new DecimalFormat(f);
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(dfs);
            return df.format(value);
        }
        if (v > 1.0E24) {
            prefix = "Y";
            value /= 1.0E24;
        } else if (v > 1.0E21) {
            prefix = "Z";
            value /= 1.0E21;
        } else if (v > 1.0E18) {
            prefix = "E";
            value /= 1.0E18;
        } else if (v > 1.0E15) {
            prefix = "P";
            value /= 1.0E15;
        } else if (v > 1.0E12) {
            prefix = "T";
            value /= 1.0E12;
        } else if (v > 1.0E9) {
            prefix = "G";
            value /= 1.0E9;
        } else if (v > 1000000.0) {
            prefix = "M";
            value /= 1000000.0;
        } else if (v > 1000.0) {
            prefix = "k";
            value /= 1000.0;
        } else if (v < 1.0E-25) {
            value = 0.0;
        } else if (v < 1.0E-21 && limit >= 8) {
            prefix = "y";
            value *= 1.0E24;
        } else if (v < 1.0E-18 && limit >= 7) {
            prefix = "z";
            value *= 1.0E21;
        } else if (v < 1.0E-15 && limit >= 6) {
            prefix = "a";
            value *= 1.0E18;
        } else if (v < 1.0E-12 && limit >= 5) {
            prefix = "f";
            value *= 1.0E15;
        } else if (v < 1.0E-9 && limit >= 4) {
            prefix = "p";
            value *= 1.0E12;
        } else if (v < 1.0E-6 && limit >= 3) {
            prefix = "n";
            value *= 1.0E9;
        } else if (v < 0.001 && limit >= 2) {
            prefix = "u";
            value *= 1000000.0;
        } else if (v < 1.0 && limit >= 1) {
            prefix = "m";
            value *= 1000.0;
        }
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setGroupingUsed(false);
        if (digits <= 2) {
            int n = 5;
            v = Math.abs(value);
            if (v > 100000.0) {
                n = 1;
            } else if (v > 10000.0) {
                n = 2;
            } else if (v > 1000.0) {
                n = 3;
            } else if (v > 100.0) {
                n = 4;
            } else if (v > 10.0) {
                n = 5;
            } else {
                v = 6.0;
            }
            nf.setMaximumFractionDigits(n);
            return String.valueOf(nf.format(value)) + (spaceBeforeUnit ? " " : "") + prefix;
        }
        nf.setMaximumFractionDigits(digits - 1);
        String s = nf.format(value);
        int i = 0;
        boolean pointFound = false;
        while (!(digits <= 0 && pointFound || i >= s.length())) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                --digits;
            }
            if (c == '.') {
                pointFound = true;
            }
            ++i;
        }
        if ((s = s.substring(0, i)).charAt(s.length() - 1) == '.') {
            s = s.substring(0, s.length() - 1);
        }
        return String.valueOf(s) + (spaceBeforeUnit ? " " : "") + prefix;
    }

    public static String formatHMS(double seconds) {
        return StringUtil.formatHMS(seconds, 0);
    }

    public static String formatHMS(double seconds, int msDigits) {
        StringBuilder sb = new StringBuilder();
        if (seconds < 0.0) {
            seconds = -seconds;
            sb.append('-');
        }
        int sec = 0;
        int ms = 0;
        switch (msDigits) {
            case 0: {
                sec = (int)(seconds + 0.5);
                break;
            }
            case 1: {
                sec = (int)(seconds * 10.0 + 0.5);
                ms = sec % 10 * 100;
                sec /= 10;
                break;
            }
            case 2: {
                sec = (int)(seconds * 100.0 + 0.5);
                ms = sec % 100 * 10;
                sec /= 100;
                break;
            }
            case 3: {
                sec = (int)(seconds * 1000.0 + 0.5);
                ms = sec % 1000;
                sec /= 1000;
            }
        }
        int s = sec % 60;
        int m = (sec /= 60) % 60;
        int h = sec /= 60;
        if (h > 0) {
            sb.append(h);
            sb.append(':');
        }
        sb.append(StringUtil.dec2(m));
        sb.append(':');
        sb.append(StringUtil.dec2(s));
        if (ms != 0) {
            if (ms % 100 == 0) {
                sb.append(".");
                sb.append(StringUtil.dec1(ms / 100));
            } else if (ms % 10 == 0) {
                sb.append(".");
                sb.append(StringUtil.dec2(ms / 10));
            } else {
                sb.append(".");
                sb.append(StringUtil.dec3(ms));
            }
        }
        return sb.toString();
    }

    public static String extractSubstring(String searchFirst, String searchLast, String line) {
        Matcher m = Pattern.compile(searchFirst).matcher(line);
        if (!m.find()) {
            return "";
        }
        int first = m.end();
        m = Pattern.compile(searchLast).matcher(line.substring(first));
        if (!m.find()) {
            return "";
        }
        int last = m.start();
        return line.substring(first, first + last);
    }

    public static String listToString(List<String> list, String delimeter) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
            sb.append(delimeter);
        }
        return sb.toString();
    }

    public static List<String> stringToList(String str, String delimeters) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = str.split("[" + delimeters + "]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s.trim());
            ++n2;
        }
        return list;
    }

    public static boolean isInt(String s) {
        try {
            StringUtil.parseInt(s);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int parseInt(String s) {
        if (s.startsWith("0x") || s.startsWith("0X")) {
            return Integer.parseInt(s.substring(2), 16);
        }
        if (s.startsWith("0b") || s.startsWith("0b")) {
            return Integer.parseInt(s.substring(2), 2);
        }
        if (s.startsWith("$")) {
            return Integer.parseInt(s.substring(1), 16);
        }
        if (s.endsWith("h")) {
            return Integer.parseInt(s.substring(0, s.length() - 1), 16);
        }
        if (s.endsWith("b")) {
            return Integer.parseInt(s.substring(0, s.length() - 1), 16);
        }
        return Integer.parseInt(s);
    }

    public static long parseLong(String s) {
        if (s.startsWith("0x") || s.startsWith("0X")) {
            return Long.parseLong(s.substring(2), 16);
        }
        if (s.startsWith("0b") || s.startsWith("0b")) {
            return Long.parseLong(s.substring(2), 2);
        }
        if (s.startsWith("$")) {
            return Long.parseLong(s.substring(1), 16);
        }
        if (s.endsWith("h")) {
            return Long.parseLong(s.substring(0, s.length() - 1), 16);
        }
        if (s.endsWith("b")) {
            return Long.parseLong(s.substring(0, s.length() - 1), 16);
        }
        return Long.parseLong(s);
    }

    public static String unQuote(String str) {
        if (str.trim().length() >= 2) {
            if ((str = str.trim()).charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
                str = str.substring(1, str.length() - 1);
            } else if (str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
                str = str.substring(1, str.length() - 1);
            }
        }
        return str;
    }

    public static String sanitiseName(String name) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (sb.length() == 0 && Character.isJavaIdentifierStart(c)) {
                sb.append(c);
            } else if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String sanitiseFilename(String fname) {
        if (fname == null) {
            return null;
        }
        String invalidCharacters = "<>:\"/\\*|?";
        int i = 0;
        while (i < invalidCharacters.length()) {
            char c = invalidCharacters.charAt(i);
            fname = fname.replace(String.valueOf(c), "");
            ++i;
        }
        if (fname.equals(".") || fname.equals("..")) {
            return "";
        }
        return fname.trim();
    }

    public static boolean matchBits(String matchString, long value) {
        long mask = 0L;
        long ref = 0L;
        char[] cArray = matchString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '0': {
                    mask = mask << 1 | 1L;
                    ref = ref << 1 | 0L;
                    break;
                }
                case '1': {
                    mask = mask << 1 | 1L;
                    ref = ref << 1 | 1L;
                    break;
                }
                default: {
                    mask = mask << 1 | 0L;
                    ref <<= 1;
                }
            }
            ++n2;
        }
        return (value & mask) == ref;
    }

    public static String fixNumber(String number) {
        if (!number.contains("0000000000") || number.indexOf(46) < 0) {
            return number;
        }
        if (number.charAt(number.length() - 2) == '.') {
            return number;
        }
        String ee = "";
        int i = number.indexOf(69);
        if (i > 0) {
            ee = number.substring(i);
            number = number.substring(0, i);
        }
        while (number.charAt(number.length() - 1) != '0') {
            number = number.substring(0, number.length() - 1);
        }
        while (number.charAt(number.length() - 1) == '0') {
            number = number.substring(0, number.length() - 1);
        }
        return String.valueOf(number) + ee;
    }

    public static double parseFloat(String value) {
        if ((value = value.replace(',', '.').trim()).length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public static double parseHMS(String value) {
        value = value.trim();
        String[] v = value.replaceAll(":", " : ").split("[:]");
        double h = 0.0;
        double m = 0.0;
        double s = 0.0;
        int sign = 1;
        int n = v.length;
        if (n == 1 && value.endsWith("s")) {
            return StringUtil.parseFloat(value.substring(0, value.length() - 1));
        }
        if (n == 1 && value.endsWith("m")) {
            return StringUtil.parseFloat(value.substring(0, value.length() - 1)) * 60.0;
        }
        if (n == 1 && value.endsWith("h")) {
            return StringUtil.parseFloat(value.substring(0, value.length() - 1)) * 3600.0;
        }
        if (n > 0 && (s = StringUtil.parseFloat(v[--n])) < 0.0) {
            sign = -1;
            s = -s;
        }
        if (n > 0 && (m = StringUtil.parseFloat(v[--n])) < 0.0) {
            sign = -1;
            m = -m;
        }
        if (n > 0 && (h = StringUtil.parseFloat(v[--n])) < 0.0) {
            sign = -1;
            h = -h;
        }
        return (h * 3600.0 + m * 60.0 + s) * (double)sign;
    }
}

