/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

public class ProbabilitiesUtil {
    public static long facInt(int n) {
        if (n < 1 || n > 20) {
            return 0L;
        }
        long f = 1L;
        while (n > 1) {
            f *= (long)n;
            --n;
        }
        return f;
    }

    public static double fac(int n) {
        if (n < 1 || n > 170) {
            return Double.NaN;
        }
        double f = 1.0;
        while (n > 1) {
            f *= (double)n;
            --n;
        }
        return f;
    }

    private static double sqr(double v) {
        return v * v;
    }

    public static double pdf(double x) {
        return Math.exp(-x * x / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double pdf(double x, double mean, double sigma) {
        return ProbabilitiesUtil.pdf((x - mean) / sigma) / sigma;
    }

    public static double cdf(double z) {
        if (z < -8.0) {
            return 0.0;
        }
        if (z > 8.0) {
            return 1.0;
        }
        double sum = 0.0;
        double term = z;
        int i = 3;
        while (sum + term != sum) {
            sum += term;
            term = term * z * z / (double)i;
            i += 2;
        }
        return 0.5 + sum * ProbabilitiesUtil.pdf(z);
    }

    public static double cdf(double z, double mean, double sigma) {
        return ProbabilitiesUtil.cdf((z - mean) / sigma);
    }

    public static double inverseCDF(double y) {
        return ProbabilitiesUtil.inverseCDF(y, 1.0E-8, -8.0, 8.0);
    }

    private static double inverseCDF(double y, double delta, double lo, double hi) {
        double mid = lo + (hi - lo) / 2.0;
        if (hi - lo < delta) {
            return mid;
        }
        if (ProbabilitiesUtil.cdf(mid) > y) {
            return ProbabilitiesUtil.inverseCDF(y, delta, lo, mid);
        }
        return ProbabilitiesUtil.inverseCDF(y, delta, mid, hi);
    }
}

