/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

public class Polyfit {
    public static double[] fit(int degree, double[] x, double[] y) {
        int k;
        int j;
        int N = x.length;
        if (y.length != N) {
            throw new IllegalArgumentException("x & y must be same size");
        }
        double[] X = new double[2 * degree + 1];
        int i = 0;
        while (i < 2 * degree + 1) {
            X[i] = 0.0;
            int j2 = 0;
            while (j2 < N) {
                X[i] = X[i] + Math.pow(x[j2], i);
                ++j2;
            }
            ++i;
        }
        double[][] B = new double[degree + 1][degree + 2];
        double[] a = new double[degree + 1];
        int i2 = 0;
        while (i2 <= degree) {
            int j3 = 0;
            while (j3 <= degree) {
                B[i2][j3] = X[i2 + j3];
                ++j3;
            }
            ++i2;
        }
        double[] Y = new double[degree + 1];
        int i3 = 0;
        while (i3 < degree + 1) {
            Y[i3] = 0.0;
            j = 0;
            while (j < N) {
                Y[i3] = Y[i3] + Math.pow(x[j], i3) * y[j];
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 <= degree) {
            B[i3][degree + 1] = Y[i3];
            ++i3;
        }
        ++degree;
        i3 = 0;
        while (i3 < degree) {
            k = i3 + 1;
            while (k < degree) {
                if (B[i3][i3] < B[k][i3]) {
                    int j4 = 0;
                    while (j4 <= degree) {
                        double temp = B[i3][j4];
                        B[i3][j4] = B[k][j4];
                        B[k][j4] = temp;
                        ++j4;
                    }
                }
                ++k;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < degree - 1) {
            k = i3 + 1;
            while (k < degree) {
                double t = B[k][i3] / B[i3][i3];
                int j5 = 0;
                while (j5 <= degree) {
                    B[k][j5] = B[k][j5] - t * B[i3][j5];
                    ++j5;
                }
                ++k;
            }
            ++i3;
        }
        i3 = degree - 1;
        while (i3 >= 0) {
            a[i3] = B[i3][degree];
            j = 0;
            while (j < degree) {
                if (j != i3) {
                    a[i3] = a[i3] - B[i3][j] * a[j];
                }
                ++j;
            }
            a[i3] = a[i3] / B[i3][i3];
            --i3;
        }
        return a;
    }
}

