/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import dk.hkj.util.StringUtil;
import dk.hkj.util.Vector;
import java.util.List;

public class Matrix {
    private final double[][] mx;
    private final boolean isNaN;
    private final boolean isInfinite;

    public Matrix() {
        this.mx = new double[0][0];
        this.isNaN = false;
        this.isInfinite = false;
    }

    public Matrix(long matrix) {
        this.mx = new double[1][1];
        this.mx[0][0] = matrix;
        this.isNaN = false;
        this.isInfinite = false;
    }

    public Matrix(double matrix) {
        this.mx = new double[1][1];
        this.mx[0][0] = matrix;
        this.isNaN = Double.isNaN(this.mx[0][0]);
        this.isInfinite = Double.isInfinite(this.mx[0][0]);
    }

    private Matrix(int dummy, double[][] matrix) {
        this.mx = matrix;
        boolean lisNaN = false;
        boolean lisInfinite = false;
        double[][] dArray = this.mx;
        int n = this.mx.length;
        int n2 = 0;
        while (n2 < n) {
            double[] vv;
            double[] dArray2 = vv = dArray[n2];
            int n3 = vv.length;
            int n4 = 0;
            while (n4 < n3) {
                double v = dArray2[n4];
                if (Double.isNaN(v)) {
                    lisNaN = true;
                }
                if (Double.isInfinite(v)) {
                    lisInfinite = true;
                }
                ++n4;
            }
            ++n2;
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public Matrix(double[][] matrix) {
        boolean lisNaN = false;
        boolean lisInfinite = false;
        if (matrix.length > 0) {
            int n = matrix[0].length;
            double[][] dArray = matrix;
            int n2 = matrix.length;
            int n3 = 0;
            while (n3 < n2) {
                double[] row = dArray[n3];
                if (row.length > n) {
                    n = row.length;
                }
                ++n3;
            }
            this.mx = new double[matrix.length][n];
            int i = 0;
            while (i < this.mx.length) {
                int j = 0;
                while (j < n) {
                    this.mx[i][j] = j < this.mx[i].length ? matrix[i][j] : 0.0;
                    if (Double.isNaN(this.mx[i][j])) {
                        lisNaN = true;
                    }
                    if (Double.isInfinite(this.mx[i][j])) {
                        lisInfinite = true;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.mx = new double[0][0];
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public Matrix(Double[][] matrix) {
        boolean lisNaN = false;
        boolean lisInfinite = false;
        if (matrix.length > 0) {
            int n = matrix[0].length;
            Double[][] doubleArray = matrix;
            int n2 = matrix.length;
            int n3 = 0;
            while (n3 < n2) {
                Double[] row = doubleArray[n3];
                if (row.length > n) {
                    n = row.length;
                }
                ++n3;
            }
            this.mx = new double[matrix.length][n];
            int i = 0;
            while (i < this.mx.length) {
                int j = 0;
                while (j < n) {
                    this.mx[i][j] = j < this.mx[i].length ? matrix[i][j] : 0.0;
                    if (Double.isNaN(this.mx[i][j])) {
                        lisNaN = true;
                    }
                    if (Double.isInfinite(this.mx[i][j])) {
                        lisInfinite = true;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.mx = new double[0][0];
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public Matrix(List<Vector> vector) {
        boolean lisNaN = false;
        boolean lisInfinite = false;
        if (vector.size() > 0) {
            int n = 0;
            for (Vector v : vector) {
                if (v.length() <= n) continue;
                n = v.length();
            }
            this.mx = new double[vector.size()][n];
            int i = 0;
            while (i < this.mx.length) {
                int j = 0;
                while (j < n) {
                    this.mx[i][j] = vector.get(i).get(j);
                    if (Double.isNaN(this.mx[i][j])) {
                        lisNaN = true;
                    }
                    if (Double.isInfinite(this.mx[i][j])) {
                        lisInfinite = true;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.mx = new double[0][0];
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public Matrix(Vector vector) {
        this.isNaN = vector.isNaN();
        this.isInfinite = vector.isInfinite();
        if (vector.isColumnVector()) {
            this.mx = new double[vector.length()][1];
            int i = 0;
            while (i < vector.length()) {
                this.mx[i][0] = vector.get(i);
                ++i;
            }
        } else {
            this.mx = new double[1][vector.length()];
            int i = 0;
            while (i < vector.length()) {
                this.mx[0][i] = vector.get(i);
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMatrix(String value) {
        String[] vv = value.split("[;]");
        if (vv.length == 0) {
            return false;
        }
        try {
            String[] stringArray = vv;
            int n = vv.length;
            int n2 = 0;
            block2: while (true) {
                if (n2 >= n) {
                    return true;
                }
                String ss = stringArray[n2];
                String[] v = ss.split("[, ]+");
                if (v.length == 0) {
                    return false;
                }
                String[] stringArray2 = v;
                int n3 = v.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        ++n2;
                        continue block2;
                    }
                    String s = stringArray2[n4];
                    double a = StringUtil.parseDoubleEE(s);
                    if (Double.isNaN(a)) return false;
                    if (Double.isInfinite(a)) {
                        return false;
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private int countElements(String s) {
        int n = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ',') {
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            return s.trim().split("[, ]+").length;
        }
        return n + 1;
    }

    public Matrix(String value) {
        boolean lisNaN = false;
        boolean lisInfinite = false;
        if (value.trim().length() > 0) {
            String[] vv = value.split("[;]");
            int n = 0;
            String[] stringArray = vv;
            int n2 = vv.length;
            int n3 = 0;
            while (n3 < n2) {
                String ss = stringArray[n3];
                n = Math.max(n, this.countElements(ss));
                ++n3;
            }
            this.mx = new double[vv.length][n];
            int i = 0;
            while (i < vv.length) {
                String[] v = vv[i].trim().split("[, ]+");
                int j = 0;
                while (j < n) {
                    if (j < v.length) {
                        String s = v[j].trim();
                        this.mx[i][j] = StringUtil.parseDoubleEE(s);
                        if (Double.isNaN(this.mx[i][j])) {
                            lisNaN = true;
                        }
                        if (Double.isInfinite(this.mx[i][j])) {
                            lisInfinite = true;
                        }
                    } else {
                        this.mx[i][j] = 0.0;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.mx = new double[0][0];
        }
        this.isNaN = lisNaN;
        this.isInfinite = lisInfinite;
    }

    public boolean isSingle() {
        return this.rows() == 1 && this.columns() == 1;
    }

    public double get(int row, int column) {
        if (row < 0 || row >= this.mx.length) {
            return 0.0;
        }
        if (column < 0 || column >= this.mx[row].length) {
            return 0.0;
        }
        return this.mx[row][column];
    }

    public double[] getRow(int row) {
        double[] r = new double[this.mx.length];
        int column = 0;
        while (column < this.mx[row].length) {
            r[column] = this.mx[row][column];
            ++column;
        }
        return this.mx[row];
    }

    public double[] getColumn(int column) {
        int n = this.mx[0].length;
        double[] col = new double[n];
        int row = 0;
        while (row < n) {
            col[row] = this.mx[row][column];
            ++row;
        }
        return col;
    }

    public boolean isZero() {
        double[][] dArray = this.mx;
        int n = this.mx.length;
        int n2 = 0;
        while (n2 < n) {
            double[] aa;
            double[] dArray2 = aa = dArray[n2];
            int n3 = aa.length;
            int n4 = 0;
            while (n4 < n3) {
                double a = dArray2[n4];
                if (a != 0.0) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public boolean isNaN() {
        return this.isNaN;
    }

    public double[][] getMatrix() {
        return this.mx;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    public boolean equals(Matrix m) {
        if (m.mx.length != this.mx.length) {
            return false;
        }
        int i = 0;
        while (i < this.mx.length) {
            if (m.mx[i].length != this.mx[i].length) {
                return false;
            }
            int j = 0;
            while (j < this.mx[i].length) {
                if (m.mx[i][j] != this.mx[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object v) {
        if (this == v) {
            return true;
        }
        if (v instanceof Matrix) {
            return this.equals((Matrix)v);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean mark = false;
        double[][] dArray = this.mx;
        int n = this.mx.length;
        int n2 = 0;
        while (n2 < n) {
            double[] vv = dArray[n2];
            if (mark) {
                sb.append("; ");
                mark = false;
            }
            double[] dArray2 = vv;
            int n3 = vv.length;
            int n4 = 0;
            while (n4 < n3) {
                double v = dArray2[n4];
                if (mark) {
                    sb.append(", ");
                }
                sb.append(v);
                mark = true;
                ++n4;
            }
            ++n2;
        }
        return sb.toString();
    }

    public int rows() {
        return this.mx.length;
    }

    public int columns() {
        return this.mx.length == 0 ? 0 : this.mx[0].length;
    }

    public Matrix neg() {
        double[][] v = new double[this.rows()][this.columns()];
        int i = 0;
        while (i < this.rows()) {
            int j = 0;
            while (j < this.columns()) {
                v[i][j] = -this.mx[i][j];
                ++j;
            }
            ++i;
        }
        return new Matrix(0, v);
    }

    public Matrix abs() {
        double[][] v = new double[this.rows()][this.columns()];
        int i = 0;
        while (i < this.rows()) {
            int j = 0;
            while (j < this.columns()) {
                v[i][j] = Math.abs(this.mx[i][j]);
                ++j;
            }
            ++i;
        }
        return new Matrix(0, v);
    }

    private double[][] minorOfMatrix(double[][] mat, int row, int column) {
        int rowsz = row >= 0 && row < mat.length ? mat.length - 1 : mat.length;
        int colsz = column >= 0 && column < mat[0].length ? mat[0].length - 1 : mat[0].length;
        double[][] minor = new double[rowsz][colsz];
        int i = 0;
        int j = 0;
        int r = 0;
        while (r < mat.length) {
            int c = 0;
            while (c < mat[0].length) {
                if (r != row && c != column) {
                    minor[i][j++] = mat[r][c];
                    if (j == colsz) {
                        j = 0;
                        ++i;
                    }
                }
                ++c;
            }
            ++r;
        }
        return minor;
    }

    private double determinantOfMatrix(double[][] mat) {
        int D = 0;
        if (mat.length == 1) {
            return mat[0][0];
        }
        int sign = 1;
        int f = 0;
        while (f < mat.length) {
            D = (int)((double)D + (double)sign * mat[0][f] * this.determinantOfMatrix(this.minorOfMatrix(mat, 0, f)));
            sign = -sign;
            ++f;
        }
        return D;
    }

    private double[][] adjointOfMatrix(double[][] matrix) {
        if (matrix.length == 0 || matrix[0].length == 0) {
            return new double[0][0];
        }
        double[][] adj = new double[matrix.length][matrix.length];
        if (matrix.length == 1) {
            adj[0][0] = 1.0;
            return adj;
        }
        int sign = 1;
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix.length) {
                double[][] cofactor = this.minorOfMatrix(matrix, i, j);
                sign = (i + j) % 2 == 0 ? 1 : -1;
                adj[j][i] = (double)sign * this.determinantOfMatrix(cofactor);
                ++j;
            }
            ++i;
        }
        return adj;
    }

    double[][] inverseOfMatrix(double[][] matrix) {
        if (matrix.length == 0 || matrix[0].length == 0) {
            return new double[0][0];
        }
        double det = this.determinantOfMatrix(matrix);
        if (det == 0.0) {
            throw new DeterminantZeroException("inverse");
        }
        double[][] adj = this.adjointOfMatrix(matrix);
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix.length) {
                adj[i][j] = adj[i][j] / (double)((float)det);
                ++j;
            }
            ++i;
        }
        return adj;
    }

    double[][] transposeOfMatrix(double[][] matrix) {
        if (matrix.length == 0 || matrix[0].length == 0) {
            return new double[0][0];
        }
        double[][] t = new double[matrix[0].length][matrix.length];
        int i = 0;
        while (i < matrix[0].length) {
            int j = 0;
            while (j < matrix.length) {
                t[i][j] = matrix[j][i];
                ++j;
            }
            ++i;
        }
        return t;
    }

    void swap(double[][] matrix, int row1, int row2, int col) {
        if (matrix == this.mx) {
            throw new RuntimeException("Function called with immuteable matrix");
        }
        int i = 0;
        while (i < col) {
            double temp = matrix[row1][i];
            matrix[row1][i] = matrix[row2][i];
            matrix[row2][i] = temp;
            ++i;
        }
    }

    double[][] duplicate(double[][] matrix) {
        if (matrix.length == 0 || matrix[0].length == 0) {
            return new double[0][0];
        }
        double[][] m = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                m[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return m;
    }

    int rankOfMatrix(double[][] matrix) {
        if (matrix.length == 0 || matrix[0].length == 0) {
            return 0;
        }
        int rank = Math.min(matrix.length, matrix[0].length);
        int row = 0;
        while (row < rank) {
            if (matrix[row][row] != 0.0) {
                int col = 0;
                while (col < matrix.length) {
                    if (col != row) {
                        double mult = matrix[col][row] / matrix[row][row];
                        int i = 0;
                        while (i < matrix[0].length) {
                            double[] dArray = matrix[col];
                            int n = i;
                            dArray[n] = dArray[n] - mult * matrix[row][i];
                            ++i;
                        }
                    }
                    ++col;
                }
            } else {
                boolean reduce = true;
                int i = row + 1;
                while (i < matrix.length) {
                    if (matrix[i][row] != 0.0) {
                        if (matrix == this.mx) {
                            matrix = this.duplicate(matrix);
                        }
                        this.swap(matrix, row, i, rank);
                        reduce = false;
                        break;
                    }
                    ++i;
                }
                if (reduce) {
                    --rank;
                    i = 0;
                    while (i < matrix.length) {
                        matrix[i][row] = matrix[i][rank];
                        ++i;
                    }
                }
                --row;
            }
            ++row;
        }
        return rank;
    }

    double[][] cofactorMatrix(double[][] matrix) {
        if (matrix.length == 0 || matrix[0].length == 0) {
            return new double[0][0];
        }
        double sign = 1.0;
        double[][] v = new double[matrix.length][matrix[0].length];
        int r = 0;
        while (r < matrix.length) {
            int c = 0;
            while (c < matrix[0].length) {
                v[r][c] = sign * this.determinantOfMatrix(this.minorOfMatrix(this.mx, r, c));
                sign = -sign;
                ++c;
            }
            ++r;
        }
        return v;
    }

    public Matrix adjoint() {
        if (this.rows() != this.columns()) {
            throw new DimensionsException("adjoint", this.mx);
        }
        return new Matrix(0, this.adjointOfMatrix(this.mx));
    }

    public Matrix inverse() {
        if (this.rows() != this.columns()) {
            throw new DimensionsException("inverse", this.mx);
        }
        return new Matrix(0, this.inverseOfMatrix(this.mx));
    }

    public double determinant() {
        if (this.rows() != this.columns()) {
            throw new DimensionsException("determinant", this.mx);
        }
        return this.determinantOfMatrix(this.mx);
    }

    public double[][] transpose() {
        return this.transposeOfMatrix(this.mx);
    }

    public double[][] minor(int row, int column) {
        return this.minorOfMatrix(this.mx, row, column);
    }

    public double[][] cofactors() {
        return this.cofactorMatrix(this.mx);
    }

    public int rank() {
        return this.rankOfMatrix(this.mx);
    }

    public Matrix power1(int n) {
        if (n == 1) {
            return this;
        }
        Matrix m = this.mult(this);
        int mn = 2;
        while (mn < n) {
            if (mn <= n / 2) {
                m = m.mult(m);
                mn += mn;
                continue;
            }
            m = this.mult(m);
            ++mn;
        }
        return m;
    }

    public static double[][] idMatrix(int size) {
        double[][] matrix = new double[size][size];
        int r = 0;
        while (r < matrix.length) {
            int c = 0;
            while (c < matrix[0].length) {
                matrix[r][c] = r == c ? 1 : 0;
                ++c;
            }
            ++r;
        }
        return matrix;
    }

    public static double[][] randomMatrix(int rows, int columns, double min, double max) {
        double[][] matrix = new double[rows][columns];
        int r = 0;
        while (r < matrix.length) {
            int c = 0;
            while (c < matrix[0].length) {
                matrix[r][c] = Math.random() * (max - min) + min;
                ++c;
            }
            ++r;
        }
        return matrix;
    }

    public static double[][] randomMatrix(int rows, int columns, long min, long max) {
        double[][] matrix = new double[rows][columns];
        int r = 0;
        while (r < matrix.length) {
            int c = 0;
            while (c < matrix[0].length) {
                matrix[r][c] = Math.rint(Math.random() * (double)(max - min) + (double)min);
                ++c;
            }
            ++r;
        }
        return matrix;
    }

    public Matrix power(int n) {
        if (n == 1) {
            return this;
        }
        Matrix fac = this;
        Matrix result = null;
        int bitmask = 1;
        while (bitmask <= n) {
            if ((bitmask & n) != 0) {
                result = result == null ? fac : result.mult(fac);
            }
            bitmask <<= 1;
            fac = fac.mult(fac);
        }
        return result;
    }

    public Matrix add(Matrix value) {
        int r = Math.max(this.rows(), value.rows());
        int c = Math.max(this.columns(), value.columns());
        double[][] v = new double[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                v[i][j] = this.get(i, j) + value.get(i, j);
                ++j;
            }
            ++i;
        }
        return new Matrix(0, v);
    }

    public Matrix add(double value) {
        double[][] v = new double[this.rows()][this.columns()];
        int i = 0;
        while (i < this.rows()) {
            int j = 0;
            while (j < this.columns()) {
                v[i][j] = this.mx[i][j] + value;
                ++j;
            }
            ++i;
        }
        return new Matrix(0, v);
    }

    public Matrix sub(Matrix value) {
        int r = Math.max(this.rows(), value.rows());
        int c = Math.max(this.columns(), value.columns());
        double[][] v = new double[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                v[i][j] = this.get(i, j) - value.get(i, j);
                ++j;
            }
            ++i;
        }
        return new Matrix(0, v);
    }

    public Matrix sub(double v) {
        return this.add(-v);
    }

    public double dot(Matrix value) {
        return 0.0;
    }

    public Vector multC(Vector value) {
        if (!value.isColumnVector()) {
            throw new Vector.OrientationException("matrix*vector");
        }
        double[] vv = new double[this.rows()];
        int n = Math.max(this.columns(), value.length());
        int i = 0;
        while (i < vv.length) {
            vv[i] = 0.0;
            int j = 0;
            while (j < n) {
                int n2 = i;
                vv[n2] = vv[n2] + this.get(i, j) * value.get(j);
                ++j;
            }
            ++i;
        }
        return new Vector(true, vv);
    }

    public Matrix multR(Vector value) {
        if (value.isColumnVector()) {
            throw new Vector.OrientationException("matrix*vector");
        }
        double[][] vv = new double[this.rows()][value.length()];
        int k = 0;
        while (k < value.length()) {
            int i = 0;
            while (i < vv.length) {
                vv[i][k] = this.get(i, 1) * value.get(k);
                ++i;
            }
            ++k;
        }
        return new Matrix(0, vv);
    }

    public Matrix mult(Matrix value) {
        double[][] vv = new double[this.rows()][value.columns()];
        int k = 0;
        while (k < value.columns()) {
            int i = 0;
            while (i < vv.length) {
                vv[i][k] = 0.0;
                int j = 0;
                while (j < value.rows()) {
                    double[] dArray = vv[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.get(i, j) * value.get(j, k);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return new Matrix(0, vv);
    }

    public Matrix mult(double value) {
        double[][] v = new double[this.rows()][this.columns()];
        int i = 0;
        while (i < this.rows()) {
            int j = 0;
            while (j < this.columns()) {
                v[i][j] = this.mx[i][j] * value;
                ++j;
            }
            ++i;
        }
        return new Matrix(0, v);
    }

    public Matrix div(double v) {
        return this.mult(1.0 / v);
    }

    public static class DeterminantZeroException
    extends RuntimeException {
        DeterminantZeroException(String msg) {
            super("Determinant is zero, cannot do " + msg);
        }
    }

    public static class DimensionsException
    extends RuntimeException {
        DimensionsException(String msg, double[][] mx) {
            super("Invalid matrix dimensions [" + mx.length + "," + (mx.length == 0 ? 0 : mx[0].length) + "] for " + msg);
        }

        DimensionsException(String msg, double[][] mx, double[][] my) {
            super("Invalid matrix dimensions [" + mx.length + "," + (mx.length == 0 ? 0 : mx[0].length) + "] and [" + my.length + "," + (my.length == 0 ? 0 : my[0].length) + "] for " + msg);
        }
    }
}

