/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.util.Arrays;

public class MathUtil {
    static long[] primes = new long[]{2L, 3L};

    public static double stddev(double[] values) {
        double avg = 0.0;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        avg /= (double)values.length;
        double var = 0.0;
        int i2 = 0;
        while (i2 < values.length) {
            double v = values[i2] - avg;
            var += v * v;
            ++i2;
        }
        return values.length > 1 ? Math.sqrt(var / (double)(values.length - 1)) : 0.0;
    }

    public static double slope(double[] values) {
        double sumx = 0.0;
        double sumy = 0.0;
        double sumxx = 0.0;
        double sumxy = 0.0;
        int n = 0;
        int i = 0;
        while (i < values.length) {
            if (!Double.isNaN(values[i])) {
                sumy += values[i];
                sumx += (double)i;
                sumxx += (double)(i * i);
                sumxy += (double)i * values[i];
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            return Double.NaN;
        }
        double b = ((double)n * sumxy - sumy * sumx) / ((double)n * sumxx - sumx * sumx);
        return b;
    }

    public static double slope(double[] time, double[] values) {
        if (time.length != values.length) {
            return 0.0;
        }
        double sumx = 0.0;
        double sumy = 0.0;
        double sumxx = 0.0;
        double sumxy = 0.0;
        double t0 = time[values.length - 1];
        int n = 0;
        int i = 0;
        while (i < values.length) {
            if (!Double.isNaN(values[i])) {
                sumy += values[i];
                sumx += time[i] - t0;
                sumxx += (time[i] - t0) * (time[i] - t0);
                sumxy += (time[i] - t0) * values[i];
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            return Double.NaN;
        }
        double b = ((double)n * sumxy - sumy * sumx) / ((double)n * sumxx - sumx * sumx);
        return b;
    }

    /*
     * Unable to fully structure code
     */
    public static double interpolateLinear(double value, int valueColumn, int targetColumn, float[][] table) {
        block10: {
            l = 0;
            r = table.length - 1;
            row = 0;
            if (!(table[0][valueColumn] > table[table.length - 1][valueColumn])) ** GOTO lbl28
            while (l < r) {
                row = (l + r) / 2;
                valueEntry = table[row][valueColumn];
                if (valueEntry > value) {
                    l = row + 1;
                    continue;
                }
                if (!(valueEntry < value)) break;
                r = row - 1;
            }
            while (row < table.length - 2 && (double)table[row + 1][valueColumn] > value) {
                ++row;
            }
            while (row > 0 && (double)table[row][valueColumn] < value) {
                --row;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                row = (l + r) / 2;
                valueEntry = table[row][valueColumn];
                if (valueEntry < value) {
                    l = row + 1;
                    continue;
                }
                if (!(valueEntry > value)) break;
                r = row - 1;
lbl28:
                // 3 sources

                ** while (l < r)
            }
lbl29:
            // 3 sources

            while (row < table.length - 2 && (double)table[row + 1][valueColumn] < value) {
                ++row;
            }
            while (row > 0 && (double)table[row][valueColumn] > value) {
                --row;
            }
        }
        f = 0.0;
        if (row < table.length - 1) {
            dv = table[row + 1][valueColumn] - table[row][valueColumn];
            dt = table[row + 1][targetColumn] - table[row][targetColumn];
            f = dt * (value - (double)table[row][valueColumn]) / dv;
        } else {
            dv = table[row][valueColumn] - table[row - 1][valueColumn];
            dt = table[row][targetColumn] - table[row - 1][targetColumn];
            f = dt * (value - (double)table[row][valueColumn]) / dv;
        }
        return (double)table[row][targetColumn] + f;
    }

    static void findPrimes(long max) {
        if (primes != null && primes[primes.length - 1] > max) {
            return;
        }
        long v = primes[primes.length - 1] + 2L;
        int n = primes.length;
        while (v <= max) {
            long vv = (int)Math.sqrt(v);
            boolean found = true;
            int i = 0;
            while (primes[i] <= vv && primes[i] != 0L) {
                if (v % primes[i] == 0L) {
                    found = false;
                    break;
                }
                ++i;
            }
            if (found) {
                if (primes.length == n) {
                    primes = Arrays.copyOf(primes, n + 100);
                }
                MathUtil.primes[n] = v;
                ++n;
            }
            v += 2L;
        }
        if (primes.length != n) {
            primes = Arrays.copyOf(primes, n);
        }
    }

    public static long[] primes(long limit) {
        MathUtil.findPrimes(limit);
        int i = 0;
        while (i < primes.length) {
            if (primes[i] > limit) {
                return Arrays.copyOf(primes, i);
            }
            ++i;
        }
        return primes;
    }

    /*
     * Unable to fully structure code
     */
    public static long[] factor(long number) {
        MathUtil.findPrimes(number);
        v = new long[100];
        i = 0;
        n = 0;
        ** GOTO lbl13
        {
            number /= MathUtil.primes[i];
            if (n == v.length) {
                v = Arrays.copyOf(v, v.length + 100);
            }
            v[n++] = MathUtil.primes[i];
            do {
                if (number % MathUtil.primes[i] == 0L) continue block0;
                ++i;
lbl13:
                // 2 sources

            } while (number > 1L && i < MathUtil.primes.length && MathUtil.primes[i] < number);
        }
        if (number != 1L) {
            if (n == v.length) {
                v = Arrays.copyOf(v, v.length + 100);
            }
            v[n++] = number;
        }
        return Arrays.copyOf(v, n);
    }

    private static long internal_gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        if (a == 0L) {
            return b;
        }
        return a > b ? MathUtil.internal_gcd(a - b, b) : MathUtil.internal_gcd(a, b - a);
    }

    public static long gcd(long a, long b) {
        return MathUtil.internal_gcd(Math.abs(a), Math.abs(b));
    }

    public static long lcm(long a, long b) {
        a = Math.abs(a);
        b = Math.abs(b);
        return a * b / MathUtil.internal_gcd(a, b);
    }

    public static long gcdxxx(long[] v) {
        long max = 0L;
        long[][] fac = new long[v.length][0];
        int i = 0;
        while (i < v.length) {
            fac[i] = MathUtil.factor(v[i]);
            max = Math.max(max, fac[i][fac[i].length - 1]);
            ++i;
        }
        long gcd = 1L;
        int i2 = 0;
        while (i2 < primes.length && primes[i2] <= max) {
            boolean common = true;
            int j = 0;
            while (j < fac.length) {
                boolean found = false;
                int k = 0;
                while (k < fac[j].length) {
                    if (fac[j][k] == primes[i2]) {
                        found = true;
                        fac[j][k] = 0L;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    common = false;
                }
                ++j;
            }
            if (common) {
                gcd *= primes[i2];
                --i2;
            }
            ++i2;
        }
        return gcd;
    }

    public static long gcd(long[] v) {
        long max = 0L;
        int i = 0;
        while (i < v.length) {
            max = Math.max(max, v[i]);
            ++i;
        }
        MathUtil.findPrimes(max);
        long gcd = 1L;
        int i2 = 0;
        while (i2 < primes.length && primes[i2] <= max) {
            boolean div = true;
            int j = 0;
            while (j < v.length) {
                if (v[j] % primes[i2] != 0L) {
                    div = false;
                    break;
                }
                ++j;
            }
            if (div) {
                gcd *= primes[i2];
                j = 0;
                while (j < v.length) {
                    int n = j++;
                    v[n] = v[n] / primes[i2];
                }
                --i2;
            }
            ++i2;
        }
        return gcd;
    }

    public static long lcm(long[] v) {
        long max = 0L;
        int i = 0;
        while (i < v.length) {
            max = Math.max(max, v[i]);
            ++i;
        }
        MathUtil.findPrimes(max);
        long lcm = 1L;
        int i2 = 0;
        while (i2 < primes.length && primes[i2] <= max) {
            int nn = 0;
            int j = 0;
            while (j < v.length) {
                int n = 0;
                while (v[j] % primes[i2] == 0L) {
                    ++n;
                    int n2 = j;
                    v[n2] = v[n2] / primes[i2];
                }
                nn = Math.max(nn, n);
                ++j;
            }
            while (nn > 0) {
                lcm *= primes[i2];
                --nn;
            }
            ++i2;
        }
        return lcm;
    }

    public static long[] toFraction(double d, long maxDenominator) {
        double minn = 0.0;
        double mind = 1.0;
        double maxn = 1.0;
        double maxd = 1.0;
        long[] r = new long[3];
        boolean s = d < 0.0;
        d = Math.abs(d);
        double f = Math.pow(10.0, (int)Math.floor(Math.log10(d) - 14.0));
        r[0] = (long)Math.floor(d);
        if ((d -= (double)r[0]) > 0.0) {
            double cenn = minn + maxn;
            double cend = mind + maxd;
            while (cend < (double)maxDenominator) {
                r[1] = (long)cenn;
                r[2] = (long)cend;
                if (d > cenn / cend + f) {
                    minn = cenn;
                    mind = cend;
                } else {
                    if (!(d < cenn / cend - f)) break;
                    maxn = cenn;
                    maxd = cend;
                }
                cenn = minn + maxn;
                cend = mind + maxd;
            }
        } else {
            r[1] = 0L;
            r[2] = 1L;
        }
        if (s) {
            r[0] = -r[0];
            r[1] = -r[1];
        }
        return r;
    }

    public static int[] toInchFraction(double d) {
        int[] r = new int[3];
        boolean s = d < 0.0;
        d = Math.abs(d);
        r[0] = (int)Math.floor(d);
        d -= (double)r[0];
        double dd = Double.MAX_VALUE;
        int n = -1;
        int i = 0;
        while (i < 65) {
            double t = Math.abs(d - (double)i / 64.0);
            if (t < dd) {
                dd = t;
                n = i;
            }
            ++i;
        }
        if (n == 64) {
            r[0] = r[0] + 1;
            n = 0;
        }
        int nn = 64;
        while (n != 0 && n % 2 == 0) {
            nn /= 2;
            n /= 2;
        }
        r[1] = n;
        r[2] = nn;
        if (s) {
            r[0] = -r[0];
            r[1] = -r[1];
        }
        return r;
    }

    public static double roundDigits(double basis, double value, int digits) {
        double v = Math.pow(10.0, (int)Math.log10(basis) - digits + 1);
        return Math.rint(value / v) * v;
    }

    public static double roundDigits(double value, int digits) {
        double v = Math.pow(10.0, (int)Math.log10(value) - digits + 1);
        return Math.rint(value / v) * v;
    }
}

