/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;

public class LogToWebserver {
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final String POST_URL = "https://lygte-info.dk/UsageLog.php";
    private String charset = "ASCII";
    private String data;
    private long shortWaitTime = 1000L;
    private long longWaitTime = 300000L;

    private static long makeCheck(long uid) {
        int u1 = (int)(uid & 0x7FFFL);
        int u2 = (int)(uid >> 15 & 0x7FFFL);
        int u3 = (int)(uid >> 30 & 0x7FFFL);
        return u1 ^ u2 ^ u3 ^ 0x3C41;
    }

    private static long getCheck(long uid) {
        return uid >> 45 & 0xFFFFL;
    }

    public LogToWebserver(String id, long uid, String version, String data) {
        this.data = this.buildMessage(id, uid, version, data);
    }

    public static long makeUid() {
        long uid = new Random().nextLong();
        uid = uid & 0x1FFFFFFFFFFFL | LogToWebserver.makeCheck(uid) << 45;
        return uid;
    }

    public static boolean uidValid(long uid) {
        return uid != 0L && LogToWebserver.getCheck(uid) == LogToWebserver.makeCheck(uid);
    }

    public boolean post() {
        try {
            return this.sendPOST(this.data);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean postWithRetryFast(int n) {
        while (n > 0) {
            --n;
            if (this.post()) {
                return true;
            }
            try {
                Thread.sleep(this.shortWaitTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean postWithRetrySlow(int n) {
        while (n > 0) {
            --n;
            if (this.postWithRetryFast(2)) {
                return true;
            }
            try {
                Thread.sleep(this.longWaitTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void postAsync(final int n) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LogToWebserver.this.postWithRetrySlow(n);
            }
        };
        new Thread(r).start();
    }

    private boolean sendPOST(String data) throws IOException {
        BufferedReader in;
        URL obj = new URL(POST_URL);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Accept-Charset", this.charset);
        con.setRequestProperty("Content-Type", "text/plain;charset=" + this.charset);
        con.setRequestProperty("User-Agent", USER_AGENT);
        con.setDoOutput(true);
        OutputStream os = con.getOutputStream();
        os.write(data.getBytes(this.charset));
        os.flush();
        os.close();
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        } else {
            return false;
        }
        in.close();
        return true;
    }

    private String buildMessage(String id, long uid, String version, String data) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(id) + "|");
        SimpleDateFormat sd = new SimpleDateFormat("dd/MM-yyyy HH:mm:ss");
        sb.append(sd.format(new Date()));
        TimeZone tz = TimeZone.getDefault();
        sb.append(tz.useDaylightTime() ? " S" : " ");
        sb.append(tz.getRawOffset() > 0 ? "+" : "");
        sb.append(tz.getRawOffset() / 60000);
        sb.append('|');
        sb.append(String.valueOf(Locale.getDefault().getISO3Country()) + "/" + Locale.getDefault().getISO3Language());
        sb.append('|');
        sb.append(System.getProperty("os.name"));
        sb.append('|');
        sb.append(uid);
        sb.append('|');
        sb.append(version);
        sb.append('|');
        sb.append(data);
        return sb.toString();
    }
}

