/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import dk.hkj.color.ColorUtil;
import dk.hkj.util.FileUtil;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class InputPopup {
    private static Font textFont = null;
    private static Font labelFont = null;
    private static Image windowIcon = null;
    JDialog dialog = null;
    static JDialog progressDialog = null;
    static JProgressBar progressBar = null;
    static Timer progressTimer = null;
    private String title = "";
    private List<Item> items = null;
    private BlockingQueue<String> done = null;
    private boolean useSI = true;
    private Color errorBackground = ColorUtil.blend(Color.white, Color.red, 0.5);
    private Color normalBackground = Color.white;
    private Var varBase = null;
    static int showQuestionAnswer = 0;

    public static void setFont(Font labelFont, Font textFont) {
        InputPopup.labelFont = labelFont;
        InputPopup.textFont = textFont;
    }

    public static void setIcon(Image icon) {
        windowIcon = icon;
    }

    private static String getData(IconType iconType) {
        switch (iconType) {
            case FileLoad: {
                return "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAFKSURBVDhPhZK/SsNQFMZPagIFg+hQCFQhSJWMjhk6ODi4CA4uDkIfoQXBR3BwyAM4OOogOLg4uDnoG1SnOggpdCmkomDh+J1wWhObm3zkd+/5c++Xm0ssZiajLMvH2AFNYEsJkpqoDqYkBkaIdgAiI4OqE6xi7IIh+AZyijPQAqIxbArebILoUt8c61ywyATRuW5KQFtjPNuYK+g2IgTphh+wr4YjqdX0W4w6Sm4pGvU0oxPYPGg8kaHUYO/zka7j4zTuNSI5w02a5FRwZCHceObEcpEQX6ydprX5fQhEIdgtNAj8PsdLHhLiq5XOvJ4zUBYMvM2YB7YvLb5bPmR7C/emvezGGTkDt5Vw3wmkzE/1dppn+9mNM3KXGH690Pr0g16dgA6a9zSpudoxy0rdMxKTd8enoe1p5U/8hvX/tGBQpiKDyh+pXES/IUVdcw4fQnEAAAAASUVORK5CYII=";
            }
            case FileSave: {
                return "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAADTSURBVDhP7ZAxCsJAEEV/dIUtPEAKwbWRFB7AIoUewgN4Mg/gJYR4Awtjk6QQSW8TUFhnlg1Jlo3B3g9vyczO/xkWWuvfAaZEQjz9AwywJjaEdPq1mSpcmwsXILdDqtXrmImwMbi4AR4z97umNu2AHjMDLOn0kAv6MRlW84tOZGy+XTMzooivOj52iKsz0knE5ZZcpbmwGgyIXinKcYh9eOBSIgiURXIjMCt7lGcLqHdhK694m1PvBncxQyFUBxIn1lTc6N3AJ32jeUeDbzCkfwDwAWMnA4chTpZCAAAAAElFTkSuQmCC";
            }
            case ColorWheel: {
                return "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsIAAA7CARUoSoAAAAL8SURBVDhPNVNZSJRhFD33+2ccW2ZMR5E2yzStJgNpoSLKrJ7qIaq31ocKeupJqYceeu21hxYoIcgHW2ghkKAioj1osc3ENEyszHGZZvFfvtv5gwbO3P+/9zvnnrn3G1HVBIA4MaYaNLx4nn9645xg7L5BclCwkIX62cC8JosZhw1ia2IQgxUC+cBSDBSYaa09lcm67oGjE16syNVasbpdAj0Bq+3EK+IHc7mIp7l9OfUnXGtVW8mNhwJbxgtuuvlkVmVdoCZpNUnyZhKOs3qF5PfEKBEQVjzNN6XVy7ik6jbDr6vHHnulD2wxUCPQ+YpMTDBKfy7hENOIKYQggGgORQ/H4bX0U05vm66sn7joRoEFAtQpkBL4c4BfJBRgQVkOSMAT/PyBYghG+xG98Bb+u2GYSwWFW80+iwBdxjPLKbIaGC6zdGEwnbrTxLL9OGX6iI8U+Qjjf4K2PYI0Zif1jR+hXwNkeW7EQrsZbwFrrgHnfWCxpiHymh1IlgHGEcYMvFQJpML19XeEZGUrq5CALgrEgEXlKR9d7Z9RajvYuYvJnzz3h+o5Pnvw4lxp0s/piONwOLRJc2EByBPDqPTb8LnzLKZ3uDC9VE6zSVgKp+sp/GJOJ+UP6wfHZYdJ0rOMaVZ7GR9gNZd4WV3M+8bUE6KHDYYYwxVlqJGoh1mneU51kBvvpYHQ5jPiHqfeiWq2SvPXBVVMbSR5Ax1wwNLI9wYD3boeZj+3bLSPmS/s2k0Xb4iXKMcIyjn9LN/yDsnlJC5iXMqjS9irjpe5eS/MKqf0yM4gyoWFPnv+iUTxHTM5k6nM5MnhcmCjvGSlfJhLcjVdrdyByOy1ewwd3j/tbMZSP6AInegAL04BSbot4mYm/89NqFTEl4TAzkrBSZ2GEfPViEi8wsQPdppWNHlzEcE4ylSRIDlKP+Fuwq265AdCF8WbIGV3YSLlLUyPhn/n8JaGbmtc686/6V+/dkfOwDGvUGsKqKNIjRajCivp7BCiZtduWgknPQmg5C/LHG4EDPvJLQAAAABJRU5ErkJggg==";
            }
        }
        return null;
    }

    public static BufferedImage makeImage(IconType iconType) {
        BufferedImage image = null;
        try {
            byte[] imageByte = Base64.getDecoder().decode(InputPopup.getData(iconType));
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            image = ImageIO.read(bis);
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return image;
    }

    public static ImageIcon makeIcon(IconType iconType) {
        return new ImageIcon(InputPopup.makeImage(iconType));
    }

    public InputPopup(Var varBase, String title) {
        this.title = title;
        if (varBase == null) {
            varBase = Var.gl;
        }
        this.varBase = varBase;
        this.items = new ArrayList<Item>();
        this.done = new ArrayBlockingQueue<String>(3);
    }

    public void addNumberInput(String message, String varName, double min, double max, String tip) {
        this.items.add(new NumberItem(message, varName, min, max, tip));
    }

    public void addTextInput(String message, String varName, int maxLength, String tip) {
        this.items.add(new TextItem(message, varName, maxLength, tip));
    }

    public void addFilenameInput(String message, String varName, String tip) {
        this.items.add(new FilenameItem(message, varName, tip));
    }

    public void addNumberIntInput(String message, String varName, long min, long max, String tip) {
        this.items.add(new NumberIntItem(message, varName, min, max, tip));
    }

    public void addNumberListInput(String message, String varName, double min, double max, String tip) {
        this.items.add(new NumberListItem(message, varName, min, max, tip));
    }

    public void addNumberIntListInput(String message, String varName, long min, long max, String tip) {
        this.items.add(new NumberIntListItem(message, varName, min, max, tip));
    }

    public void addComboboxInput(String message, String varName, List<String> selections, String tip) {
        this.items.add(new ComboboxItem(message, varName, selections, tip));
    }

    public void addListInput(String message, String varName, List<String> selections, int lines, String tip) {
        this.items.add(new ListItem(message, varName, selections, lines, tip));
    }

    public void addRadioInput(String message, String varName, List<String> selections, String tip) {
        this.items.add(new RadioItem(message, varName, selections, tip));
    }

    public void addCheckboxInput(String message, String varName, String tip) {
        this.items.add(new CheckboxItem(message, varName, tip));
    }

    public void addLabelInput(String message, String varName, String tip) {
        this.items.add(new LabelItem(message, varName, tip));
    }

    public void addFileInput(String message, String varName, String path, String ext, boolean load, String tip) {
        this.items.add(new FileItem(message, varName, path, ext, load, tip));
    }

    public void addColorInput(String message, String varName, String tip) {
        this.items.add(new ColorItem(message, varName, tip));
    }

    public void addButton(String message, String varName, String tip) {
        this.items.add(new ButtonItem(message, varName, tip));
    }

    public void addButton(String message, String varName, String cancelMessage, String tip) {
        this.items.add(new ButtonItem(message, varName, cancelMessage, tip));
    }

    public void addImage(String message, String varName, List<String> imageList, String tip, ImageViewerCallback ivc) {
        this.items.add(new ImageItem(message, varName, imageList, tip, ivc));
    }

    protected void setEnable() {
        boolean ok = true;
        for (Item item : this.items) {
            if (item.ok) continue;
            ok = false;
        }
        for (Item item : this.items) {
            if (!(item instanceof ButtonItem)) continue;
            ((ButtonItem)item).setEnabled(ok);
        }
    }

    protected void setAllVar() {
        for (Item item : this.items) {
            item.setVar();
        }
    }

    private void showPopup(Window w, int x, int y) {
        JDialog dialog;
        this.dialog = dialog = new JDialog(w, this.title);
        if (w != null) {
            dialog.setIconImages(w.getIconImages());
        }
        if (windowIcon != null) {
            dialog.setIconImage(windowIcon);
        }
        if (labelFont != null) {
            dialog.setFont(labelFont);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        try {
            dialog.add(panel);
            int line = 0;
            boolean buttons = false;
            for (Item item : this.items) {
                item.layout(panel, line);
                if (item instanceof ButtonItem) {
                    buttons = true;
                }
                ++line;
            }
            if (!buttons) {
                Item item;
                item = new ButtonItem("Ok", null, null);
                item.layout(panel, line);
                this.items.add(item);
            }
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    InputPopup.this.done.add("closed");
                }
            });
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.pack();
            if (w == null) {
                dialog.setLocation(x, y);
            } else {
                dialog.setLocation(w.getX() + x, w.getY() + y);
            }
            dialog.setVisible(true);
            this.setEnable();
        }
        catch (Exception e) {
            this.done.add("closed");
            e.printStackTrace(System.out);
        }
    }

    public void show(final Window w, final int x, final int y) {
        this.done.clear();
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopup(w, x, y);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InputPopup.this.showPopup(w, x, y);
                    InputPopup.this.done.add("closed");
                }
            });
            try {
                this.done.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void showInfoPopup(Window w, String message, int icon) {
        int messageType = -1;
        switch (icon) {
            case 0: {
                messageType = -1;
                break;
            }
            case 1: {
                messageType = 1;
                break;
            }
            case 2: {
                messageType = 3;
                break;
            }
            case 3: {
                messageType = 2;
                break;
            }
            case 4: {
                messageType = 0;
            }
        }
        JOptionPane.showMessageDialog(w, message, "Info", messageType);
    }

    private static void showInfoPopupAsync(Window w, String message, int icon, int timeout) {
        Icon ic = null;
        switch (icon) {
            case 0: {
                break;
            }
            case 1: {
                ic = UIManager.getIcon("OptionPane.informationIcon");
                break;
            }
            case 2: {
                ic = UIManager.getIcon("OptionPane.questionIcon");
                break;
            }
            case 3: {
                ic = UIManager.getIcon("OptionPane.warningIcon");
                break;
            }
            case 4: {
                ic = UIManager.getIcon("OptionPane.errorIcon");
            }
        }
        JDialog dialog = new JDialog(w, "Info");
        dialog.setMinimumSize(new Dimension(260, 120));
        dialog.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        dialog.setAlwaysOnTop(true);
        dialog.setDefaultCloseOperation(2);
        dialog.setLayout(new BoxLayout(dialog.getContentPane(), 1));
        Timer timer = null;
        JProgressBar pb = null;
        AsyncActionCloser aac = null;
        if (timeout > 0) {
            pb = new JProgressBar();
            pb.setMaximum(100);
            dialog.add(pb);
            aac = new AsyncActionCloser(timer, dialog, pb);
            timer = new Timer(timeout / 100, aac);
            timer.start();
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        dialog.add(panel);
        JLabel label = new JLabel(message, ic, 2);
        label.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        panel.add(label);
        panel = new JPanel();
        JButton button = new JButton("OK");
        if (aac == null) {
            aac = new AsyncActionCloser(timer, dialog, null);
        }
        button.addActionListener(aac);
        panel.add(button);
        dialog.add(panel);
        dialog.pack();
        if (pb != null) {
            Dimension d = new Dimension(dialog.getWidth(), 5);
            pb.setMaximumSize(d);
            pb.setPreferredSize(d);
            pb.setSize(d);
        }
        if (w != null) {
            dialog.setLocation(w.getX() + (w.getWidth() - dialog.getWidth()) / 2, w.getY() + 50);
        } else {
            dialog.setLocationRelativeTo(null);
        }
        dialog.setVisible(true);
    }

    private static void showProgressPopupAsync(Window w, String message, int maxCount, int timeout) {
        if (progressTimer != null) {
            progressTimer.stop();
            progressDialog.setVisible(false);
            progressTimer = null;
        }
        progressDialog = new JDialog(w, "Progress");
        progressDialog.setMinimumSize(new Dimension(260, 120));
        progressDialog.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        progressDialog.setAlwaysOnTop(true);
        progressDialog.setDefaultCloseOperation(2);
        progressDialog.setLayout(new BoxLayout(progressDialog.getContentPane(), 1));
        progressBar = new JProgressBar();
        progressBar.setMaximum(maxCount);
        progressDialog.add(progressBar);
        if (timeout <= 0) {
            timeout = 5000;
        }
        if (maxCount < 0) {
            progressBar.setMinimum(0);
            progressBar.setMaximum(timeout);
            progressTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    progressBar.setValue(progressBar.getValue() + 100);
                    if (progressBar.getValue() >= progressBar.getMaximum()) {
                        progressDialog.setVisible(false);
                        progressTimer.stop();
                        progressTimer = null;
                    }
                }
            });
        } else {
            progressTimer = new Timer(timeout, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    progressDialog.setVisible(false);
                    progressTimer.stop();
                    progressTimer = null;
                }
            });
        }
        progressTimer.start();
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        progressDialog.add(panel);
        JLabel label = new JLabel(message, 2);
        label.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        panel.add(label);
        panel = new JPanel();
        progressDialog.add(panel);
        progressDialog.pack();
        Dimension d = new Dimension(progressDialog.getWidth(), 40);
        progressBar.setMaximumSize(d);
        progressBar.setPreferredSize(d);
        progressBar.setSize(d);
        if (w != null) {
            progressDialog.setLocation(w.getX() + (w.getWidth() - progressDialog.getWidth()) / 2, w.getY() + 50);
        }
        progressDialog.setVisible(true);
    }

    public static void showProgressSetPosition(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (n > progressBar.getMaximum()) {
                    progressDialog.setVisible(false);
                } else {
                    progressBar.setValue(n);
                    progressTimer.restart();
                }
            }
        });
    }

    public static void showInfo(final Window w, final String message, final int icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            InputPopup.showInfoPopup(w, message, icon);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        InputPopup.showInfoPopup(w, message, icon);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    public static void showInfoAsync(final Window w, final String message, final int icon, final int timeout) {
        if (SwingUtilities.isEventDispatchThread()) {
            InputPopup.showInfoPopupAsync(w, message, icon, timeout);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InputPopup.showInfoPopupAsync(w, message, icon, timeout);
                }
            });
        }
    }

    public static void showProgressAsync(final Window w, final String message, final int maxCount, final int timeout) {
        if (SwingUtilities.isEventDispatchThread()) {
            InputPopup.showProgressPopupAsync(w, message, maxCount, timeout);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InputPopup.showProgressPopupAsync(w, message, maxCount, timeout);
                }
            });
        }
    }

    private static void showQuestionPopup(Window w, Var varBase, String message, String varName, String button1, String button2, String button3) {
        int n = 0;
        if (button1 == null || button1.length() == 0) {
            button1 = "Yes";
        }
        if (button2 == null || button2.length() == 0) {
            button2 = "No";
        }
        if (button3 != null && button3.length() > 0) {
            Object[] options = new Object[]{button1, button2, button3};
            int i = JOptionPane.showOptionDialog(w, message, "Question", 1, 3, null, options, options[0]);
            switch (i) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                }
            }
        } else {
            Object[] options = new Object[]{button1, button2};
            int i = JOptionPane.showOptionDialog(w, message, "Question", 0, 3, null, options, options[0]);
            switch (i) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 0;
                }
            }
        }
        showQuestionAnswer = n;
        if (varBase == null) {
            varBase = Var.gl;
        }
        if (varName != null && varName.length() > 0) {
            varBase.getCreate(varName).set(n);
        }
    }

    public static int showQuestion(final Window w, final Var varBase, final String message, final String varName, final String button1, final String button2, final String button3) {
        if (SwingUtilities.isEventDispatchThread()) {
            InputPopup.showQuestionPopup(w, varBase, message, varName, button1, button2, button3);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        InputPopup.showQuestionPopup(w, varBase, message, varName, button1, button2, button3);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return showQuestionAnswer;
    }

    private static class AsyncActionCloser
    implements ActionListener {
        private JDialog dialog;
        private Timer timer;
        private JProgressBar pb = null;
        int cnt = 0;

        AsyncActionCloser(Timer timer, JDialog dialog, JProgressBar pb) {
            this.timer = timer;
            this.dialog = dialog;
            this.pb = pb;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++this.cnt;
            if (e.getSource() instanceof JButton) {
                this.cnt += 100;
            }
            if (this.pb != null) {
                this.pb.setValue(this.cnt);
            }
            if (this.cnt > 100) {
                this.dialog.setVisible(false);
                if (this.timer != null) {
                    this.timer.stop();
                    this.timer = null;
                }
            }
        }
    }

    private abstract class BaseTextItem
    extends Item {
        protected JTextField field;

        public BaseTextItem(String message, String varName, String tip) {
            super(message, varName, tip);
            this.field = null;
        }

        protected int textLength() {
            return 6;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JLabel label = new JLabel(String.valueOf(this.message) + ":");
            if (labelFont != null) {
                label.setFont(labelFont);
            }
            label.setToolTipText(this.tip);
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)label, c);
            c = new GridBagConstraints();
            this.field = new JTextField(this.textLength());
            if (textFont != null) {
                this.field.setFont(textFont);
            }
            this.field.setText(this.getVar());
            if (this.field.getText().length() > 0) {
                this.parse();
            }
            this.field.selectAll();
            this.field.setToolTipText(this.tip);
            this.field.addActionListener(e -> this.valueChanged());
            this.field.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    BaseTextItem.this.valueChanged();
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 9) {
                        BaseTextItem.this.valueChanged();
                    }
                }
            });
            c.gridx = 1;
            c.gridy = line;
            c.insets = new Insets(2, 5, 2, 5);
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 2;
            panel.add((Component)this.field, c);
        }

        public void valueChanged() {
            this.parse();
            this.field.setBackground(this.ok ? InputPopup.this.normalBackground : InputPopup.this.errorBackground);
        }
    }

    private class ButtonItem
    extends Item {
        protected String cancelText;
        protected JButton okButton;
        protected JButton cancelButton;
        protected int value;

        public ButtonItem(String message, String varName, String tip) {
            super(message, varName, tip);
            this.cancelText = null;
            this.okButton = null;
            this.cancelButton = null;
            this.value = 0;
            this.ok = true;
            this.okButton = new JButton(message);
        }

        public ButtonItem(String message, String varName, String cancelText, String tip) {
            super(message, varName, tip);
            this.cancelText = null;
            this.okButton = null;
            this.cancelButton = null;
            this.value = 0;
            this.cancelText = cancelText;
            this.ok = true;
            this.okButton = new JButton(message);
            this.setVar();
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JPanel gPanel = new JPanel();
            c.gridx = 1;
            c.gridy = line;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)gPanel, c);
            if (labelFont != null) {
                this.okButton.setFont(labelFont);
            }
            this.okButton.setToolTipText(this.tip);
            this.okButton.addActionListener(e -> this.pressed(1));
            this.okButton.setFocusable(true);
            gPanel.add(this.okButton);
            if (this.cancelText != null) {
                c = new GridBagConstraints();
                this.cancelButton = new JButton(this.cancelText);
                if (labelFont != null) {
                    this.cancelButton.setFont(labelFont);
                }
                this.cancelButton.setToolTipText(this.tip);
                this.cancelButton.addActionListener(e -> this.pressed(0));
                gPanel.add(this.cancelButton);
            }
        }

        void setEnabled(boolean enabled) {
            this.okButton.setEnabled(enabled);
        }

        private void pressed(int value) {
            this.value = value;
            if (value != 0) {
                InputPopup.this.setAllVar();
            } else {
                this.setVar();
            }
            SwingUtilities.windowForComponent(this.okButton).setVisible(false);
        }

        @Override
        public void parse() {
        }

        @Override
        public void setVar() {
            if (this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }
    }

    private class CheckboxItem
    extends Item {
        protected JCheckBox checkbox;
        protected Boolean value;

        public CheckboxItem(String message, String varName, String tip) {
            super(message, varName, tip);
            this.checkbox = null;
            this.value = false;
            this.ok = true;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JLabel label = new JLabel(String.valueOf(this.message) + ":");
            if (labelFont != null) {
                label.setFont(labelFont);
            }
            label.setToolTipText(this.tip);
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)label, c);
            this.checkbox = new JCheckBox();
            int i = 0;
            try {
                i = StringUtil.parseInt(this.getVar());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.value = i > 0;
            this.checkbox.setSelected(this.value);
            this.checkbox.addActionListener(e -> this.valueChanged());
            this.checkbox.setToolTipText(this.tip);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = line;
            c.insets = new Insets(2, 5, 2, 5);
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 2;
            panel.add((Component)this.checkbox, c);
        }

        private void valueChanged() {
            this.parse();
            this.ok = true;
            InputPopup.this.setEnable();
        }

        @Override
        public void parse() {
            this.value = this.checkbox.isSelected();
        }

        @Override
        public void setVar() {
            if (this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }
    }

    private class ColorItem
    extends Item
    implements ActionListener,
    FocusListener {
        protected Color value;
        protected JTextField colorTextField;

        public ColorItem(String message, String varName, String tip) {
            super(message, varName, tip);
            this.value = null;
            this.colorTextField = null;
            this.ok = false;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JLabel label = new JLabel(String.valueOf(this.message) + ":");
            if (labelFont != null) {
                label.setFont(labelFont);
            }
            label.setToolTipText(this.tip);
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)label, c);
            JPanel gPanel = new JPanel();
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = line;
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)gPanel, c);
            this.colorTextField = new JTextField(8);
            this.colorTextField.setText(this.getVar());
            this.colorTextField.setToolTipText(this.tip);
            this.colorTextField.addActionListener(this);
            this.colorTextField.addFocusListener(this);
            Dimension dim = new Dimension(60, 20);
            this.colorTextField.setMinimumSize(dim);
            if (labelFont != null) {
                this.colorTextField.setFont(labelFont);
            }
            this.colorTextField.setToolTipText(this.tip);
            gPanel.add(this.colorTextField);
            JButton button = new JButton(InputPopup.makeIcon(IconType.ColorWheel));
            button.setBorder(null);
            button.setToolTipText(this.tip);
            button.addActionListener(e -> this.buttonPressed());
            gPanel.add(button);
            this.parse();
        }

        private void buttonPressed() {
            Window ww = SwingUtilities.windowForComponent(this.colorTextField);
            Color c = JColorChooser.showDialog(ww, this.message, this.value);
            if (c != null) {
                this.value = c;
                this.colorTextField.setText(ColorUtil.colorToName(this.value));
                InputPopup.this.setEnable();
            }
        }

        @Override
        public void parse() {
            try {
                this.value = ColorUtil.nameToColor(this.colorTextField.getText().trim());
            }
            catch (Exception e) {
                this.value = null;
            }
            this.colorTextField.setBackground(this.value != null ? InputPopup.this.normalBackground : InputPopup.this.errorBackground);
            this.ok = this.value != null;
            InputPopup.this.setEnable();
        }

        @Override
        public void setVar() {
            if (this.ok && this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.parse();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parse();
        }
    }

    private class ComboboxItem
    extends Item {
        protected List<String> selections;
        protected JComboBox<String> combobox;
        protected String value;

        public ComboboxItem(String message, String varName, List<String> selections, String tip) {
            super(message, varName, tip);
            this.selections = null;
            this.combobox = null;
            this.value = "";
            this.selections = selections;
            this.ok = true;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JLabel label = new JLabel(String.valueOf(this.message) + ":");
            if (labelFont != null) {
                label.setFont(labelFont);
            }
            label.setToolTipText(this.tip);
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)label, c);
            c = new GridBagConstraints();
            this.combobox = new JComboBox();
            if (textFont != null) {
                this.combobox.setFont(textFont);
            }
            for (String s : this.selections) {
                this.combobox.addItem(s);
            }
            this.combobox.setMaximumRowCount(30);
            this.combobox.setSelectedItem(this.getVar());
            this.combobox.setToolTipText(this.tip);
            this.combobox.addActionListener(e -> this.valueChanged());
            c.gridx = 1;
            c.gridy = line;
            c.insets = new Insets(2, 5, 2, 5);
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 2;
            panel.add(this.combobox, c);
            this.parse();
        }

        private void valueChanged() {
            this.parse();
            InputPopup.this.setEnable();
        }

        @Override
        public void parse() {
            this.value = (String)this.combobox.getSelectedItem();
        }

        @Override
        public void setVar() {
            if (this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }
    }

    private class FileItem
    extends Item {
        protected String path;
        protected String ext;
        protected String value;
        protected boolean load;
        protected JLabel pathLabel;

        public FileItem(String message, String varName, String path, String ext, boolean load, String tip) {
            super(message, varName, tip);
            this.path = null;
            this.ext = null;
            this.value = "";
            this.load = false;
            this.pathLabel = null;
            this.path = path;
            this.ext = ext;
            this.load = load;
            this.ok = false;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JLabel label = new JLabel(String.valueOf(this.message) + ":");
            if (labelFont != null) {
                label.setFont(labelFont);
            }
            label.setToolTipText(this.tip);
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)label, c);
            JPanel gPanel = new JPanel();
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = line;
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)gPanel, c);
            JButton button = new JButton(InputPopup.makeIcon(this.load ? IconType.FileLoad : IconType.FileSave));
            button.setBorder(null);
            button.setToolTipText(this.tip);
            button.addActionListener(e -> this.buttonPressed());
            gPanel.add(button);
            this.pathLabel = new JLabel(this.getVar());
            this.pathLabel.setToolTipText(this.tip);
            if (labelFont != null) {
                this.pathLabel.setFont(labelFont);
            }
            gPanel.add(this.pathLabel);
            this.ok = this.value != null && this.value.length() > 0;
        }

        private void buttonPressed() {
            try {
                String fname;
                JFileChooser fc = new JFileChooser();
                if (textFont != null) {
                    fc.setFont(textFont);
                }
                if ((fname = this.pathLabel.getText()) != null && fname.length() > 0) {
                    fc.setSelectedFile(new File(fname));
                } else if (this.path != null && this.path.length() > 0) {
                    fc.setCurrentDirectory(new File(this.path));
                }
                if (this.ext != null && this.ext.length() > 0) {
                    this.ext = this.ext.replace(".", "");
                    fc.setFileFilter(new FileNameExtensionFilter(this.ext, this.ext));
                }
                fname = null;
                Window ww = SwingUtilities.windowForComponent(this.pathLabel);
                fc.setFileSelectionMode(0);
                if (this.load) {
                    fc.setFileSelectionMode(0);
                    if (fc.showDialog(ww, "Load file") == 0 && fc.getSelectedFile().exists()) {
                        fname = fc.getSelectedFile().getCanonicalPath();
                    }
                } else {
                    boolean done = false;
                    do {
                        if (fc.showDialog(ww, "Save file") != 0) continue;
                        if (fc.getSelectedFile().exists()) {
                            int opt = JOptionPane.showConfirmDialog(ww, "File exists, overwrite?", "File exists", 1);
                            if (opt == 0) {
                                fname = fc.getSelectedFile().getCanonicalPath();
                                done = true;
                                continue;
                            }
                            if (opt != 2) continue;
                            done = true;
                            continue;
                        }
                        fname = fc.getSelectedFile().getCanonicalPath();
                        done = true;
                    } while (!done);
                }
                if (fname != null) {
                    this.value = fname;
                    this.pathLabel.setText(this.value);
                    ww.pack();
                }
                this.ok = this.value != null && this.value.length() > 0;
                InputPopup.this.setEnable();
            }
            catch (IOException e) {
                this.ok = false;
                e.printStackTrace(System.out);
            }
        }

        @Override
        public void parse() {
        }

        @Override
        public void setVar() {
            if (this.ok && this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }
    }

    private class FilenameItem
    extends BaseTextItem {
        protected String value;

        public FilenameItem(String message, String varName, String tip) {
            super(message, varName, tip);
            this.value = "";
        }

        @Override
        protected int textLength() {
            return 30;
        }

        @Override
        public void parse() {
            String v = this.field.getText().trim();
            this.ok = FileUtil.isFilenameValid(v);
            if (this.ok) {
                this.value = v;
            }
            InputPopup.this.setEnable();
        }

        @Override
        public void setVar() {
            this.valueChanged();
            if (this.ok && this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }

        @Override
        public void valueChanged() {
            this.parse();
            this.field.setBackground(this.ok ? InputPopup.this.normalBackground : InputPopup.this.errorBackground);
            InputPopup.this.setEnable();
        }
    }

    private static enum IconType {
        FileLoad,
        FileSave,
        ColorWheel;

    }

    private class ImageItem
    extends Item {
        private boolean imagesViewed;
        private List<String> imageList;
        private ImageViewerCallback ivc;
        private JButton viewButton;

        public ImageItem(String message, String varName, List<String> imageList, String tip, ImageViewerCallback ivc) {
            super(message, varName, tip);
            this.imagesViewed = false;
            this.imageList = null;
            this.ivc = null;
            this.viewButton = null;
            this.imageList = imageList;
            this.ivc = ivc;
            this.ok = true;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = line;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            this.viewButton = new JButton(this.message);
            if (labelFont != null) {
                this.viewButton.setFont(labelFont);
            }
            this.viewButton.setToolTipText(this.tip);
            this.viewButton.addActionListener(e -> this.pressed(1));
            this.viewButton.setFocusable(true);
            panel.add((Component)this.viewButton, c);
        }

        private void pressed(int n) {
            if (this.ivc != null) {
                this.ivc.show(this.imageList);
                this.imagesViewed = true;
            }
        }

        @Override
        public void parse() {
        }

        @Override
        public void setVar() {
            if (this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.imagesViewed);
            }
        }
    }

    public static interface ImageViewerCallback {
        public void show(List<String> var1);
    }

    private abstract class Item {
        protected String message = "";
        protected String varName = "";
        protected String tip = "";
        protected boolean ok = false;

        public Item(String message, String varName, String tip) {
            this.message = message;
            this.varName = varName;
            this.tip = tip;
        }

        public abstract void layout(JPanel var1, int var2);

        public String getVar() {
            if (this.varName == null && this.varName.length() == 0) {
                return "";
            }
            Var v = InputPopup.this.varBase.find(this.varName);
            if (v == null && InputPopup.this.varBase != Var.gl) {
                v = Var.gl.find(this.varName);
            }
            if (v != null && InputPopup.this.useSI && v.isDouble()) {
                return StringUtil.formatDoubleEE(v.asDouble(), false);
            }
            return v == null ? "" : v.asString();
        }

        public abstract void parse();

        public abstract void setVar();
    }

    private class LabelItem
    extends Item {
        public LabelItem(String message, String varName, String tip) {
            super(message, varName, tip);
            this.ok = true;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JLabel label = new JLabel(this.message);
            if (labelFont != null) {
                label.setFont(labelFont);
            }
            label.setToolTipText(this.tip);
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 10;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 2;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)label, c);
        }

        @Override
        public void parse() {
        }

        @Override
        public void setVar() {
        }
    }

    private class ListItem
    extends Item {
        protected List<String> selections;
        protected JList<String> list;
        protected String value;
        protected int lines;

        public ListItem(String message, String varName, List<String> selections, int lines, String tip) {
            super(message, varName, tip);
            this.selections = null;
            this.list = null;
            this.value = "";
            this.selections = selections;
            this.lines = lines;
            this.ok = true;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JLabel label = new JLabel(String.valueOf(this.message) + ":");
            if (labelFont != null) {
                label.setFont(labelFont);
            }
            label.setToolTipText(this.tip);
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)label, c);
            c = new GridBagConstraints();
            this.list = new JList<String>(this.selections.toArray(new String[0]));
            this.list.setSelectionMode(0);
            if (textFont != null) {
                this.list.setFont(textFont);
            }
            this.list.setSelectedValue(this.getVar(), true);
            this.list.setToolTipText(this.tip);
            this.list.addListSelectionListener(e -> this.valueChanged());
            c.gridx = 1;
            c.gridy = line;
            c.insets = new Insets(2, 5, 2, 5);
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 2;
            String ss = "";
            for (String s : this.selections) {
                if (s.length() <= ss.length()) continue;
                ss = s;
            }
            while (ss.length() < 8) {
                ss = String.valueOf(ss) + "W";
            }
            Rectangle2D r = panel.getFontMetrics(this.list.getFont()).getStringBounds(ss, panel.getGraphics());
            JScrollPane scrollPane = new JScrollPane(this.list);
            Dimension dim = new Dimension((int)(r.getWidth() * 1.2) + 10, (int)(r.getHeight() * 1.2 * (double)this.lines + 5.0));
            scrollPane.setMinimumSize(dim);
            scrollPane.setSize(dim);
            scrollPane.setMaximumSize(dim);
            scrollPane.setPreferredSize(dim);
            panel.add((Component)scrollPane, c);
            this.parse();
        }

        private void valueChanged() {
            this.parse();
            InputPopup.this.setEnable();
        }

        @Override
        public void parse() {
            this.value = this.list.getSelectedValue();
        }

        @Override
        public void setVar() {
            if (this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }
    }

    private class NumberIntItem
    extends BaseTextItem {
        protected long min;
        protected long max;
        protected long value;

        public NumberIntItem(String message, String varName, long min, long max, String tip) {
            super(message, varName, tip);
            this.min = 0L;
            this.max = 0L;
            this.value = 0L;
            this.min = min;
            this.max = max;
        }

        @Override
        protected int textLength() {
            return 6;
        }

        @Override
        public void parse() {
            this.ok = false;
            try {
                long v = StringUtil.parseLong(this.field.getText());
                if (v >= this.min && v <= this.max) {
                    this.ok = true;
                    this.value = v;
                }
            }
            catch (Exception e) {
                this.ok = false;
            }
            InputPopup.this.setEnable();
        }

        @Override
        public void setVar() {
            this.valueChanged();
            if (this.ok && this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }

        @Override
        public void valueChanged() {
            this.parse();
            this.field.setBackground(this.ok ? InputPopup.this.normalBackground : InputPopup.this.errorBackground);
            InputPopup.this.setEnable();
        }
    }

    private class NumberIntListItem
    extends BaseTextItem {
        protected long min;
        protected long max;
        protected List<Long> values;

        public NumberIntListItem(String message, String varName, long min, long max, String tip) {
            super(message, varName, tip);
            this.min = 0L;
            this.max = 0L;
            this.values = null;
            this.min = min;
            this.max = max;
        }

        @Override
        protected int textLength() {
            return 20;
        }

        @Override
        public String getVar() {
            Var v;
            Var var = v = this.varName != null && this.varName.length() > 0 ? InputPopup.this.varBase.find(this.varName) : null;
            if (v == null) {
                return "";
            }
            if (v.isArray()) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < v.getSize()) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(v.get(i).asLong());
                    ++i;
                }
                return sb.toString();
            }
            return v == null ? "" : Long.toString(v.asLong());
        }

        @Override
        public void parse() {
            this.ok = true;
            this.values = new ArrayList<Long>();
            try {
                String[] stringArray = this.field.getText().trim().split("[ ;]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    long v = StringUtil.parseLong(s);
                    if (v < this.min || v > this.max) {
                        this.ok = false;
                    }
                    this.values.add(v);
                    ++n2;
                }
            }
            catch (Exception e) {
                this.ok = false;
            }
            InputPopup.this.setEnable();
        }

        @Override
        public void setVar() {
            this.valueChanged();
            if (this.ok && this.varName != null && this.varName.length() > 0) {
                Var v = Var.createArray();
                for (long d : this.values) {
                    v.addVar(Var.createValue(d));
                }
                InputPopup.this.varBase.getCreate(this.varName).set(v);
            }
        }

        @Override
        public void valueChanged() {
            this.parse();
            this.field.setBackground(this.ok ? InputPopup.this.normalBackground : InputPopup.this.errorBackground);
            InputPopup.this.setEnable();
        }
    }

    private class NumberItem
    extends BaseTextItem {
        protected double min;
        protected double max;
        protected double value;

        public NumberItem(String message, String varName, double min, double max, String tip) {
            super(message, varName, tip);
            this.min = 0.0;
            this.max = 0.0;
            this.value = 0.0;
            this.min = min;
            this.max = max;
        }

        @Override
        protected int textLength() {
            return 8;
        }

        @Override
        public void parse() {
            this.ok = false;
            try {
                double v = StringUtil.parseDoubleEE(this.field.getText());
                if (v >= this.min && v <= this.max) {
                    this.ok = true;
                    this.value = v;
                }
            }
            catch (Exception e) {
                this.ok = false;
            }
            InputPopup.this.setEnable();
        }

        @Override
        public void setVar() {
            this.valueChanged();
            if (this.ok && this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }

        @Override
        public void valueChanged() {
            this.parse();
            this.field.setBackground(this.ok ? InputPopup.this.normalBackground : InputPopup.this.errorBackground);
            InputPopup.this.setEnable();
        }
    }

    private class NumberListItem
    extends BaseTextItem {
        protected double min;
        protected double max;
        protected List<Double> values;

        public NumberListItem(String message, String varName, double min, double max, String tip) {
            super(message, varName, tip);
            this.min = 0.0;
            this.max = 0.0;
            this.values = null;
            this.min = min;
            this.max = max;
        }

        @Override
        protected int textLength() {
            return 20;
        }

        @Override
        public String getVar() {
            Var v;
            Var var = v = this.varName != null && this.varName.length() > 0 ? InputPopup.this.varBase.find(this.varName) : null;
            if (v == null) {
                return "";
            }
            if (v.isArray()) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < v.getSize()) {
                    Var vv = v.get(i);
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(InputPopup.this.useSI && vv.isDouble() ? StringUtil.formatDoubleEE(vv.asDouble(), false) : vv.asString());
                    ++i;
                }
                return sb.toString();
            }
            if (v != null && InputPopup.this.useSI && v.isDouble()) {
                return StringUtil.formatDoubleEE(v.asDouble(), false);
            }
            return v == null ? "" : v.asString();
        }

        @Override
        public void parse() {
            this.ok = true;
            this.values = new ArrayList<Double>();
            try {
                String[] stringArray = this.field.getText().trim().split("[ ;]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    double v = StringUtil.parseDoubleEE(s);
                    if (v < this.min || v > this.max || Double.isNaN(v)) {
                        this.ok = false;
                    }
                    this.values.add(v);
                    ++n2;
                }
            }
            catch (Exception e) {
                this.ok = false;
            }
            InputPopup.this.setEnable();
        }

        @Override
        public void setVar() {
            if (this.ok && this.varName != null && this.varName.length() > 0) {
                Var v = Var.createArray();
                for (Double d : this.values) {
                    v.addVar(Var.createValue(d));
                }
                InputPopup.this.varBase.getCreate(this.varName).set(v);
            }
        }

        @Override
        public void valueChanged() {
            this.parse();
            this.field.setBackground(this.ok ? InputPopup.this.normalBackground : InputPopup.this.errorBackground);
            InputPopup.this.setEnable();
        }
    }

    private static class ProgressActionListener
    implements ActionListener {
        private ProgressActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            progressBar.setValue(progressBar.getValue() + 100);
            if (progressBar.getValue() >= progressBar.getMaximum()) {
                progressDialog.setVisible(false);
                progressTimer.stop();
                progressTimer = null;
            }
        }
    }

    private class RadioItem
    extends Item
    implements ActionListener {
        protected List<String> selections;
        protected String value;

        public RadioItem(String message, String varName, List<String> selections, String tip) {
            super(message, varName, tip);
            this.selections = null;
            this.value = "";
            this.selections = selections;
            this.ok = false;
        }

        @Override
        public void layout(JPanel panel, int line) {
            GridBagConstraints c = new GridBagConstraints();
            JLabel label = new JLabel(String.valueOf(this.message) + ":");
            if (labelFont != null) {
                label.setFont(labelFont);
            }
            label.setToolTipText(this.tip);
            c.gridx = 0;
            c.gridy = line;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 5, 2, 5);
            panel.add((Component)label, c);
            c = new GridBagConstraints();
            JPanel rPanel = new JPanel();
            String sel = this.getVar();
            ButtonGroup bg = new ButtonGroup();
            for (String s : this.selections) {
                JRadioButton rb = new JRadioButton(s);
                if (labelFont != null) {
                    rb.setFont(labelFont);
                }
                bg.add(rb);
                rb.setActionCommand(s);
                rb.setToolTipText(this.tip);
                rb.addActionListener(this);
                rPanel.add(rb);
                if (!s.equals(sel)) continue;
                this.ok = true;
                this.value = s;
                rb.setSelected(true);
            }
            c.gridx = 1;
            c.gridy = line;
            c.insets = new Insets(2, 5, 2, 5);
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 2;
            panel.add((Component)rPanel, c);
            this.parse();
        }

        @Override
        public void parse() {
        }

        @Override
        public void setVar() {
            if (this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.value = arg0.getActionCommand();
            this.ok = true;
            InputPopup.this.setEnable();
        }
    }

    private class TextItem
    extends BaseTextItem {
        protected String value;
        protected int maxLength;

        public TextItem(String message, String varName, int maxLength, String tip) {
            super(message, varName, tip);
            this.value = "";
            this.maxLength = 0;
            this.maxLength = maxLength;
        }

        @Override
        protected int textLength() {
            return this.maxLength < 30 ? this.maxLength : 30;
        }

        @Override
        public void parse() {
            String v = this.field.getText();
            boolean bl = this.ok = v.length() <= this.maxLength;
            if (this.ok) {
                this.value = v;
            }
            InputPopup.this.setEnable();
        }

        @Override
        public void setVar() {
            this.valueChanged();
            if (this.ok && this.varName != null && this.varName.length() > 0) {
                InputPopup.this.varBase.getCreate(this.varName).set(this.value);
            }
        }

        @Override
        public void valueChanged() {
            this.parse();
            this.field.setBackground(this.ok ? InputPopup.this.normalBackground : InputPopup.this.errorBackground);
            InputPopup.this.setEnable();
        }
    }
}

