/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImageUtil {
    public static Dimension getScaledDimension(Dimension imgSize, Dimension boundary) {
        int original_width = imgSize.width;
        int original_height = imgSize.height;
        int bound_width = boundary.width;
        int bound_height = boundary.height;
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new Dimension(new_width, new_height);
    }

    public static BufferedImage scale(BufferedImage imageToScale, int dWidth, int dHeight, boolean fit) {
        return ImageUtil.scale(imageToScale, new Dimension(dWidth, dHeight), fit);
    }

    public static BufferedImage scale(BufferedImage imageToScale, Dimension dim, boolean fit) {
        BufferedImage scaledImage = null;
        if (imageToScale != null) {
            if (!fit) {
                dim = ImageUtil.getScaledDimension(new Dimension(imageToScale.getWidth(), imageToScale.getHeight()), dim);
            }
            scaledImage = new BufferedImage(dim.width, dim.height, imageToScale.getType());
            Graphics gph = scaledImage.getGraphics();
            gph.setColor(Color.white);
            gph.fillRect(0, 0, dim.width, dim.height);
            Graphics2D graphics2D = scaledImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawImage(imageToScale, 0, 0, dim.width, dim.height, null);
            graphics2D.dispose();
        }
        return scaledImage;
    }
}

