/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private Image image = null;

    public ImagePanel() {
    }

    public ImagePanel(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.image = image;
        Dimension d = new Dimension(image.getWidth(this), image.getHeight(this));
        this.setSize(d);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        super.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    @Override
    public void paint(Graphics gph) {
        super.paintComponent(gph);
        if (this.image == null) {
            gph.setColor(Color.white);
            gph.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            int iw = this.image.getWidth(this);
            int ih = this.image.getHeight(this);
            int dx = this.getWidth() - iw;
            int dy = this.getHeight() - ih;
            gph.drawImage(this.image, dx / 2, dy / 2, iw + dx / 2, ih + dy / 2, 0, 0, iw, ih, this);
        }
    }
}

