/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import dk.hkj.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static boolean isFileUtf16(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            int b1 = ((InputStream)is).read();
            int b2 = ((InputStream)is).read();
            if (b1 == 255 && b2 == 254) {
                return true;
            }
            if (b1 == 254 && b2 == 255) {
                return true;
            }
        }
        return false;
    }

    public static String fileEncoding(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            int b1 = ((InputStream)is).read();
            if (b1 < 200) {
                return "cp1252";
            }
            int b2 = ((InputStream)is).read();
            if (b1 == 255 && b2 == 254) {
                return "utf-16";
            }
            if (b1 == 254 && b2 == 255) {
                return "utf-16";
            }
            if (b1 == 239 && b2 == 187 && ((InputStream)is).read() == 191) {
                return "utf-8";
            }
        }
        return "cp1252";
    }

    public static boolean needUTF16(String str) {
        try {
            Charset cs = Charset.defaultCharset();
            CharsetEncoder ce = cs.newEncoder();
            ce.onMalformedInput(CodingErrorAction.REPORT);
            ce.onUnmappableCharacter(CodingErrorAction.REPORT);
            ce.encode(CharBuffer.wrap(str));
        }
        catch (CharacterCodingException e) {
            return true;
        }
        return false;
    }

    public static boolean needUTF16(List<String> list) {
        try {
            Charset cs = Charset.defaultCharset();
            CharsetEncoder ce = cs.newEncoder();
            ce.onMalformedInput(CodingErrorAction.REPORT);
            ce.onUnmappableCharacter(CodingErrorAction.REPORT);
            for (String str : list) {
                ce.encode(CharBuffer.wrap(str));
            }
        }
        catch (CharacterCodingException e) {
            return true;
        }
        return false;
    }

    public static List<String> readFileAsList(File file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(file), 32768);){
            while (br.ready()) {
                list.add(br.readLine());
            }
        }
        return list;
    }

    public static List<String> readFileAsListAutoCharset(File file, String commentSymbol, boolean trim, boolean removeEmptyLine) throws IOException {
        String charset = FileUtil.fileEncoding(file);
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)is, charset);
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(isr, 32768);){
            while (br.ready()) {
                String line = br.readLine();
                if (list.size() == 0 && line.length() > 0 && (line.charAt(0) == '\ufeff' || line.charAt(0) == '\ufffe')) {
                    line = line.substring(1);
                }
                if (trim) {
                    line = line.trim();
                }
                if (commentSymbol != null && commentSymbol.length() > 0 && line.startsWith(commentSymbol)) {
                    line = null;
                }
                if (removeEmptyLine && line != null && line.trim().length() == 0) {
                    line = null;
                }
                if (line == null) continue;
                list.add(line);
            }
        }
        return list;
    }

    public static String readFileAsString(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(file), 32768);){
            while (br.ready()) {
                sb.append(br.readLine());
                sb.append("\r\n");
            }
        }
        if (sb.charAt(0) == '\ufeff' || sb.charAt(0) == '\ufffe') {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static List<String> readFileAsList(File file, String charsetName) throws IOException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)is, charsetName);
        BufferedReader br = new BufferedReader(isr, 32768);
        ArrayList<String> list = new ArrayList<String>();
        if (br.ready()) {
            String line = br.readLine();
            if (line.length() > 0 && (line.charAt(0) == '\ufeff' || line.charAt(0) == '\ufffe')) {
                line = line.substring(1);
            }
            list.add(line);
        }
        try {
            while (br.ready()) {
                list.add(br.readLine());
            }
        }
        finally {
            br.close();
        }
        return list;
    }

    public static String readFileAsString(File file, String charsetName) throws IOException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)is, charsetName);
        StringBuilder sb = new StringBuilder(1000);
        try (BufferedReader br = new BufferedReader(isr, 32768);){
            while (br.ready()) {
                sb.append(br.readLine());
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    public static void writeFile(File file, List<String> list) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file), 32768);){
            for (String s : list) {
                bw.write(s);
                bw.write("\r\n");
            }
        }
    }

    public static void writeFileAutoCharset(File file, List<String> list) throws IOException {
        if (FileUtil.needUTF16(list)) {
            FileUtil.writeFile(file, "utf-16le", list);
        } else {
            FileUtil.writeFile(file, list);
        }
    }

    public static void writeFileAutoCharset(File file, String str) throws IOException {
        if (FileUtil.needUTF16(str)) {
            FileUtil.writeFile(file, "utf-16le", str);
        } else {
            FileUtil.writeFile(file, str);
        }
    }

    public static void writeFile(File file, String charsetName, List<String> list) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        if (!charsetName.equalsIgnoreCase("UTF-16le") && !charsetName.equalsIgnoreCase("UTF-16be") && charsetName.equalsIgnoreCase("UTF-8")) {
            ((OutputStream)os).write(-17);
            ((OutputStream)os).write(-69);
            ((OutputStream)os).write(-65);
        }
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, charsetName);
        try (BufferedWriter bw = new BufferedWriter(osw, 32768);){
            for (String s : list) {
                bw.write(s);
                bw.write("\r\n");
            }
        }
    }

    public static void writeFile(File file, String str) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file), 32768);){
            bw.write(str);
        }
    }

    public static void writeFile(File file, String charsetName, String str) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, charsetName);
        try (BufferedWriter bw = new BufferedWriter(osw, 32768);){
            bw.write(str);
        }
    }

    public static List<String> readFileAsListAutoCharset(File file) throws IOException {
        return FileUtil.readFileAsList(file, FileUtil.fileEncoding(file));
    }

    public static String readFileAsStringAutoCharset(File file) throws IOException {
        return FileUtil.readFileAsString(file, FileUtil.fileEncoding(file));
    }

    public static void combineLongLines(List<String> list) {
        StringBuilder sb = new StringBuilder();
        int dst = 0;
        int src = 0;
        while (src < list.size()) {
            String s;
            if ((s = list.get(src++)).length() > 0 && s.charAt(s.length() - 1) == '\\') {
                while (s.charAt(s.length() - 1) == '\\') {
                    sb.append(s.substring(0, s.length() - 1));
                    sb.append(' ');
                    s = list.get(src++);
                }
                sb.append(s);
                s = sb.toString();
                sb.setLength(0);
            }
            list.set(dst++, s);
        }
        while (list.size() > dst) {
            list.remove(list.size() - 1);
        }
    }

    public static File getFilePathWithDefaults(String defaultPath, String pathAndFileName, String defaultExt) {
        if (defaultExt != null && !defaultExt.equals("")) {
            int i = pathAndFileName.lastIndexOf(46);
            int j = pathAndFileName.lastIndexOf(47);
            if (j != pathAndFileName.length() && (i > j && i < pathAndFileName.length() - 4 || i < 0)) {
                pathAndFileName = defaultExt.charAt(0) == '.' ? String.valueOf(pathAndFileName) + defaultExt : String.valueOf(pathAndFileName) + '.' + defaultExt;
            }
        }
        File file = new File(pathAndFileName);
        if (defaultPath != null && !defaultPath.equals("") && !file.isAbsolute()) {
            if (defaultPath.charAt(defaultPath.length() - 1) != '/' && defaultPath.charAt(defaultPath.length() - 1) != '\\') {
                defaultPath = String.valueOf(defaultPath) + '/';
            }
            file = new File(String.valueOf(defaultPath) + pathAndFileName);
        }
        return file;
    }

    public static String getExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return filename.substring(i + 1);
    }

    public static boolean isFilenameValid(String filename) {
        File f = new File(filename);
        try {
            f.getCanonicalPath();
            return filename.equals(StringUtil.sanitiseFilename(filename));
        }
        catch (IOException e) {
            return false;
        }
    }
}

