/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import dk.hkj.util.Complex;

public class FFT {
    public static double[] magnitude(Complex[] fft) {
        int n = fft.length;
        double[] data = new double[n / 2];
        double f = 1.0 / (double)n / Math.sqrt(2.0);
        int i = 0;
        while (i < n / 2) {
            data[i] = fft[i].abs() * (i == 0 ? 1.0 / (double)n : f);
            ++i;
        }
        return data;
    }

    public static double[] interpolate(int points, double[] data) {
        double[] output = new double[points];
        int i = 0;
        while (i < points) {
            double frac = (double)i / (double)points * (double)data.length;
            int idx = (int)Math.floor(frac);
            frac -= (double)idx;
            output[i] = data[idx];
            if (frac > 0.0) {
                int n = i;
                output[n] = output[n] + (data[idx + 1] - data[idx]) * frac;
            }
            ++i;
        }
        return output;
    }

    public static int pointsPower2(int points) {
        if (points < 2) {
            return 0;
        }
        int n = 2;
        while (n * 2 <= points) {
            n *= 2;
        }
        return n;
    }

    public static Complex[] fft(double[] x) {
        int n = x.length;
        Complex[] buffer = new Complex[n];
        int i = 0;
        while (i < n) {
            buffer[i] = new Complex(x[i]);
            ++i;
        }
        return FFT.fftrec(buffer);
    }

    static Complex[] fft(Complex[] x) {
        int n = x.length;
        if (n == 1) {
            return new Complex[]{x[0]};
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("n is not a power of 2");
        }
        Complex[] buffer = new Complex[n];
        int i = 0;
        while (i < n) {
            buffer[i] = x[i];
            ++i;
        }
        int bits = (int)(Math.log(n) / Math.log(2.0));
        int j = 1;
        while (j < n / 2) {
            int swapPos = FFT.bitReverse(j, bits);
            Complex temp = buffer[j];
            buffer[j] = buffer[swapPos];
            buffer[swapPos] = temp;
            ++j;
        }
        int nn = 2;
        while (nn <= n) {
            int i2 = 0;
            while (i2 < n) {
                int k = 0;
                while (k < nn / 2) {
                    int evenIndex = i2 + k;
                    int oddIndex = i2 + k + nn / 2;
                    Complex even = buffer[evenIndex];
                    Complex odd = buffer[oddIndex];
                    double term = Math.PI * -2 * (double)k / (double)nn;
                    Complex exp = new Complex(Math.cos(term), Math.sin(term)).mult(odd);
                    buffer[evenIndex] = even.add(exp);
                    buffer[oddIndex] = even.sub(exp);
                    ++k;
                }
                i2 += nn;
            }
            nn <<= 1;
        }
        return buffer;
    }

    public static Complex[] fftrec3(Complex[] vector) {
        int n = vector.length;
        int bits = (int)(Math.log(n) / Math.log(2.0));
        int j = 1;
        while (j < vector.length / 2) {
            int swapPos = FFT.bitReverse(j, bits);
            Complex temp = vector[j];
            vector[j] = vector[swapPos];
            vector[swapPos] = temp;
            ++j;
        }
        int m = 2;
        while (m <= n) {
            int i = 0;
            while (i < n) {
                int k = 0;
                while (k < m / 2) {
                    int evenIndex = i + k;
                    int oddIndex = i + k + m / 2;
                    Complex even = vector[evenIndex];
                    Complex odd = vector[oddIndex];
                    Complex wm = Complex.Polar(1.0, Math.PI * -2 * (double)k / (double)m).mult(odd);
                    vector[evenIndex] = even.add(wm);
                    vector[oddIndex] = even.sub(wm);
                    ++k;
                }
                i += m;
            }
            m <<= 1;
        }
        return vector;
    }

    private static int bitReverse(int n, int bits) {
        int reversedN = n;
        int count = bits - 1;
        n >>= 1;
        while (n > 0) {
            reversedN = reversedN << 1 | n & 1;
            --count;
            n >>= 1;
        }
        return reversedN << count & (1 << bits) - 1;
    }

    public static Complex[] fftrec(Complex[] x) {
        int n = x.length;
        if (n == 1) {
            return new Complex[]{x[0]};
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("n is not a power of 2");
        }
        Complex[] even = new Complex[n / 2];
        Complex[] odd = new Complex[n / 2];
        int i = 0;
        while (i < n / 2) {
            even[i] = x[i * 2];
            odd[i] = x[i * 2 + 1];
            ++i;
        }
        even = FFT.fftrec(even);
        odd = FFT.fftrec(odd);
        Complex[] buffer = new Complex[n];
        int i2 = 0;
        while (i2 < n / 2) {
            Complex t = Complex.Polar(1.0, Math.PI * -2 * (double)i2 / (double)n).mult(odd[i2]);
            buffer[i2] = even[i2].add(t);
            buffer[i2 + n / 2] = even[i2].sub(t);
            ++i2;
        }
        return buffer;
    }

    public static Complex[] ifft(Complex[] x) {
        int n = x.length;
        Complex[] y = new Complex[n];
        int i = 0;
        while (i < n) {
            y[i] = x[i].conjugate();
            ++i;
        }
        y = FFT.fft(y);
        i = 0;
        while (i < n) {
            y[i] = y[i].conjugate();
            ++i;
        }
        i = 0;
        while (i < n) {
            y[i] = y[i].mult(1.0 / (double)n);
            ++i;
        }
        return y;
    }

    public static Complex[] cconvolve(Complex[] x, Complex[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Dimensions don't agree");
        }
        int n = x.length;
        Complex[] a = FFT.fft(x);
        Complex[] b = FFT.fft(y);
        Complex[] c = new Complex[n];
        int i = 0;
        while (i < n) {
            c[i] = a[i].mult(b[i]);
            ++i;
        }
        return FFT.ifft(c);
    }

    public static Complex[] convolve(Complex[] x, Complex[] y) {
        Complex ZERO = new Complex(0.0, 0.0);
        Complex[] a = new Complex[2 * x.length];
        int i = 0;
        while (i < x.length) {
            a[i] = x[i];
            ++i;
        }
        i = x.length;
        while (i < 2 * x.length) {
            a[i] = ZERO;
            ++i;
        }
        Complex[] b = new Complex[2 * y.length];
        int i2 = 0;
        while (i2 < y.length) {
            b[i2] = y[i2];
            ++i2;
        }
        i2 = y.length;
        while (i2 < 2 * y.length) {
            b[i2] = ZERO;
            ++i2;
        }
        return FFT.cconvolve(a, b);
    }

    public static Complex[] dft(Complex[] x) {
        int n = x.length;
        Complex ZERO = new Complex(0.0, 0.0);
        Complex[] y = new Complex[n];
        int k = 0;
        while (k < n) {
            y[k] = ZERO;
            int j = 0;
            while (j < n) {
                int power = k * j % n;
                double kth = (double)(-2 * power) * Math.PI / (double)n;
                Complex wkj = new Complex(Math.cos(kth), Math.sin(kth));
                y[k] = y[k].add(x[j].mult(wkj));
                ++j;
            }
            ++k;
        }
        return y;
    }

    public static void show(Complex[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int i = 0;
        while (i < x.length) {
            System.out.println(x[i]);
            ++i;
        }
        System.out.println();
    }
}

