/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtractData {
    private List<String> data = null;
    private List<String> orginalData = null;

    ExtractData() {
    }

    public void loadFile(String fname) {
    }

    public void loadText(String text) {
        this.data = new ArrayList<String>();
        String[] stringArray = text.split("[\r\n]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.data.add(line);
            ++n2;
        }
        this.orginalData = this.data;
    }

    public void reset() {
        this.data = this.orginalData;
    }

    public void filterLinesMatching(String regex, boolean include) {
        Pattern p = Pattern.compile(regex);
        ArrayList<String> newData = new ArrayList<String>();
        Matcher m = p.matcher("");
        for (String line : this.data) {
            m.reset(line);
            if (include) {
                if (!m.matches()) continue;
                newData.add(line);
                continue;
            }
            if (m.matches()) continue;
            newData.add(line);
        }
        this.data = newData;
    }

    public void filterLinesContains(String regex, boolean include) {
        Pattern p = Pattern.compile(regex);
        ArrayList<String> newData = new ArrayList<String>();
        Matcher m = p.matcher("");
        for (String line : this.data) {
            m.reset(line);
            if (include) {
                if (!m.find()) continue;
                newData.add(line);
                continue;
            }
            if (m.find()) continue;
            newData.add(line);
        }
        this.data = newData;
    }

    public void editLineRemoveStart(int n) {
        ArrayList<String> newData = new ArrayList<String>();
        for (String line : this.data) {
            if (line.length() < n) continue;
            newData.add(line.substring(n));
        }
        this.data = newData;
    }

    public void editLineRemoveEnd(int n) {
        ArrayList<String> newData = new ArrayList<String>();
        for (String line : this.data) {
            if (line.length() < n) continue;
            newData.add(line.substring(0, line.length() - n));
        }
        this.data = newData;
    }

    public void editLineKeepStart(int n) {
        ArrayList<String> newData = new ArrayList<String>();
        for (String line : this.data) {
            if (line.length() < n) continue;
            newData.add(line.substring(0, n));
        }
        this.data = newData;
    }

    public void editLineIncludeMatch(String regex) {
        Pattern p = Pattern.compile(regex);
        ArrayList<String> newData = new ArrayList<String>();
        Matcher m = p.matcher("");
        for (String line : this.data) {
            m.reset(line);
            if (!m.find()) continue;
            newData.add(line.substring(m.start(), m.end()));
        }
        this.data = newData;
    }

    public void editLineRemoveMatch(String regex) {
        Pattern p = Pattern.compile(regex);
        ArrayList<String> newData = new ArrayList<String>();
        Matcher m = p.matcher("");
        for (String line : this.data) {
            m.reset(line);
            if (!m.find()) continue;
            newData.add(String.valueOf(line.substring(0, m.start())) + line.substring(m.end()));
        }
        this.data = newData;
    }

    public List<String> getValueMatch(String regex) {
        return this.getValue(new FilterMatch(regex));
    }

    public List<String> getValueFromTo(String regexFrom, String regexTo) {
        return this.getValue(new FilterFromTo(regexFrom, regexTo));
    }

    public List<String> getValue(Filter f) {
        ArrayList<String> newData = new ArrayList<String>();
        for (String line : this.data) {
            if (!f.match(line)) continue;
            newData.add(f.getMatch());
        }
        return newData;
    }

    public List<List<String>> getValues(List<Filter> fs, boolean partialMatch) {
        ArrayList<List<String>> newData = new ArrayList<List<String>>();
        for (String line : this.data) {
            ArrayList<String> ll = new ArrayList<String>();
            int pos = 0;
            for (Filter f : fs) {
                if (f.match(pos, line)) {
                    ll.add(f.getMatch());
                    pos = f.getNext();
                    while (f.getRepeat() && f.match(pos, line)) {
                        ll.add(f.getMatch());
                        pos = f.getNext();
                    }
                    continue;
                }
                if (partialMatch) {
                    ll.add(null);
                    continue;
                }
                ll.clear();
                break;
            }
            if (ll.size() <= 0) continue;
            newData.add(ll);
        }
        return newData;
    }

    public List<List<String>> filterAndGetValues2(String format, boolean partialMatch) {
        this.reset();
        int i = 0;
        String exp = "";
        i = format.indexOf("<", i);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        while (i >= 0 && i < format.length()) {
            char c = format.charAt(i + 1);
            int j = format.indexOf(String.valueOf(c) + ">", i + 2);
            if (j > 0) {
                exp = format.substring(i + 2, j);
                i = format.indexOf("<", j + 2);
            }
            switch (c) {
                case 'I': {
                    this.filterLinesMatching(exp, true);
                    break;
                }
                case 'X': {
                    this.filterLinesMatching(exp, false);
                    break;
                }
                case 'C': {
                    this.filterLinesContains(exp, true);
                    break;
                }
                case 'N': {
                    this.filterLinesContains(exp, false);
                    break;
                }
                case 'M': {
                    filters.add(new FilterMatch(exp));
                    break;
                }
                case 'B': {
                    String[] s = exp.split("><");
                    if (s.length != 2) {
                        return null;
                    }
                    filters.add(new FilterFromTo(s[0], s[1]));
                }
            }
        }
        return this.getValues(filters, partialMatch);
    }

    public List<String> filterAndGetValue(String deli, String format) {
        List<List<String>> list = this.filterAndGetValues(deli, format, false);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public List<List<String>> filterAndGetValues(String deli, String format, boolean partialMatch) {
        this.reset();
        String[] formats = format.split(deli);
        boolean toSection = false;
        String savedExp = "";
        ArrayList<Filter> filters = new ArrayList<Filter>();
        String[] stringArray = formats;
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (toSection) {
                filters.add(new FilterFromTo(savedExp, f));
            } else {
                int i = f.indexOf(58);
                if (i > 5) {
                    String cmd = f.substring(0, i).trim();
                    String exp = f.substring(i + 1);
                    if (cmd.equalsIgnoreCase("LinesMatch")) {
                        this.filterLinesMatching(exp, true);
                    } else if (cmd.equalsIgnoreCase("LinesNotMatch")) {
                        this.filterLinesMatching(exp, false);
                    } else if (cmd.equalsIgnoreCase("LinesContains")) {
                        this.filterLinesContains(exp, true);
                    } else if (cmd.equalsIgnoreCase("LinesNotContain")) {
                        this.filterLinesContains(exp, false);
                    } else if (cmd.equalsIgnoreCase("ValueMatch")) {
                        filters.add(new FilterMatch(exp));
                    } else if (cmd.equalsIgnoreCase("ValueMatchMultiple")) {
                        filters.add(new FilterMatchMultiple(exp));
                    } else if (cmd.equalsIgnoreCase("ValueFromTo")) {
                        savedExp = exp;
                        toSection = true;
                    }
                }
            }
            ++n2;
        }
        return this.getValues(filters, partialMatch);
    }

    public List<String> getCurrentList() {
        return this.data;
    }

    public static abstract class Filter {
        protected String value = "";
        protected int next = 0;

        public boolean match(String line) {
            return this.match(0, line);
        }

        public abstract boolean match(int var1, String var2);

        public String getMatch() {
            return this.value;
        }

        public int getNext() {
            return this.next;
        }

        public boolean getRepeat() {
            return false;
        }
    }

    public static class FilterFromTo
    extends Filter {
        private Pattern p1 = null;
        private Pattern p2 = null;
        private Matcher m1 = null;
        private Matcher m2 = null;

        FilterFromTo(String regexFrom, String regexTo) {
            this.p1 = Pattern.compile(regexFrom);
            this.p2 = Pattern.compile(regexTo);
            this.m1 = this.p1.matcher("");
            this.m2 = this.p2.matcher("");
        }

        @Override
        public boolean match(int from, String line) {
            this.m1.reset(line);
            this.m2.reset(line);
            if (this.m1.find(from) && this.m2.find(this.m1.end())) {
                int i = this.m1.end();
                int j = this.m2.start();
                this.value = line.substring(i, j);
                this.next = j;
                return true;
            }
            this.value = null;
            this.next = from;
            return false;
        }
    }

    public static class FilterMatch
    extends Filter {
        private Pattern p = null;
        private Matcher m = null;

        FilterMatch(String regex) {
            this.p = Pattern.compile(regex);
            this.m = this.p.matcher("");
        }

        @Override
        public boolean match(int from, String line) {
            this.m.reset(line);
            if (this.m.find(from)) {
                this.value = this.m.group();
                this.next = this.m.end();
                return true;
            }
            this.value = null;
            this.next = from;
            return false;
        }
    }

    public static class FilterMatchMultiple
    extends FilterMatch {
        FilterMatchMultiple(String regex) {
            super(regex);
        }

        @Override
        public boolean getRepeat() {
            return true;
        }
    }
}

