/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import dk.hkj.util.Complex;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ElectronicUtils {
    public static double[] R125 = new double[]{1.0, 2.0, 5.0, 10.0};
    public static double[] E3 = new double[]{1.0, 2.2, 4.7, 10.0};
    public static double[] E6 = new double[]{1.0, 1.5, 2.2, 3.3, 4.7, 6.8, 10.0};
    public static double[] E12 = new double[]{1.0, 1.2, 1.5, 1.8, 2.2, 2.7, 3.3, 3.9, 4.7, 5.6, 6.8, 8.2, 10.0};
    public static double[] E24 = new double[]{1.0, 1.1, 1.2, 1.3, 1.5, 1.6, 1.8, 2.0, 2.2, 2.4, 2.7, 3.0, 3.3, 3.6, 3.9, 4.3, 4.7, 5.1, 5.6, 6.2, 6.8, 7.5, 8.2, 9.1, 10.0};
    public static double[] E48 = new double[]{1.0, 1.05, 1.1, 1.15, 1.21, 1.27, 1.33, 1.4, 1.47, 1.54, 1.62, 1.69, 1.78, 1.87, 1.96, 2.05, 2.15, 2.26, 2.37, 2.49, 2.61, 2.74, 2.87, 3.01, 3.16, 3.32, 3.48, 3.65, 3.83, 4.02, 4.22, 4.42, 4.64, 4.87, 5.11, 5.36, 5.62, 5.9, 6.19, 6.49, 6.81, 7.15, 7.5, 7.87, 8.25, 8.66, 9.09, 9.53, 10.0};
    public static double[] E96 = new double[]{1.0, 1.02, 1.05, 1.07, 1.1, 1.13, 1.15, 1.18, 1.21, 1.24, 1.27, 1.3, 1.33, 1.37, 1.4, 1.43, 1.47, 1.5, 1.54, 1.58, 1.62, 1.65, 1.69, 1.74, 1.78, 1.82, 1.87, 1.91, 1.96, 2.0, 2.05, 2.1, 2.15, 2.21, 2.26, 2.32, 2.37, 2.43, 2.49, 2.55, 2.61, 2.67, 2.74, 2.8, 2.87, 2.94, 3.01, 3.09, 3.16, 3.24, 3.32, 3.4, 3.48, 3.57, 3.65, 3.74, 3.83, 3.92, 4.02, 4.12, 4.22, 4.32, 4.42, 4.53, 4.64, 4.75, 4.87, 4.99, 5.11, 5.23, 5.36, 5.49, 5.62, 5.76, 5.9, 6.04, 6.19, 6.34, 6.49, 6.65, 6.81, 6.98, 7.15, 7.32, 7.5, 7.68, 7.87, 8.06, 8.25, 8.45, 8.66, 8.87, 9.09, 9.31, 9.53, 9.76, 10.0};
    public static double[] E192 = new double[]{1.0, 1.01, 1.02, 1.04, 1.05, 1.06, 1.07, 1.09, 1.1, 1.11, 1.13, 1.14, 1.15, 1.17, 1.18, 1.2, 1.21, 1.23, 1.24, 1.26, 1.27, 1.29, 1.3, 1.32, 1.33, 1.35, 1.37, 1.38, 1.4, 1.42, 1.43, 1.45, 1.47, 1.49, 1.5, 1.52, 1.54, 1.56, 1.58, 1.6, 1.62, 1.64, 1.65, 1.67, 1.69, 1.72, 1.74, 1.76, 1.78, 1.8, 1.82, 1.84, 1.87, 1.89, 1.91, 1.93, 1.96, 1.98, 2.0, 2.03, 2.05, 2.08, 2.1, 2.13, 2.15, 2.18, 2.21, 2.23, 2.26, 2.29, 2.32, 2.34, 2.37, 2.4, 2.43, 2.46, 2.49, 2.52, 2.55, 2.58, 2.61, 2.64, 2.67, 2.71, 2.74, 2.77, 2.8, 2.84, 2.87, 2.91, 2.94, 2.98, 3.01, 3.05, 3.09, 3.12, 3.16, 3.2, 3.24, 3.28, 3.32, 3.36, 3.4, 3.44, 3.48, 3.52, 3.57, 3.61, 3.65, 3.7, 3.74, 3.79, 3.83, 3.88, 3.92, 3.97, 4.02, 4.07, 4.12, 4.17, 4.22, 4.27, 4.32, 4.37, 4.42, 4.48, 4.53, 4.59, 4.64, 4.7, 4.75, 4.81, 4.87, 4.93, 4.99, 5.05, 5.11, 5.17, 5.23, 5.3, 5.36, 5.42, 5.49, 5.56, 5.62, 5.69, 5.76, 5.83, 5.9, 5.97, 6.04, 6.12, 6.19, 6.26, 6.34, 6.42, 6.49, 6.57, 6.65, 6.73, 6.81, 6.9, 6.98, 7.06, 7.15, 7.23, 7.32, 7.41, 7.5, 7.59, 7.68, 7.77, 7.87, 7.96, 8.06, 8.16, 8.25, 8.35, 8.45, 8.56, 8.66, 8.76, 8.87, 8.98, 9.09, 9.2, 9.31, 9.42, 9.53, 9.65, 9.76, 9.88, 10.0};
    public static double[] C33 = new double[]{1.0, 1.1, 1.2, 1.3, 1.5, 1.6, 1.8, 2.0, 2.2, 2.4, 2.6, 2.7, 3.0, 3.3, 3.5, 3.6, 3.9, 4.0, 4.3, 4.5, 4.7, 5.0, 5.1, 5.6, 6.0, 6.2, 6.8, 7.0, 7.5, 8.0, 8.2, 9.0, 9.1, 10.0};
    public static String[] standards = new String[]{"E3", "E6", "E12", "E24", "E48", "E96", "E192", "R125", "C33"};
    static Map<String, ktyConst> ptcConsts = new HashMap<String, ktyConst>();
    static Map<String, ptcModel> ptcModels = null;

    public static int digitsInSeries(int seriesNo) {
        switch (seriesNo) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 3;
            }
            case 12: {
                return 2;
            }
            case 24: {
                return 2;
            }
            case 48: {
                return 3;
            }
            case 96: {
                return 3;
            }
            case 125: {
                return 1;
            }
            case 192: {
                return 3;
            }
            case 33: {
                return 2;
            }
            case 991: {
                return 1;
            }
            case 992: {
                return 2;
            }
            case 993: {
                return 3;
            }
            case 994: {
                return 3;
            }
        }
        return 0;
    }

    public static int getSeriesNo(String seriesName) {
        if (seriesName.equalsIgnoreCase("E3")) {
            return 0;
        }
        if (seriesName.equalsIgnoreCase("E6")) {
            return 1;
        }
        if (seriesName.equalsIgnoreCase("E12")) {
            return 2;
        }
        if (seriesName.equalsIgnoreCase("E24")) {
            return 3;
        }
        if (seriesName.equalsIgnoreCase("E48")) {
            return 4;
        }
        if (seriesName.equalsIgnoreCase("E96")) {
            return 5;
        }
        if (seriesName.equalsIgnoreCase("E192")) {
            return 6;
        }
        if (seriesName.equalsIgnoreCase("C33")) {
            return 33;
        }
        if (seriesName.equalsIgnoreCase("X9")) {
            return 9991;
        }
        if (seriesName.equalsIgnoreCase("X99")) {
            return 9992;
        }
        if (seriesName.equalsIgnoreCase("X999")) {
            return 9993;
        }
        if (seriesName.equalsIgnoreCase("X9999")) {
            return 9994;
        }
        if (seriesName.equalsIgnoreCase("R125")) {
            return 125;
        }
        return -1;
    }

    public static double[] getSeries(int seriesNo) {
        switch (seriesNo) {
            case 0: {
                return E3;
            }
            case 1: {
                return E6;
            }
            case 2: {
                return E12;
            }
            case 3: {
                return E24;
            }
            case 4: {
                return E48;
            }
            case 5: {
                return E96;
            }
            case 6: {
                return E192;
            }
            case 12: {
                return E12;
            }
            case 24: {
                return E24;
            }
            case 48: {
                return E48;
            }
            case 96: {
                return E96;
            }
            case 125: {
                return R125;
            }
            case 192: {
                return E192;
            }
            case 33: {
                return C33;
            }
            case 991: {
                double[] s = new double[10];
                int i = 0;
                while (i < 10) {
                    s[i] = i + 1;
                    ++i;
                }
                return s;
            }
            case 992: {
                double[] s = new double[100];
                int i = 0;
                while (i < 100) {
                    s[i] = (double)(i + 1) / 10.0;
                    ++i;
                }
                return s;
            }
            case 993: {
                double[] s = new double[1000];
                int i = 0;
                while (i < 1000) {
                    s[i] = (double)(i + 1) / 100.0;
                    ++i;
                }
                return s;
            }
            case 994: {
                double[] s = new double[10000];
                int i = 0;
                while (i < 10000) {
                    s[i] = (double)(i + 1) / 1000.0;
                    ++i;
                }
                return s;
            }
        }
        return E192;
    }

    public static String getSeriesName(int seriesNo) {
        if (seriesNo < 0) {
            return "";
        }
        double[] s = ElectronicUtils.getSeries(seriesNo);
        if (s.equals(R125)) {
            return "R125";
        }
        if (s.equals(C33)) {
            return "C33";
        }
        if (seriesNo == 991) {
            return "X9";
        }
        if (seriesNo == 992) {
            return "X99";
        }
        if (seriesNo == 993) {
            return "X999";
        }
        if (seriesNo == 994) {
            return "X9999";
        }
        return "E" + (s.length - 1);
    }

    public static double findValue(int seriesNo, double value) {
        return ElectronicUtils.findValue(ElectronicUtils.getSeries(seriesNo), value);
    }

    public static double findValueAbove(int seriesNo, double value) {
        SeriesIndex si = ElectronicUtils.findIndex(seriesNo, value);
        if (value > si.getValue()) {
            si.next();
        }
        return si.getValue();
    }

    public static double findValueBelow(int seriesNo, double value) {
        SeriesIndex si = ElectronicUtils.findIndex(seriesNo, value);
        if (value < si.getValue()) {
            si.previous();
        }
        return si.getValue();
    }

    public static SeriesIndex findIndex(int seriesNo, double value) {
        return ElectronicUtils.findIndex(ElectronicUtils.getSeries(seriesNo), value);
    }

    static SeriesIndex findIndex(double[] series, double value) {
        double delta = Double.MAX_VALUE;
        int n = 0;
        if (value <= Double.MIN_VALUE || Double.isInfinite(value)) {
            return new SeriesIndex(null, 0, 0.0);
        }
        double f = 1.0;
        f = Math.pow(10.0, (int)Math.floor(Math.log10(value)));
        value /= f;
        int i = 0;
        while (i < series.length) {
            double d = Math.abs(series[i] - value) / series[i];
            if (d < delta) {
                delta = d;
                n = i;
            } else if (d > delta) break;
            ++i;
        }
        return new SeriesIndex(series, n, f);
    }

    static double findValue(double[] series, double value) {
        SeriesIndex si = ElectronicUtils.findIndex(series, value);
        return si.getValue();
    }

    public static double findE3(double v) {
        return ElectronicUtils.findValue(E3, v);
    }

    public static double findE6(double v) {
        return ElectronicUtils.findValue(E6, v);
    }

    public static double findE12(double v) {
        return ElectronicUtils.findValue(E12, v);
    }

    public static double findE24(double v) {
        return ElectronicUtils.findValue(E24, v);
    }

    public static double findE48(double v) {
        return ElectronicUtils.findValue(E48, v);
    }

    public static double findE96(double v) {
        return ElectronicUtils.findValue(E96, v);
    }

    public static double findE192(double v) {
        return ElectronicUtils.findValue(E192, v);
    }

    public static double[] findRser(int seriesNo, double value, boolean checkSingleResistor) {
        if (value <= Double.MIN_VALUE) {
            return new double[]{0.0, 0.0};
        }
        double[] series = ElectronicUtils.getSeries(seriesNo);
        SeriesIndex si = ElectronicUtils.findIndex(series, value / 2.0);
        double[] rr = new double[]{0.0, 0.0, Double.MAX_VALUE};
        int i = 0;
        while (i < series.length) {
            double x = (si.getValue() - value) / value;
            if (checkSingleResistor && Math.abs(x) <= Math.abs(rr[2])) {
                rr[0] = si.getValue();
                rr[1] = 0.0;
                rr[2] = x;
            }
            if ((x = value - si.getValue()) >= 4.9E-323) {
                double r = ElectronicUtils.findValue(series, x);
                x = (si.getValue() + r - value) / value;
                if (Math.abs(x) < Math.abs(rr[2])) {
                    rr[0] = si.getValue();
                    rr[1] = r;
                    rr[2] = x;
                }
            }
            si.next();
            ++i;
        }
        return rr;
    }

    public static double[] findRpar(int seriesNo, double value, boolean checkSingleResistor) {
        if (value <= Double.MIN_VALUE) {
            return new double[]{0.0, 0.0};
        }
        double[] series = ElectronicUtils.getSeries(seriesNo);
        SeriesIndex si = ElectronicUtils.findIndex(seriesNo, value);
        double[] rr = new double[]{0.0, 0.0, Double.MAX_VALUE};
        int i = 0;
        while (i < series.length) {
            double x = (si.getValue() - value) / value;
            if (checkSingleResistor && Math.abs(x) <= Math.abs(rr[2])) {
                rr[0] = si.getValue();
                rr[1] = Double.POSITIVE_INFINITY;
                rr[2] = x;
            }
            if ((x = 1.0 / (1.0 / value - 1.0 / si.getValue())) >= 0.0 && !Double.isInfinite(x)) {
                double r = ElectronicUtils.findValue(series, x);
                x = 1.0 / (1.0 / r + 1.0 / si.getValue());
                if (Math.abs(x = (x - value) / value) < Math.abs(rr[2])) {
                    rr[0] = si.getValue();
                    rr[1] = r;
                    rr[2] = x;
                }
            }
            si.next();
            ++i;
        }
        return rr;
    }

    public static double[] findR(int seriesNo, double value) {
        SeriesIndex si = ElectronicUtils.findIndex(seriesNo, value);
        double[] rr = new double[]{0.0, Double.MAX_VALUE};
        rr[0] = si.getValue();
        rr[1] = (si.getValue() - value) / value;
        return rr;
    }

    public static boolean isParBest(double[] par, double[] ser) {
        if (Math.abs(Math.abs(par[2]) - Math.abs(ser[2])) < 1.0E-5) {
            double rs;
            double rp = Math.abs(Math.abs(par[1] / par[0]) - 1.0);
            return rp < (rs = Math.abs(Math.abs(ser[1] / ser[0]) - 1.0));
        }
        return !(Math.abs(ser[2]) < Math.abs(par[2]));
    }

    public static NtcCoefficients calcNtcCoefficients(double r1, double t1, double r2, double t2) {
        NtcCoefficients nc = new NtcCoefficients();
        if (Math.abs(t1 - 25.0) > Math.abs(t2 - 25.0)) {
            nc.beta = Math.log(r1 / r2) / (1.0 / (t1 + 273.15) - 1.0 / (t2 + 273.15));
            nc.r0 = r2;
            nc.t0 = t2;
        } else {
            nc.beta = Math.log(r2 / r1) / (1.0 / (t2 + 273.15) - 1.0 / (t1 + 273.15));
            nc.r0 = r1;
            nc.t0 = t1;
        }
        nc.beta = Math.log(r1 / r2) / (1.0 / (t1 + 273.15) - 1.0 / (t2 + 273.15));
        double l1 = Math.log(r1);
        double l2 = Math.log(r2);
        double y1 = 1.0 / (t1 + 273.15);
        double y2 = 1.0 / (t2 + 273.15);
        double la2 = (y2 - y1) / (l2 - l1);
        nc.b = la2 * 10000.0;
        nc.a = (y1 - nc.b * l1) * 1000.0;
        nc.c = 0.0;
        return nc;
    }

    public static NtcCoefficients calcNtcCoefficients(double r1, double t1, double r2, double t2, double r3, double t3) {
        NtcCoefficients nc = new NtcCoefficients();
        if (Math.abs(t1 - 25.0) > Math.abs(t2 - 25.0)) {
            nc.beta = Math.log(r1 / r2) / (1.0 / (t1 + 273.15) - 1.0 / (t2 + 273.15));
            nc.r0 = r2;
            nc.t0 = t2;
        } else {
            nc.beta = Math.log(r2 / r1) / (1.0 / (t2 + 273.15) - 1.0 / (t1 + 273.15));
            nc.r0 = r1;
            nc.t0 = t1;
        }
        double l1 = Math.log(r1);
        double l2 = Math.log(r2);
        double l3 = Math.log(r3);
        double y1 = 1.0 / (t1 + 273.15);
        double y2 = 1.0 / (t2 + 273.15);
        double y3 = 1.0 / (t3 + 273.15);
        double la2 = (y2 - y1) / (l2 - l1);
        double la3 = (y3 - y1) / (l3 - l1);
        nc.c = (la3 - la2) / (l3 - l2) / (l1 + l2 + l3);
        nc.b = la2 - nc.c * (l1 * l1 + l1 * l2 + l2 * l2);
        nc.a = y1 - (nc.b + l1 * l1 * nc.c) * l1;
        return nc;
    }

    public static double ntcSHRtoT(NtcCoefficients ntcCoefficients, double r) {
        double lnr = Math.log(r);
        double tx = ntcCoefficients.a + ntcCoefficients.b * lnr + ntcCoefficients.c * lnr * lnr * lnr;
        return 1.0 / tx - 273.15;
    }

    public static double ntcBetaRtoT(NtcCoefficients ntcCoefficients, double r) {
        double r8 = ntcCoefficients.r0 * Math.exp(-ntcCoefficients.beta / (ntcCoefficients.t0 + 273.15));
        double t = ntcCoefficients.beta / Math.log(r / r8);
        return t - 273.15;
    }

    public static double ntcSHTtoR(NtcCoefficients ntcCoefficients, double t) {
        double r = 10000.0;
        double dr = 0.5;
        double tt = 25.0;
        int n = 100;
        boolean s = false;
        do {
            if (tt > t) {
                if (s) {
                    s = false;
                    dr /= 2.0;
                }
                r *= 1.0 + dr;
                continue;
            }
            if (!s) {
                s = true;
                dr /= 2.0;
            }
            r /= 1.0 + dr;
        } while (Math.abs(t - (tt = ElectronicUtils.ntcSHRtoT(ntcCoefficients, r))) >= 1.0E-5 && --n > 0);
        return n == 0 ? Double.NaN : r;
    }

    public static double ntcBetaTtoR(NtcCoefficients ntcCoefficients, double t) {
        return ntcCoefficients.r0 * Math.exp(ntcCoefficients.beta * (1.0 / (t + 273.15) - 1.0 / (ntcCoefficients.t0 + 273.15)));
    }

    private static RTD getRTD(String type, double r0) {
        RTD rtd = null;
        if (type.equalsIgnoreCase("PT")) {
            rtd = new RTD_PT(r0);
        } else if (type.startsWith("ITS-90")) {
            rtd = new RTD_ITS(r0);
        } else if (type.startsWith("CU")) {
            rtd = new RTD_CU(r0);
        } else if (type.equalsIgnoreCase("NI")) {
            rtd = new RTD_NI(r0);
        }
        return rtd;
    }

    public static double rtdTtoR(String type, double r0, double temp) {
        RTD rtd = ElectronicUtils.getRTD(type, r0);
        return rtd == null ? 0.0 : rtd.calcR(temp);
    }

    public static double rtdRtoT(String type, double r0, double r) {
        RTD rtd = ElectronicUtils.getRTD(type, r0);
        return rtd == null ? 0.0 : rtd.calcT(r);
    }

    private static ptcModel getModel(String type) {
        ptcModel m;
        if (ptcModels == null) {
            ptcModels = new HashMap<String, ptcModel>();
            ptcModels.put("KTY81/110", new ptcModel("KTY81/110", 990.0, 1010.0, "KTY81-1"));
            ptcModels.put("KTY81/120", new ptcModel("KTY81/120", 980.0, 1020.0, "KTY81-1"));
            ptcModels.put("KTY81/121", new ptcModel("KTY81/121", 980.0, 1000.0, "KTY81-1"));
            ptcModels.put("KTY81/122", new ptcModel("KTY81/122", 1000.0, 1020.0, "KTY81-1"));
            ptcModels.put("KTY81/150", new ptcModel("KTY81/150", 950.0, 1050.0, "KTY81-1"));
            ptcModels.put("KTY81/210", new ptcModel("KTY81/210", 1980.0, 2020.0, "KTY81-2"));
            ptcModels.put("KTY81/220", new ptcModel("KTY81/220", 1960.0, 2040.0, "KTY81-2"));
            ptcModels.put("KTY81/221", new ptcModel("KTY81/221", 1960.0, 2000.0, "KTY81-2"));
            ptcModels.put("KTY81/222", new ptcModel("KTY81/222", 2000.0, 2040.0, "KTY81-2"));
            ptcModels.put("KTY81/250", new ptcModel("KTY81/250", 1900.0, 2100.0, "KTY81-2"));
            ptcModels.put("KTY82/110", new ptcModel("KTY82/110", 990.0, 1010.0, "KTY82-1"));
            ptcModels.put("KTY82/120", new ptcModel("KTY82/120", 980.0, 1020.0, "KTY82-1"));
            ptcModels.put("KTY82/121", new ptcModel("KTY82/121", 980.0, 1000.0, "KTY82-1"));
            ptcModels.put("KTY82/122", new ptcModel("KTY82/122", 1000.0, 1020.0, "KTY82-1"));
            ptcModels.put("KTY82/150", new ptcModel("KTY82/150", 950.0, 1050.0, "KTY82-1"));
            ptcModels.put("KTY82/151", new ptcModel("KTY82/151", 980.0, 1000.0, "KTY82-1"));
            ptcModels.put("KTY82/210", new ptcModel("KTY82/210", 1980.0, 2020.0, "KTY82-2"));
            ptcModels.put("KTY82/220", new ptcModel("KTY82/220", 1960.0, 2040.0, "KTY82-2"));
            ptcModels.put("KTY82/221", new ptcModel("KTY82/221", 1960.0, 2000.0, "KTY82-2"));
            ptcModels.put("KTY82/222", new ptcModel("KTY82/222", 2000.0, 2040.0, "KTY82-2"));
            ptcModels.put("KTY82/250", new ptcModel("KTY82/250", 1900.0, 2100.0, "KTY82-2"));
            ptcModels.put("KTY82/251", new ptcModel("KTY82/251", 1900.0, 2000.0, "KTY82-2"));
            ptcModels.put("KTY82/252", new ptcModel("KTY82/252", 2000.0, 2100.0, "KTY82-2"));
            ptcModels.put("KTY83/110", new ptcModel("KTY83/110", 990.0, 1010.0, "KTY83"));
            ptcModels.put("KTY83/120", new ptcModel("KTY83/120", 980.0, 1020.0, "KTY83"));
            ptcModels.put("KTY83/121", new ptcModel("KTY83/121", 980.0, 1000.0, "KTY83"));
            ptcModels.put("KTY83/122", new ptcModel("KTY83/122", 1000.0, 1020.0, "KTY83"));
            ptcModels.put("KTY83/150", new ptcModel("KTY83/150", 950.0, 1050.0, "KTY83"));
            ptcModels.put("KTY83/151", new ptcModel("KTY83/151", 950.0, 1000.0, "KTY83"));
            ptcModels.put("KT83A", new ptcModel("KTY83/110", 990.0, 1010.0, "KTY83"));
            ptcModels.put("KT83C", new ptcModel("KTY83/120", 980.0, 1020.0, "KTY83"));
            ptcModels.put("KT83D", new ptcModel("KTY83/121", 980.0, 1000.0, "KTY83"));
            ptcModels.put("KT83E", new ptcModel("KTY83/122", 1000.0, 1020.0, "KTY83"));
            ptcModels.put("KT83H", new ptcModel("KTY83/150", 950.0, 1050.0, "KTY83"));
            ptcModels.put("KT83K", new ptcModel("KTY83/151", 950.0, 1000.0, "KTY83"));
            ptcModels.put("KTY84/130", new ptcModel("KTY84/130", 970.0, 1030.0, "KTY84"));
            ptcModels.put("KTY84/150", new ptcModel("KTY84/150", 950.0, 1050.0, "KTY84"));
            ptcModels.put("KTY84/151", new ptcModel("KTY84/151", 950.0, 1000.0, "KTY84"));
            ptcModels.put("KT84L", new ptcModel("KTY84/130", 970.0, 1030.0, "KTY84"));
            ptcModels.put("KT84M", new ptcModel("KTY84/150", 950.0, 1050.0, "KTY84"));
            ptcModels.put("KT84O", new ptcModel("KTY84/151", 950.0, 1000.0, "KTY84"));
            ptcModels.put("KT100", new ptcModel("KT100", 1940.0, 2060.0, "KTY"));
            ptcModels.put("KT110", new ptcModel("KT110", 1940.0, 2060.0, "KTY"));
            ptcModels.put("KT130", new ptcModel("KT130", 1940.0, 2060.0, "KTY"));
            ptcModels.put("KT210", new ptcModel("KT210", 970.0, 1030.0, "KTY"));
            ptcModels.put("KT230", new ptcModel("KT230", 970.0, 1030.0, "KTY"));
            ptcModels.put("T1", new ptcModel("KT130", 1940.0, 2060.0, "KTY"));
            ptcModels.put("N1", new ptcModel("KT210", 970.0, 1030.0, "KTY"));
            ptcModels.put("KTY10-5", new ptcModel("KTY10-5", 1950.0, 1990.0, "KTY"));
            ptcModels.put("KTY10-6", new ptcModel("KTY10-5", 1980.0, 2020.0, "KTY"));
            ptcModels.put("KTY10-62", new ptcModel("KTY10-5", 1990.0, 2010.0, "KTY"));
            ptcModels.put("KTY10-7", new ptcModel("KTY10-5", 2010.0, 2050.0, "KTY"));
            ptcModels.put("KTY11-5", new ptcModel("KTY11-5", 1950.0, 1990.0, "KTY"));
            ptcModels.put("KTY11-6", new ptcModel("KTY11-6", 1980.0, 2020.0, "KTY"));
            ptcModels.put("KTY11-7", new ptcModel("KTY11-7", 2010.0, 2050.0, "KTY"));
            ptcModels.put("KTY13-5", new ptcModel("KTY13-5", 1950.0, 1990.0, "KTY"));
            ptcModels.put("KTY13-6", new ptcModel("KTY13-6", 1980.0, 2020.0, "KTY"));
            ptcModels.put("KTY13-7", new ptcModel("KTY13-7", 2010.0, 2050.0, "KTY"));
            ptcModels.put("T5", new ptcModel("KTY11-5", 1950.0, 1990.0, "KTY"));
            ptcModels.put("T6", new ptcModel("KTY11-6", 1980.0, 2020.0, "KTY"));
            ptcModels.put("T7", new ptcModel("KTY11-7", 2010.0, 2050.0, "KTY"));
            ptcModels.put("KTY21-5", new ptcModel("KTY21-5", 975.0, 995.0, "KTY"));
            ptcModels.put("KTY21-6", new ptcModel("KTY21-6", 990.0, 1010.0, "KTY"));
            ptcModels.put("KTY21-7", new ptcModel("KTY21-7", 1005.0, 1025.0, "KTY"));
            ptcModels.put("KTY23-5", new ptcModel("KTY23-5", 975.0, 995.0, "KTY"));
            ptcModels.put("KTY23-6", new ptcModel("KTY23-6", 990.0, 1010.0, "KTY"));
            ptcModels.put("KTY23-7", new ptcModel("KTY23-7", 1005.0, 1025.0, "KTY"));
            ptcModels.put("N5", new ptcModel("KTY21-5", 975.0, 995.0, "KTY"));
            ptcModels.put("N6", new ptcModel("KTY21-6", 990.0, 1010.0, "KTY"));
            ptcModels.put("N7", new ptcModel("KTY21-7", 1005.0, 1025.0, "KTY"));
            ptcModels.put("TFPT100", new ptcModel("TFPT", 100.0, 0.0, "TFPT"));
            ptcModels.put("TFPT120", new ptcModel("TFPT", 120.0, 0.0, "TFPT"));
            ptcModels.put("TFPT150", new ptcModel("TFPT", 150.0, 0.0, "TFPT"));
            ptcModels.put("TFPT180", new ptcModel("TFPT", 180.0, 0.0, "TFPT"));
            ptcModels.put("TFPT220", new ptcModel("TFPT", 220.0, 0.0, "TFPT"));
            ptcModels.put("TFPT270", new ptcModel("TFPT", 270.0, 0.0, "TFPT"));
            ptcModels.put("TFPT330", new ptcModel("TFPT", 330.0, 0.0, "TFPT"));
            ptcModels.put("TFPT390", new ptcModel("TFPT", 390.0, 0.0, "TFPT"));
            ptcModels.put("TFPT470", new ptcModel("TFPT", 470.0, 0.0, "TFPT"));
            ptcModels.put("TFPT560", new ptcModel("TFPT", 560.0, 0.0, "TFPT"));
            ptcModels.put("TFPT680", new ptcModel("TFPT", 680.0, 0.0, "TFPT"));
            ptcModels.put("TFPT820", new ptcModel("TFPT", 8200.0, 0.0, "TFPT"));
            ptcModels.put("TFPT1K", new ptcModel("TFPT", 1000.0, 0.0, "TFPT"));
            ptcModels.put("TFPT1K2", new ptcModel("TFPT", 1200.0, 0.0, "TFPT"));
            ptcModels.put("TFPT1K5", new ptcModel("TFPT", 1500.0, 0.0, "TFPT"));
            ptcModels.put("TFPT1K8", new ptcModel("TFPT", 1800.0, 0.0, "TFPT"));
            ptcModels.put("TFPT2K2", new ptcModel("TFPT", 2200.0, 0.0, "TFPT"));
            ptcModels.put("TFPT2K7", new ptcModel("TFPT", 2700.0, 0.0, "TFPT"));
            ptcModels.put("TFPT3K3", new ptcModel("TFPT", 3300.0, 0.0, "TFPT"));
            ptcModels.put("TFPT3K9", new ptcModel("TFPT", 3900.0, 0.0, "TFPT"));
            ptcModels.put("TFPT4K7", new ptcModel("TFPT", 4700.0, 0.0, "TFPT"));
            ptcModels.put("TFPT5K", new ptcModel("TFPT", 5000.0, 0.0, "TFPT"));
            ptcModels.put("TFPT5K6", new ptcModel("TFPT", 5600.0, 0.0, "TFPT"));
            ptcModels.put("TFPT6K8", new ptcModel("TFPT", 6800.0, 0.0, "TFPT"));
            ptcModels.put("TFPT8K2", new ptcModel("TFPT", 8200.0, 0.0, "TFPT"));
            ptcModels.put("TFPT10K", new ptcModel("TFPT", 10000.0, 0.0, "TFPT"));
            ptcConsts.put("KTY", new ktyConst("KTY", 1.0, 0.00788, 1.937E-5, 0.0, 3.0, 25.0, 1000.0, -50.0, 150.0));
            ptcConsts.put("KTY81-1", new ktyConst("KTY81-1", 1.0, 0.007874, 1.874E-5, -3.42E-8, 3.7, 25.0, 100.0, -55.0, 150.0));
            ptcConsts.put("KTY81-2", new ktyConst("KTY81-2", 1.0, 0.007874, 1.874E-5, -1.096E-6, 3.0, 25.0, 100.0, -55.0, 150.0));
            ptcConsts.put("KTY82-1", new ktyConst("KTY82-1", 1.0, 0.007874, 1.874E-5, -3.42E-8, 3.7, 25.0, 100.0, -55.0, 150.0));
            ptcConsts.put("KTY82-2", new ktyConst("KTY82-2", 1.0, 0.007874, 1.874E-5, -3.096E-6, 3.0, 25.0, 100.0, -55.0, 150.0));
            ptcConsts.put("KTY83", new ktyConst("KTY83", 1.0, 0.007635, 1.731E-5, 0.0, 0.0, 25.0, 1000.0, -55.0, 175.0));
            ptcConsts.put("KTY84", new ktyConst("KTY84", 1.0, 0.00612, 1.1E-5, -3.14E-8, 3.6, 100.0, 250.0, -40.0, 300.0));
            ptcConsts.put("TFPT", new ktyConst("TFPT", 0.90014, 0.00387235, 4.86825E-6, 1.37559E-9, 3.0, 0.0, -100.0, -55.0, 150.0));
        }
        if ((m = ptcModels.get(type.toUpperCase())) == null) {
            m = ptcModels.get("KTY" + type.toUpperCase());
        }
        return m;
    }

    public static double ptcTtoR(String type, double t) {
        return ElectronicUtils.ptcTtoR(type, t, -1.0);
    }

    public static double ptcTtoR(String type, double t, double rref) {
        ptcModel m = ElectronicUtils.getModel(type);
        if (m == null) {
            return Double.NaN;
        }
        return m.getConst().calcR(rref >= m.rlow && rref <= m.rhigh ? rref : (m.rlow + m.rhigh) / 2.0, t);
    }

    public static double ptcRtoT(String type, double r) {
        return ElectronicUtils.ptcRtoT(type, r, -1.0);
    }

    public static double ptcRtoT(String type, double r, double rref) {
        ptcModel m = ElectronicUtils.getModel(type);
        if (m == null) {
            return Double.NaN;
        }
        return m.getConst().calcT(rref >= m.rlow && rref <= m.rhigh ? rref : (m.rlow + m.rhigh) / 2.0, r);
    }

    public static ptcModel ptcParams(String type) {
        return ElectronicUtils.getModel(type);
    }

    public static String ptcTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(ptcModels.keySet());
        list.sort(null);
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static double vdivLowR(double vin, double highR, double vout) {
        double i = (vin - vout) / highR;
        return vout / i;
    }

    public static double[] vdiv(double vin, double r1, double r2) {
        double[] result = new double[]{vin / (r1 + r2) * r2, vin / (r1 + r2)};
        return result;
    }

    private static double[] vdivCalc(int seriesNo, double vin, double vout, double r1) {
        double[] result = new double[5];
        SeriesIndex r2 = ElectronicUtils.findIndex(seriesNo, vout / ((vin - vout) / r1));
        double avout = vin / (r1 + r2.getValue()) * r2.getValue();
        double tol = (avout - vout) / vout;
        result[0] = r1;
        result[1] = r2.getValue();
        result[2] = avout;
        result[3] = vin / (r1 + r2.getValue());
        result[4] = tol;
        return result;
    }

    public static double[] vdiv(int seriesNo, double vin, double vout, double current) {
        double[] r;
        double[] result = new double[5];
        int s = vin < 0.0 ? -1 : 1;
        vin = Math.abs(vin);
        int n = (ElectronicUtils.getSeries(seriesNo).length - 1) / 4;
        SeriesIndex r1 = ElectronicUtils.findIndex(seriesNo, (vin - vout) / current);
        result = ElectronicUtils.vdivCalc(seriesNo, vin, vout, r1.getValue());
        int j = 0;
        while (j < n) {
            r1.previous();
            r = ElectronicUtils.vdivCalc(seriesNo, vin, vout, r1.getValue());
            if (Math.abs(r[4]) < Math.abs(result[4])) {
                result = r;
            }
            ++j;
        }
        r1 = ElectronicUtils.findIndex(seriesNo, (vin - vout) / current);
        j = 0;
        while (j < n) {
            r1.next();
            r = ElectronicUtils.vdivCalc(seriesNo, vin, vout, r1.getValue());
            if (Math.abs(r[4]) < Math.abs(result[4])) {
                result = r;
            }
            ++j;
        }
        if (s < 0) {
            result[2] = -result[2];
        }
        return result;
    }

    public static double[] vdiv2(int seriesNo, double vin, double vout, double current) {
        double[] result = new double[6];
        int s = vin < 0.0 ? -1 : 1;
        vin = Math.abs(vin);
        SeriesIndex r1 = ElectronicUtils.findIndex(seriesNo, (vin - vout) / current);
        double r2 = vout / ((vin - vout) / r1.getValue());
        double[] f = ElectronicUtils.findRpar(seriesNo, r2, true);
        double rpar = f[0];
        if (!Double.isInfinite(f[1])) {
            rpar = 1.0 / (1.0 / f[0] + 1.0 / f[1]);
        }
        result[0] = r1.getValue();
        result[1] = f[0];
        result[2] = f[1];
        result[3] = (double)s * vin / (r1.getValue() + rpar) * rpar;
        result[4] = vin / (r1.getValue() + rpar);
        result[5] = (result[3] - vout) / vout;
        return result;
    }

    public static Complex par(Complex v1, Complex v2) {
        if (v1.isZero() || v2.isZero()) {
            return new Complex();
        }
        return v1.reciprocal().add(v2.reciprocal()).reciprocal();
    }

    public static Complex par(Complex v1, Complex v2, Complex v3) {
        if (v1.isZero() || v2.isZero() || v3.isZero()) {
            return new Complex();
        }
        return v1.reciprocal().add(v2.reciprocal()).add(v3.reciprocal()).reciprocal();
    }

    public static Complex cpxC(double freq, double c) {
        return new Complex(0.0, -1.0 / (freq * 2.0 * Math.PI * c));
    }

    public static Complex cpxC(double freq, double c, double rs) {
        return new Complex(rs, -1.0 / (freq * 2.0 * Math.PI * c));
    }

    public static Complex cpxL(double freq, double l) {
        return new Complex(0.0, freq * 2.0 * Math.PI * l);
    }

    public static Complex cpxL(double freq, double l, double rs) {
        return new Complex(rs, freq * 2.0 * Math.PI * l);
    }

    public static Complex cpxCLRs(double freq, double c, double l, double rs) {
        return ElectronicUtils.cpxC(freq, c).add(ElectronicUtils.cpxL(freq, l)).add(ElectronicUtils.cpxR(rs));
    }

    public static Complex cpxCLRs(double freq, double c, double l, double rs, double rp) {
        return ElectronicUtils.par(ElectronicUtils.cpxC(freq, c).add(ElectronicUtils.cpxL(freq, l)).add(ElectronicUtils.cpxR(rs)), ElectronicUtils.cpxR(rp));
    }

    public static Complex cpxCLRp(double freq, double c, double l, double rs) {
        return ElectronicUtils.par(ElectronicUtils.cpxC(freq, c), ElectronicUtils.cpxL(freq, l)).add(ElectronicUtils.cpxR(rs));
    }

    public static Complex cpxCLRp(double freq, double c, double l, double rs, double rp) {
        return ElectronicUtils.par(ElectronicUtils.cpxC(freq, c), ElectronicUtils.cpxL(freq, l), ElectronicUtils.cpxR(rp)).add(ElectronicUtils.cpxR(rs));
    }

    public static Complex cpxR(double r) {
        return new Complex(r, 0.0);
    }

    public static Complex cpxR(double freq, double r) {
        return new Complex(r, 0.0);
    }

    public static Double cpxToQ(Complex v) {
        return Math.abs(v.imag() / v.real());
    }

    public static Double cpxToZ(Complex v) {
        return v.abs();
    }

    public static Double cpxToPhase(Complex v) {
        return v.phase() * 180.0 / Math.PI;
    }

    public static double[] cpxToCLRs(Double freq, Complex v) {
        double[] vv = new double[]{v.imag() < 0.0 ? 0.15915494309189535 / freq / v.imag() : v.imag() / 2.0 / Math.PI / freq, v.real()};
        return vv;
    }

    public static double[] cpxToCLRp(Double freq, Complex v) {
        double[] vv = new double[2];
        double xx = v.real() * v.real() + v.imag() * v.imag();
        double Rp = xx / v.real();
        double Xp = xx / v.imag();
        vv[0] = Xp < 0.0 ? 0.15915494309189535 / freq / Xp : Xp / 2.0 / Math.PI / freq;
        vv[1] = Rp;
        return vv;
    }

    public static class NtcCoefficients {
        public double a = 0.0;
        public double b = 0.0;
        public double c = 0.0;
        public double r0 = 0.0;
        public double t0 = 0.0;
        public double beta = 0.0;
    }

    private static abstract class RTD {
        protected double r0;
        protected double t0;

        public RTD(double r0) {
            this.r0 = r0;
            this.t0 = 0.0;
        }

        public RTD(double r0, double t0) {
            this.r0 = r0;
            this.t0 = t0;
        }

        public abstract double calcR(double var1);

        public double calcT(double r) {
            double rr = this.r0;
            double t = 0.0;
            double dt = 100.0;
            int n = 100;
            boolean s = false;
            do {
                if (rr > r) {
                    if (s) {
                        s = false;
                        dt /= 2.0;
                    }
                    t -= dt;
                    continue;
                }
                if (!s) {
                    s = true;
                    dt /= 2.0;
                }
                t += dt;
            } while (Math.abs(r - (rr = this.calcR(t))) >= 1.0E-4 && --n > 0);
            if (Double.isNaN(this.calcR(t))) {
                return Double.NaN;
            }
            return t;
        }
    }

    private static class RTD_CU
    extends RTD {
        protected double alpha = 0.00427;

        public RTD_CU(double r0) {
            super(r0);
        }

        public RTD_CU(double r0, double t0) {
            super(r0, t0);
        }

        @Override
        public double calcR(double temp) {
            return this.r0 * (1.0 + this.alpha * (temp - this.t0));
        }
    }

    private static class RTD_ITS
    extends RTD {
        protected double a = 0.0039848;
        protected double b = -5.87E-7;
        protected double c = -4.0E-12;

        public RTD_ITS(double r0) {
            super(r0);
        }

        @Override
        public double calcR(double temp) {
            if (temp < 0.0) {
                return this.r0 * (1.0 + this.a * temp + this.b * temp * temp + this.c * temp * temp * temp * (temp - 100.0));
            }
            return this.r0 * (1.0 + this.a * temp + this.b * temp * temp);
        }

        @Override
        public double calcT(double r) {
            if (r < this.r0) {
                return super.calcT(r);
            }
            return (Math.sqrt(this.a * this.a - 4.0 * this.b * (1.0 - r / this.r0)) - this.a) / 2.0 / this.b;
        }
    }

    private static class RTD_NI
    extends RTD {
        public RTD_NI(double r0) {
            super(r0);
        }

        public RTD_NI(double r0, double t0) {
            super(r0, t0);
        }

        @Override
        public double calcR(double temp) {
            double x = temp - this.t0;
            return (4.492E-6 * x * x * x + 0.007311096 * x * x + 5.455781164 * x + 999.29100412) / 1000.0 * this.r0;
        }
    }

    private static class RTD_PT
    extends RTD {
        protected double a = 0.0039083;
        protected double b = -5.775E-7;
        protected double c = -4.183E-12;

        public RTD_PT(double r0) {
            super(r0);
        }

        @Override
        public double calcR(double temp) {
            if (temp < 0.0) {
                return this.r0 * (1.0 + this.a * temp + this.b * temp * temp + this.c * temp * temp * temp * (temp - 100.0));
            }
            return this.r0 * (1.0 + this.a * temp + this.b * temp * temp);
        }

        @Override
        public double calcT(double r) {
            if (r < this.r0) {
                return super.calcT(r);
            }
            return (Math.sqrt(this.a * this.a - 4.0 * this.b * (1.0 - r / this.r0)) - this.a) / 2.0 / this.b;
        }
    }

    public static class SeriesIndex {
        private double[] series;
        private int index;
        private double scale;

        SeriesIndex(double[] series, int index, double scale) {
            this.series = series;
            this.index = index;
            this.scale = scale;
        }

        public void previous() {
            if (this.series == null) {
                return;
            }
            --this.index;
            if (this.index < 0) {
                this.index = this.series.length - 2;
                this.scale /= 10.0;
            }
        }

        public void next() {
            if (this.series == null) {
                return;
            }
            ++this.index;
            if (this.index >= this.series.length - 1) {
                this.index = 0;
                this.scale *= 10.0;
            }
        }

        public int getIndex() {
            return this.index;
        }

        public double getScale() {
            return this.scale;
        }

        public double getValue() {
            return this.series == null ? 0.0 : this.series[this.index] * this.scale;
        }

        public double getSeriesEntry() {
            return this.series == null ? 0.0 : this.series[this.index];
        }

        public String toString() {
            return "E" + (this.series.length - 1) + "  " + StringUtil.formatDoubleEE(this.getValue());
        }
    }

    public static class ktyConst {
        public String type;
        public double a;
        public double b;
        public double c;
        public double d;
        public double pwr;
        public double tref;
        public double ti;
        public double min;
        public double max;

        public ktyConst(String type, double a, double b, double c, double d, double pwr, double tref, double ti, double min, double max) {
            this.type = type;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.pwr = pwr;
            this.tref = tref;
            this.ti = ti;
            this.min = min;
            this.max = max;
        }

        public double calcR(double rref, double t) {
            if (t < this.min - 10.0 || t > this.max + 10.0) {
                return Double.NaN;
            }
            double x = this.a + this.b * (t - this.tref) + this.c * Math.pow(t - this.tref, 2.0) + (t > this.ti ? this.d * Math.pow(t + (this.ti > 0.0 ? -this.ti : 0.0), this.pwr) : 0.0);
            return x * rref;
        }

        public double calcT(double rref, double r) {
            double t;
            double tmin = this.min - 10.0;
            double tmax = this.max + 10.0;
            int n = 0;
            do {
                double rr;
                if ((rr = this.calcR(rref, t = (tmin + tmax) / 2.0)) < r) {
                    tmin = t;
                } else if (rr > r) {
                    tmax = t;
                } else {
                    return t;
                }
                if (++n <= 100) continue;
                return Double.NaN;
            } while (Math.abs(tmin - tmax) > 3.0E-4);
            if (t < this.min - 5.0 || t > this.max + 5.0) {
                return Double.NaN;
            }
            return t;
        }

        public Var getParams() {
            Var v = Var.createStruct();
            v.addVar(Var.createValue("type", this.type));
            v.addVar(Var.createValue("A", this.a));
            v.addVar(Var.createValue("B", this.b));
            v.addVar(Var.createValue("C", this.c));
            if (this.d != 0.0) {
                v.addVar(Var.createValue("D", this.d));
                v.addVar(Var.createValue("pwr", this.pwr));
                if (this.ti > this.min) {
                    v.addVar(Var.createValue("Ti", this.ti));
                }
            }
            v.addVar(Var.createValue("Tref", this.tref));
            v.addVar(Var.createValue("Min", this.min));
            v.addVar(Var.createValue("Max", this.max));
            return v;
        }
    }

    public static class ptcModel {
        String model;
        public double rlow;
        public double rhigh;
        String type;

        public ptcModel(String model, double rlow, double rhigh, String type) {
            this.model = model;
            if (rhigh == 0.0 || rlow == rhigh) {
                this.rlow = rlow * 0.95;
                this.rhigh = rlow * 1.05;
            } else {
                this.rlow = rlow;
                this.rhigh = rhigh;
            }
            this.type = type;
        }

        public ktyConst getConst() {
            return ptcConsts.get(this.type);
        }

        public Var getParams() {
            Var v = this.getConst().getParams();
            v.addVar(Var.createValue("Rmin", this.rlow));
            v.addVar(Var.createValue("Rmax", this.rhigh));
            return v;
        }
    }
}

