/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public abstract class DataSet
implements Iterable<Point2D> {
    public abstract Point2D get(int var1);

    public abstract int getSize();

    public Point2D getFromX(Double X) {
        return null;
    }

    public DataSetIterator iterator() {
        return new DataSetIterator();
    }

    public void add(double x, double y) {
        this.add(new Point2D.Double(x, y));
    }

    public abstract void add(Point2D var1);

    public abstract void clear();

    public Rectangle2D getLimits() {
        if (this.getSize() == 0) {
            return new Rectangle2D.Double();
        }
        Point2D pt = this.get(0);
        double x1 = pt.getX();
        double x2 = pt.getX();
        double y1 = pt.getY();
        double y2 = pt.getY();
        int i = 1;
        while (i < this.getSize()) {
            pt = this.get(i);
            x1 = Math.min(x1, pt.getX());
            x2 = Math.max(x2, pt.getX());
            y1 = Math.min(y1, pt.getY());
            y2 = Math.max(y2, pt.getY());
            ++i;
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.getSize()) {
            sb.append(i);
            sb.append("  ");
            sb.append(this.get(i).toString());
            sb.append("\r\n");
            ++i;
        }
        return sb.toString();
    }

    protected class DataSetIterator
    implements Iterator<Point2D> {
        int index = -1;

        @Override
        public boolean hasNext() {
            return this.index < DataSet.this.getSize();
        }

        @Override
        public Point2D next() {
            ++this.index;
            return DataSet.this.get(this.index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

