/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

public class Complex {
    public static char complexChar = (char)105;
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    private final double real;
    private final double imag;

    static Complex Polar(double r, double theta) {
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    public Complex() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public Complex(double real) {
        this.real = real;
        this.imag = 0.0;
    }

    public boolean isZero() {
        return this.real == 0.0 && this.imag == 0.0;
    }

    public boolean isNaN() {
        return Double.isNaN(this.real) || Double.isNaN(this.imag);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.real) || Double.isInfinite(this.imag);
    }

    public boolean equals(Complex v) {
        return this.real == v.real && this.imag == v.imag;
    }

    public boolean equals(Object v) {
        if (this == v) {
            return true;
        }
        if (v instanceof Complex) {
            return this.equals((Complex)v);
        }
        return false;
    }

    public String toString() {
        if (this.imag == 0.0) {
            return Double.toString(this.real);
        }
        if (this.real == 0.0) {
            return String.valueOf(Double.toString(this.imag)) + complexChar;
        }
        if (this.imag < 0.0) {
            return String.valueOf(Double.toString(this.real)) + "-" + Double.toString(-this.imag) + complexChar;
        }
        return String.valueOf(Double.toString(this.real)) + "+" + Double.toString(this.imag) + complexChar;
    }

    public double real() {
        return this.real;
    }

    public double imag() {
        return this.imag;
    }

    public Complex neg() {
        return new Complex(-this.real, -this.imag);
    }

    public Complex conjugate() {
        return new Complex(this.real, -this.imag);
    }

    public double abs() {
        return Math.hypot(this.real, this.imag);
    }

    public double phase() {
        return Math.atan2(this.imag, this.real);
    }

    public Complex add(Complex v) {
        return new Complex(this.real + v.real, this.imag + v.imag);
    }

    public Complex add(double v) {
        return new Complex(this.real + v, this.imag);
    }

    public Complex sub(Complex v) {
        return new Complex(this.real - v.real, this.imag - v.imag);
    }

    public Complex sub(double v) {
        return new Complex(this.real - v, this.imag);
    }

    public Complex mult(Complex v) {
        return new Complex(this.real * v.real - this.imag * v.imag, this.real * v.imag + this.imag * v.real);
    }

    public Complex mult(double v) {
        return new Complex(this.real * v, this.imag * v);
    }

    public Complex reciprocal() {
        double d = this.real * this.real + this.imag * this.imag;
        return new Complex(this.real / d, -this.imag / d);
    }

    public boolean isReal() {
        return Math.abs(this.imag) <= Math.abs(Math.ulp(this.real) * 10.0);
    }

    public Complex div(Complex v) {
        return this.mult(v.reciprocal());
    }

    public Complex div(double v) {
        return this.mult(1.0 / v);
    }

    public Complex sqr() {
        return this.mult(this);
    }

    public Complex sqrt() {
        if (this.real < 0.0 && Math.abs(this.imag) < Math.abs(this.real / 1.0E13)) {
            double v = Math.sqrt(-this.real);
            return new Complex(0.0, v);
        }
        double r = this.abs();
        Complex zr = this.add(r);
        return zr.div(zr.abs()).mult(Math.sqrt(r));
    }

    public Complex pow(Complex exp) {
        return exp.mult(this.ln()).exp();
    }

    public Complex exp() {
        double ex = Math.exp(this.real);
        return new Complex(ex * Math.cos(this.imag), ex * Math.sin(this.imag));
    }

    public Complex ln() {
        return new Complex(Math.log(this.abs()), this.phase());
    }

    public Complex log10() {
        return this.ln().div(Math.log(10.0));
    }

    public Complex sin() {
        return new Complex(Math.sin(this.real) * Math.cosh(this.imag), Math.cos(this.real) * Math.sinh(this.imag));
    }

    public Complex cos() {
        return new Complex(Math.cos(this.real) * Math.cosh(this.imag), -Math.sin(this.real) * Math.sinh(this.imag));
    }

    public Complex tan() {
        return this.sin().div(this.cos());
    }

    private Complex sqrt1z() {
        return ONE.sub(this.sqr()).sqrt();
    }

    public Complex acos() {
        return this.sqrt1z().mult(I).add(this).ln().mult(I.neg());
    }

    public Complex asin() {
        return this.sqrt1z().add(this.mult(I)).ln().mult(I.neg());
    }

    public Complex atan() {
        return this.add(I).div(I.sub(this)).ln().mult(I.div(new Complex(2.0, 0.0)));
    }

    public Complex sinh() {
        return this.exp().sub(this.neg().exp()).mult(0.5);
    }

    public Complex cosh() {
        return this.exp().add(this.neg().exp()).mult(0.5);
    }

    public Complex tanh() {
        Complex zp = this.exp();
        Complex zm = this.neg().exp();
        return zp.sub(zm).div(zp.add(zm));
    }

    public Complex asinh() {
        return this.sqr().add(1.0).sqrt().add(this).ln();
    }

    public Complex acosh() {
        return this.sqr().sub(1.0).sqrt().add(this).ln();
    }

    public Complex atanh() {
        return this.add(1.0).div(ONE.sub(this)).ln().mult(0.5);
    }

    public Complex csc() {
        return new Complex(1.0).div(this.sin());
    }

    public Complex acsc() {
        return new Complex(1.0).div(this).asin();
    }

    public Complex sec() {
        return new Complex(1.0).div(this.cos());
    }

    public Complex asec() {
        return new Complex(1.0).div(this).acos();
    }

    public Complex cot() {
        return this.cos().div(this.sin());
    }

    public Complex acot() {
        return new Complex(1.0).div(this).atan();
    }
}

