/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.text.StringCharacterIterator;

public class CharacterEscapes {
    public static String fromHTML(String txt) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int j = 0;
        while ((i = txt.indexOf(38, j)) > 0) {
            if (i <= 0) continue;
            sb.append(txt.substring(j, i));
            j = txt.indexOf(59, i + 1);
            if (j > 0 && j < i + 6) {
                String tag = txt.substring(i + 1, j);
                if (tag.equalsIgnoreCase("amp")) {
                    sb.append("&");
                } else if (tag.equalsIgnoreCase("lt")) {
                    sb.append("<");
                } else if (tag.equalsIgnoreCase("gt")) {
                    sb.append(">");
                }
                ++j;
                continue;
            }
            sb.append('&');
            j = i + 1;
        }
        sb.append(txt.substring(j));
        return sb.toString();
    }

    public static String forHTML(String aText) {
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                sb.append("&lt;");
            } else if (character == '>') {
                sb.append("&gt;");
            } else if (character == '&') {
                sb.append("&amp;");
            } else if (character == '\"') {
                sb.append("&quot;");
            } else if (character == '\t') {
                CharacterEscapes.addCharEntity(9, sb);
            } else if (character == '!') {
                CharacterEscapes.addCharEntity(33, sb);
            } else if (character == '#') {
                CharacterEscapes.addCharEntity(35, sb);
            } else if (character == '$') {
                CharacterEscapes.addCharEntity(36, sb);
            } else if (character == '%') {
                CharacterEscapes.addCharEntity(37, sb);
            } else if (character == '\'') {
                CharacterEscapes.addCharEntity(39, sb);
            } else if (character == '(') {
                CharacterEscapes.addCharEntity(40, sb);
            } else if (character == ')') {
                CharacterEscapes.addCharEntity(41, sb);
            } else if (character == '*') {
                CharacterEscapes.addCharEntity(42, sb);
            } else if (character == '+') {
                CharacterEscapes.addCharEntity(43, sb);
            } else if (character == ',') {
                CharacterEscapes.addCharEntity(44, sb);
            } else if (character == '-') {
                CharacterEscapes.addCharEntity(45, sb);
            } else if (character == '.') {
                CharacterEscapes.addCharEntity(46, sb);
            } else if (character == '/') {
                CharacterEscapes.addCharEntity(47, sb);
            } else if (character == ':') {
                CharacterEscapes.addCharEntity(58, sb);
            } else if (character == ';') {
                CharacterEscapes.addCharEntity(59, sb);
            } else if (character == '=') {
                CharacterEscapes.addCharEntity(61, sb);
            } else if (character == '?') {
                CharacterEscapes.addCharEntity(63, sb);
            } else if (character == '@') {
                CharacterEscapes.addCharEntity(64, sb);
            } else if (character == '[') {
                CharacterEscapes.addCharEntity(91, sb);
            } else if (character == '\\') {
                CharacterEscapes.addCharEntity(92, sb);
            } else if (character == ']') {
                CharacterEscapes.addCharEntity(93, sb);
            } else if (character == '^') {
                CharacterEscapes.addCharEntity(94, sb);
            } else if (character == '_') {
                CharacterEscapes.addCharEntity(95, sb);
            } else if (character == '`') {
                CharacterEscapes.addCharEntity(96, sb);
            } else if (character == '{') {
                CharacterEscapes.addCharEntity(123, sb);
            } else if (character == '|') {
                CharacterEscapes.addCharEntity(124, sb);
            } else if (character == '}') {
                CharacterEscapes.addCharEntity(125, sb);
            } else if (character == '~') {
                CharacterEscapes.addCharEntity(126, sb);
            } else {
                sb.append(character);
            }
            character = iterator.next();
        }
        return sb.toString();
    }

    public static String forHrefAmpersand(String aURL) {
        return aURL.replace("&", "&amp;");
    }

    public static String forURL(String str) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == ' ') {
                result.append("%20");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forXML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String toDisableTags(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forRegex(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\.");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '?') {
                result.append("\\?");
            } else if (character == '*') {
                result.append("\\*");
            } else if (character == '+') {
                result.append("\\+");
            } else if (character == '&') {
                result.append("\\&");
            } else if (character == ':') {
                result.append("\\:");
            } else if (character == '{') {
                result.append("\\{");
            } else if (character == '}') {
                result.append("\\}");
            } else if (character == '[') {
                result.append("\\[");
            } else if (character == ']') {
                result.append("\\]");
            } else if (character == '(') {
                result.append("\\(");
            } else if (character == ')') {
                result.append("\\)");
            } else if (character == '^') {
                result.append("\\^");
            } else if (character == '$') {
                result.append("\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String forSimpleSearch(String aRegexFragment) {
        if (aRegexFragment.startsWith("!")) {
            return aRegexFragment.substring(1);
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        result.append("(?i)");
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\.");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '?') {
                result.append(".");
            } else if (character == '*') {
                result.append(".*");
            } else if (character == '+') {
                result.append("\\+");
            } else if (character == '&') {
                result.append("\\&");
            } else if (character == ':') {
                result.append("\\:");
            } else if (character == '{') {
                result.append("\\{");
            } else if (character == '}') {
                result.append("\\}");
            } else if (character == '[') {
                result.append("\\[");
            } else if (character == ']') {
                result.append("\\]");
            } else if (character == '(') {
                result.append("\\(");
            } else if (character == ')') {
                result.append("\\)");
            } else if (character == '^') {
                result.append("\\^");
            } else if (character == '$') {
                result.append("\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    private static void addCharEntity(Integer aIdx, StringBuilder aBuilder) {
        String padding = "";
        if (aIdx <= 9) {
            padding = "00";
        } else if (aIdx <= 99) {
            padding = "0";
        }
        String number = String.valueOf(padding) + aIdx.toString();
        aBuilder.append("&#" + number + ";");
    }
}

