/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ByteBuffer {
    protected byte[] buffer;
    private int size;

    public ByteBuffer() {
        this(100);
    }

    public ByteBuffer(int initialSize) {
        this.buffer = new byte[initialSize];
        this.size = 0;
    }

    public synchronized void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.buffer.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    public synchronized void delete(int index, int length) {
        if (index < 0 || index >= this.size) {
            return;
        }
        if (index + length > this.size) {
            length = this.size - index;
        }
        int i = index + length;
        while (i < this.size) {
            this.buffer[i - length] = this.buffer[i];
            ++i;
        }
        this.size -= length;
    }

    public synchronized void delete(int index) {
        if (index < 0 || index >= this.size) {
            return;
        }
        int i = index + 1;
        while (i < this.size) {
            this.buffer[i - 1] = this.buffer[i];
            ++i;
        }
        --this.size;
    }

    public synchronized void insert(int index, byte b) {
        int newSize = this.size + 1;
        if (newSize >= this.buffer.length) {
            this.expandCapacity(newSize);
        }
        int i = this.size - 1;
        while (i >= index) {
            this.buffer[i + 1] = this.buffer[i];
            --i;
        }
        this.buffer[index] = b;
        ++this.size;
    }

    public synchronized void insertMsbFirst(int index, int i) {
        int newSize = this.size + 4;
        if (newSize >= this.buffer.length) {
            this.expandCapacity(newSize);
        }
        int j = this.size - 1;
        while (j >= index) {
            this.buffer[j + 4] = this.buffer[j];
            --j;
        }
        this.buffer[index++] = (byte)(i >> 24 & 0xFF);
        this.buffer[index++] = (byte)(i >> 16 & 0xFF);
        this.buffer[index++] = (byte)(i >> 8 & 0xFF);
        this.buffer[index++] = (byte)(i & 0xFF);
        this.size += 4;
    }

    public synchronized void insertLsbFirst(int index, int i) {
        int newSize = this.size + 4;
        if (newSize >= this.buffer.length) {
            this.expandCapacity(newSize);
        }
        int j = index;
        while (j < this.size) {
            this.buffer[j + 4] = this.buffer[j];
            ++j;
        }
        this.buffer[index++] = (byte)(i & 0xFF);
        this.buffer[index++] = (byte)(i >> 8 & 0xFF);
        this.buffer[index++] = (byte)(i >> 16 & 0xFF);
        this.buffer[index++] = (byte)(i >> 24 & 0xFF);
        this.size += 4;
    }

    public synchronized ByteBuffer append(byte b) {
        int newSize = this.size + 1;
        if (newSize >= this.buffer.length) {
            this.expandCapacity(newSize);
        }
        this.buffer[this.size++] = b;
        return this;
    }

    public synchronized ByteBuffer appendMsbFirst(int i) {
        int newSize = this.size + 4;
        if (newSize >= this.buffer.length) {
            this.expandCapacity(newSize);
        }
        this.buffer[this.size++] = (byte)(i >> 24 & 0xFF);
        this.buffer[this.size++] = (byte)(i >> 16 & 0xFF);
        this.buffer[this.size++] = (byte)(i >> 8 & 0xFF);
        this.buffer[this.size++] = (byte)(i & 0xFF);
        return this;
    }

    public synchronized ByteBuffer appendLsbFirst(int i) {
        int newSize = this.size + 4;
        if (newSize >= this.buffer.length) {
            this.expandCapacity(newSize);
        }
        this.buffer[this.size++] = (byte)(i & 0xFF);
        this.buffer[this.size++] = (byte)(i >> 8 & 0xFF);
        this.buffer[this.size++] = (byte)(i >> 16 & 0xFF);
        this.buffer[this.size++] = (byte)(i >> 24 & 0xFF);
        return this;
    }

    public synchronized ByteBuffer appendMsbFirst(long i) {
        int newSize = this.size + 8;
        if (newSize >= this.buffer.length) {
            this.expandCapacity(newSize);
        }
        this.buffer[this.size++] = (byte)(i >> 56 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 48 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 40 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 32 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 24 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 16 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 8 & 0xFFL);
        this.buffer[this.size++] = (byte)(i & 0xFFL);
        return this;
    }

    public synchronized ByteBuffer appendLsbFirst(long i) {
        int newSize = this.size + 8;
        if (newSize >= this.buffer.length) {
            this.expandCapacity(newSize);
        }
        this.buffer[this.size++] = (byte)(i & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 8 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 16 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 24 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 32 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 40 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 48 & 0xFFL);
        this.buffer[this.size++] = (byte)(i >> 56 & 0xFFL);
        return this;
    }

    public ByteBuffer append(char b) {
        return this.append((byte)b);
    }

    public ByteBuffer append(String s) {
        return this.append(s.getBytes());
    }

    public ByteBuffer append(String s, String charset) {
        try {
            return this.append(s.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            return this.append(s.getBytes());
        }
    }

    public ByteBuffer appendAscii(String s) {
        try {
            return this.append(s.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            return this.append(s.getBytes());
        }
    }

    public synchronized ByteBuffer append(byte[] b) {
        if (b != null && b.length > 0) {
            int newSize = this.size + b.length;
            if (newSize >= this.buffer.length) {
                this.expandCapacity(newSize);
            }
            byte[] byArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                byte aB = byArray[n2];
                this.buffer[this.size++] = aB;
                ++n2;
            }
        }
        return this;
    }

    public synchronized ByteBuffer append(byte[] b, int offset, int length) {
        if (b != null && b.length > 0) {
            if ((length -= offset) < 0) {
                return this;
            }
            int newSize = this.size + (length = Math.min(length, b.length));
            if (newSize >= this.buffer.length) {
                this.expandCapacity(newSize);
            }
            int i = offset;
            while (i < length) {
                this.buffer[this.size++] = b[i];
                ++i;
            }
        }
        return this;
    }

    public ByteBuffer append(File f) throws IOException {
        return this.appendClose(new FileInputStream(f));
    }

    public ByteBuffer append(InputStream is) throws IOException {
        if (is == null) {
            return this;
        }
        byte[] buffer = new byte[32768];
        int n = 0;
        while (n >= 0) {
            n = is.read(buffer);
            if (n < 0) {
                return this;
            }
            this.append(buffer, 0, n);
        }
        return this;
    }

    public ByteBuffer appendClose(InputStream is) throws IOException {
        this.append(is);
        is.close();
        return this;
    }

    public synchronized void setLength(int length) {
        if (length >= this.buffer.length) {
            this.expandCapacity(length);
        }
        this.size = length;
    }

    public synchronized int indexOf(byte[] match) {
        if (match.length > this.size) {
            return -1;
        }
        int i = 0;
        while (i < this.size - match.length) {
            boolean fail = false;
            int j = 0;
            while (j < match.length) {
                if (this.buffer[i + j] != match[j]) {
                    fail = true;
                    break;
                }
                ++j;
            }
            if (!fail) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized byte[] getAsArray(int index, int length) {
        return Arrays.copyOfRange(this.buffer, index, index + length);
    }

    public synchronized byte[] getAsArray() {
        return Arrays.copyOf(this.buffer, this.size);
    }

    public synchronized byte[] getAsArrayAndClear() {
        byte[] b = Arrays.copyOf(this.buffer, this.size);
        this.size = 0;
        return b;
    }

    public synchronized byte[] getAsArrayAndRemove(int count) {
        if (count > this.size) {
            count = this.size;
        }
        byte[] b = Arrays.copyOf(this.buffer, count);
        this.buffer = Arrays.copyOfRange(this.buffer, count, this.size);
        this.size -= count;
        return b;
    }

    public synchronized InputStream getAsInputStream() {
        return new ByteArrayInputStream(this.buffer, 0, this.size);
    }

    public synchronized int indexOf(int start, byte b) {
        int i = start;
        while (i < this.size) {
            if (this.buffer[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized byte byteAt(int index) {
        return this.buffer[index];
    }

    public synchronized void change(int index, byte b) {
        if (index >= 0 && index < this.size) {
            this.buffer[index] = b;
        }
    }

    public synchronized int unsignedByteAt(int index) {
        int i = this.buffer[index] & 0xFF;
        return i;
    }

    public synchronized String toString() {
        return new String(this.buffer, 0, this.size);
    }

    public synchronized String toString(int first, int length) {
        byte[] b = Arrays.copyOfRange(this.buffer, first, first + length);
        return new String(b, 0, length);
    }

    public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.size, charsetName);
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized ByteBuffer appendAutoCharset(String str) {
        try {
            byte[] data = str.getBytes("cp1252");
            if (!new String(data, "cp1252").equals(str)) {
                this.append((byte)-1);
                this.append((byte)-2);
                this.append(str.getBytes("UTF-16LE"));
            } else {
                this.append(data);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    public synchronized String toStringAutoCharset() throws UnsupportedEncodingException {
        int ofs = 0;
        String charset = "CP1252";
        if (this.size >= 3 && this.buffer[0] == -17 && this.buffer[1] == -69 && this.buffer[2] == -65) {
            charset = "UTF8";
            ofs = 3;
        } else if (this.size >= 2 && this.buffer[0] == -1 && this.buffer[1] == -2) {
            charset = "UTF-16LE";
            ofs = 2;
        } else if (this.size >= 2 && this.buffer[0] == -2 && this.buffer[2] == -1) {
            charset = "UTF-16BE";
            ofs = 2;
        }
        return new String(this.buffer, ofs, this.size, charset);
    }

    public synchronized byte lastByte() {
        return this.size > 0 ? this.buffer[this.size - 1] : (byte)0;
    }

    public synchronized void clear() {
        this.size = 0;
    }
}

