/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.util;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class AudibleAlarm
extends Thread {
    static List<AudibleAlarm> playingAlarams = new ArrayList<AudibleAlarm>();
    private static final int SAMPLE_RATE = 16384;
    private int samples = 0;
    private byte[] toneBuffer = null;
    private SourceDataLine line;
    private int alarmSoundRepeat = 0;
    private final AudioFormat audioFormat = new AudioFormat(16384.0f, 8, 1, true, true);
    private boolean playing = false;
    private int playTime = 0;
    private int pauseTime = 0;
    private int cycles = 0;
    private int audioLevel;
    private AlarmSound alarmSound;
    private static AlarmSound defaultAlarmSound = new AlarmSound('s', 300, 800, 400, 0);

    public static void setDefaultSound(char generator, int f1, int f2, int ms1, int ms2) {
        defaultAlarmSound = new AlarmSound(generator, f1, f2, ms1, ms2);
    }

    public static AudibleAlarm play(int audioLevel, int playTime, int pauseTime, int cycles, AlarmSound alarmSound) {
        AudibleAlarm aa = new AudibleAlarm(audioLevel, playTime, pauseTime, cycles, alarmSound);
        aa.start();
        return aa;
    }

    public static AudibleAlarm play(int audioLevel, int playTime, int pauseTime, int cycles) {
        return AudibleAlarm.play(audioLevel, playTime, pauseTime, cycles, defaultAlarmSound);
    }

    public static AudibleAlarm play() {
        return AudibleAlarm.play(100, 2, 0, 1);
    }

    private AudibleAlarm(int audioLevel, int playTime, int pauseTime, int cycles, AlarmSound alarmSound) {
        this.audioLevel = audioLevel;
        this.playTime = playTime;
        this.pauseTime = pauseTime;
        this.cycles = cycles;
        this.alarmSound = alarmSound;
    }

    private void createDualTone(AlarmSound alarmSound) {
        double time = 0.0;
        double period1 = 1.0 / (double)alarmSound.f1;
        double period2 = 1.0 / (double)alarmSound.f2;
        double dt = 6.103515625E-5;
        double time1 = (double)alarmSound.ms1 / 1000.0;
        double time2 = (double)alarmSound.ms2 / 1000.0;
        boolean f1 = true;
        int i = 0;
        while (i < this.samples) {
            double v = 0.0;
            if (f1) {
                v = Math.sin(Math.PI * 2 * time / period1);
                if (time > time1 && Math.abs(v) < 0.1) {
                    time = 0.0;
                    f1 = !f1;
                }
            } else {
                v = Math.sin(Math.PI * 2 * time / period2);
                if (time > time2 && Math.abs(v) < 0.1) {
                    time = 0.0;
                    f1 = !f1;
                }
            }
            time += dt;
            this.toneBuffer[i] = (byte)(v * 127.0);
            ++i;
        }
    }

    private void createSlidingTone(AlarmSound alarmSound) {
        double time = 0.0;
        double period1 = 1.0 / (double)alarmSound.f1;
        double period2 = 1.0 / (double)alarmSound.f2;
        double dp = period2 - period1;
        double dt = 6.103515625E-5;
        double time1 = (double)alarmSound.ms1 / 1000.0;
        double time2 = (double)alarmSound.ms2 / 1000.0;
        boolean f1 = true;
        int i = 0;
        while (i < this.samples) {
            double v = 0.0;
            if (f1) {
                v = Math.sin(Math.PI * 2 * time / (period1 + dp * time / time1));
                if (time > time1 && Math.abs(v) < 0.1) {
                    time = 0.0;
                    f1 = !f1;
                }
            } else if (time > time2) {
                time = 0.0;
                f1 = !f1;
            }
            time += dt;
            this.toneBuffer[i] = (byte)(v * 127.0);
            ++i;
        }
    }

    private void createUpDownTone(AlarmSound alarmSound) {
        double time = 0.0;
        double period1 = 1.0 / (double)alarmSound.f1;
        double period2 = 1.0 / (double)alarmSound.f2;
        double dp = period2 - period1;
        double dt = 6.103515625E-5;
        double time1 = (double)alarmSound.ms1 / 1000.0;
        double time2 = (double)alarmSound.ms2 / 1000.0;
        boolean f1 = true;
        int i = 0;
        while (i < this.samples) {
            double v = 0.0;
            if (f1) {
                v = Math.sin(Math.PI * 2 * time / (period1 + dp * time / time1));
                if (time > time1 && Math.abs(v) < 0.1) {
                    time = 0.0;
                    f1 = !f1;
                }
            } else {
                v = Math.sin(Math.PI * 2 * time / (period2 - dp * time / time1));
                if (time > time2) {
                    time = 0.0;
                    f1 = !f1;
                }
            }
            time += dt;
            this.toneBuffer[i] = (byte)(v * 127.0);
            ++i;
        }
    }

    public void setVolume(int volume) {
        if (this.line == null) {
            return;
        }
        if (volume < 0 || volume > 100) {
            throw new IllegalArgumentException("Volume not valid: " + volume);
        }
        this.audioLevel = volume;
        FloatControl volumeControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
        volume = volume / 2 - 50;
        volumeControl.setValue(volume);
    }

    void setup() throws LineUnavailableException {
        this.toneBuffer = null;
        if (this.alarmSound.f1 == 0) {
            return;
        }
        this.samples = 16384 * this.playTime / 1000;
        this.toneBuffer = new byte[this.samples];
        switch (this.alarmSound.generator) {
            case 's': {
                this.createSlidingTone(this.alarmSound);
                break;
            }
            case 'u': {
                this.createUpDownTone(this.alarmSound);
                break;
            }
            default: {
                this.createDualTone(this.alarmSound);
            }
        }
        this.line = AudioSystem.getSourceDataLine(this.audioFormat);
        this.line.open(this.audioFormat, 16384);
    }

    public static void stopAllSound() {
        for (AudibleAlarm aa : playingAlarams) {
            aa.stopSound();
        }
    }

    public static boolean isAnyPlaying() {
        for (AudibleAlarm aa : playingAlarams) {
            if (!aa.isPlaying()) continue;
            return true;
        }
        return false;
    }

    public void stopSound() {
        this.alarmSoundRepeat = 0;
        if (this.line != null) {
            this.line.close();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public void run() {
        if (this.playTime == 0 || this.alarmSound.f1 == 0 || this.alarmSound.f2 == 0) {
            return;
        }
        playingAlarams.add(this);
        try {
            block12: {
                this.playing = true;
                this.setup();
                this.alarmSoundRepeat = this.cycles;
                if (this.toneBuffer != null) break block12;
                return;
            }
            try {
                do {
                    if (this.alarmSoundRepeat > 0) {
                        --this.alarmSoundRepeat;
                    }
                    this.line.start();
                    this.setVolume(this.audioLevel);
                    this.line.write(this.toneBuffer, 0, this.toneBuffer.length);
                    this.line.drain();
                    int pt = this.pauseTime;
                    while (pt > 200 && this.alarmSoundRepeat > 0 && this.line.isOpen()) {
                        Thread.sleep(200L);
                        pt -= 200;
                    }
                    if (pt <= 0 || this.alarmSoundRepeat <= 0 || !this.line.isOpen()) continue;
                    Thread.sleep(pt);
                } while (this.alarmSoundRepeat > 0);
                this.line.close();
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.playing = false;
            playingAlarams.remove(this);
        }
    }

    public static class AlarmSound {
        char generator;
        int f1;
        int f2;
        int ms1;
        int ms2;

        public AlarmSound(char generator, int f1, int f2, int ms1, int ms2) {
            this.generator = generator;
            this.f1 = f1;
            this.f2 = f2;
            this.ms1 = ms1;
            this.ms2 = ms2;
        }

        public String toString() {
            return String.valueOf(this.generator) + ":" + this.f1 + "-" + this.ms1 + " / " + this.f2 + "-" + this.ms2;
        }
    }
}

