/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.shared;

import dk.hkj.shared.SharedInterface;

public class SharedInterfaceNSGPIB232CT
extends SharedInterface {
    public static String interfaceType = "National Instruments GPIB-232CT";
    private int selectedTimeout = -1;
    private int currentReadEol = -1;

    public SharedInterfaceNSGPIB232CT(String line) {
        super(line);
    }

    public SharedInterfaceNSGPIB232CT() {
    }

    @Override
    public String getType() {
        return interfaceType;
    }

    private void setUsedEOS(SharedInterface.DeviceSettings ds) {
        if (ds.readEolEoi && this.currentReadEol != -1) {
            this.writeWithDelay("EOS D");
            this.currentReadEol = -1;
        } else if (!ds.readEolEoi && this.currentReadEol != ds.readEolChar) {
            this.writeWithDelay("EOS R," + ds.readEolChar);
            this.currentReadEol = ds.readEolChar;
        }
    }

    private void setActualTimeout(int timeout) {
        if (timeout < 700) {
            timeout = 700;
        }
        if (timeout > 300000) {
            timeout = 300000;
        }
        if (timeout != this.selectedTimeout) {
            this.writeWithDelay("TMO " + (double)timeout / 1000.0);
            this.selectedTimeout = timeout;
        }
    }

    @Override
    public void init() {
        if (this.deviceSettings.size() == 1) {
            for (SharedInterface.DeviceSettings ds : this.deviceSettings.values()) {
                this.setUsedEOS(ds);
            }
        }
        String[] stringArray = this.settings.split("[;]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            s = s.trim();
            this.writeWithDelay(s);
            ++n2;
        }
    }

    @Override
    public synchronized void writeControl(String ctrl) {
        if (ctrl.equals("CLR")) {
            this.writeWithDelay("CLR " + this.localAddress);
        } else if (ctrl.equals("LOC")) {
            this.writeWithDelay("LOC " + this.localAddress);
        } else if (ctrl.equals("TRG")) {
            this.writeWithDelay("TRG " + this.localAddress);
        }
    }

    @Override
    public synchronized boolean write(int localAddress, String msg) {
        this.writeWithDelay("WRT " + localAddress);
        this.writeWithDelay(msg);
        return true;
    }

    @Override
    public synchronized String read(int localAddress, int timeout) {
        this.setActualTimeout(timeout - 50);
        SharedInterface.DeviceSettings ds = this.getDeviceSettings(localAddress);
        this.setUsedEOS(ds);
        this.writeWithDelay("RD #" + ds.readCount + "," + localAddress);
        String s = this.ci.read(timeout);
        if (s == null) {
            return s;
        }
        int i = (s = s.trim()).indexOf(0);
        if (i >= 0) {
            s = s.substring(0, i);
        }
        return s.trim();
    }
}

