/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.shared;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.Support;
import dk.hkj.shared.SharedInterface;
import dk.hkj.shared.SharedInterfaceAR488;
import dk.hkj.shared.SharedInterfaceAR488Lan;
import dk.hkj.shared.SharedInterfaceKeysightE5810;
import dk.hkj.shared.SharedInterfaceNSGPIB232CT;
import dk.hkj.shared.SharedInterfacePrologixEthernet;
import dk.hkj.shared.SharedInterfacePrologixUSB;
import dk.hkj.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SharedInterfaceList
implements TableModel {
    List<SharedInterface> sifList = new ArrayList<SharedInterface>();
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    public void reset() {
        for (SharedInterface sif : this.sifList) {
            sif.reset();
        }
    }

    public SharedInterface find(String address) {
        int i = address.indexOf(58);
        if (i < 0) {
            return null;
        }
        String id = address.substring(0, i).trim();
        int localAddress = Integer.parseInt(address.substring(i + 1).trim());
        if (localAddress < 0) {
            localAddress = 0;
        } else if (localAddress > 30) {
            localAddress = 30;
        }
        for (SharedInterface sif : this.sifList) {
            if (!sif.getId().equals(id)) continue;
            sif.setLocalAddress(localAddress);
            return sif;
        }
        return null;
    }

    private boolean idUsed(String id) {
        for (SharedInterface sif : this.sifList) {
            if (!sif.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public SharedInterface get(int index) {
        return this.sifList.get(index);
    }

    public void add(SharedInterface sif) {
        if (sif.getId().length() == 0) {
            char id = 'A';
            while (id < 'Z') {
                if (!this.idUsed(String.valueOf(id))) {
                    sif.setId(String.valueOf(id));
                    break;
                }
                id = (char)(id + '\u0001');
            }
        }
        this.sifList.add(sif);
        this.saveDefault();
        this.tableChanged();
    }

    public void remove(int i) {
        this.sifList.remove(i);
        this.tableChanged();
        this.saveDefault();
    }

    @Override
    public void addTableModelListener(TableModelListener tml) {
        this.listeners.add(tml);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Id";
            }
            case 2: {
                return "Connection";
            }
            case 3: {
                return "Address";
            }
            case 4: {
                return "Baudrate";
            }
            case 5: {
                return "Settings";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.sifList.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        SharedInterface sif = this.sifList.get(row);
        switch (column) {
            case 0: {
                return sif.getType();
            }
            case 1: {
                return sif.getId();
            }
            case 2: {
                return ManageDeviceDefinitions.portTypeToString(sif.getPortType());
            }
            case 3: {
                return sif.address;
            }
            case 4: {
                return sif.getPortType() == ManageDeviceDefinitions.PortType.Serial ? sif.baudrate : "-";
            }
            case 5: {
                return sif.settings;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        SharedInterface sif = this.sifList.get(row);
        switch (column) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return sif.getPortType() == ManageDeviceDefinitions.PortType.Serial;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener tml) {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            if (this.listeners.get(i) == tml) {
                this.listeners.remove(i);
            }
            --i;
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        SharedInterface sif = this.sifList.get(row);
        switch (column) {
            case 1: {
                String id = Support.filterToIdentifier((String)aValue);
                if (id.length() <= 0 || this.idUsed(id)) break;
                sif.setId(id);
                break;
            }
            case 3: {
                sif.setAddress((String)aValue);
                break;
            }
            case 4: {
                sif.setBaudrate((String)aValue);
                break;
            }
            case 5: {
                sif.setSettings((String)aValue);
            }
        }
        this.saveDefault();
    }

    public void tableChanged() {
        if (this.getRowCount() > 0) {
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(this, 0, this.getRowCount(), -1, 1));
            }
        }
    }

    public void saveToFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        for (SharedInterface sif : this.sifList) {
            list.add(sif.toString());
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public void sort() {
        this.sifList.sort(null);
    }

    public void addGPIBInterface(String line) {
        if (line.startsWith(SharedInterface.interfaceType)) {
            this.add(new SharedInterface(line));
        } else if (line.startsWith(SharedInterfaceAR488.interfaceType)) {
            this.add(new SharedInterfaceAR488(line));
        } else if (line.startsWith(SharedInterfaceAR488Lan.interfaceType)) {
            this.add(new SharedInterfaceAR488Lan(line));
        } else if (line.startsWith(SharedInterfacePrologixUSB.interfaceType)) {
            this.add(new SharedInterfacePrologixUSB(line));
        } else if (line.startsWith(SharedInterfacePrologixEthernet.interfaceType)) {
            this.add(new SharedInterfacePrologixEthernet(line));
        } else if (line.startsWith(SharedInterfaceNSGPIB232CT.interfaceType)) {
            this.add(new SharedInterfaceNSGPIB232CT(line));
        } else if (line.startsWith(SharedInterfaceKeysightE5810.interfaceType)) {
            this.add(new SharedInterfaceKeysightE5810(line));
        }
    }

    public void loadFromFile(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            for (String line : list) {
                if ((line = line.trim()).length() <= 0 || line.startsWith(";") || !line.contains("|")) continue;
                this.addGPIBInterface(line);
            }
            this.sort();
            this.tableChanged();
        }
        catch (IOException iOException) {}
    }

    public void saveDefault() {
        this.saveToFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsGPIB.txt"));
    }

    public void loadDefault() {
        this.loadFromFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsGPIB.txt"));
    }
}

