/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.shared;

import dk.hkj.shared.SharedInterface;

public class SharedInterfaceAR488
extends SharedInterface {
    public static String interfaceType = "AR488";
    private int selectedLocalAddress = -1;
    private int selectedTimeout = -1;

    public SharedInterfaceAR488(String line) {
        super(line);
    }

    public SharedInterfaceAR488() {
    }

    @Override
    public String getType() {
        return interfaceType;
    }

    private void setActualAddress(int localAddress) {
        if (localAddress != this.selectedLocalAddress) {
            this.writeWithDelay("++addr " + localAddress);
            this.selectedLocalAddress = localAddress;
        }
    }

    private void setActualTimeout(int timeout) {
        if (timeout < 150) {
            timeout = 150;
        }
        if (timeout > 32000) {
            timeout = 32000;
        }
        if (timeout != this.selectedTimeout) {
            this.writeWithDelay("++read_tmo_ms " + timeout);
            this.selectedTimeout = timeout;
        }
    }

    @Override
    public void init() {
        this.writeWithDelay("++default");
        String[] stringArray = this.settings.split("[;]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).startsWith("++")) {
                this.writeWithDelay(s);
            }
            ++n2;
        }
    }

    @Override
    public byte[] writeReadBin(String msg, int count, int timeout) {
        this.setActualAddress(this.localAddress);
        this.ci.flush();
        this.writeWithDelay(this.escape(msg, 27, "+\r\n"));
        this.setActualTimeout(timeout - 50);
        SharedInterface.DeviceSettings ds = this.getDeviceSettings(this.localAddress);
        this.writeWithDelay("++read " + (ds.readEolEoi ? "eoi" : Integer.valueOf(ds.readEolChar)));
        return this.ci.writeReadBin(null, count, timeout);
    }

    @Override
    public synchronized boolean write(int localAddress, String msg) {
        this.setActualAddress(localAddress);
        this.writeWithDelay(this.escape(msg, 27, "+"));
        return true;
    }

    @Override
    public synchronized void writeControl(String ctrl) {
        this.setActualAddress(this.localAddress);
        if (ctrl.equals("CLR")) {
            this.writeWithDelay("++CLR");
        } else if (ctrl.equals("LLO")) {
            this.writeWithDelay("++LLO");
        } else if (ctrl.equals("LOC")) {
            this.writeWithDelay("++LOC");
        } else if (ctrl.equals("TRG")) {
            this.writeWithDelay("++TRG");
        }
    }

    @Override
    public synchronized String read(int localAddress, int timeout) {
        this.setActualAddress(localAddress);
        this.setActualTimeout(timeout - 50);
        SharedInterface.DeviceSettings ds = this.getDeviceSettings(localAddress);
        this.writeWithDelay("++read " + (ds.readEolEoi ? "eoi" : Integer.valueOf(ds.readEolChar)));
        return this.ci.read(timeout);
    }
}

