/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.shared;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.GpibInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.Support;
import java.util.HashMap;
import java.util.Map;

public class SharedInterface
implements Comparable<SharedInterface> {
    public static String interfaceType = "SharedInterface";
    protected CommInterface ci = null;
    protected boolean debug = false;
    protected String id = "";
    protected String address = "";
    protected String baudrate = "";
    protected String settings = "";
    protected int localAddress = 0;
    protected Map<Integer, DeviceSettings> deviceSettings = new HashMap<Integer, DeviceSettings>();

    public SharedInterface() {
    }

    public void reset() {
        if (this.ci != null) {
            this.ci.close();
            this.ci = null;
        }
        this.deviceSettings.clear();
    }

    public SharedInterface(String line) {
        for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
            if (element.name.equalsIgnoreCase("id")) {
                this.id = element.value;
                continue;
            }
            if (element.name.equalsIgnoreCase("address")) {
                this.address = element.value;
                continue;
            }
            if (element.name.equalsIgnoreCase("baudrate")) {
                this.baudrate = element.value;
                continue;
            }
            if (!element.name.equalsIgnoreCase("settings")) continue;
            this.settings = element.value;
        }
    }

    public void writeControl(String ctrl) {
    }

    public String getSettings() {
        return this.settings;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    protected String escape(String msg, int escape, String charsToEscape) {
        return this.escape(msg, String.valueOf((char)escape), charsToEscape);
    }

    protected String escape(String msg, String escape, String charsToEscape) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < msg.length()) {
            char c = msg.charAt(i);
            if (charsToEscape.indexOf(c) >= 0) {
                sb.append(escape);
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    protected boolean openStatus() {
        for (DeviceSettings ds : this.deviceSettings.values()) {
            if (!ds.isOpen) continue;
            return true;
        }
        return false;
    }

    public String getBaudrate() {
        return this.baudrate;
    }

    protected DeviceSettings getDeviceSettings(int localAddress) {
        DeviceSettings ds = this.deviceSettings.get(localAddress);
        if (ds == null) {
            ds = new DeviceSettings();
            this.deviceSettings.put(localAddress, ds);
        }
        return ds;
    }

    protected void writeWithDelay(String msg) {
        this.ci.write(msg);
        int d = this.getDeviceSettings((int)this.localAddress).writeDelay;
        if (d > 0) {
            CommInterface.sleep(d);
        }
    }

    public void setReadEol(int localAddress, String format) {
        DeviceSettings ds = this.getDeviceSettings(localAddress);
        if (format.equalsIgnoreCase("eoi")) {
            ds.readEolEoi = true;
        } else {
            ds.readEolEoi = false;
            int i = Integer.parseInt(format);
            if (i >= 0 && i <= 255) {
                ds.readEolChar = (char)i;
            }
        }
    }

    public void setReadCount(int localAddress, int count) {
        DeviceSettings ds = this.getDeviceSettings(localAddress);
        ds.readCount = count;
    }

    public void setWriteDelay(int localAddress, int delay) {
        this.getDeviceSettings((int)localAddress).writeDelay = delay;
    }

    public void setWriteReadDelay(int localAddress, int delay) {
        this.getDeviceSettings((int)localAddress).writeReadDelay = delay;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType());
        sb.append("|");
        sb.append("id:");
        sb.append(this.id);
        sb.append("|");
        sb.append("address:");
        sb.append(this.address);
        sb.append("|");
        sb.append("baudrate:");
        sb.append(this.baudrate);
        sb.append("|");
        sb.append("settings:");
        sb.append(this.settings);
        sb.append("|");
        return sb.toString();
    }

    protected int getPort() {
        String[] stringArray = this.settings.split("[;]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).toLowerCase().startsWith("port:")) {
                return Integer.parseInt(s.substring(5).trim());
            }
            ++n2;
        }
        return 1234;
    }

    public String getType() {
        return interfaceType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if ((id = Support.filterToIdentifier(id)).length() == 0) {
            return;
        }
        this.id = id;
    }

    public String getName() {
        return String.valueOf(this.getType()) + " " + this.getId();
    }

    public String getDeviceName() {
        return this.getName();
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setBaudrate(String baudrate) {
        this.baudrate = SerialInterface.formatSettingString(baudrate);
    }

    public void setLocalAddress(int localAddress) {
        this.localAddress = localAddress;
    }

    public CommInterface getInterface() {
        return new GpibInterface(this, this.localAddress);
    }

    public void init() {
    }

    public String neededCommInterface() {
        return this.address;
    }

    public void setCommInterface(CommInterface ci) {
        this.ci = ci;
    }

    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.Serial;
    }

    public synchronized void open(int localAddress) {
        if (!this.openStatus()) {
            this.ci.open();
            this.init();
        }
        this.getDeviceSettings((int)localAddress).isOpen = true;
    }

    public void close(int localAddress) {
        this.getDeviceSettings((int)localAddress).isOpen = false;
        if (!this.openStatus() && this.ci != null) {
            this.ci.close();
        }
    }

    public void flush() {
        this.ci.flush();
    }

    public synchronized boolean isData() {
        return false;
    }

    public synchronized boolean write(int localAddress, String msg) {
        return this.ci.write(msg);
    }

    public synchronized String read(int localAddress, int timeout) {
        return this.ci.read(timeout);
    }

    public byte[] writeReadBin(String msg, int count, int timeout) {
        this.ci.flush();
        return this.ci.writeReadBin(msg, count, timeout);
    }

    public String writeRead(int localAddress, String msg, int timeout) {
        this.flush();
        if (!this.write(localAddress, msg)) {
            return null;
        }
        CommInterface.sleep(this.getDeviceSettings((int)localAddress).writeReadDelay);
        return this.read(localAddress, timeout);
    }

    public boolean isOpen() {
        return this.ci != null && this.ci.isOpen();
    }

    protected void log(String msg) {
        if (this.debug) {
            System.out.println(String.valueOf(this.getDeviceName()) + " " + (double)(System.currentTimeMillis() % 100000L) / 1000.0 + " " + msg);
        }
    }

    protected void log(String msg1, String msg2) {
        if (this.debug) {
            System.out.println(String.valueOf(this.getDeviceName()) + " " + (double)(System.currentTimeMillis() % 100000L) / 1000.0 + " " + msg1 + " " + msg2);
        }
    }

    public int getSerialId() {
        return 0;
    }

    @Override
    public int compareTo(SharedInterface o) {
        return this.id.toLowerCase().compareTo(o.id.toLowerCase());
    }

    protected class DeviceSettings {
        protected boolean isOpen = false;
        protected boolean readEolEoi = true;
        protected int readEolChar = 10;
        protected int writeDelay = 0;
        protected int writeReadDelay = 1;
        protected int readCount = 100;

        protected DeviceSettings() {
        }
    }
}

