/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Condition;
import dk.hkj.script.ConditionKind;
import dk.hkj.script.Functions;
import dk.hkj.script.Program;
import dk.hkj.script.ProgramExceptions;
import dk.hkj.script.Token;
import dk.hkj.script.TokenType;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.Complex;
import dk.hkj.util.Matrix;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarValueBytes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Script {
    private static Script globalScript;
    Program program;
    private StringBuilder printText;
    private List<Condition> conditions = new ArrayList<Condition>(10);
    private Var lastResult;
    private Token token;
    private boolean ignore;
    private Script parentScript = null;
    private Var localVars = new Var();
    private String defaultStartMark;
    private String defaultEndMark;
    private boolean stopRequest = false;
    Var noFault = null;

    public static void setLocalSyntax(boolean on) {
        Program.localSyntax = on;
    }

    public void stop() {
        this.stopRequest = true;
    }

    public Script getParent() {
        return this.parentScript;
    }

    private Var findVar(List<Object> indexList) {
        Var v = null;
        v = this.localVars.find(indexList);
        if (v == null && this.parentScript != null) {
            v = this.parentScript.findVar(indexList);
        }
        if (v == null && this.parentScript == null) {
            v = Var.gl.find(indexList);
        }
        return v;
    }

    private Var getVar(List<Object> indexList) {
        Var v = this.findVar(indexList);
        if (v == null) {
            throw new ProgramExceptions.UnknownException(this, "Variable not found " + Var.indexListToString(indexList, -1) + "  ");
        }
        return v;
    }

    public Var getVar(String namePath) {
        return this.getVar(Var.makeIndexList(namePath));
    }

    private Functions.Func findFunc(List<Object> indexList) {
        Functions.Func f = null;
        f = this.localVars.findFunc(indexList);
        if (f == null && this.parentScript != null) {
            f = this.parentScript.findFunc(indexList);
        }
        if (f == null && indexList.size() == 1) {
            f = Functions.gf().find((String)indexList.get(0));
        }
        return f;
    }

    private Functions.Func getFunc(List<Object> indexList) {
        Functions.Func f = this.findFunc(indexList);
        if (f == null) {
            throw new ProgramExceptions.UnknownException(this, "Function not found " + Var.indexListToString(indexList, -1) + "  ");
        }
        return f;
    }

    private void nextOutside() {
        this.token = this.program.nextTokenOutsideProgram();
    }

    private void next() {
        this.token = this.program.nextToken();
    }

    private void parseParamListSkip() {
        this.next();
        while (this.token.tokenType != TokenType.BRACKETEND) {
            this.parseExpressionSkip();
            if (this.token.tokenType == TokenType.COMMA) {
                this.next();
                continue;
            }
            if (this.token.tokenType == TokenType.BRACKETEND) continue;
            throw new ProgramExceptions.ExpectedException(this, "Expect a )");
        }
        this.next();
    }

    private List<Var> parseParamList() {
        ArrayList<Var> paramList = new ArrayList<Var>(10);
        this.next();
        while (this.token.tokenType != TokenType.BRACKETEND) {
            paramList.add(this.parseExpression());
            if (this.token.tokenType == TokenType.COMMA) {
                this.next();
                continue;
            }
            if (this.token.tokenType == TokenType.BRACKETEND) continue;
            throw new ProgramExceptions.ExpectedException(this, "Expect a )");
        }
        this.next();
        return paramList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseValueSkip() {
        if (this.token.tokenType == TokenType.PLUS) {
            this.next();
            this.parseValueSkip();
        } else if (this.token.tokenType == TokenType.MINUS) {
            this.next();
            this.parseValueSkip();
        } else if (this.token.tokenType == TokenType.NOT) {
            this.next();
            this.parseValueSkip();
        } else if (this.token.tokenType == TokenType.BITNOT) {
            this.next();
            this.parseValueSkip();
        } else if (this.token.tokenType == TokenType.VALUE) {
            this.next();
        } else if (this.token.tokenType == TokenType.STRING) {
            this.next();
        } else if (this.token.tokenType == TokenType.BRACKETBEGIN) {
            this.next();
            this.parseExpressionSkip();
            if (this.token.tokenType != TokenType.BRACKETEND) {
                throw new ProgramExceptions.ExpectedException(this, "Expected a )");
            }
            this.next();
        } else {
            if (this.token.tokenType != TokenType.IDENTIFIER) {
                throw new ProgramExceptions.ExpectedException(this, "Value");
            }
            boolean lastIsNumber = false;
            this.next();
            while (this.token.tokenType == TokenType.POINT || this.token.tokenType == TokenType.SQUAREBRACKETBEGIN) {
                if (this.token.tokenType == TokenType.POINT) {
                    this.next();
                    if (this.token.tokenType != TokenType.IDENTIFIER) {
                        throw new ProgramExceptions.ExpectedException(this, "Expected a identifier");
                    }
                    lastIsNumber = false;
                    this.next();
                    continue;
                }
                if (this.token.tokenType != TokenType.SQUAREBRACKETBEGIN) continue;
                this.next();
                this.parseExpressionSkip();
                lastIsNumber = true;
                if (this.token.tokenType != TokenType.SQUAREBRACKETEND) {
                    throw new ProgramExceptions.ExpectedException(this, "Expected a ]");
                }
                this.next();
            }
            if (this.token.tokenType == TokenType.BRACKETBEGIN) {
                if (lastIsNumber) {
                    throw new ProgramExceptions.ExpectedException(this, "Function name can not be an array index");
                }
                this.parseParamListSkip();
            }
        }
        while (this.token.tokenType == TokenType.POINT) {
            this.next();
            if (this.token.tokenType != TokenType.IDENTIFIER) {
                throw new ProgramExceptions.ExpectedException(this, "Identifier expected");
            }
            this.next();
            if (this.token.tokenType != TokenType.BRACKETBEGIN) {
                throw new ProgramExceptions.ExpectedException(this, "( expected");
            }
            this.parseParamListSkip();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Var parseValue() {
        Functions.Func f;
        List<Var> paramList;
        Var v;
        block33: {
            Var vv;
            block35: {
                block38: {
                    block37: {
                        block36: {
                            block34: {
                                v = null;
                                if (this.token.tokenType != TokenType.PLUS) break block34;
                                this.next();
                                v = this.parseValue();
                                break block33;
                            }
                            if (this.token.tokenType != TokenType.MINUS) break block35;
                            this.next();
                            vv = this.parseValue();
                            v = new Var();
                            if (!vv.isInt()) break block36;
                            v.set(-vv.asInt());
                            break block33;
                        }
                        if (!vv.isLong()) break block37;
                        v.set(-vv.asLong());
                        break block33;
                    }
                    if (!vv.isDouble() && !vv.isFloat()) break block38;
                    v.set(-vv.asDouble());
                    break block33;
                }
                if (vv.canLong()) {
                    v.set(-vv.asLong());
                    break block33;
                } else if (vv.canDouble()) {
                    v.set(-vv.asDouble());
                    break block33;
                } else {
                    if (!vv.canComplex()) {
                        throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "-", vv);
                    }
                    v.set(vv.asComplex().neg());
                }
                break block33;
            }
            if (this.token.tokenType == TokenType.NOT) {
                this.next();
                vv = this.parseValue();
                v = new Var();
                v.set(!vv.asBoolean());
            } else if (this.token.tokenType == TokenType.BITNOT) {
                this.next();
                vv = this.parseValue();
                v = new Var();
                if (vv.isInt()) {
                    v.set(~vv.asInt());
                } else {
                    if (!vv.canLong()) {
                        throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "bitnot", vv);
                    }
                    v.set(vv.asLong() ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else if (this.token.tokenType == TokenType.VALUE) {
                v = this.token.value;
                this.next();
            } else if (this.token.tokenType == TokenType.STRING) {
                v = new Var();
                v.set(this.token.text);
                this.next();
            } else if (this.token.tokenType == TokenType.BRACKETBEGIN) {
                this.next();
                v = this.parseExpression();
                if (this.token.tokenType != TokenType.BRACKETEND) {
                    throw new ProgramExceptions.ExpectedException(this, "Expected a )");
                }
                this.next();
            } else {
                if (this.token.tokenType != TokenType.IDENTIFIER) {
                    throw new ProgramExceptions.ExpectedException(this, "Value");
                }
                ArrayList<Object> indexList = new ArrayList<Object>();
                indexList.add(this.token.text);
                this.next();
                while (this.token.tokenType == TokenType.POINT || this.token.tokenType == TokenType.SQUAREBRACKETBEGIN) {
                    if (this.token.tokenType == TokenType.POINT) {
                        this.next();
                        if (this.token.tokenType != TokenType.IDENTIFIER) {
                            throw new ProgramExceptions.ExpectedException(this, "Expected a identifier");
                        }
                        indexList.add(this.token.text);
                        this.next();
                        continue;
                    }
                    if (this.token.tokenType != TokenType.SQUAREBRACKETBEGIN) continue;
                    this.next();
                    indexList.add(this.parseExpression().asInt());
                    if (this.token.tokenType != TokenType.SQUAREBRACKETEND) {
                        throw new ProgramExceptions.ExpectedException(this, "Expected a ]");
                    }
                    this.next();
                }
                if (this.token.tokenType == TokenType.BRACKETBEGIN) {
                    if (!(indexList.get(indexList.size() - 1) instanceof String)) {
                        throw new ProgramExceptions.ExpectedException(this, "Function name can not be an array index");
                    }
                    paramList = this.parseParamList();
                    f = this.getFunc(indexList);
                    v = f.execute(this, paramList);
                    paramList.clear();
                    if (this.token.tokenType == TokenType.SQUAREBRACKETBEGIN) {
                        this.next();
                        indexList.clear();
                        int arrayIndex = this.parseExpression().asInt();
                        if (this.token.tokenType != TokenType.SQUAREBRACKETEND) {
                            throw new ProgramExceptions.ExpectedException(this, "Expected a ]");
                        }
                        this.next();
                        v = v.get(arrayIndex);
                    }
                } else {
                    v = this.getVar(indexList);
                    indexList.clear();
                }
            }
        }
        while (this.token.tokenType == TokenType.POINT) {
            this.next();
            if (this.token.tokenType != TokenType.IDENTIFIER) {
                throw new ProgramExceptions.ExpectedException(this, "Identifier expected");
            }
            String funcName = this.token.text;
            this.next();
            if (this.token.tokenType != TokenType.BRACKETBEGIN) {
                throw new ProgramExceptions.ExpectedException(this, "( expected");
            }
            paramList = this.parseParamList();
            f = v.findFunc(funcName);
            if (f == null) {
                throw new ProgramExceptions.UnknownFunctionException(this, String.valueOf(funcName) + " not found");
            }
            v = f.execute(this, paramList);
            paramList.clear();
        }
        return v;
    }

    private void parseBitOpSkip() {
        this.parseValueSkip();
        while (this.token.tokenType == TokenType.SHIFT_LEFT || this.token.tokenType == TokenType.SHIFT_RIGHT || this.token.tokenType == TokenType.BITAND || this.token.tokenType == TokenType.BITOR || this.token.tokenType == TokenType.BITXOR) {
            this.next();
            this.parseValueSkip();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Var parseBitOp() {
        Var v1 = this.parseValue();
        while (this.token.tokenType == TokenType.SHIFT_LEFT || this.token.tokenType == TokenType.SHIFT_RIGHT || this.token.tokenType == TokenType.BITAND || this.token.tokenType == TokenType.BITOR || this.token.tokenType == TokenType.BITXOR) {
            Var v = new Var();
            TokenType t = this.token.tokenType;
            this.next();
            Var v2 = this.parseValue();
            if (t == TokenType.SHIFT_LEFT) {
                if (v1.isInt() && v2.isInt()) {
                    long vv = v1.asLong() << v2.asInt();
                    if (vv != (long)((int)vv)) {
                        v.set(vv);
                    } else {
                        v.set((int)vv);
                    }
                } else if (v1.isLong() && v2.isInt()) {
                    v.set(v1.asLong() << v2.asInt());
                } else {
                    if (!v1.canLong() || !v2.canInt()) throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "<<", v1, v2);
                    v.set(v1.asLong() << v2.asInt());
                }
            } else if (t == TokenType.SHIFT_RIGHT) {
                if (v1.isInt() && v2.isInt()) {
                    v.set(v1.asInt() >> v2.asInt());
                } else if (v1.isLong() && v2.isInt()) {
                    v.set(v1.asLong() >> v2.asInt());
                } else {
                    if (!v1.canLong() || !v2.canInt()) throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, ">>", v1, v2);
                    v.set(v1.asLong() >> v2.asInt());
                }
            } else if (t == TokenType.BITAND) {
                if (v1.isInt() && v2.isInt()) {
                    v.set(v1.asInt() & v2.asInt());
                } else if (v1.isLong() && v2.isLong()) {
                    v.set(v1.asLong() & v2.asLong());
                } else {
                    if (!v1.canLong() || !v2.canLong()) throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "BitAnd", v1, v2);
                    v.set(v1.asLong() & v2.asLong());
                }
            } else if (t == TokenType.BITOR) {
                if (v1.isInt() && v2.isInt()) {
                    v.set(v1.asInt() | v2.asInt());
                } else if (v1.isLong() && v2.isLong()) {
                    v.set(v1.asLong() | v2.asLong());
                } else {
                    if (!v1.canLong() || !v2.canLong()) throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "BitOr", v1, v2);
                    v.set(v1.asLong() | v2.asLong());
                }
            } else if (t == TokenType.BITXOR) {
                if (v1.isInt() && v2.isInt()) {
                    v.set(v1.asInt() ^ v2.asInt());
                } else if (v1.isLong() && v2.isLong()) {
                    v.set(v1.asLong() ^ v2.asLong());
                } else {
                    if (!v1.canLong() || !v2.canLong()) throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "BitXor", v1, v2);
                    v.set(v1.asLong() ^ v2.asLong());
                }
            }
            v1 = v;
        }
        return v1;
    }

    private void parseProductSkip() {
        this.parseBitOpSkip();
        while (this.token.tokenType == TokenType.MULTIPLY || this.token.tokenType == TokenType.DIVIDE || this.token.tokenType == TokenType.MODULUS) {
            this.next();
            this.parseBitOpSkip();
        }
    }

    /*
     * Unable to fully structure code
     */
    private Var parseProduct() {
        v1 = this.parseBitOp();
        while (this.token.tokenType == TokenType.MULTIPLY || this.token.tokenType == TokenType.DIVIDE || this.token.tokenType == TokenType.MODULUS) {
            block19: {
                block17: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                block24: {
                                                    block23: {
                                                        block22: {
                                                            block21: {
                                                                block20: {
                                                                    block18: {
                                                                        v = new Var();
                                                                        t = this.token.tokenType;
                                                                        this.next();
                                                                        v2 = this.parseBitOp();
                                                                        dt = v1.commonType(v2);
                                                                        if (t != TokenType.MULTIPLY) break block17;
                                                                        if (dt != Integer.class) break block18;
                                                                        v.set(v1.asInt() * v2.asInt());
                                                                        break block19;
                                                                    }
                                                                    if (dt != Long.class) break block20;
                                                                    v.set(v1.asLong() * v2.asLong());
                                                                    break block19;
                                                                }
                                                                if (dt != Float.class) break block21;
                                                                v.set(v1.asFloat() * v2.asFloat());
                                                                break block19;
                                                            }
                                                            if (dt != Double.class) break block22;
                                                            v.set(v1.asDouble() * v2.asDouble());
                                                            break block19;
                                                        }
                                                        if (dt != Complex.class) break block23;
                                                        v.set(v1.asComplex().mult(v2.asComplex()));
                                                        break block19;
                                                    }
                                                    if (!v1.isVector() || !v2.canDouble()) break block24;
                                                    v.set(v1.asVector().mult(v2.asDouble()));
                                                    break block19;
                                                }
                                                if (!v1.canDouble() || !v2.isVector()) break block25;
                                                v.set(v2.asVector().mult(v1.asDouble()));
                                                break block19;
                                            }
                                            if (!v1.isMatrix() || !v2.canDouble()) break block26;
                                            v.set(v1.asMatrix().mult(v2.asDouble()));
                                            break block19;
                                        }
                                        if (!v1.canDouble() || !v2.isMatrix()) break block27;
                                        v.set(v2.asMatrix().mult(v1.asDouble()));
                                        break block19;
                                    }
                                    if (!v1.isMatrix() || !v2.isVector()) break block28;
                                    y = v2.asVector();
                                    if (y.isColumnVector()) {
                                        v.set(v1.asMatrix().multC(y));
                                    } else {
                                        v.set(v1.asMatrix().multR(y));
                                    }
                                    break block19;
                                }
                                if (!v1.isVector() || !v2.isMatrix()) break block29;
                                v.set(v1.asVector().mult(v2.asMatrix()));
                                break block19;
                            }
                            if (dt != Matrix.class) break block30;
                            v.set(v1.asMatrix().mult(v2.asMatrix()));
                            break block19;
                        }
                        if (!v1.isString() || !v2.canInt()) break block31;
                        s = v1.asString();
                        sb = new StringBuilder();
                        i = v2.asInt();
                        if (i <= 10000) ** GOTO lbl70
                        throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "*", v1, v2);
lbl-1000:
                        // 1 sources

                        {
                            sb.append(s);
                            --i;
lbl70:
                            // 2 sources

                            ** while (i > 0)
                        }
lbl71:
                        // 1 sources

                        v.set(sb.toString());
                        break block19;
                    }
                    throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "*", v1, v2);
                }
                if (t != TokenType.DIVIDE) ** GOTO lbl93
                if (dt == Long.class) {
                    v.set(v1.asLong() / v2.asLong());
                } else if (dt == Double.class) {
                    v.set(v1.asDouble() / v2.asDouble());
                } else if (dt == Complex.class) {
                    v.set(v1.asComplex().div(v2.asComplex()));
                } else if (v1.isVector() && v2.canDouble()) {
                    v.set(v1.asVector().div(v2.asDouble()));
                } else if (v1.canDouble() && v2.isVector()) {
                    v.set(v2.asVector().div(v1.asDouble()));
                } else {
                    throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "/", v1, v2);
lbl93:
                    // 1 sources

                    if (t == TokenType.MODULUS) {
                        if (dt == Long.class) {
                            v.set(v1.asLong() % v2.asLong());
                        } else {
                            throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "MOD", v1, v2);
                        }
                    }
                }
            }
            v1 = v;
        }
        return v1;
    }

    private void parseSumSkip() {
        this.parseProductSkip();
        while (this.token.tokenType == TokenType.PLUS || this.token.tokenType == TokenType.MINUS) {
            this.next();
            this.parseProductSkip();
        }
    }

    private Var parseSum() {
        Var v1 = this.parseProduct();
        while (this.token.tokenType == TokenType.PLUS || this.token.tokenType == TokenType.MINUS) {
            Var v = new Var();
            TokenType t = this.token.tokenType;
            this.next();
            Var v2 = this.parseProduct();
            Class<?> dt = v1.commonType(v2);
            if (t == TokenType.PLUS) {
                if (dt == Long.class) {
                    v.set(v1.asLong() + v2.asLong());
                } else if (dt == Double.class) {
                    v.set(v1.asDouble() + v2.asDouble());
                } else if (dt == Complex.class) {
                    v.set(v1.asComplex().add(v2.asComplex()));
                } else if (dt == Vector.class) {
                    v.set(v1.asVector().add(v2.asVector()));
                } else if (dt == Matrix.class) {
                    v.set(v1.asMatrix().add(v2.asMatrix()));
                } else if (dt == VarValueBytes.class) {
                    ByteBuffer bb = new ByteBuffer();
                    bb.append(v1.asBytes());
                    bb.append(v2.asBytes());
                    v.set(bb.getAsArray());
                } else {
                    v.set(String.valueOf(v1.asString()) + v2.asString());
                }
            } else if (t == TokenType.MINUS) {
                if (dt == Long.class) {
                    v.set(v1.asLong() - v2.asLong());
                } else if (dt == Double.class) {
                    v.set(v1.asDouble() - v2.asDouble());
                } else if (dt == Complex.class) {
                    v.set(v1.asComplex().sub(v2.asComplex()));
                } else if (dt == Vector.class) {
                    v.set(v1.asVector().sub(v2.asVector()));
                } else if (dt == Matrix.class) {
                    v.set(v1.asMatrix().sub(v2.asMatrix()));
                } else {
                    throw new ProgramExceptions.OperationNotSupportedForDataTypeException(this, "-", v1, v2);
                }
            }
            v1 = v;
        }
        return v1;
    }

    private void parseCompareSkip() {
        this.parseSumSkip();
        if (this.token.tokenType == TokenType.COMPARE_LESS || this.token.tokenType == TokenType.COMPARE_GREATER || this.token.tokenType == TokenType.COMPARE_LESS_EQUAL || this.token.tokenType == TokenType.COMPARE_GREATER_EQUAL || this.token.tokenType == TokenType.COMPARE_EQUAL || this.token.tokenType == TokenType.COMPARE_NOT_EQUAL) {
            this.next();
            this.parseSumSkip();
        }
    }

    private Var parseCompare() {
        Var v1 = this.parseSum();
        if (this.token.tokenType == TokenType.COMPARE_LESS || this.token.tokenType == TokenType.COMPARE_GREATER || this.token.tokenType == TokenType.COMPARE_LESS_EQUAL || this.token.tokenType == TokenType.COMPARE_GREATER_EQUAL || this.token.tokenType == TokenType.COMPARE_EQUAL || this.token.tokenType == TokenType.COMPARE_NOT_EQUAL) {
            Var v = new Var();
            TokenType t = this.token.tokenType;
            this.next();
            Var v2 = this.parseSum();
            int s = v1.compareTo(v2);
            if (t == TokenType.COMPARE_LESS) {
                v.set(s < 0);
            } else if (t == TokenType.COMPARE_GREATER) {
                v.set(s > 0);
            } else if (t == TokenType.COMPARE_LESS_EQUAL) {
                v.set(s <= 0);
            } else if (t == TokenType.COMPARE_GREATER_EQUAL) {
                v.set(s >= 0);
            } else if (t == TokenType.COMPARE_EQUAL) {
                v.set(s == 0);
            } else if (t == TokenType.COMPARE_NOT_EQUAL) {
                v.set(s != 0);
            }
            v1 = v;
        }
        return v1;
    }

    private void parseLogicalSkip() {
        this.parseCompareSkip();
        while (this.token.tokenType == TokenType.AND || this.token.tokenType == TokenType.OR) {
            this.next();
            this.parseCompareSkip();
        }
    }

    private Var parseLogical() {
        Var v1 = this.parseCompare();
        while (this.token.tokenType == TokenType.AND || this.token.tokenType == TokenType.OR) {
            Var v = new Var();
            TokenType t = this.token.tokenType;
            this.next();
            Var v2 = this.parseCompare();
            if (t == TokenType.AND) {
                v.set(v1.asBoolean() && v2.asBoolean());
            } else if (t == TokenType.OR) {
                v.set(v1.asBoolean() || v2.asBoolean());
            }
            v1 = v;
        }
        return v1;
    }

    private void parseQuestionMarkSkip() {
        this.parseLogicalSkip();
        if (this.token.tokenType == TokenType.QUESTIONMARK) {
            this.next();
            this.parseLogicalSkip();
            if (this.token.tokenType != TokenType.COLON) {
                throw new ProgramExceptions.ExpectedException(this, "Expected a :");
            }
            this.next();
            this.parseLogicalSkip();
        }
    }

    private Var parseQuestionMark() {
        Var v = this.parseLogical();
        if (this.token.tokenType == TokenType.QUESTIONMARK) {
            this.next();
            if (v.asBoolean()) {
                v = this.parseLogical();
                if (this.token.tokenType != TokenType.COLON) {
                    throw new ProgramExceptions.ExpectedException(this, "Expected a :");
                }
                this.next();
                this.parseLogicalSkip();
            } else {
                this.parseLogicalSkip();
                if (this.token.tokenType != TokenType.COLON) {
                    throw new ProgramExceptions.ExpectedException(this, "Expected a :");
                }
                this.next();
                v = this.parseLogical();
            }
        }
        return v;
    }

    private void parseExpressionSkip() {
        this.parseQuestionMarkSkip();
    }

    private Var parseExpression() {
        return this.parseQuestionMark();
    }

    private Condition addCondition(ConditionKind ck) {
        Condition cc = new Condition(this.program.getPosition(), ck);
        this.conditions.add(cc);
        return cc;
    }

    private Condition currentCondition(ConditionKind ck) {
        Condition cc = this.conditions.get(this.conditions.size() - 1);
        if (cc.ck != ck) {
            throw new ProgramExceptions.ExpectedException(this, "Expected end of " + cc.ck.toString());
        }
        return cc;
    }

    private void removeCondition(ConditionKind kind) {
        this.currentCondition(kind);
        this.conditions.remove(this.conditions.size() - 1);
    }

    private void setConditionBreak() {
        Condition cc;
        int i = this.conditions.size() - 1;
        while (i >= 0) {
            cc = this.conditions.get(i);
            if (cc.ck != ConditionKind.IF && cc.ck != ConditionKind.UNDEF) break;
            cc.enabled = false;
            cc.enabledUsed = true;
            cc.isBreak = true;
            --i;
        }
        if (i < 0) {
            throw new ProgramExceptions.SyntaxException(this, "break, outside off breakable loop");
        }
        cc = this.conditions.get(i);
        if (cc.ck != ConditionKind.FOR && cc.ck != ConditionKind.FOREACH && cc.ck != ConditionKind.REPEAT && cc.ck != ConditionKind.WHILE) {
            throw new ProgramExceptions.SyntaxException(this, "break, outside off breakable loop");
        }
        cc.enabled = false;
        cc.enabledUsed = true;
        cc.isBreak = true;
    }

    private boolean isCurrentEnabled() {
        int n = this.conditions.size();
        if (n >= 2) {
            Condition cc = this.conditions.get(n - 2);
            return cc.enabled && !cc.isBreak;
        }
        if (n >= 1) {
            Condition cc = this.conditions.get(n - 1);
            return !cc.isBreak;
        }
        return true;
    }

    private void updateIgnoreFlag() {
        int i = this.conditions.size() - 1;
        while (i >= 0) {
            if (!this.conditions.get((int)i).enabled) {
                this.ignore = true;
                return;
            }
            --i;
        }
        this.ignore = false;
    }

    private boolean checkIf() {
        if (this.isCurrentEnabled()) {
            Var v = this.parseExpression();
            if (v == null) {
                throw new ProgramExceptions.ExpectedException(this, "Expression");
            }
            return v.asBoolean();
        }
        this.parseExpressionSkip();
        return false;
    }

    private void statementIf() {
        this.next();
        Condition cc = this.addCondition(ConditionKind.IF);
        cc.enabledUsed = cc.enabled = this.checkIf();
        this.updateIgnoreFlag();
    }

    private void statementElse() {
        this.next();
        Condition cc = this.currentCondition(ConditionKind.IF);
        cc.enabled = !cc.enabledUsed & this.isCurrentEnabled();
        this.updateIgnoreFlag();
    }

    private void statementElseIf() {
        this.next();
        Condition cc = this.currentCondition(ConditionKind.IF);
        cc.enabled = this.checkIf() && !cc.enabledUsed;
        cc.enabledUsed = cc.enabledUsed || cc.enabled;
        this.updateIgnoreFlag();
    }

    private void statementEndIf() {
        this.next();
        this.removeCondition(ConditionKind.IF);
        this.updateIgnoreFlag();
    }

    private void statementRepeat() {
        Condition cc = this.addCondition(ConditionKind.REPEAT);
        cc.enabled = this.isCurrentEnabled();
        cc.enabledUsed = cc.enabledUsed || cc.enabled;
        this.next();
        this.updateIgnoreFlag();
    }

    private void statementUntil() {
        this.next();
        Condition cc = this.currentCondition(ConditionKind.REPEAT);
        if (this.isCurrentEnabled()) {
            Var v = this.parseExpression();
            if (!v.asBoolean()) {
                this.program.setPosition(cc.programPosition);
                this.next();
            } else {
                this.removeCondition(ConditionKind.REPEAT);
            }
        } else {
            this.parseExpressionSkip();
            this.removeCondition(ConditionKind.REPEAT);
        }
        this.updateIgnoreFlag();
    }

    private boolean nextForEachElement(Condition cc) {
        if (cc.endValue.isArray() || cc.endValue.isStruct()) {
            if (cc.index >= cc.endValue.getSize()) {
                return false;
            }
            cc.ref.set(cc.endValue.get(cc.index).clone());
            ++cc.index;
            return true;
        }
        if (cc.endValue == null) {
            return false;
        }
        throw new ProgramExceptions.UnknownException(this, "ForEach iteration not possible");
    }

    private void statementForEach() {
        this.next();
        Condition cc = this.addCondition(ConditionKind.FOREACH);
        if (this.isCurrentEnabled()) {
            cc.ref = this.varReference();
            if (cc.ref == null) {
                throw new ProgramExceptions.UnknownException(this, "ForEach loop variable not found");
            }
            if (this.token.tokenType != TokenType.IN) {
                throw new ProgramExceptions.ExpectedException(this, "IN expected");
            }
            this.next();
            cc.endValue = this.parseExpression();
            if (this.token.tokenType != TokenType.DO) {
                throw new ProgramExceptions.ExpectedException(this, "DO expected");
            }
            cc.programPosition = this.program.getPosition();
            this.next();
            cc.enabled = this.nextForEachElement(cc);
        } else {
            cc.endValue = null;
            cc.ref = null;
            this.varReferenceSkip();
            if (this.token.tokenType != TokenType.IN) {
                throw new ProgramExceptions.ExpectedException(this, "IN expected");
            }
            this.next();
            this.parseExpressionSkip();
            if (this.token.tokenType != TokenType.DO) {
                throw new ProgramExceptions.ExpectedException(this, "DO expected");
            }
            this.next();
            cc.enabled = false;
        }
        this.updateIgnoreFlag();
    }

    private void statementEndForEach() {
        Condition cc = this.currentCondition(ConditionKind.FOREACH);
        if (this.isCurrentEnabled()) {
            cc.enabled = this.nextForEachElement(cc);
        }
        if (!cc.enabled) {
            this.removeCondition(ConditionKind.FOREACH);
        } else {
            this.program.setPosition(cc.programPosition);
        }
        this.next();
        this.updateIgnoreFlag();
    }

    private void statementFor() {
        this.next();
        Condition cc = this.addCondition(ConditionKind.FOR);
        if (this.isCurrentEnabled()) {
            cc.ref = this.varReference();
            if (cc.ref == null) {
                throw new ProgramExceptions.UnknownException(this, "For loop variable not found");
            }
            if (this.token.tokenType != TokenType.ASSIGN) {
                throw new ProgramExceptions.ExpectedException(this, "Assignment expected");
            }
            this.next();
            cc.ref.set(this.parseExpression());
            boolean bl = cc.down = this.token.tokenType == TokenType.DOWNTO;
            if (this.token.tokenType != TokenType.TO && this.token.tokenType != TokenType.DOWNTO) {
                throw new ProgramExceptions.ExpectedException(this, "To/DownTo expected");
            }
            this.next();
            cc.endValue = this.parseExpression();
            if (this.token.tokenType != TokenType.DO) {
                throw new ProgramExceptions.ExpectedException(this, "Do expected");
            }
            cc.programPosition = this.program.getPosition();
            this.next();
            cc.enabled = cc.down ? cc.ref.asLong() >= cc.endValue.asLong() : cc.ref.asLong() <= cc.endValue.asLong();
        } else {
            this.varReferenceSkip();
            if (this.token.tokenType != TokenType.ASSIGN) {
                throw new ProgramExceptions.ExpectedException(this, "Assignment expected");
            }
            this.next();
            this.parseExpressionSkip();
            if (this.token.tokenType != TokenType.TO && this.token.tokenType != TokenType.DOWNTO) {
                throw new ProgramExceptions.ExpectedException(this, "To/DownTo expected");
            }
            this.next();
            this.parseExpressionSkip();
            if (this.token.tokenType != TokenType.DO) {
                throw new ProgramExceptions.ExpectedException(this, "Do expected");
            }
            this.next();
            cc.enabled = false;
            cc.ref = null;
            cc.endValue = null;
        }
        this.updateIgnoreFlag();
    }

    private void statementEndFor() {
        Condition cc = this.currentCondition(ConditionKind.FOR);
        if (this.isCurrentEnabled()) {
            if (cc.down) {
                cc.ref.set(cc.ref.asLong() - 1L);
                cc.enabled = cc.ref.asLong() >= cc.endValue.asLong();
            } else {
                cc.ref.set(cc.ref.asLong() + 1L);
                boolean bl = cc.enabled = cc.ref.asLong() <= cc.endValue.asLong();
            }
        }
        if (!cc.enabled) {
            this.removeCondition(ConditionKind.FOR);
        } else {
            this.program.setPosition(cc.programPosition);
        }
        this.next();
        this.updateIgnoreFlag();
    }

    private void statementWhile() {
        Condition cc = this.addCondition(ConditionKind.WHILE);
        if (this.isCurrentEnabled()) {
            this.next();
            Var v = this.parseExpression();
            cc.enabled = v.asBoolean();
        } else {
            this.next();
            this.parseExpressionSkip();
            cc.enabled = false;
        }
        if (this.token.tokenType != TokenType.DO) {
            throw new ProgramExceptions.ExpectedException(this, "Do expected");
        }
        this.next();
        this.updateIgnoreFlag();
    }

    private void statementEndWhile() {
        Condition cc = this.currentCondition(ConditionKind.WHILE);
        if (this.isCurrentEnabled()) {
            Program.ProgramPosition pp = this.program.getPosition();
            this.program.setPosition(cc.programPosition);
            this.next();
            Var v = this.parseExpression();
            if (!v.asBoolean()) {
                this.program.setPosition(pp);
                this.next();
                this.removeCondition(ConditionKind.WHILE);
            } else {
                if (this.token.tokenType != TokenType.DO) {
                    throw new ProgramExceptions.ExpectedException(this, "Do expected");
                }
                this.next();
            }
        } else {
            this.next();
            cc.enabled = false;
            this.removeCondition(ConditionKind.WHILE);
        }
        this.updateIgnoreFlag();
    }

    private void statementVar(boolean global) {
        do {
            Var varList;
            Var v = null;
            this.next();
            if (this.token.tokenType != TokenType.IDENTIFIER) {
                throw new ProgramExceptions.ExpectedException(this, "Identifier expected");
            }
            ArrayList<Object> indexList = new ArrayList<Object>(10);
            indexList.add(this.token.text);
            this.next();
            while (this.token.tokenType == TokenType.POINT || this.token.tokenType == TokenType.SQUAREBRACKETBEGIN) {
                if (this.token.tokenType == TokenType.POINT) {
                    this.next();
                    indexList.add(this.token.text);
                    this.next();
                    continue;
                }
                if (this.token.tokenType != TokenType.SQUAREBRACKETBEGIN) continue;
                this.next();
                indexList.add(this.parseExpression().asInt());
                if (this.token.tokenType != TokenType.SQUAREBRACKETEND) {
                    throw new ProgramExceptions.ExpectedException(this, "] expected");
                }
                this.next();
            }
            if (!this.ignore && (v = (varList = global ? Var.gl : this.localVars).find(indexList)) == null) {
                v = varList.getCreate(indexList);
            }
            if (this.token.tokenType != TokenType.ASSIGN) continue;
            this.next();
            if (this.ignore) {
                this.parseExpressionSkip();
                continue;
            }
            v.set(this.parseExpression());
        } while (this.token.tokenType == TokenType.COMMA);
    }

    private void statementFail() {
        throw new ProgramExceptions.UnknownException(this, "Not expecting " + this.token.tokenType.toString());
    }

    private void statementBreak() {
        if (!this.ignore) {
            this.setConditionBreak();
            this.updateIgnoreFlag();
        }
        this.next();
    }

    private void statementReturn() {
        this.next();
        if (this.token.tokenType != TokenType.COLON && this.token.tokenType != TokenType.EOF) {
            if (this.printText.length() > 0) {
                throw new ProgramExceptions.SyntaxException(this, "Print and return with a result can not be combined");
            }
            if (!this.ignore) {
                this.lastResult = this.parseExpression();
            }
            this.printText.setLength(0);
        }
        this.token = new Token(TokenType.EOF);
    }

    private void statementOutside() {
        this.nextOutside();
        if (!this.ignore) {
            this.printText.append(this.token.text);
        }
        this.next();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Var varReference() {
        Var v = null;
        try {
            if (this.token.tokenType != TokenType.IDENTIFIER) return v;
            String name = this.token.text;
            this.next();
            if (this.token.tokenType == TokenType.BRACKETBEGIN) return v;
            ArrayList<Object> indexList = new ArrayList<Object>(10);
            indexList.add(name);
            while (true) {
                if (this.token.tokenType != TokenType.POINT && this.token.tokenType != TokenType.SQUAREBRACKETBEGIN) {
                    v = this.getVar(indexList);
                    indexList.clear();
                    return v;
                }
                if (this.token.tokenType == TokenType.POINT) {
                    this.next();
                    indexList.add(this.token.text);
                    this.next();
                    continue;
                }
                if (this.token.tokenType != TokenType.SQUAREBRACKETBEGIN) continue;
                this.next();
                indexList.add(this.parseExpression().asInt());
                if (this.token.tokenType != TokenType.SQUAREBRACKETEND) {
                    return null;
                }
                this.next();
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean varReferenceSkip() {
        boolean v = false;
        try {
            if (this.token.tokenType != TokenType.IDENTIFIER) return v;
            this.next();
            if (this.token.tokenType == TokenType.BRACKETBEGIN) return v;
            while (true) {
                if (this.token.tokenType != TokenType.POINT && this.token.tokenType != TokenType.SQUAREBRACKETBEGIN) {
                    return true;
                }
                if (this.token.tokenType == TokenType.POINT) {
                    this.next();
                    this.next();
                    continue;
                }
                if (this.token.tokenType != TokenType.SQUAREBRACKETBEGIN) continue;
                this.next();
                if (this.token.tokenType != TokenType.SQUAREBRACKETEND) {
                    return false;
                }
                this.next();
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private void statement() {
        if (this.token.tokenType == TokenType.SEMICOLON) {
            this.next();
            return;
        }
        this.lastResult = null;
        if (this.token.tokenType == TokenType.IF) {
            this.statementIf();
        } else if (this.token.tokenType == TokenType.ELSE) {
            this.statementElse();
        } else if (this.token.tokenType == TokenType.ELSEIF) {
            this.statementElseIf();
        } else if (this.token.tokenType == TokenType.ENDIF) {
            this.statementEndIf();
        } else if (this.token.tokenType == TokenType.REPEAT) {
            this.statementRepeat();
        } else if (this.token.tokenType == TokenType.UNTIL) {
            this.statementUntil();
        } else if (this.token.tokenType == TokenType.FOR) {
            this.statementFor();
        } else if (this.token.tokenType == TokenType.FOREACH) {
            this.statementForEach();
        } else if (this.token.tokenType == TokenType.ENDFOREACH) {
            this.statementEndForEach();
        } else if (this.token.tokenType == TokenType.ENDFOR) {
            this.statementEndFor();
        } else if (this.token.tokenType == TokenType.WHILE) {
            this.statementWhile();
        } else if (this.token.tokenType == TokenType.ENDWHILE) {
            this.statementEndWhile();
        } else if (this.token.tokenType == TokenType.VAR) {
            this.statementVar(false);
        } else if (this.token.tokenType == TokenType.GLOBALVAR) {
            this.statementVar(true);
        } else if (this.token.tokenType == TokenType.IN) {
            this.statementFail();
        } else if (this.token.tokenType == TokenType.DO) {
            this.statementFail();
        } else if (this.token.tokenType == TokenType.RETURN) {
            this.statementReturn();
        } else if (this.token.tokenType == TokenType.BREAK) {
            this.statementBreak();
        } else if (this.token.tokenType == TokenType.END_MARK) {
            this.statementOutside();
        } else if (this.ignore) {
            Program.ProgramPosition savedPos = this.program.getPosition();
            Token savedToken = this.token;
            if (!this.varReferenceSkip() && this.token.tokenType == TokenType.ASSIGN) {
                this.next();
                this.parseExpressionSkip();
            } else {
                this.program.setPosition(savedPos);
                this.token = savedToken;
                this.parseExpressionSkip();
            }
        } else {
            Program.ProgramPosition savedPos = this.program.getPosition();
            Token savedToken = this.token;
            Var ref = this.varReference();
            if (ref != null && this.token.tokenType == TokenType.ASSIGN) {
                this.next();
                Var v = this.parseExpression();
                ref.setCopy(v);
            } else {
                this.program.setPosition(savedPos);
                this.token = savedToken;
                this.lastResult = this.parseExpression();
            }
        }
    }

    public Script() {
        this.localVars.addFunc(new Functions.Func("print"){

            @Override
            public Var execute(Script script, List<Var> params) {
                for (Var v : params) {
                    script.printText.append(v.asString());
                }
                return null;
            }
        });
        this.defaultStartMark = "<?";
        this.defaultEndMark = "?>";
        this.printText = new StringBuilder();
    }

    public Script(Script parentScript) {
        this();
        this.parentScript = parentScript;
    }

    public Script(String startMark, String endMark) {
        this();
        this.defaultStartMark = startMark;
        this.defaultEndMark = endMark;
    }

    private void initScript() {
        this.printText.setLength(0);
        this.lastResult = null;
        this.conditions.clear();
    }

    public synchronized void addLocalVar(Var v) {
        if (v.getName().length() == 0) {
            throw new ProgramExceptions.SyntaxException(this, "Local variable must have a name");
        }
        this.localVars.addVar(v);
    }

    public synchronized void addLocalVar(String name, Var v) {
        if (name.length() == 0) {
            throw new ProgramExceptions.SyntaxException(this, "Local variable must have a name");
        }
        this.localVars.addVar(name, v);
    }

    public Var findVar(String name) {
        return this.findVar(Var.makeIndexList(name));
    }

    public Var findLocalVar(String name) {
        return this.localVars.find(name);
    }

    public Var getLocalVar(String name) {
        return this.localVars.get(name);
    }

    public Var getLocalVars() {
        return this.localVars;
    }

    public void addLocalVars(Collection<Var> params) {
        for (Var v : params) {
            this.addLocalVar(v);
        }
    }

    public void addLocalVars(Var[] params) {
        Var[] varArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            this.addLocalVar(v);
            ++n2;
        }
    }

    public void addLocalVars(String[] names, Var[] params) {
        int i = 0;
        while (i < params.length) {
            this.addLocalVar(names[i], params[i]);
            ++i;
        }
    }

    public synchronized void removeLocalVar(Var v) {
        if (v.getName().length() == 0) {
            throw new ProgramExceptions.SyntaxException(this, "Local variable must have a name");
        }
        this.localVars.remove(v.getName());
    }

    public void removeLocalVar(String name) {
        this.localVars.remove(name);
    }

    public void removeLocalVars(Collection<Var> params) {
        for (Var v : params) {
            this.removeLocalVar(v.getName());
        }
    }

    public void removeLocalVars(Var[] params) {
        Var[] varArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            this.removeLocalVar(v.getName());
            ++n2;
        }
    }

    public synchronized Var expression(String text) {
        this.noFault = null;
        this.program = new Program(this, text, false);
        this.initScript();
        try {
            this.next();
            this.lastResult = this.parseExpression();
        }
        catch (ProgramExceptions.ScriptException e) {
            if (this.noFault != null) {
                this.lastResult = this.noFault;
                return this.noFault;
            }
            throw e;
        }
        catch (Exception e) {
            if (this.noFault != null) {
                this.lastResult = this.noFault;
                return this.noFault;
            }
            throw new ProgramExceptions.UnknownException(this, (Throwable)e);
        }
        if (this.printText.length() > 0) {
            this.lastResult = Var.createValue(this.printText.toString());
        }
        return this.lastResult;
    }

    private void doExecute(Program program) {
        this.noFault = null;
        this.stopRequest = false;
        this.program = program;
        this.initScript();
        try {
            if (program.isEmbedded()) {
                this.statementOutside();
            } else {
                this.next();
            }
            while (this.token.tokenType != TokenType.EOF && !this.stopRequest) {
                this.statement();
            }
        }
        catch (ProgramExceptions.ScriptException e) {
            if (this.noFault != null) {
                this.printText.setLength(0);
                this.lastResult = this.noFault;
                return;
            }
            throw e;
        }
        catch (Exception e) {
            if (this.noFault != null) {
                this.printText.setLength(0);
                this.lastResult = this.noFault;
                return;
            }
            throw new ProgramExceptions.UnknownException(this, (Throwable)e);
        }
    }

    public Var execute(Program program) {
        program.resetPosition();
        this.doExecute(program);
        if (this.printText.length() > 0) {
            this.lastResult = Var.createValue(this.printText.toString());
        }
        return this.lastResult;
    }

    public Var execute(String text) {
        return this.execute(new Program(this, text, false));
    }

    public synchronized Var execute(String text, Collection<Var> params) {
        this.addLocalVars(params);
        try {
            Var var = this.execute(text);
            return var;
        }
        finally {
            this.removeLocalVars(params);
        }
    }

    public synchronized Var execute(String text, Var[] params) {
        this.addLocalVars(params);
        try {
            Var var = this.execute(text);
            return var;
        }
        finally {
            this.removeLocalVars(params);
        }
    }

    public synchronized Var execute(String text, String[] names, Var[] params) {
        this.addLocalVars(names, params);
        try {
            Var var = this.execute(text);
            return var;
        }
        finally {
            this.removeLocalVars(params);
        }
    }

    public Var execute(String text, Var v1) {
        return this.execute(text, new Var[]{v1});
    }

    public Var execute(String text, Var v1, Var v2) {
        return this.execute(text, new Var[]{v1, v2});
    }

    public Var execute(String text, Var v1, Var v2, Var v3) {
        return this.execute(text, new Var[]{v1, v2, v3});
    }

    public synchronized String executeEmbedded(Program program) {
        this.doExecute(program);
        if (this.printText.length() > 0) {
            return this.printText.toString();
        }
        return this.lastResult == null ? "" : this.lastResult.asString();
    }

    public String executeEmbedded(String text, String startMark, String endMark) {
        return this.executeEmbedded(new Program(this, text, startMark, endMark, false));
    }

    public String executeEmbedded(String text) {
        return this.executeEmbedded(new Program(this, text, this.defaultStartMark, this.defaultEndMark, false));
    }

    public synchronized String executeEmbedded(String text, Var[] params) {
        this.addLocalVars(params);
        try {
            String string = this.executeEmbedded(new Program(this, text, this.defaultStartMark, this.defaultEndMark, false));
            return string;
        }
        finally {
            this.removeLocalVars(params);
        }
    }

    public synchronized String executeEmbedded(String text, Collection<Var> params) {
        this.addLocalVars(params);
        try {
            String string = this.executeEmbedded(new Program(this, text, this.defaultStartMark, this.defaultEndMark, false));
            return string;
        }
        finally {
            this.removeLocalVars(params);
        }
    }

    public String executeEmbedded(String text, Var v1) {
        return this.executeEmbedded(text, new Var[]{v1});
    }

    public String executeEmbedded(String text, Var v1, Var v2) {
        return this.executeEmbedded(text, new Var[]{v1, v2});
    }

    public String executeEmbedded(String text, Var v1, Var v2, Var v3) {
        return this.executeEmbedded(text, new Var[]{v1, v2, v3});
    }

    public synchronized Var getResult() {
        if (this.lastResult == null) {
            this.lastResult = this.printText != null && this.printText.length() > 0 ? Var.createValue(this.printText.toString()) : new Var();
        }
        return this.lastResult;
    }

    public Program getProgram() {
        return new Program(this.program);
    }

    public Program compile(String text, String startMark, String endMark) {
        return new Program(this, text, startMark, endMark, true);
    }

    public Program compile(boolean embedded, String text) {
        this.program = embedded ? new Program(this, text, this.defaultStartMark, this.defaultEndMark, true) : new Program(this, text, true);
        return this.program;
    }

    public List<String> tokenize(boolean embedded, String text) {
        ArrayList<String> list = new ArrayList<String>(1000);
        this.program = embedded ? new Program(this, text, this.defaultStartMark, this.defaultEndMark, false) : new Program(this, text, false);
        do {
            this.next();
            list.add(this.token.toString());
        } while (this.token.tokenType != TokenType.EOF);
        return list;
    }

    public static synchronized Var globalExecute(String program) {
        if (globalScript == null) {
            globalScript = new Script();
        }
        return globalScript.execute(program);
    }
}

