/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Script;
import dk.hkj.vars.Var;

public class ProgramExceptions {

    public static class DateTimeErrorException
    extends ScriptException {
        public DateTimeErrorException(Script script, String msg) {
            super(script, msg);
        }

        public DateTimeErrorException(Script script, String msg, Throwable cause) {
            super(script, msg, cause);
        }
    }

    public static class ExpectedException
    extends ScriptException {
        ExpectedException(Script script, String msg) {
            super(script, msg);
        }
    }

    public static class FileErrorException
    extends ScriptException {
        public FileErrorException(Script script, String msg) {
            super(script, msg);
        }

        public FileErrorException(Script script, String msg, Throwable cause) {
            super(script, msg, cause);
        }
    }

    public static class InvalidException
    extends ScriptException {
        InvalidException(Script script, String msg) {
            super(script, msg);
        }
    }

    public static class InvalidNumberOfParamsException
    extends ScriptException {
        public InvalidNumberOfParamsException(Script script, String msg) {
            super(script, msg);
        }
    }

    public static class OperationNotSupportedForDataTypeException
    extends ScriptException {
        OperationNotSupportedForDataTypeException(Script script, String msg, Var v1, Var v2) {
            super(script, msg);
        }

        OperationNotSupportedForDataTypeException(Script script, String msg, Var v1) {
            super(script, msg);
        }
    }

    public static class ScriptException
    extends RuntimeException {
        ScriptException(Script script, String msg) {
            super(String.valueOf(msg) + '\n' + script.program.getExtract());
        }

        ScriptException(Script script, String msg, Throwable cause) {
            super(String.valueOf(msg) + '\n' + script.program.getExtract(), cause);
        }
    }

    public static class SyntaxException
    extends ScriptException {
        public SyntaxException(Script script, String msg) {
            super(script, msg);
        }
    }

    public static class UnexpectedEofException
    extends ScriptException {
        UnexpectedEofException(Script script, String msg) {
            super(script, msg);
        }
    }

    public static class UnknownException
    extends ScriptException {
        public UnknownException(Script script, String msg) {
            super(script, msg);
        }

        public UnknownException(Script script, Throwable e) {
            super(script, e.getMessage());
            this.initCause(e);
        }
    }

    public static class UnknownFunctionException
    extends ScriptException {
        public UnknownFunctionException(Script script, String msg) {
            super(script, msg);
        }
    }

    public static class UnknownValueException
    extends ScriptException {
        public UnknownValueException(Script script, String msg) {
            super(script, msg);
        }
    }

    public static class ValueOutOfRangeException
    extends ScriptException {
        ValueOutOfRangeException(Script script, String msg) {
            super(script, msg);
        }
    }
}

