/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.ProgramExceptions;
import dk.hkj.script.Script;
import dk.hkj.script.Token;
import dk.hkj.script.TokenType;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.Complex;
import dk.hkj.vars.Var;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Program {
    private String sourceProgram;
    private Token[] compiledProgram;
    private int line;
    private int index = 0;
    private StringBuilder sb;
    private String startMark;
    private String endMark;
    static boolean localSyntax = true;
    Script script;
    private static Map<String, Token> reservedWordsList;
    private static final Token TOKEN_WHITESPACE;
    private static final Token TOKEN_SEMICOLON;
    private static final Token TOKEN_EOF;
    private static final String numberDigitsLetters = "YZEPTGMkmunpfazoObBhHe";
    private static final String numberDigitsDigits = "0123456789";
    private static final String numberDigitsHex = "abcdefABCDEF$";
    private static final String numberDigits = "0123456789YZEPTGMkmunpfazoObBhHeabcdefABCDEF$.";

    static {
        TOKEN_WHITESPACE = new Token(TokenType.WHITESPACE);
        TOKEN_SEMICOLON = new Token(TokenType.SEMICOLON);
        TOKEN_EOF = new Token(TokenType.EOF);
        Program.initReservedWord();
    }

    private void compile() {
        Token t;
        boolean outside;
        ArrayList<Token> list = new ArrayList<Token>();
        boolean bl = outside = this.startMark != null;
        do {
            if (outside) {
                t = this.nextTokenOutsideProgram();
                outside = false;
            } else {
                t = this.nextTokenWhiteSpace();
                if (t.tokenType == TokenType.END_MARK) {
                    outside = true;
                }
            }
            list.add(t);
        } while (t.tokenType != TokenType.EOF);
        this.compiledProgram = list.toArray(new Token[0]);
        this.line = 0;
        this.index = 0;
    }

    public Program(Program program) {
        this(program.script, program.sourceProgram, program.startMark, program.endMark, true);
    }

    public Program(Script script, String program, boolean compile) {
        this.sourceProgram = program;
        this.compiledProgram = null;
        this.sb = new StringBuilder();
        this.line = 0;
        this.startMark = null;
        this.endMark = null;
        this.script = script;
        if (compile) {
            this.compile();
        }
    }

    public Program(Script script, String program, String startMark, String endMark, boolean compile) {
        this(script, program, false);
        if (startMark != null || endMark != null) {
            this.compiledProgram = null;
            this.startMark = startMark;
            this.endMark = endMark;
            if (startMark == null || startMark.length() == 0) {
                throw new ProgramExceptions.SyntaxException(script, "start mark is undefined");
            }
            if (endMark == null || endMark.length() == 0) {
                throw new ProgramExceptions.SyntaxException(script, "end mark is undefined");
            }
        }
        if (compile) {
            this.compile();
        }
    }

    public char next() {
        if (this.index < this.sourceProgram.length()) {
            char c;
            if ((c = this.sourceProgram.charAt(this.index++)) == '\n') {
                ++this.line;
            }
            return c;
        }
        return '\u0000';
    }

    public char nextPeek() {
        if (this.index < this.sourceProgram.length()) {
            return this.sourceProgram.charAt(this.index);
        }
        return '\u0000';
    }

    public char nextNextPeek() {
        if (this.index < this.sourceProgram.length() - 1) {
            return this.sourceProgram.charAt(this.index + 1);
        }
        return '\u0000';
    }

    public ProgramPosition getPosition() {
        return new ProgramPosition(this.index, this.line);
    }

    public void setPosition(ProgramPosition pp) {
        this.index = pp.index;
        this.line = pp.line;
    }

    public void resetPosition() {
        this.index = 0;
        this.line = 0;
    }

    private boolean nextIsStartMark() {
        int n = this.startMark.length() - 1;
        int i = 0;
        while (i < n) {
            if (this.sourceProgram.charAt(this.index + i) != this.startMark.charAt(i + 1)) {
                return false;
            }
            ++i;
        }
        this.index += n;
        return true;
    }

    private boolean nextIsEndMark() {
        int n = this.endMark.length() - 1;
        int i = 0;
        while (i < n) {
            if (this.sourceProgram.charAt(this.index + i) != this.endMark.charAt(i + 1)) {
                return false;
            }
            ++i;
        }
        this.index += n;
        return true;
    }

    private static void initReservedWord() {
        reservedWordsList = new HashMap<String, Token>();
        reservedWordsList.put("IF", new Token(TokenType.IF));
        reservedWordsList.put("ELSEIF", new Token(TokenType.ELSEIF));
        reservedWordsList.put("ELSE", new Token(TokenType.ELSE));
        reservedWordsList.put("ENDIF", new Token(TokenType.ENDIF));
        reservedWordsList.put("REPEAT", new Token(TokenType.REPEAT));
        reservedWordsList.put("UNTIL", new Token(TokenType.UNTIL));
        reservedWordsList.put("FOR", new Token(TokenType.FOR));
        reservedWordsList.put("TO", new Token(TokenType.TO));
        reservedWordsList.put("DOWNTO", new Token(TokenType.DOWNTO));
        reservedWordsList.put("ENDFOR", new Token(TokenType.ENDFOR));
        reservedWordsList.put("FOREACH", new Token(TokenType.FOREACH));
        reservedWordsList.put("IN", new Token(TokenType.IN));
        reservedWordsList.put("ENDFOREACH", new Token(TokenType.ENDFOREACH));
        reservedWordsList.put("WHILE", new Token(TokenType.WHILE));
        reservedWordsList.put("DO", new Token(TokenType.DO));
        reservedWordsList.put("ENDWHILE", new Token(TokenType.ENDWHILE));
        reservedWordsList.put("RETURN", new Token(TokenType.RETURN));
        reservedWordsList.put("BREAK", new Token(TokenType.BREAK));
        reservedWordsList.put("AND", new Token(TokenType.AND));
        reservedWordsList.put("OR", new Token(TokenType.OR));
        reservedWordsList.put("NOT", new Token(TokenType.NOT));
        reservedWordsList.put("BITAND", new Token(TokenType.BITAND));
        reservedWordsList.put("BITOR", new Token(TokenType.BITOR));
        reservedWordsList.put("BITXOR", new Token(TokenType.BITXOR));
        reservedWordsList.put("BITNOT", new Token(TokenType.BITXOR));
        reservedWordsList.put("MOD", new Token(TokenType.MODULUS));
        reservedWordsList.put("VAR", new Token(TokenType.VAR));
        reservedWordsList.put("GLOBALVAR", new Token(TokenType.GLOBALVAR));
    }

    public Token nextTokenOutsideProgram() {
        if (this.compiledProgram != null) {
            return this.index < this.compiledProgram.length ? this.compiledProgram[this.index++] : TOKEN_EOF;
        }
        this.sb.setLength(0);
        char c;
        while ((c = this.next()) != this.startMark.charAt(0) || !this.nextIsStartMark()) {
            if (c == '\u0000') {
                return new Token(TokenType.EOF, this.sb.toString());
            }
            this.sb.append(c);
        }
        return new Token(TokenType.START_MARK, this.sb.toString());
    }

    /*
     * Unable to fully structure code
     */
    public Token nextTokenWhiteSpace() {
        block119: {
            block121: {
                block120: {
                    if (this.compiledProgram != null) {
                        return this.index < this.compiledProgram.length ? this.compiledProgram[this.index++] : Program.TOKEN_EOF;
                    }
                    c = this.next();
                    if (Character.isWhitespace(c)) {
                        while (Character.isWhitespace(this.nextPeek())) {
                            this.next();
                        }
                        return Program.TOKEN_WHITESPACE;
                    }
                    if (c == '\u0000') {
                        return Program.TOKEN_EOF;
                    }
                    if (this.endMark != null && this.endMark.charAt(0) == c && this.nextIsEndMark()) {
                        return new Token(TokenType.END_MARK);
                    }
                    if (!Character.isDigit(c) && c != '$') break block119;
                    base = 10;
                    isFloat = false;
                    isInt = false;
                    isBin = false;
                    isComplex = false;
                    isBytes = false;
                    ee = 1.0;
                    this.sb.setLength(0);
                    this.sb.append(c);
                    cn = this.nextPeek();
                    if (c == '$') {
                        base = 16;
                        isInt = true;
                        this.sb.setLength(0);
                    } else if (c == '0' && (cn == 'x' || cn == 'X')) {
                        base = 16;
                        isInt = true;
                        this.sb.setLength(0);
                        this.next();
                        cn = this.nextPeek();
                    } else if (c == '0' && (cn == 'b' || cn == 'B')) {
                        base = 2;
                        isInt = true;
                        this.sb.setLength(0);
                        this.next();
                        cn = this.nextPeek();
                    }
                    while ("0123456789YZEPTGMkmunpfazoObBhHeabcdefABCDEF$.".indexOf(cn) >= 0) {
                        this.sb.append(cn);
                        this.next();
                        cn = this.nextPeek();
                    }
                    if (cn == 'i' && "kMGTPEZY".indexOf(this.sb.charAt(this.sb.length() - 1)) >= 0) {
                        isBin = true;
                        this.next();
                        cn = this.nextPeek();
                    }
                    if (this.sb.toString().indexOf(46) >= 0) {
                        isFloat = true;
                    }
                    cn = this.nextPeek();
                    if (!(isBin || cn != 'i' && cn != 'j')) {
                        Complex.complexChar = cn;
                        isComplex = true;
                        this.next();
                    }
                    if (base != 10) break block120;
                    block0 : switch (this.sb.charAt(this.sb.length() - 1)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            i = this.sb.length() - 1;
                            while (i >= 1) {
                                if (this.sb.charAt(i) == 'e' || this.sb.charAt(i) == 'E') {
                                    isFloat = true;
                                    break block0;
                                }
                                --i;
                            }
                            break block121;
                        }
                        case 'E': 
                        case 'e': {
                            isFloat = true;
                            if (cn != '+' && cn != '-' || "0123456789".indexOf(this.nextNextPeek()) < 0) ** GOTO lbl99
                            this.sb.append(cn);
                            this.next();
                            cn = this.nextPeek();
                            while ("0123456789".indexOf(cn) >= 0) {
                                this.sb.append(cn);
                                this.next();
                                cn = this.nextPeek();
                            }
                            if (!(cn != 'i' && cn != 'j' || isComplex)) {
                                Complex.complexChar = cn;
                                isComplex = true;
                                this.next();
                                break;
                            }
                            break block121;
lbl99:
                            // 1 sources

                            if (this.sb.charAt(this.sb.length() - 1) == 'E') {
                                ee = 1.0E18;
                                this.sb.setLength(this.sb.length() - 1);
                                break;
                            }
                            throw new ProgramExceptions.SyntaxException(this.script, "Number is not valid");
                        }
                        case 'H': 
                        case 'h': {
                            isInt = true;
                            base = 16;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'O': 
                        case 'o': {
                            isInt = true;
                            base = 8;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            isInt = true;
                            base = 2;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'Y': {
                            ee = 1.0E24;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            if (isBin) {
                                ee = 1.2089258196146292E24;
                                break;
                            }
                            break block121;
                        }
                        case 'Z': {
                            ee = 1.0E21;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            if (isBin) {
                                ee = 1.152921504606847E18;
                                break;
                            }
                            break block121;
                        }
                        case 'P': {
                            ee = 1.0E15;
                            isFloat = true;
                            if (isBin) {
                                ee = 1.125899906842624E15;
                            }
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'T': {
                            ee = 1.0E12;
                            isFloat = true;
                            if (isBin) {
                                ee = 1.099511627776E12;
                            }
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'G': {
                            ee = 1.0E9;
                            isFloat = true;
                            if (isBin) {
                                ee = 1.073741824E9;
                            }
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'M': {
                            ee = 1000000.0;
                            isFloat = true;
                            if (isBin) {
                                ee = 1048576.0;
                            }
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'k': {
                            ee = 1000.0;
                            isFloat = true;
                            if (isBin) {
                                ee = 1024.0;
                            }
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'm': {
                            ee = 0.001;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'u': {
                            ee = 1.0E-6;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'n': {
                            ee = 1.0E-9;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'p': {
                            ee = 1.0E-12;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'f': {
                            ee = 1.0E-15;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'a': {
                            ee = 1.0E-18;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'z': {
                            ee = 1.0E-21;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                            break;
                        }
                        case 'y': {
                            ee = 1.0E-24;
                            isFloat = true;
                            this.sb.setLength(this.sb.length() - 1);
                        }
                    }
                    break block121;
                }
                if (base == 16 && this.sb.charAt(this.sb.length() - 1) == '$') {
                    isBytes = true;
                    base = 16;
                    this.sb.setLength(this.sb.length() - 1);
                }
            }
            v = new Var();
            if (isInt && isFloat) {
                throw new ProgramExceptions.SyntaxException(this.script, "Number is not valid");
            }
            if (isComplex) {
                v.set(new Complex(0.0, Double.parseDouble(this.sb.toString()) * ee));
            } else if (isBytes) {
                bb = new ByteBuffer();
                i = 0;
                while (i < this.sb.length()) {
                    s = this.sb.substring(i, Math.min(i + 2, this.sb.length()));
                    bb.append((byte)Integer.parseInt(s, 16));
                    i += 2;
                }
                v.set(bb.getAsArray());
            } else if (isFloat) {
                v.set(Double.parseDouble(this.sb.toString()) * ee);
            } else {
                v.set(Long.parseLong(this.sb.toString(), base));
            }
            return new Token(TokenType.VALUE, "", v);
        }
        if (Character.isLetter(c)) {
            this.sb.setLength(0);
            this.sb.append(c);
            while (Character.isLetterOrDigit(c = this.nextPeek()) || c == '_') {
                this.sb.append(this.next());
            }
            s = this.sb.toString();
            t = Program.reservedWordsList.get(s.toUpperCase());
            return t != null ? t : new Token(TokenType.IDENTIFIER, s);
        }
        switch (c) {
            case '(': {
                return new Token(TokenType.BRACKETBEGIN);
            }
            case ')': {
                return new Token(TokenType.BRACKETEND);
            }
            case '[': {
                return new Token(TokenType.SQUAREBRACKETBEGIN);
            }
            case ']': {
                return new Token(TokenType.SQUAREBRACKETEND);
            }
            case '+': {
                return new Token(TokenType.PLUS);
            }
            case '-': {
                return new Token(TokenType.MINUS);
            }
            case '*': {
                return new Token(TokenType.MULTIPLY);
            }
            case '%': {
                return new Token(TokenType.MODULUS);
            }
            case '!': {
                if (this.nextPeek() == '=') {
                    this.next();
                    return new Token(TokenType.COMPARE_NOT_EQUAL);
                }
                return new Token(TokenType.NOT);
            }
            case '~': {
                return new Token(TokenType.BITNOT);
            }
            case '^': {
                return new Token(TokenType.BITXOR);
            }
            case ';': {
                return Program.TOKEN_SEMICOLON;
            }
            case ',': {
                return new Token(TokenType.COMMA);
            }
            case '.': {
                return new Token(TokenType.POINT);
            }
            case '?': {
                return new Token(TokenType.QUESTIONMARK);
            }
            case '/': {
                cn = this.nextPeek();
                if (cn == '*') {
                    this.next();
                    do {
                        if ((c = this.next()) != '\u0000') continue;
                        throw new ProgramExceptions.UnexpectedEofException(this.script, "Missing */");
                    } while (c != '*' && this.nextPeek() != '/');
                    this.next();
                    return Program.TOKEN_WHITESPACE;
                }
                if (cn == '/') {
                    this.next();
                    while ((c = this.next()) != '\r' && c != '\n' && c != '\u0000') {
                    }
                    return Program.TOKEN_WHITESPACE;
                }
                return new Token(TokenType.DIVIDE);
            }
            case ':': {
                if (this.nextPeek() == '=') {
                    this.next();
                    return new Token(TokenType.ASSIGN);
                }
                return new Token(TokenType.COLON);
            }
            case '<': {
                cn = this.nextPeek();
                if (cn == '<') {
                    this.next();
                    return new Token(TokenType.SHIFT_LEFT);
                }
                if (cn == '=') {
                    this.next();
                    return new Token(TokenType.COMPARE_LESS_EQUAL);
                }
                if (cn == '>') {
                    this.next();
                    return new Token(TokenType.COMPARE_NOT_EQUAL);
                }
                return new Token(TokenType.COMPARE_LESS);
            }
            case '>': {
                cn = this.nextPeek();
                if (cn == '>') {
                    this.next();
                    return new Token(TokenType.SHIFT_RIGHT);
                }
                if (cn == '=') {
                    this.next();
                    return new Token(TokenType.COMPARE_GREATER_EQUAL);
                }
                return new Token(TokenType.COMPARE_GREATER);
            }
            case '=': {
                cn = this.nextPeek();
                if (cn == '=') {
                    this.next();
                    return new Token(TokenType.COMPARE_EQUAL);
                }
                return new Token(TokenType.ASSIGN);
            }
            case '&': {
                cn = this.nextPeek();
                if (cn == '&') {
                    this.next();
                    return new Token(TokenType.AND);
                }
                return new Token(Program.localSyntax != false ? TokenType.AND : TokenType.BITAND);
            }
            case '|': {
                cn = this.nextPeek();
                if (cn == '|') {
                    this.next();
                    return new Token(TokenType.OR);
                }
                return new Token(Program.localSyntax != false ? TokenType.OR : TokenType.BITOR);
            }
            case '\"': {
                this.sb.setLength(0);
                c = this.next();
                longString = false;
                if (c == '\"') {
                    if (this.nextPeek() != '\"') {
                        return new Token(TokenType.STRING, "");
                    }
                    this.next();
                    longString = true;
                    c = this.next();
                }
                while ((longString || c != '\"') && c != '\u0000') {
                    if (!(longString || c != '\n' && c != '\r')) {
                        throw new ProgramExceptions.ExpectedException(this.script, "Linebreak found before \"");
                    }
                    if (c == '\\') {
                        cn = this.next();
                        switch (cn) {
                            case '\"': {
                                c = '\"';
                                break;
                            }
                            case '\'': {
                                c = '\'';
                                break;
                            }
                            case '\\': {
                                c = '\\';
                                break;
                            }
                            case 'r': {
                                c = '\r';
                                break;
                            }
                            case 't': {
                                c = '\t';
                                break;
                            }
                            case 'b': {
                                c = '\b';
                                break;
                            }
                            case 'n': {
                                c = '\n';
                                break;
                            }
                            case ' ': {
                                c = ' ';
                                break;
                            }
                            case 'x': {
                                i = Character.getNumericValue(this.next()) * 16;
                                c = (char)(i += Character.getNumericValue(this.next()));
                                break;
                            }
                            case 'u': {
                                i = Character.getNumericValue(this.next()) * 16 * 16 * 16;
                                i += Character.getNumericValue(this.next()) * 16 * 16;
                                i += Character.getNumericValue(this.next()) * 16;
                                c = (char)(i += Character.getNumericValue(this.next()));
                                break;
                            }
                            case '\u0000': {
                                throw new ProgramExceptions.SyntaxException(this.script, "unexpected EOF");
                            }
                        }
                    }
                    this.sb.append(c);
                    if (longString) {
                        c = this.next();
                        if (c != 34 || this.nextPeek() != '\"') continue;
                        this.next();
                        c = this.next();
                        if (c == '\"') {
                            return new Token(TokenType.STRING, this.sb.toString());
                        }
                        this.sb.append("\"\"");
                        continue;
                    }
                    c = this.next();
                }
                return new Token(TokenType.STRING, this.sb.toString());
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return Program.TOKEN_WHITESPACE;
            }
        }
        throw new ProgramExceptions.InvalidException(this.script, "<" + (char)c + "> is not a valid token");
    }

    public boolean isCompiled() {
        return this.compiledProgram != null;
    }

    public boolean isEmbedded() {
        return this.startMark != null;
    }

    public String getExtract() {
        if (this.compiledProgram != null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = this.index - 120;
        if (i < 0) {
            i = 0;
        }
        sb.append(this.sourceProgram.substring(i, this.index));
        sb.append("____<----____");
        i = this.index + 120;
        if (i > this.sourceProgram.length()) {
            i = this.sourceProgram.length();
        }
        sb.append(this.sourceProgram.substring(this.index, i));
        return sb.toString();
    }

    public Token nextToken() {
        Token token;
        while ((token = this.nextTokenWhiteSpace()) == TOKEN_WHITESPACE) {
        }
        return token;
    }

    class ProgramPosition {
        private int line;
        private int index;

        public ProgramPosition(int index, int line) {
            this.index = index;
            this.line = line;
        }
    }
}

