/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Functions;
import dk.hkj.script.ProgramExceptions;
import dk.hkj.script.Script;
import dk.hkj.util.AudibleAlarm;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.FileUtil;
import dk.hkj.util.Matrix;
import dk.hkj.util.StringUtil;
import dk.hkj.util.SystemUtil;
import dk.hkj.util.Vector;
import dk.hkj.vars.Var;
import dk.hkj.vars.VarValue;
import dk.hkj.vars.VarValueArray;
import dk.hkj.vars.VarValueComplex;
import dk.hkj.vars.VarValueDateTime;
import dk.hkj.vars.VarValueMatrix;
import dk.hkj.vars.VarValueVector;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class FunctionsSystem {
    static long[] ByteMask;

    static {
        long[] lArray = new long[9];
        lArray[1] = 255L;
        lArray[2] = 65535L;
        lArray[3] = 0xFFFFFFL;
        lArray[4] = -1L;
        lArray[5] = 0xFFFFFFFFFFL;
        lArray[6] = 0xFFFFFFFFFFFFL;
        lArray[7] = 0xFFFFFFFFFFFFFFL;
        lArray[8] = -1L;
        ByteMask = lArray;
    }

    private static boolean stringCanDouble(String s) {
        try {
            Double.valueOf(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void add() {
        Functions.gf().add(new Functions.Func("type"){

            @Override
            public Var execute(Script script, List<Var> params) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < params.size()) {
                    VarValue vv;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append((vv = params.get(i).getValue()) == null ? "Empty" : vv.typeName());
                    ++i;
                }
                return Var.createValue(sb.toString());
            }
        });
        Functions.gf().add(new Functions.Func("isNan"){

            @Override
            public Var execute(Script script, List<Var> params) {
                boolean nan = false;
                int i = 0;
                while (i < params.size()) {
                    VarValue vv = params.get(i).getValue();
                    if (vv.isVector() && ((VarValueVector)vv).isNaN()) {
                        nan = true;
                    } else if (vv.isMatrix() && ((VarValueMatrix)vv).isNaN()) {
                        nan = true;
                    } else if (vv.isComplex() && ((VarValueComplex)vv).isNaN()) {
                        nan = true;
                    } else if (Double.isNaN(vv.asDouble())) {
                        nan = true;
                    }
                    ++i;
                }
                return Var.createValue(nan ? 1 : 0);
            }
        });
        Functions.gf().add(new Functions.Func("invalidValue"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double a;
                if (params.size() != 1) {
                    3.invalidNumberOfParams(script, "invalidValueType(-1,0,1)");
                }
                if ((a = params.get(0).asDouble()) > 0.0) {
                    return Var.createValue(Double.POSITIVE_INFINITY);
                }
                if (a < 0.0) {
                    return Var.createValue(Double.NEGATIVE_INFINITY);
                }
                return Var.createValue(Double.NaN);
            }
        });
        Functions.gf().add(new Functions.Func("isInfinite"){

            @Override
            public Var execute(Script script, List<Var> params) {
                boolean infinite = false;
                int i = 0;
                while (i < params.size()) {
                    VarValue vv = params.get(i).getValue();
                    if (vv.isVector() && ((VarValueVector)vv).isInfinite()) {
                        infinite = true;
                    } else if (vv.isMatrix() && ((VarValueMatrix)vv).isInfinite()) {
                        infinite = true;
                    } else if (vv.isComplex() && ((VarValueComplex)vv).isInfinite()) {
                        infinite = true;
                    } else if (Double.isInfinite(vv.asDouble())) {
                        infinite = true;
                    }
                    ++i;
                }
                return Var.createValue(infinite ? 1 : 0);
            }
        });
        Functions.gf().add(new Functions.Func("noFault"){

            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 0: {
                        script.noFault = Var.createValue(0);
                        break;
                    }
                    case 1: {
                        script.noFault = params.get(0);
                        break;
                    }
                    default: {
                        5.invalidNumberOfParams(script, "{faultValue}");
                    }
                }
                return Var.createValue(0);
            }
        });
        Functions.gf().add(new Functions.Func("const"){

            @Override
            public Var execute(Script script, List<Var> params) {
                boolean ro = true;
                switch (params.size()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ro = params.get(1).asBoolean();
                        break;
                    }
                    default: {
                        6.invalidNumberOfParams(script, "value{,ro}");
                    }
                }
                String name = params.get(0).asString();
                Var v = script.findVar(name);
                v.setReadOnly(ro);
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("clear"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int i = 0;
                while (i < params.size()) {
                    params.get(i).clear();
                    ++i;
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("max"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var result;
                if (params.size() == 0) {
                    8.invalidNumberOfParams(script, "number,...");
                }
                if (params.get(0).isArray()) {
                    VarValueArray v = (VarValueArray)params.get(0).getValue();
                    result = v.getVar(0);
                    int i = 1;
                    while (i < v.getSize()) {
                        if (result.compareTo(v.getVar(i)) < 0) {
                            result = v.getVar(i);
                        }
                        ++i;
                    }
                } else {
                    result = params.get(0);
                    int i = 1;
                    while (i < params.size()) {
                        if (result.compareTo(params.get(i)) < 0) {
                            result = params.get(i);
                        }
                        ++i;
                    }
                }
                return result;
            }
        });
        Functions.gf().add(new Functions.Func("min"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var result;
                if (params.size() == 0) {
                    9.invalidNumberOfParams(script, "number,...");
                }
                if (params.get(0).isArray()) {
                    VarValueArray v = (VarValueArray)params.get(0).getValue();
                    result = v.getVar(0);
                    int i = 1;
                    while (i < v.getSize()) {
                        if (result.compareTo(v.getVar(i)) > 0) {
                            result = v.getVar(i);
                        }
                        ++i;
                    }
                } else {
                    result = params.get(0);
                    int i = 1;
                    while (i < params.size()) {
                        if (result.compareTo(params.get(i)) > 0) {
                            result = params.get(i);
                        }
                        ++i;
                    }
                }
                return result;
            }
        });
        Functions.gf().add(new Functions.FuncVarValue("varExists"){

            @Override
            public Var execute(VarValue value, Script script, List<Var> params) {
                if (params.size() == 0) {
                    10.invalidNumberOfParams(script, "varname{,varname{,...}}");
                }
                for (Var v : params) {
                    String name = v.asString();
                    if (script.findVar(name) != null) continue;
                    return Var.createValue(false);
                }
                return Var.createValue(true);
            }
        });
        Functions.gf().add(new Functions.Func("varExist"){

            @Override
            public Var execute(Script script, List<Var> params) {
                for (Var v : params) {
                    String name = v.asString();
                    if (Var.gl.find(name) != null) continue;
                    return Var.createValue(false);
                }
                return Var.createValue(true);
            }
        });
        Functions.gf().add(new Functions.Func("array"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 1 && params.get(0).isArray()) {
                    return params.get(0);
                }
                if (params.size() == 1 && params.get(0).canVector()) {
                    return Var.createArray(params.get(0).asVector());
                }
                Var var = Var.createArray();
                for (Var v : params) {
                    var.addVar(v);
                }
                return var;
            }
        });
        Functions.gf().add(new Functions.Func("arrayCombine"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var var = Var.createArray();
                for (Var v : params) {
                    if (v.isArray()) {
                        int i = 0;
                        while (i < v.getSize()) {
                            var.addVar(v.get(i).clone());
                            ++i;
                        }
                        continue;
                    }
                    if (v.isStruct()) {
                        var.addVar(v);
                        continue;
                    }
                    var.addVar(v.clone());
                }
                return var;
            }
        });
        Functions.gf().add(new Functions.Func("clone"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    14.invalidNumberOfParams(script, "value");
                }
                return params.get(0).clone();
            }
        });
        Functions.gf().add(new Functions.Func("double"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1 && params.size() != 2) {
                    15.invalidNumberOfParams(script, "number{,defaultValue}");
                }
                if (params.get(0).canDouble()) {
                    return Var.createValue(params.get(0).asDouble());
                }
                String v = params.get(0).asString().trim().replace(',', '.');
                if (!(params.size() != 2 || v.trim().length() != 0 && FunctionsSystem.stringCanDouble(v))) {
                    return Var.createValue(params.get(1).asDouble());
                }
                return Var.createValue(Double.valueOf(v));
            }
        });
        Functions.gf().add(new Functions.Func("doubleSI"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1 && params.size() != 2) {
                    16.invalidNumberOfParams(script, "number");
                }
                String v = params.get(0).asString().trim().replace(',', '.');
                return Var.createValue(StringUtil.parseDoubleEE(v));
            }
        });
        Functions.gf().add(new Functions.Func("int"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    17.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(params.get(0).asLong());
            }
        });
        Functions.gf().add(new Functions.Func("long"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    18.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(params.get(0).asLong());
            }
        });
        Functions.gf().add(new Functions.Func("bytes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 0) {
                    19.invalidNumberOfParams(script, "number");
                    return null;
                }
                if (params.size() > 1) {
                    ByteBuffer bb = new ByteBuffer();
                    int i = 0;
                    while (i < params.size()) {
                        Var v = params.get(i);
                        if (v.isLong() || v.isInt()) {
                            bb.append((byte)v.asLong());
                        } else {
                            bb.append(v.asBytes());
                        }
                        ++i;
                    }
                    return Var.createValue(bb.getAsArray());
                }
                Var v = params.get(0);
                return Var.createValue(v.asBytes());
            }
        });
        Functions.gf().add(new Functions.Func("floatBytes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                byte[] b = null;
                float v = 0.0f;
                boolean swap = false;
                switch (params.size()) {
                    case 1: {
                        v = params.get(0).asFloat();
                        break;
                    }
                    case 2: {
                        v = params.get(0).asFloat();
                        swap = params.get(1).asBoolean();
                        break;
                    }
                    default: {
                        20.invalidNumberOfParams(script, "number");
                    }
                }
                int j = Float.floatToIntBits(v);
                b = new byte[4];
                int i = 0;
                while (i < 4) {
                    b[swap ? 3 - i : i] = (byte)j;
                    j >>= 8;
                    ++i;
                }
                return Var.createValue(b);
            }
        });
        Functions.gf().add(new Functions.Func("doubleBytes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                byte[] b = null;
                double v = 0.0;
                boolean swap = false;
                switch (params.size()) {
                    case 1: {
                        v = params.get(0).asDouble();
                        break;
                    }
                    case 2: {
                        v = params.get(0).asDouble();
                        swap = params.get(1).asBoolean();
                        break;
                    }
                    default: {
                        21.invalidNumberOfParams(script, "number");
                    }
                }
                long j = Double.doubleToLongBits(v);
                b = new byte[8];
                int i = 0;
                while (i < 8) {
                    b[swap ? 7 - i : i] = (byte)j;
                    j >>= 8;
                    ++i;
                }
                return Var.createValue(b);
            }
        });
        Functions.gf().add(new Functions.Func("complex"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    22.invalidNumberOfParams(script, "number");
                }
                return Var.createValue(params.get(0).asComplex());
            }
        });
        Functions.gf().add(new Functions.Func("vector"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 0) {
                    23.invalidNumberOfParams(script, "number{,number{,number...}}");
                }
                if (params.size() == 1) {
                    return Var.createValue(params.get(0).asVector());
                }
                ArrayList<Double> list = new ArrayList<Double>();
                int i = 0;
                while (i < params.size()) {
                    list.add(params.get(i).asDouble());
                    ++i;
                }
                return Var.createValue(new Vector(list));
            }
        });
        Functions.gf().add(new Functions.Func("matrix"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 0) {
                    24.invalidNumberOfParams(script, "value/vector{,vector{,vector...}}");
                }
                if (params.size() == 1) {
                    return Var.createValue(params.get(0).asMatrix());
                }
                ArrayList<Vector> list = new ArrayList<Vector>();
                int i = 0;
                while (i < params.size()) {
                    list.add(params.get(i).asVector());
                    ++i;
                }
                return Var.createValue(new Matrix(list));
            }
        });
        Functions.gf().add(new Functions.Func("isNumber"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var vv;
                if (params.size() != 1) {
                    25.invalidNumberOfParams(script, "value");
                }
                boolean v = (vv = params.get(0)).isDouble() || vv.isFloat() || vv.isInt() || vv.isLong() || vv.isComplex();
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("isString"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    26.invalidNumberOfParams(script, "value");
                }
                boolean v = params.get(0).isString();
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("floor"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    27.invalidNumberOfParams(script, "number");
                }
                Double v = Math.floor(params.get(0).asDouble());
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("string"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    28.invalidNumberOfParams(script, "value");
                }
                return Var.createValue(params.get(0).asString());
            }
        });
        Functions.gf().add(new Functions.Func("size"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    29.invalidNumberOfParams(script, "array/struct/string/vector");
                }
                Var v = params.get(0);
                long n = 0L;
                if (v.isArray()) {
                    n = v.getSize();
                } else if (v.isString()) {
                    n = v.asString().length();
                } else if (v.isBytes()) {
                    n = v.asBytes().length;
                } else if (v.isVector()) {
                    n = v.getSize();
                }
                return Var.createValue(n);
            }
        });
        Functions.gf().add(new Functions.Func("printConsole"){

            @Override
            public Var execute(Script script, List<Var> params) {
                for (Var v : params) {
                    if (v == null) continue;
                    System.out.print(v.asString());
                }
                System.out.println();
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("executeFile"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 1) {
                    31.invalidNumberOfParams(script, "filename{,param1{,param2{,...}}}");
                }
                Script localScript = new Script(script);
                try {
                    Var p = Var.createArray("params");
                    int i = 1;
                    while (i < params.size()) {
                        p.addVar(i - 1, params.get(i));
                        ++i;
                    }
                    localScript.execute(FileUtil.readFileAsString(new File(params.get(0).asString())), p);
                }
                catch (IOException e) {
                    throw new ProgramExceptions.FileErrorException(script, "Could not read file", e);
                }
                return localScript.getResult();
            }
        });
        Functions.gf().add(new Functions.Func("executeEmbeddedFile"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 1) {
                    32.invalidNumberOfParams(script, "filename{,param1{,param2{,...}}}");
                }
                Script localScript = new Script(script);
                try {
                    Var p = Var.createArray("params");
                    int i = 1;
                    while (i < params.size()) {
                        p.addVar(i - 1, params.get(i));
                        ++i;
                    }
                    localScript.executeEmbedded(FileUtil.readFileAsString(new File(params.get(0).asString())), p);
                }
                catch (IOException e) {
                    throw new ProgramExceptions.FileErrorException(script, "Could not read file", e);
                }
                return localScript.getResult();
            }
        });
        Functions.gf().add(new Functions.Func("executeDos"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    33.invalidNumberOfParams(script, "program,path,timeout");
                }
                String s = SystemUtil.execute(params.get(0).asString(), params.get(1).asString(), params.get(2).asInt());
                return Var.createValue(s);
            }
        });
        Functions.gf().add(new Functions.Func("executeString"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 1) {
                    34.invalidNumberOfParams(script, "program{,param1{,param2{,...}}}");
                }
                Script localScript = new Script(script);
                Var p = Var.createArray("params");
                int i = 1;
                while (i < params.size()) {
                    p.addVar(i - 1, params.get(i));
                    ++i;
                }
                localScript.execute(params.get(0).asString(), p);
                return localScript.getResult();
            }
        });
        Functions.gf().add(new Functions.Func("executeEmbeddedString"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 1) {
                    35.invalidNumberOfParams(script, "program{,param1{,param2{,...}}}");
                }
                Script localScript = new Script(script);
                Var p = Var.createArray("params");
                int i = 1;
                while (i < params.size()) {
                    p.addVar(i - 1, params.get(i));
                    ++i;
                }
                localScript.executeEmbedded(params.get(0).asString(), p);
                return localScript.getResult();
            }
        });
        Functions.gf().add(new Functions.Func("addFunc"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    36.invalidNumberOfParams(script, "name,script");
                }
                script.getLocalVars().addFunc(new Functions.FuncScript(params.get(0).asString(), params.get(1).asString()));
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("addFuncGlobal"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    37.invalidNumberOfParams(script, "name,script");
                }
                Functions.gf().add(new Functions.FuncScript(params.get(0).asString(), params.get(1).asString()));
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("addFuncEmbedded"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    38.invalidNumberOfParams(script, "name,script");
                }
                script.getLocalVars().addFunc(new Functions.FuncScriptEmbedded(params.get(0).asString(), params.get(1).asString()));
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("addFuncEmbeddedGlobal"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    39.invalidNumberOfParams(script, "name,script");
                }
                Functions.gf().add(new Functions.FuncScriptEmbedded(params.get(0).asString(), params.get(1).asString()));
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("listVars"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 0) {
                    40.invalidNumberOfParams(script, "var1{,var2{,var3{,...}}}");
                }
                int i = 0;
                while (i < params.size()) {
                    for (String line : params.get(i).listFormat(true)) {
                        System.out.println(line);
                    }
                    ++i;
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("getVar"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    41.invalidNumberOfParams(script, "\"varName\"");
                }
                try {
                    return script.getVar(params.get(0).asString());
                }
                catch (Exception exception) {
                    return new Var();
                }
            }
        });
        Functions.gf().add(new Functions.Func("getVarList"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    42.invalidNumberOfParams(script, "local");
                }
                int local = params.get(0).asInt();
                Var v = null;
                Script parent = null;
                switch (local) {
                    case 0: {
                        v = Var.gl;
                    }
                    case 1: {
                        v = script.getLocalVars();
                    }
                }
                if (local >= 2) {
                    parent = script.getParent();
                    if (parent != null && (local -= 2) > 0) {
                        parent = parent.getParent();
                        --local;
                    }
                    if (parent != null) {
                        v = parent.getLocalVars();
                    }
                }
                StringBuilder sb = new StringBuilder();
                if (v != null) {
                    List<String> list = v.listFormat(true);
                    list.sort(null);
                    for (String s : list) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(s);
                    }
                }
                return Var.createValue(sb.toString());
            }
        });
        Functions.gf().add(new Functions.Func("getFuncList"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 0) {
                    43.invalidNumberOfParams(script, "No parameters");
                }
                StringBuilder sb = new StringBuilder();
                for (String s : Functions.gf().getFuncList()) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(s);
                }
                return Var.createValue(sb.toString());
            }
        });
        Functions.gf().add(new Functions.Func("sleep"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    44.invalidNumberOfParams(script, "msec");
                }
                try {
                    Thread.sleep(params.get(0).asLong());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("StructBuildList"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    45.invalidNumberOfParams(script, "delimeter,fieldNames,list");
                }
                String deli = params.get(0).asString();
                String[] fieldNames = params.get(1).asString().split(deli);
                String[] list = params.get(2).asString().split(deli);
                Var v = Var.createStruct();
                int i = 0;
                while (i < fieldNames.length) {
                    String val = "";
                    if (i < list.length) {
                        val = list[i];
                    }
                    v.addVar(Var.createValue(fieldNames[i], val));
                    ++i;
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("arraySort"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    46.invalidNumberOfParams(script, "array,fieldName");
                }
                Var array = params.get(0);
                ((VarValueArray)array.getValue()).sort(params.get(1).asString());
                return array;
            }
        });
        Functions.gf().add(new Functions.Func("alarmSound"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 5) {
                    47.invalidNumberOfParams(script, "generator,f1,f2,ms1,ms2");
                }
                AudibleAlarm.setDefaultSound(params.get(0).asChar(), params.get(1).asInt(), params.get(2).asInt(), params.get(3).asInt(), params.get(4).asInt());
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("alarmPlay"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 4) {
                    48.invalidNumberOfParams(script, "volume,onTime,offTime,cycles");
                }
                AudibleAlarm.play(params.get(0).asInt(), params.get(1).asInt(), params.get(2).asInt(), params.get(3).asInt());
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("alarmStopAll"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 0) {
                    49.invalidNumberOfParams(script, "");
                }
                AudibleAlarm.stopAllSound();
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("seconds"){

            @Override
            public Var execute(Script script, List<Var> params) {
                return Var.createValue((double)System.nanoTime() / 1.0E9);
            }
        });
        Functions.gf().add(new Functions.Func("timestamp"){

            @Override
            public Var execute(Script script, List<Var> params) {
                return new Var(new VarValueDateTime(new Date(), "HH:mm:ss"));
            }
        });
        Functions.gf().add(new Functions.Func("dateTimestamp"){

            @Override
            public Var execute(Script script, List<Var> params) {
                return new Var(new VarValueDateTime(new Date(), "yyyyMMdd HH:mm:ss"));
            }
        });
        Functions.gf().add(new Functions.Func("binConv"){

            @Override
            public Var execute(Script script, List<Var> params) {
                long value = 0L;
                int index = 0;
                int count = 0;
                boolean signed = false;
                String swap = null;
                switch (params.size()) {
                    case 3: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        signed = params.get(3).asBoolean();
                        break;
                    }
                    case 5: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        signed = params.get(3).asBoolean();
                        if (params.get(4).isString()) {
                            swap = params.get(4).asString();
                            break;
                        }
                        if (!params.get(4).asBoolean()) break;
                        swap = "01234567".substring(0, count);
                        break;
                    }
                    default: {
                        53.invalidNumberOfParams(script, "value,index,count{,signed{,swap}}");
                    }
                }
                if (params.get(0).isString() || params.get(0).isBytes()) {
                    byte[] b = params.get(0).asBytes();
                    int i = 0;
                    while (i < count) {
                        value |= ((long)b[i + index] & 0xFFL) << 8 * i;
                        ++i;
                    }
                } else {
                    value = params.get(0).asLong();
                    value >>= index * 8;
                    value &= ByteMask[count];
                }
                if (swap != null) {
                    long v = 0L;
                    int i = 0;
                    while (i < count) {
                        int j = count - (swap.charAt(i) - 48) - 1;
                        v |= (value >> j * 8 & 0xFFL) << i * 8;
                        ++i;
                    }
                    value = v;
                }
                if (signed && (value & (long)(1 << count * 8 - 1)) != 0L) {
                    int i = count;
                    while (i < 8) {
                        value |= 255L << i * 8;
                        ++i;
                    }
                }
                return Var.createValue(value);
            }
        });
        Functions.gf().add(new Functions.Func("binConvFloat"){

            @Override
            public Var execute(Script script, List<Var> params) {
                long value = 0L;
                int index = 0;
                int count = 0;
                String swap = null;
                switch (params.size()) {
                    case 3: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        if (params.get(3).isString()) {
                            swap = params.get(3).asString();
                            break;
                        }
                        if (!params.get(3).asBoolean()) break;
                        swap = "01234567".substring(0, count);
                        break;
                    }
                    default: {
                        54.invalidNumberOfParams(script, "value,index,count (4 or 8){,swap}");
                    }
                }
                if (params.get(0).isString() || params.get(0).isBytes()) {
                    byte[] b = params.get(0).asBytes();
                    int i = 0;
                    while (i < count) {
                        value |= ((long)b[i + index] & 0xFFL) << 8 * i;
                        ++i;
                    }
                } else {
                    value = params.get(0).asLong();
                    value >>= index * 8;
                    value &= ByteMask[count];
                }
                if (swap != null) {
                    long v = 0L;
                    int i = 0;
                    while (i < count) {
                        int j = count - (swap.charAt(i) - 48) - 1;
                        v |= (value >> j * 8 & 0xFFL) << i * 8;
                        ++i;
                    }
                    value = v;
                }
                if (count == 4) {
                    return Var.createValue(Float.intBitsToFloat((int)value));
                }
                if (count == 8) {
                    return Var.createValue(Double.longBitsToDouble(value));
                }
                return Var.createValue(0);
            }
        });
        Functions.gf().add(new Functions.Func("binConvString"){

            @Override
            public Var execute(Script script, List<Var> params) {
                byte[] b;
                long value = 0L;
                int index = 0;
                int count = Integer.MAX_VALUE;
                boolean swap = false;
                int termination = -1;
                String codepage = "";
                switch (params.size()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        index = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        codepage = params.get(3).asString();
                        break;
                    }
                    case 5: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        codepage = params.get(3).asString();
                        swap = params.get(4).asBoolean();
                        break;
                    }
                    case 6: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        codepage = params.get(3).asString();
                        swap = params.get(4).asBoolean();
                        termination = params.get(5).asInt();
                        break;
                    }
                    default: {
                        55.invalidNumberOfParams(script, "value{,index{,count{,codepage{,swap{,termination}}}}}");
                    }
                }
                if (codepage.isEmpty()) {
                    codepage = "ISO-8859-1";
                }
                if (count <= 0) {
                    count = Integer.MAX_VALUE;
                }
                if (params.get(0).isString() || params.get(0).isBytes()) {
                    b = params.get(0).asBytes();
                } else {
                    value = params.get(0).asLong();
                    b = new byte[8];
                    int i = 0;
                    while (i < 8) {
                        b[i] = (byte)value;
                        value >>= 8;
                        ++i;
                    }
                }
                index = Math.min(index, b.length);
                b = Arrays.copyOfRange(b, index, Math.min(index + count, b.length));
                if (swap) {
                    byte[] b1 = new byte[b.length];
                    int i = 0;
                    while (i < b.length) {
                        b1[i] = b[b.length - i - 1];
                        ++i;
                    }
                    b = b1;
                }
                if (termination >= 0 && termination <= 255) {
                    int i = 0;
                    while (i < b.length) {
                        if (b[i] == (byte)termination) {
                            b = Arrays.copyOf(b, i);
                            break;
                        }
                        ++i;
                    }
                }
                try {
                    return Var.createValue(new String(b, codepage));
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        return Var.createValue(new String(b, "ISO-8859-1"));
                    }
                    catch (UnsupportedEncodingException e1) {
                        return Var.createValue("");
                    }
                }
            }
        });
        Functions.gf().add(new Functions.Func("binConvBit"){

            @Override
            public Var execute(Script script, List<Var> params) {
                long value = 0L;
                int index = 0;
                int count = 0;
                boolean signed = false;
                switch (params.size()) {
                    case 3: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        index = params.get(1).asInt();
                        count = params.get(2).asInt();
                        signed = params.get(3).asBoolean();
                        break;
                    }
                    default: {
                        56.invalidNumberOfParams(script, "value,index,count{,signed}");
                    }
                }
                value = params.get(0).asLong();
                value >>= index;
                if (signed && ((value &= (long)((1 << count) - 1)) & (long)(1 << count - 1)) != 0L) {
                    int i = count;
                    while (i < 64) {
                        value |= 1L << i;
                        ++i;
                    }
                }
                return Var.createValue(value);
            }
        });
        Functions.gf().add(new Functions.Func("date"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = new Var();
                switch (params.size()) {
                    case 0: {
                        v.set(new Date());
                        break;
                    }
                    case 1: {
                        v = new Var();
                        VarValueDateTime vv = new VarValueDateTime(new Date(), params.get(0).asString());
                        v.set(vv);
                        break;
                    }
                    case 2: {
                        v = new Var();
                        SimpleDateFormat sdf = new SimpleDateFormat(params.get(0).asString());
                        VarValueDateTime vv = null;
                        try {
                            vv = new VarValueDateTime(sdf.parse(params.get(1).asString()), params.get(0).asString());
                        }
                        catch (ParseException e) {
                            throw new ProgramExceptions.DateTimeErrorException(script, "Could not parse date time", e);
                        }
                        v.set(vv);
                        break;
                    }
                    case 3: {
                        v = new Var();
                        Calendar cal = Calendar.getInstance();
                        cal.set(params.get(0).asInt(), params.get(1).asInt() + 1, params.get(2).asInt(), 0, 0, 0);
                        cal.set(14, 0);
                        VarValueDateTime vv = new VarValueDateTime(cal.getTime());
                        v.set(vv);
                        break;
                    }
                    case 4: {
                        v = new Var();
                        Calendar cal = Calendar.getInstance();
                        cal.set(11, params.get(0).asInt());
                        cal.set(12, params.get(1).asInt());
                        cal.set(13, params.get(2).asInt());
                        cal.set(14, params.get(3).asInt());
                        VarValueDateTime vv = new VarValueDateTime(cal.getTime());
                        v.set(vv);
                        break;
                    }
                    case 6: {
                        v = new Var();
                        Calendar cal = Calendar.getInstance();
                        cal.set(1, params.get(0).asInt());
                        cal.set(2, params.get(1).asInt() - 1);
                        cal.set(5, params.get(2).asInt());
                        cal.set(11, params.get(3).asInt());
                        cal.set(12, params.get(4).asInt());
                        cal.set(13, params.get(5).asInt());
                        cal.set(14, 0);
                        VarValueDateTime vv = new VarValueDateTime(cal.getTime());
                        v.set(vv);
                        break;
                    }
                    case 7: {
                        v = new Var();
                        Calendar cal = Calendar.getInstance();
                        cal.set(1, params.get(0).asInt());
                        cal.set(2, params.get(1).asInt() - 1);
                        cal.set(5, params.get(2).asInt());
                        cal.set(11, params.get(3).asInt());
                        cal.set(12, params.get(4).asInt());
                        cal.set(13, params.get(5).asInt());
                        cal.set(14, params.get(6).asInt());
                        VarValueDateTime vv = new VarValueDateTime(cal.getTime());
                        v.set(vv);
                        break;
                    }
                    default: {
                        57.invalidNumberOfParams(script, "format");
                    }
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("makeDouble"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double v = 0.0;
                boolean minus = false;
                int pointAdjust = 0;
                int overload = 0;
                switch (params.size()) {
                    case 3: 
                    case 4: {
                        v = params.get(0).asDouble();
                        minus = params.get(1).asBoolean();
                        pointAdjust = params.get(2).asInt();
                        overload = params.size() >= 4 ? params.get(3).asInt() : 0;
                        break;
                    }
                    case 5: {
                        String[] s = params.get(4).asString().split("[ ;]+");
                        v = StringUtil.parseDoubleEE(s[params.get(0).asInt()]);
                        minus = params.get(1).asInt() >= 0 ? StringUtil.parseInt(s[params.get(1).asInt()]) != 0 : false;
                        pointAdjust = params.get(2).asInt() >= 0 ? StringUtil.parseInt(s[params.get(2).asInt()]) : 0;
                        overload = params.get(3).asInt() >= 0 ? StringUtil.parseInt(s[params.get(3).asInt()]) : 0;
                        break;
                    }
                    default: {
                        58.invalidNumberOfParams(script, "value,minus,pointAdjust{,overload}");
                    }
                }
                if (minus) {
                    v = -v;
                }
                while (pointAdjust > 0) {
                    v /= 10.0;
                    --pointAdjust;
                }
                while (pointAdjust < 0) {
                    v *= 10.0;
                    ++pointAdjust;
                }
                if (overload > 0) {
                    double d = v = minus ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
                if (overload < 0) {
                    v = Double.NaN;
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("tzOffset"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = new Var();
                if (params.size() != 0) {
                    59.invalidNumberOfParams(script, "none");
                }
                v = new Var();
                Calendar cal = Calendar.getInstance();
                v.set(cal.get(15));
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("msToDate"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = new Var();
                switch (params.size()) {
                    case 1: {
                        Date d = new Date(params.get(0).asLong());
                        v = new Var();
                        VarValueDateTime vv = new VarValueDateTime(d);
                        v.set(vv);
                        break;
                    }
                    default: {
                        60.invalidNumberOfParams(script, "ms_since_1970");
                    }
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("dateToms"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = new Var();
                switch (params.size()) {
                    case 1: {
                        long ms = params.get(0).asDateTime().getTime();
                        v.set(ms);
                        break;
                    }
                    default: {
                        61.invalidNumberOfParams(script, "date");
                    }
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("msToDateGMT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = new Var();
                switch (params.size()) {
                    case 1: {
                        Calendar cal = Calendar.getInstance();
                        cal.setTimeInMillis(params.get(0).asLong() - (long)cal.get(15));
                        VarValueDateTime vv = new VarValueDateTime(cal.getTime());
                        v.set(vv);
                        break;
                    }
                    default: {
                        62.invalidNumberOfParams(script, "ms_since_1970");
                    }
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("dateTomsGMT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = new Var();
                switch (params.size()) {
                    case 1: {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(params.get(0).asDateTime());
                        long ms = cal.getTimeInMillis() + (long)cal.get(15);
                        v.set(ms);
                        break;
                    }
                    default: {
                        63.invalidNumberOfParams(script, "date");
                    }
                }
                return v;
            }
        });
    }
}

