/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Functions;
import dk.hkj.script.Program;
import dk.hkj.script.Script;
import dk.hkj.vars.Var;
import java.util.List;

public class FunctionsSumIntegrate {
    public static void add() {
        Functions.gf().add(new Functions.Func("sum"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double stepSize = 1.0;
                switch (params.size()) {
                    case 3: {
                        break;
                    }
                    case 4: {
                        stepSize = params.get(3).asDouble();
                        break;
                    }
                    default: {
                        1.invalidNumberOfParams(script, "expression,start,end{,stepsize}");
                    }
                }
                Script solveScript = new Script(script);
                String func = params.get(0).asString();
                double start = params.get(1).asDouble();
                double stop = params.get(2).asDouble();
                Program exp = solveScript.compile(false, func);
                Var varx = solveScript.getLocalVars().getCreate("x");
                double sum = 0.0;
                int n = (int)Math.rint((stop - start) / stepSize);
                int i = 0;
                while (i < n) {
                    varx.set(start);
                    start += stepSize;
                    sum += solveScript.execute(exp).asDouble();
                    ++i;
                }
                return Var.createValue(sum);
            }
        });
        Functions.gf().add(new Functions.Func("mult"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double stepSize = 1.0;
                switch (params.size()) {
                    case 3: {
                        break;
                    }
                    case 4: {
                        stepSize = params.get(3).asDouble();
                        break;
                    }
                    default: {
                        2.invalidNumberOfParams(script, "expression,start,end{,stepsize}");
                    }
                }
                Script solveScript = new Script(script);
                String func = params.get(0).asString();
                double start = params.get(1).asDouble();
                double stop = params.get(2).asDouble();
                Program exp = solveScript.compile(false, func);
                Var varx = solveScript.getLocalVars().getCreate("x");
                double sum = 1.0;
                int n = (int)Math.rint((stop - start) / stepSize);
                int i = 0;
                while (i < n) {
                    varx.set(start);
                    start += stepSize;
                    sum *= solveScript.execute(exp).asDouble();
                    ++i;
                }
                return Var.createValue(sum);
            }
        });
        Functions.gf().add(new Functions.Func("sumInt"){

            @Override
            public Var execute(Script script, List<Var> params) {
                long stepSize = 1L;
                switch (params.size()) {
                    case 3: {
                        break;
                    }
                    case 4: {
                        stepSize = params.get(3).asLong();
                        break;
                    }
                    default: {
                        3.invalidNumberOfParams(script, "expression,start,end{,stepsize}");
                    }
                }
                Script solveScript = new Script(script);
                String func = params.get(0).asString();
                long start = params.get(1).asLong();
                long stop = params.get(2).asLong();
                Program exp = solveScript.compile(false, func);
                Var varx = solveScript.getLocalVars().getCreate("x");
                long sum = 0L;
                while (start <= stop) {
                    varx.set(start);
                    start += stepSize;
                    sum += (long)Math.rint(solveScript.execute(exp).asDouble());
                }
                return Var.createValue(sum);
            }
        });
        Functions.gf().add(new Functions.Func("integrate2"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double v;
                double steps = 1.0E7;
                switch (params.size()) {
                    case 3: {
                        break;
                    }
                    case 4: {
                        steps = params.get(3).asDouble();
                        if (steps < 500.0) {
                            steps = 500.0;
                        }
                        if (!(steps > 1.0E7)) break;
                        steps = 1.0E7;
                        break;
                    }
                    default: {
                        4.invalidNumberOfParams(script, "expression,start,end{,steps}");
                    }
                }
                Script solveScript = new Script(script);
                String func = params.get(0).asString();
                double start = params.get(1).asDouble();
                double stop = params.get(2).asDouble();
                double minStep = (stop - start) / steps;
                double maxStep = (stop - start) / 100.0;
                double stepSize = (stop - start) / 1000.0;
                Program exp = solveScript.compile(false, func);
                Var varx = solveScript.getLocalVars().getCreate("x");
                double sum = 0.0;
                varx.set(start);
                double vold = solveScript.execute(exp).asDouble();
                start += stepSize;
                while (start <= stop) {
                    varx.set(start);
                    v = solveScript.execute(exp).asDouble();
                    if (Math.abs(v - vold) > Math.abs(v + vold) * 1.0E-4 && stepSize > minStep) {
                        start -= stepSize;
                        start += (stepSize /= 2.0);
                        continue;
                    }
                    sum += (v + vold) * stepSize / 2.0;
                    vold = v;
                    if (Math.abs(v - vold) < Math.abs(v + vold) * 1.0E-5 && stepSize < maxStep) {
                        stepSize *= 2.0;
                    }
                    start += stepSize;
                }
                varx.set(stop);
                v = solveScript.execute(exp).asDouble();
                return Var.createValue(sum += (v + vold) * (stop - (start - stepSize)) / 2.0);
            }
        });
        Functions.gf().add(new Functions.Func("integrate"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double vm;
                double v;
                double steps = 1.0E7;
                switch (params.size()) {
                    case 3: {
                        break;
                    }
                    case 4: {
                        steps = params.get(3).asDouble();
                        if (steps < 500.0) {
                            steps = 500.0;
                        }
                        if (!(steps > 1.0E7)) break;
                        steps = 1.0E7;
                        break;
                    }
                    default: {
                        5.invalidNumberOfParams(script, "expression,start,end{,steps}");
                    }
                }
                Script solveScript = new Script(script);
                String func = params.get(0).asString();
                double start = params.get(1).asDouble();
                double stop = params.get(2).asDouble();
                double minStep = (stop - start) / steps;
                double maxStep = (stop - start) / 100.0;
                double stepSize = (stop - start) / 1000.0;
                Program exp = solveScript.compile(false, func);
                Var varx = solveScript.getLocalVars().getCreate("x");
                double sum = 0.0;
                varx.set(start);
                double sold = start;
                double vold = solveScript.execute(exp).asDouble();
                start += stepSize;
                while (start <= stop) {
                    varx.set(start);
                    v = solveScript.execute(exp).asDouble();
                    if (Math.abs(v - vold) > Math.abs(v + vold) * 0.001 && stepSize > minStep) {
                        start -= stepSize;
                        start += (stepSize /= 2.0);
                        continue;
                    }
                    varx.set(start - stepSize / 2.0);
                    vm = solveScript.execute(exp).asDouble();
                    sum += (v + 4.0 * vm + vold) * (start - sold) / 6.0;
                    vold = v;
                    sold = start;
                    if (Math.abs(v - vold) < Math.abs(v + vold) * 1.0E-4 && stepSize < maxStep) {
                        stepSize *= 2.0;
                    }
                    start += stepSize;
                }
                varx.set(stop);
                v = solveScript.execute(exp).asDouble();
                varx.set((stop - sold) / 2.0 + sold);
                vm = solveScript.execute(exp).asDouble();
                return Var.createValue(sum += (v + 4.0 * vm + vold) * (stop - sold) / 6.0);
            }
        });
        Functions.gf().add(new Functions.Func("deri"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double delta = -1.0;
                switch (params.size()) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        delta = params.get(2).asDouble();
                        break;
                    }
                    default: {
                        6.invalidNumberOfParams(script, "expression,x{,delta}");
                    }
                }
                Script solveScript = new Script(script);
                String func = params.get(0).asString();
                double x = params.get(1).asDouble();
                Program exp = solveScript.compile(false, func);
                Var varx = solveScript.getLocalVars().getCreate("x");
                if (delta <= 0.0) {
                    varx.set(x);
                    delta = Math.max(Math.abs(solveScript.execute(exp).asDouble() / 1.0E7), Math.abs(x) / 1.0E7);
                    if (delta < 1.0E-100) {
                        delta = 1.0E-100;
                    }
                }
                varx.set(x + delta);
                double y1 = solveScript.execute(exp).asDouble();
                varx.set(x - delta);
                double y2 = solveScript.execute(exp).asDouble();
                return Var.createValue((y1 - y2) / (2.0 * delta));
            }
        });
        Functions.gf().add(new Functions.Func("deri2"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double delta = -1.0;
                switch (params.size()) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        delta = params.get(2).asDouble();
                        break;
                    }
                    default: {
                        7.invalidNumberOfParams(script, "expression,x{,delta}");
                    }
                }
                Script solveScript = new Script(script);
                String func = params.get(0).asString();
                double x = params.get(1).asDouble();
                Program exp = solveScript.compile(false, func);
                Var varx = solveScript.getLocalVars().getCreate("x");
                varx.set(x);
                double ym = solveScript.execute(exp).asDouble();
                if (delta <= 0.0 && (delta = Math.max(Math.abs(ym / 100000.0), Math.abs(x) / 100000.0)) < 1.0E-100) {
                    delta = 1.0E-100;
                }
                varx.set(x + delta);
                double y1 = solveScript.execute(exp).asDouble();
                varx.set(x - delta);
                double y2 = solveScript.execute(exp).asDouble();
                return Var.createValue((y1 - 2.0 * ym + y2) / (delta * delta));
            }
        });
    }
}

