/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.CharacterEscapes;
import dk.hkj.util.RomenNumerals;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Support;
import dk.hkj.vars.Var;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionsString {
    private static String validSI = "0123456789+-.pnu\ufffdmkMG";

    public static void add() {
        Functions.gf().add(new Functions.Func("escapeURL"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    1.invalidNumberOfParams(script, "url");
                }
                return Var.createValue(CharacterEscapes.forURL(params.get(0).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("escapeRegEx"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    2.invalidNumberOfParams(script, "url");
                }
                return Var.createValue(Pattern.quote(params.get(0).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("trim"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    3.invalidNumberOfParams(script, "string");
                }
                return Var.createValue(params.get(0).asString().trim());
            }
        });
        Functions.gf().add(new Functions.Func("getMatch"){

            @Override
            public Var execute(Script script, List<Var> params) {
                String str = null;
                String pattern = null;
                int count = 0;
                switch (params.size()) {
                    case 2: {
                        str = params.get(0).asString();
                        pattern = params.get(1).asString();
                        break;
                    }
                    case 3: {
                        str = params.get(0).asString();
                        pattern = params.get(1).asString();
                        count = params.get(2).asInt();
                        break;
                    }
                    default: {
                        4.invalidNumberOfParams(script, "string,string");
                    }
                }
                Pattern r = Pattern.compile(pattern);
                Matcher m = r.matcher(str);
                String s = "";
                if (m.find()) {
                    while (count > 0 && m.find(m.end())) {
                        --count;
                    }
                    if (count == 0) {
                        s = str.substring(m.start(), m.end());
                    }
                }
                return Var.createValue(s);
            }
        });
        Functions.gf().add(new Functions.Func("countMatch"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    5.invalidNumberOfParams(script, "string,string");
                }
                String str = params.get(0).asString();
                Pattern r = Pattern.compile(params.get(1).asString());
                Matcher m = r.matcher(str);
                int n = 0;
                if (m.find()) {
                    ++n;
                    while (m.find(m.end())) {
                        ++n;
                    }
                }
                return Var.createValue(n);
            }
        });
        Functions.gf().add(new Functions.Func("getMatchGroup"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    6.invalidNumberOfParams(script, "string,string,groupNo");
                }
                Pattern r = Pattern.compile(params.get(1).asString());
                Matcher m = r.matcher(params.get(0).asString());
                String s = "";
                if (m.find()) {
                    s = m.group(params.get(2).asInt());
                }
                return Var.createValue(s);
            }
        });
        Functions.gf().add(new Functions.Func("match"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    7.invalidNumberOfParams(script, "string,string");
                }
                Pattern r = Pattern.compile(params.get(1).asString());
                Matcher m = r.matcher(params.get(0).asString());
                return Var.createValue(m.matches());
            }
        });
        Functions.gf().add(new Functions.Func("equalsi"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    8.invalidNumberOfParams(script, "string,string");
                }
                return Var.createValue(params.get(0).asString().equalsIgnoreCase(params.get(1).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("equals"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    9.invalidNumberOfParams(script, "string,string");
                }
                return Var.createValue(params.get(0).asString().equals(params.get(1).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("compare"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    10.invalidNumberOfParams(script, "string,string");
                }
                return Var.createValue(params.get(0).asString().compareTo(params.get(1).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("comparei"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    11.invalidNumberOfParams(script, "string,string");
                }
                return Var.createValue(params.get(0).asString().toLowerCase().compareTo(params.get(1).asString().toLowerCase()));
            }
        });
        Functions.gf().add(new Functions.Func("toUpperCase"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    12.invalidNumberOfParams(script, "string");
                }
                return Var.createValue(params.get(0).asString().toUpperCase());
            }
        });
        Functions.gf().add(new Functions.Func("toLowerCase"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    13.invalidNumberOfParams(script, "string");
                }
                return Var.createValue(params.get(0).asString().toLowerCase());
            }
        });
        Functions.gf().add(new Functions.Func("replace"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    14.invalidNumberOfParams(script, "string,from,to");
                }
                return Var.createValue(params.get(0).asString().replace(params.get(1).asString(), params.get(2).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("replacei"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    15.invalidNumberOfParams(script, "string,from,to");
                }
                return Var.createValue(params.get(0).asString().replaceAll("(?i)" + Pattern.quote(params.get(1).asString()), params.get(2).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("replaceRX"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    16.invalidNumberOfParams(script, "string,from,to");
                }
                Pattern p = Pattern.compile(params.get(1).asString());
                Matcher m = p.matcher(params.get(0).asString());
                return Var.createValue(m.replaceAll(params.get(2).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("indexOf"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    17.invalidNumberOfParams(script, "string,substring");
                }
                return Var.createValue(params.get(0).asString().indexOf(params.get(1).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("lastIndexOf"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 2) {
                    return Var.createValue(params.get(0).asString().lastIndexOf(params.get(1).asString()));
                }
                if (params.size() == 3) {
                    return Var.createValue(params.get(0).asString().lastIndexOf(params.get(1).asString(), params.get(1).asInt()));
                }
                18.invalidNumberOfParams(script, "string,substring");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("substring"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 2) {
                    String s = params.get(0).asString();
                    int from = params.get(1).asInt();
                    if (from < 0) {
                        from = 0;
                    } else if (from > s.length()) {
                        from = s.length();
                    }
                    return Var.createValue(s.substring(from));
                }
                if (params.size() == 3) {
                    String s = params.get(0).asString();
                    int from = params.get(1).asInt();
                    int to = params.get(2).asInt();
                    if (from < 0) {
                        from = 0;
                    } else if (from > s.length()) {
                        from = s.length();
                    }
                    if (to < 0) {
                        to = 0;
                    } else if (to > s.length()) {
                        to = s.length();
                    }
                    return Var.createValue(s.substring(from, to));
                }
                19.invalidNumberOfParams(script, "string,from{,to}");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("subbytes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() == 2) {
                    byte[] b = params.get(0).asBytes();
                    int from = params.get(1).asInt();
                    if (from < 0) {
                        from = 0;
                    } else if (from > b.length) {
                        from = b.length;
                    }
                    return Var.createValue(Arrays.copyOfRange(b, from, b.length));
                }
                if (params.size() == 3) {
                    byte[] b = params.get(0).asBytes();
                    int from = params.get(1).asInt();
                    int to = params.get(2).asInt();
                    if (from < 0) {
                        from = 0;
                    } else if (from > b.length) {
                        from = b.length;
                    }
                    if (to < 0) {
                        to = 0;
                    } else if (to > b.length) {
                        to = b.length;
                    }
                    return Var.createValue(Arrays.copyOfRange(b, from, to));
                }
                20.invalidNumberOfParams(script, "bytes,from{,to}");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("formatLeft"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    21.invalidNumberOfParams(script, "string,len,filler");
                }
                String s = params.get(0).asString();
                String filler = params.size() >= 3 ? params.get(2).asString() : " ";
                while (s.length() < params.get(1).asInt()) {
                    s = String.valueOf(s) + filler;
                }
                if (s.length() > params.get(1).asInt()) {
                    s = s.substring(0, params.get(1).asInt());
                }
                return Var.createValue(s);
            }
        });
        Functions.gf().add(new Functions.Func("formatRight"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    22.invalidNumberOfParams(script, "string,len,filler");
                }
                String s = params.get(0).asString();
                String filler = params.size() >= 3 ? params.get(2).asString() : " ";
                while (s.length() < params.get(1).asInt()) {
                    s = String.valueOf(filler) + s;
                }
                if (s.length() > params.get(1).asInt()) {
                    s = s.substring(s.length() - params.get(1).asInt(), params.get(1).asInt());
                }
                return Var.createValue(s);
            }
        });
        Functions.gf().add(new Functions.Func("formatDouble"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v;
                if (params.size() != 5) {
                    23.invalidNumberOfParams(script, "value,minIntDigits,maxIntDigits,minFracDigits,maxFracDigits");
                }
                if ((v = params.get(0)).asString().length() == 0) {
                    return Var.createValue("");
                }
                if (v.canDouble()) {
                    NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
                    nf.setGroupingUsed(false);
                    nf.setMinimumIntegerDigits(params.get(1).asInt());
                    nf.setMaximumIntegerDigits(params.get(2).asInt());
                    nf.setMinimumFractionDigits(params.get(3).asInt());
                    nf.setMaximumFractionDigits(params.get(4).asInt());
                    return Var.createValue(nf.format(v.asDouble()));
                }
                String s = v.asString().replaceAll(",", ".");
                if (Support.isDouble(s)) {
                    NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
                    nf.setGroupingUsed(false);
                    nf.setMinimumIntegerDigits(params.get(1).asInt());
                    nf.setMaximumIntegerDigits(params.get(2).asInt());
                    nf.setMinimumFractionDigits(params.get(3).asInt());
                    nf.setMaximumFractionDigits(params.get(4).asInt());
                    return Var.createValue(nf.format(Support.stringToDouble(s)));
                }
                return Var.createValue(v.asString());
            }
        });
        Functions.gf().add(new Functions.Func("formatInt"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v;
                if (params.size() != 3) {
                    24.invalidNumberOfParams(script, "value,minIntDigits,maxIntDigits");
                }
                if ((v = params.get(0)).asString().length() == 0) {
                    return Var.createValue("");
                }
                if (v.canLong()) {
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setGroupingUsed(false);
                    nf.setMinimumIntegerDigits(params.get(1).asInt());
                    nf.setMaximumIntegerDigits(params.get(2).asInt());
                    return Var.createValue(nf.format(v.asLong()));
                }
                return Var.createValue(v.asString());
            }
        });
        Functions.gf().add(new Functions.Func("formatSI"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = null;
                int digits = -1;
                char minSI = '.';
                switch (params.size()) {
                    case 1: {
                        v = params.get(0);
                        break;
                    }
                    case 2: {
                        v = params.get(0);
                        digits = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        v = params.get(0);
                        digits = params.get(1).asInt();
                        minSI = params.get(2).asChar();
                        break;
                    }
                    default: {
                        25.invalidNumberOfParams(script, "value");
                    }
                }
                if (v.asString().length() == 0) {
                    return Var.createValue("");
                }
                if (v.canDouble()) {
                    return Var.createValue(StringUtil.formatDoubleEE(v.asDouble(), false, digits, minSI));
                }
                return Var.createValue(v.asString());
            }
        });
        Functions.gf().add(new Functions.Func("parseSI"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    26.invalidNumberOfParams(script, "string");
                }
                String s = params.get(0).asString().trim();
                int j = 0;
                while (j < s.length()) {
                    if (validSI.indexOf(s.charAt(j)) < 0) {
                        s = s.substring(0, j);
                    }
                    ++j;
                }
                return Var.createValue(StringUtil.parseDoubleEE(s));
            }
        });
        Functions.gf().add(new Functions.Func("parseHMS"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    27.invalidNumberOfParams(script, "string");
                }
                return Var.createValue(StringUtil.parseHMS(params.get(0).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("formatHMS"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = null;
                int digits = 0;
                switch (params.size()) {
                    case 1: {
                        v = params.get(0);
                        break;
                    }
                    case 2: {
                        v = params.get(0);
                        digits = params.get(1).asInt();
                        break;
                    }
                    default: {
                        28.invalidNumberOfParams(script, "value{,msDigits}");
                    }
                }
                double seconds = 0.0;
                if (v.isDateTime()) {
                    long vv = v.asDateTime().getTime() % 86400000L + (long)TimeZone.getDefault().getOffset(v.asDateTime().getTime());
                    seconds = (double)vv / 1000.0;
                } else {
                    seconds = v.asDouble();
                }
                return Var.createValue(StringUtil.formatHMS(seconds, digits));
            }
        });
        Functions.gf().add(new Functions.Func("formatDateTime"){

            @Override
            public Var execute(Script script, List<Var> params) {
                String format = null;
                long ms = 0L;
                switch (params.size()) {
                    case 1: {
                        format = params.get(0).asString();
                        break;
                    }
                    case 2: {
                        format = params.get(0).asString();
                        if (params.get(1).isDateTime()) {
                            ms = params.get(1).asDateTime().getTime();
                            break;
                        }
                        ms = params.get(1).asLong();
                        break;
                    }
                    default: {
                        29.invalidNumberOfParams(script, "format{,dateTime/ms}");
                    }
                }
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return Var.createValue(sdf.format(new Date(ms)));
            }
        });
        Functions.gf().add(new Functions.Func("getElement"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    30.invalidNumberOfParams(script, "string,number{,string}");
                }
                String s = params.get(0).asString();
                String deli = "[ ]+";
                if (params.size() == 3) {
                    deli = params.get(2).asString();
                } else if (s.indexOf(124) >= 0) {
                    deli = "[|]";
                } else if (s.indexOf(59) >= 0) {
                    deli = "[;]";
                } else if (s.indexOf(44) >= 0) {
                    deli = "[,]";
                }
                String[] strs = s.split(deli);
                int i = (int)params.get(1).asDouble();
                if (i >= 0 && i < strs.length) {
                    return Var.createValue(strs[i]);
                }
                return Var.createValue("");
            }
        });
        Functions.gf().add(new Functions.Func("inList"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    31.invalidNumberOfParams(script, "string,string{,string}");
                }
                String deli = "[|,; ]+";
                if (params.size() == 3) {
                    deli = params.get(2).asString();
                }
                String[] strs = params.get(1).asString().split(deli);
                String item = params.get(0).asString();
                String[] stringArray = strs;
                int n = strs.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.equalsIgnoreCase(item)) {
                        return Var.createValue(true);
                    }
                    ++n2;
                }
                return Var.createValue(false);
            }
        });
        Functions.gf().add(new Functions.Func("listIndex"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    32.invalidNumberOfParams(script, "string,string{,string}");
                }
                String deli = "[|,; ]+";
                if (params.size() == 3) {
                    deli = params.get(2).asString();
                }
                String[] strs = params.get(1).asString().split(deli);
                String item = params.get(0).asString();
                int i = 0;
                String[] stringArray = strs;
                int n = strs.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.equalsIgnoreCase(item)) {
                        return Var.createValue(i);
                    }
                    ++i;
                    ++n2;
                }
                return Var.createValue(-1);
            }
        });
        Functions.gf().add(new Functions.Func("matchList"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 3) {
                    33.invalidNumberOfParams(script, "string,match,value{,match,value...}}");
                }
                Var item = params.get(0);
                int i = 0;
                while (i < params.size() - 1) {
                    if (item.equals(params.get(i + 1))) {
                        return params.get(i + 2);
                    }
                    i += 2;
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("unQuote"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    34.invalidNumberOfParams(script, "string");
                }
                String s = params.get(0).asString();
                s = StringUtil.unQuote(s);
                return Var.createValue(s);
            }
        });
        Functions.gf().add(new Functions.Func("toRoman"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    35.invalidNumberOfParams(script, "int");
                }
                return Var.createValue(RomenNumerals.toRoman(params.get(0).asInt()));
            }
        });
        Functions.gf().add(new Functions.Func("fromRoman"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    36.invalidNumberOfParams(script, "String");
                }
                return Var.createValue(RomenNumerals.fromRoman(params.get(0).asString()));
            }
        });
        Functions.gf().add(new Functions.Func("hex"){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public Var execute(Script script, List<Var> params) {
                switch (params.size()) {
                    case 1: {
                        String s = StringUtil.hex16(params.get(0).asLong());
                        if (s.startsWith("FFFFFFFFFFFFF")) {
                            s = s.substring(12);
                            return Var.createValue(s);
                        }
                        if (s.startsWith("FFFFFFFFF")) {
                            s = s.substring(8);
                            return Var.createValue(s);
                        }
                        while (s.length() > 4) {
                            if (!s.startsWith("0000")) {
                                return Var.createValue(s);
                            }
                            s = s.substring(4);
                        }
                        return Var.createValue(s);
                    }
                    case 2: {
                        int digits = params.get(1).asInt();
                        String s = StringUtil.hex16(params.get(0).asLong());
                        return Var.createValue(s.substring(16 - digits));
                    }
                }
                37.invalidNumberOfParams(script, "int{,digits}");
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("bytesAsHex"){

            @Override
            public Var execute(Script script, List<Var> params) {
                StringBuilder sb = new StringBuilder();
                byte[] v = params.get(0).asBytes();
                switch (params.size()) {
                    case 1: {
                        int j = 0;
                        boolean done = false;
                        do {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append("0x" + StringUtil.hex2(v[j++]));
                            done = true;
                            int i = j;
                            while (i < v.length) {
                                if (v[i] != 0) {
                                    done = false;
                                }
                                ++i;
                            }
                        } while (!done);
                        break;
                    }
                    case 2: {
                        int digits = params.get(1).asInt();
                        int i = 0;
                        while (i < digits) {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            if (i < v.length) {
                                sb.append("0x" + StringUtil.hex2(v[i]));
                            } else {
                                sb.append("0x00");
                            }
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        int digits = params.get(1).asInt();
                        boolean reverse = params.get(2).asBoolean();
                        int i = 0;
                        while (i < digits) {
                            if (i < v.length) {
                                if (reverse) {
                                    if (sb.length() > 0) {
                                        sb.insert(0, ' ');
                                    }
                                    sb.insert(0, "0x" + StringUtil.hex2(v[i]));
                                } else {
                                    if (sb.length() > 0) {
                                        sb.append(' ');
                                    }
                                    sb.append("0x" + StringUtil.hex2(v[i]));
                                }
                            } else if (reverse) {
                                if (sb.length() > 0) {
                                    sb.insert(0, ' ');
                                }
                                sb.insert(0, "0x00");
                            } else {
                                if (sb.length() > 0) {
                                    sb.append(' ');
                                }
                                sb.append("0x00");
                            }
                            ++i;
                        }
                        break;
                    }
                    default: {
                        38.invalidNumberOfParams(script, "int{,digits{,reverse}}");
                    }
                }
                return Var.createValue(sb.toString());
            }
        });
        Functions.gf().add(new Functions.Func("bin"){

            /*
             * Unable to fully structure code
             */
            @Override
            public Var execute(Script script, List<Var> params) {
                block6: {
                    if (params.size() != 1) {
                        39.invalidNumberOfParams(script, "int");
                    }
                    sb = new StringBuilder();
                    vv = params.get(0).asLong();
                    i = 63;
                    while (i >= 0) {
                        if ((vv & 1L << i) != 0L) {
                            sb.append('1');
                        } else {
                            sb.append('0');
                        }
                        --i;
                    }
                    if (!sb.toString().startsWith("11111111")) ** GOTO lbl23
                    while (sb.length() > 8 && sb.toString().startsWith("111111111")) {
                        sb.replace(0, 8, "");
                    }
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        sb.replace(0, 8, "");
lbl23:
                        // 2 sources

                        ** while (sb.length() > 8 && sb.toString().startsWith((String)"00000000"))
                    }
                }
                return Var.createValue(sb.toString());
            }
        });
        Functions.gf().add(new Functions.Func("strlen"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    40.invalidNumberOfParams(script, "string");
                }
                return Var.createValue(params.get(0).asString().length());
            }
        });
        Functions.gf().add(new Functions.Func("split"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    41.invalidNumberOfParams(script, "string,delimeters");
                }
                String[] s = params.get(0).asString().split(params.get(1).asString());
                Var v = Var.createArray();
                int i = 0;
                while (i < s.length) {
                    v.addVar(i, Var.createValue(s[i] == null ? "" : s[i]));
                    ++i;
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("splitq"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2 || params.size() > 3) {
                    42.invalidNumberOfParams(script, "string,delimeters{,unquote}");
                }
                String s = params.get(0).asString();
                String deli = params.get(1).asString();
                boolean unquote = params.size() >= 3 ? params.get(2).asBoolean() : false;
                Var v = Var.createArray();
                char quote = '\u0000';
                int j = 0;
                int n = 0;
                int i = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (quote == '\u0000' && (c == '\"' || c == '\'')) {
                        quote = c;
                    } else if (quote != '\u0000' && quote == c) {
                        quote = '\u0000';
                    } else if (quote == '\u0000' && s.regionMatches(i, deli, 0, deli.length())) {
                        String ss = s.substring(j, i);
                        if (unquote) {
                            ss = StringUtil.unQuote(ss);
                        }
                        v.addVar(n++, Var.createValue(ss));
                        j = i + deli.length();
                    }
                    ++i;
                }
                String ss = s.substring(j);
                if (unquote) {
                    ss = StringUtil.unQuote(ss);
                }
                v.addVar(n++, Var.createValue(ss));
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("matchBits"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    43.invalidNumberOfParams(script, "string,value");
                }
                return Var.createValue(StringUtil.matchBits(params.get(0).asString(), params.get(1).asLong()));
            }
        });
        Functions.gf().add(new Functions.Func("matchBitsList"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 3) {
                    44.invalidNumberOfParams(script, "value,string,answer{,string,answer,...}[,defaultAnswer}");
                }
                long value = params.get(0).asLong();
                int i = 0;
                while (i < (params.size() - 1) / 2) {
                    if (StringUtil.matchBits(params.get(i * 2 + 1).asString(), value)) {
                        return params.get(i * 2 + 2);
                    }
                    ++i;
                }
                if (params.size() % 2 != 0) {
                    return new Var();
                }
                return params.get(params.size() - 1);
            }
        });
    }
}

