/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.script;

import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.ProbabilitiesUtil;
import dk.hkj.vars.Var;
import java.util.List;
import java.util.Random;

public class FunctionsProbabilities {
    static Random random = null;

    public static void add() {
        Functions.gf().add(new Functions.Func("fac"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    1.invalidNumberOfParams(script, "n");
                }
                return Var.createValue(ProbabilitiesUtil.fac(params.get(0).asInt()));
            }
        });
        Functions.gf().add(new Functions.Func("nCr"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    2.invalidNumberOfParams(script, "total,sample");
                }
                int n = params.get(0).asInt();
                int r = params.get(1).asInt();
                return Var.createValue(ProbabilitiesUtil.fac(n) / (ProbabilitiesUtil.fac(r) * ProbabilitiesUtil.fac(n - r)));
            }
        });
        Functions.gf().add(new Functions.Func("nPr"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    3.invalidNumberOfParams(script, "total,sample");
                }
                int n = params.get(0).asInt();
                int r = params.get(1).asInt();
                return Var.createValue(ProbabilitiesUtil.fac(n) / ProbabilitiesUtil.fac(n - r));
            }
        });
        Functions.gf().add(new Functions.Func("normDV"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 1 || params.size() > 3) {
                    4.invalidNumberOfParams(script, "x{,mean{,sigma}}");
                }
                double x = params.get(0).asDouble();
                double mean = params.size() < 2 ? 0.0 : params.get(1).asDouble();
                double sigma = params.size() < 3 ? 1.0 : params.get(2).asDouble();
                return Var.createValue(ProbabilitiesUtil.pdf(x, mean, sigma));
            }
        });
        Functions.gf().add(new Functions.Func("normDL"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 1 || params.size() > 3) {
                    5.invalidNumberOfParams(script, "x{,mean{,sigma}}");
                }
                double x = params.get(0).asDouble();
                double mean = params.size() < 2 ? 0.0 : params.get(1).asDouble();
                double sigma = params.size() < 3 ? 1.0 : params.get(2).asDouble();
                return Var.createValue(ProbabilitiesUtil.cdf(x, mean, sigma));
            }
        });
        Functions.gf().add(new Functions.Func("normDR"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 1 || params.size() > 3) {
                    6.invalidNumberOfParams(script, "x{,mean{,sigma}}");
                }
                double x = params.get(0).asDouble();
                double mean = params.size() < 2 ? 0.0 : params.get(1).asDouble();
                double sigma = params.size() < 3 ? 1.0 : params.get(2).asDouble();
                return Var.createValue(1.0 - ProbabilitiesUtil.cdf(x, mean, sigma));
            }
        });
        Functions.gf().add(new Functions.Func("normDC"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2 || params.size() > 4) {
                    7.invalidNumberOfParams(script, "x1,x2,{,mean{,sigma}}");
                }
                double x1 = params.get(0).asDouble();
                double x2 = params.get(1).asDouble();
                double mean = params.size() < 3 ? 0.0 : params.get(2).asDouble();
                double sigma = params.size() < 4 ? 1.0 : params.get(3).asDouble();
                double lower = ProbabilitiesUtil.cdf(x1, mean, sigma);
                double upper = 1.0 - ProbabilitiesUtil.cdf(x2, mean, sigma);
                return Var.createValue(1.0 - lower - upper);
            }
        });
        Functions.gf().add(new Functions.Func("normDT"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2 || params.size() > 4) {
                    8.invalidNumberOfParams(script, "x1,x2,{,mean{,sigma}}");
                }
                double x1 = params.get(0).asDouble();
                double x2 = params.get(1).asDouble();
                double mean = params.size() < 3 ? 0.0 : params.get(2).asDouble();
                double sigma = params.size() < 4 ? 1.0 : params.get(3).asDouble();
                double lower = ProbabilitiesUtil.cdf(x1, mean, sigma);
                double upper = 1.0 - ProbabilitiesUtil.cdf(x2, mean, sigma);
                return Var.createValue(lower + upper);
            }
        });
        Functions.gf().add(new Functions.Func("normDLx"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 1 || params.size() > 3) {
                    9.invalidNumberOfParams(script, "area,{,mean{,sigma}}");
                }
                double a = params.get(0).asDouble();
                double mean = params.size() < 2 ? 0.0 : params.get(1).asDouble();
                double sigma = params.size() < 3 ? 1.0 : params.get(2).asDouble();
                return Var.createValue(ProbabilitiesUtil.inverseCDF(a) * sigma + mean);
            }
        });
        Functions.gf().add(new Functions.Func("gRandom"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double sigma;
                if (params.size() > 2) {
                    10.invalidNumberOfParams(script, "{mean{,sigma}}");
                }
                double mean = params.size() < 1 ? 0.0 : params.get(1).asDouble();
                double d = sigma = params.size() < 2 ? 1.0 : params.get(2).asDouble();
                if (random == null) {
                    random = new Random();
                }
                return Var.createValue(random.nextGaussian() * sigma + mean);
            }
        });
        Functions.gf().add(new Functions.Func("random"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (random == null) {
                    random = new Random();
                }
                double v = 0.0;
                switch (params.size()) {
                    case 0: {
                        v = random.nextDouble();
                        break;
                    }
                    case 1: {
                        v = random.nextDouble() * params.get(0).asDouble();
                        break;
                    }
                    case 2: {
                        double min = params.get(0).asDouble();
                        double max = params.get(1).asDouble();
                        v = random.nextDouble() * (max - min) + min;
                        break;
                    }
                    default: {
                        11.invalidNumberOfParams(script, "{{min,}max}");
                    }
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("randomInt"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (random == null) {
                    random = new Random();
                }
                long v = 0L;
                switch (params.size()) {
                    case 0: {
                        v = random.nextLong();
                        break;
                    }
                    case 1: {
                        v = (long)Math.floor(random.nextDouble() * (double)params.get(0).asLong());
                        break;
                    }
                    case 2: {
                        long min = params.get(0).asLong();
                        long max = params.get(1).asLong();
                        v = (long)Math.floor(random.nextDouble() * (double)(max - min) + (double)min);
                        break;
                    }
                    default: {
                        12.invalidNumberOfParams(script, "{{min,}max}");
                    }
                }
                return Var.createValue(v);
            }
        });
    }
}

